/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.svgmaps;

import java.awt.geom.AffineTransform;

public class SvgResizableCanvas {
    private float left = 0.0f;
    private float right = 0.0f;
    private float top = 0.0f;
    private float bottom = 0.0f;

    public void setResize(float left, float right, float top, float bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public AffineTransform getTransform(float width, float height, float aspectRatio) {
        AffineTransform result = new AffineTransform();
        result.translate(this.left, this.top);
        float newWidth = width - this.left - this.right;
        float newHeight = height - this.top - this.bottom;
        float newRatio = newWidth / newHeight;
        if (newRatio > aspectRatio) {
            newWidth = newHeight * aspectRatio;
        } else {
            newHeight = newWidth / aspectRatio;
        }
        result.scale(newWidth / width, newHeight / height);
        return result;
    }

    public void add(SvgResizableCanvas resizableCanvas) {
        this.left += resizableCanvas.left;
        this.right += resizableCanvas.right;
        this.top += resizableCanvas.top;
        this.bottom += resizableCanvas.bottom;
    }
}

