/*
 * Decompiled with CFR 0.152.
 */
package quadbase.maps.util;

import java.awt.Color;
import quadbase.maps.googlemaps.heatmaps.TransitionHeatmap;

public class ColorTransitions {
    private TransitionHeatmap.TransitionType transitionType = TransitionHeatmap.TransitionType.GREEN_TO_RED;

    public Color getColor(double color) {
        Color c = Color.getHSBColor(0.0f, 0.0f, 0.0f);
        if (this.transitionType.equals((Object)TransitionHeatmap.TransitionType.GREEN_TO_RED)) {
            c = this.getColorHSB(1.0 - color);
        } else if (this.transitionType.equals((Object)TransitionHeatmap.TransitionType.RED_TO_GREEN)) {
            c = this.getColorHSB(color);
        } else if (this.transitionType.equals((Object)TransitionHeatmap.TransitionType.WHITE_TO_BLACK)) {
            c = this.getColorBW(1.0 - color);
        } else if (this.transitionType.equals((Object)TransitionHeatmap.TransitionType.BLACK_TO_WHITE)) {
            c = this.getColorBW(color);
        }
        return c;
    }

    private Color getColorHSB(double color) {
        double H = color * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    private Color getColorBW(double color) {
        float shade = (float)color;
        return new Color(shade, shade, shade);
    }

    public TransitionHeatmap.TransitionType getTransitionType() {
        return this.transitionType;
    }

    public void setTransitionType(TransitionHeatmap.TransitionType transitionType) {
        this.transitionType = transitionType;
    }

    public static String getHTMLHex(String s) {
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }
}

