/*
 * Decompiled with CFR 0.152.
 */
package quadbase.miniutil.internal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.util.internal.ImageResample;

public class ImageData {
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    public static final int NONE = 3;
    URL url;
    Image image;
    Image newimage;
    int display_option;
    int im_w;
    int im_h;
    int width;
    int height;
    boolean changed;
    boolean failed;

    public ImageData(URL url, int option) {
        this.setOption(option);
        this.setImage(url);
    }

    public void setImage(URL url) {
        this.url = url;
        this.image = null;
        this.changed = true;
        this.failed = false;
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        this.image = image;
        this.changed = true;
        this.failed = false;
    }

    public void setOption(int option) {
        this.display_option = option;
        this.changed = true;
    }

    public int getOption() {
        return this.display_option;
    }

    public URL getUrl() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public void draw(Graphics g, int x, int y, int width, int height, Object comp) {
        ImageObserver obs;
        block17: {
            if (this.url == null || this.display_option == 3) {
                return;
            }
            if (this.image == null && !this.failed) {
                this.image = ImageData.retrieveImage(this.url, (Component)comp);
                if (this.image == null) {
                    this.failed = true;
                    return;
                }
            }
            this.im_w = this.image.getWidth(null);
            this.im_h = this.image.getHeight(null);
            this.changed = true;
            obs = (ImageObserver)comp;
            if (this.width != width || this.height != height) {
                this.changed = true;
            }
            this.width = width;
            this.height = height;
            if ((this.im_w > width || this.im_h > height) && this.display_option != 1 && this.changed) {
                try {
                    if (this.im_w <= width || this.im_w >= width && this.im_h >= height && this.im_h * width >= this.im_w * height) {
                        this.newimage = new ImageResample(this.image).resample(height * this.im_w / this.im_h, height);
                        break block17;
                    }
                    this.newimage = new ImageResample(this.image).resample(width, width * this.im_h / this.im_w);
                }
                catch (Exception ex) {
                    this.newimage = this.image;
                }
            } else if (this.display_option == 2 || this.display_option == 0 && this.changed) {
                this.newimage = this.image;
            }
        }
        if (this.display_option == 0) {
            g.drawImage(this.newimage, x + (width - this.newimage.getWidth(null)) / 2, y + (height - this.newimage.getHeight(null)) / 2, obs);
        } else if (this.display_option == 2) {
            ImageData.imageTile(g, x, y, width, height, this.newimage, obs);
        } else {
            try {
                if (this.changed) {
                    this.newimage = new ImageResample(this.image).resample(width, height);
                }
            }
            catch (Exception ex) {
                this.newimage = this.image;
            }
            g.drawImage(this.newimage, x, y, width, height, obs);
        }
        this.changed = false;
    }

    private static Image retrieveImage(URL url, Component c) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(url);
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                throw new IOException("");
            }
        }
        catch (Exception ex) {
            try {
                int nread;
                ReadDataFile readDataFile = new ReadDataFile();
                DataInputStream instream = readDataFile.getInputStream(url.toString(), true);
                ByteArrayOutputStream boutput = new ByteArrayOutputStream(100);
                DataOutputStream dout = new DataOutputStream(boutput);
                byte[] buf = new byte[100];
                while ((nread = instream.read(buf, 0, 100)) >= 0) {
                    dout.write(buf, 0, nread);
                }
                image = ImageData.retrieveImage(boutput.toByteArray(), c);
                readDataFile.close();
                return image;
            }
            catch (Exception ex3) {
                System.out.println("Failed to load image " + url + " " + ex3.getMessage());
                image = null;
                System.out.println("Failed to load image " + url + " " + ex.getMessage());
                image = null;
            }
        }
        return image;
    }

    private static void imageTile(Graphics g, int x, int y, int width, int height, Image image, ImageObserver obs) {
        int w = image.getWidth(obs);
        int h = image.getHeight(obs);
        if (w == 0 || h == 0) {
            return;
        }
        int col = (int)Math.ceil((double)width / (double)w);
        int row = (int)Math.ceil((double)height / (double)h);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                g.drawImage(image, j * w + x, i * h + y, w, h, obs);
            }
        }
    }

    private static Image retrieveImage(byte[] array, Component c) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(array);
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                throw new IOException("");
            }
        }
        catch (Exception ex) {
            image = null;
        }
        return image;
    }
}

