/*
 * Decompiled with CFR 0.152.
 */
package quadbase.miniutil.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.FilteredImageSource;
import java.util.StringTokenizer;
import quadbase.awt.RotateFilter;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.AffineTransformText;

public class RotateText {
    private String text;
    private Point pos;
    private Color color;
    private Font font;
    private Component component;
    private Image rotImage;
    private double angle;
    private boolean isJ2DRotate;

    public RotateText(String text, Component component, double angle) {
        this.text = text;
        this.angle = angle * Math.PI / 180.0;
        this.component = component;
        this.pos = new Point(0, 0);
        this.color = Color.black;
        this.font = QbUtil.getDefaultFont(new Font("TimesRoman", 0, 8), new Font("Arial", 0, 8));
    }

    public void setJava2DRotateText(boolean isJ2DRotate) {
        this.isJ2DRotate = isJ2DRotate;
    }

    public void setFont(Font _font) {
        this.font = _font;
        this.rotImage = null;
    }

    public void setColor(Color _color) {
        this.color = _color;
        this.rotImage = null;
    }

    public void setPos(int x, int y) {
        this.pos = new Point(x, y);
    }

    public int getWidth() {
        return this.rotImage == null ? 0 : this.rotImage.getWidth(null);
    }

    public int getHeight() {
        return this.rotImage == null ? 0 : this.rotImage.getHeight(null);
    }

    public void prepareImage(Graphics g) {
        if (IOUtil.isJava2D() && this.isJ2DRotate) {
            return;
        }
        try {
            Image image;
            Font oldfont = g.getFont();
            g.setFont(this.font);
            String[] str = this.tokenizer(this.text);
            FontMetrics fm = g.getFontMetrics();
            int height = (fm.getMaxAscent() + fm.getMaxDescent()) * str.length;
            int width = this.getCharsWidth(str, fm);
            int imagesize = height * width;
            if (imagesize == 0) {
                height = 1;
                width = 1;
            }
            if ((image = this.component.createImage(width, height)) == null) {
                Frame f = new Frame();
                f.addNotify();
                image = f.createImage(width, height);
                f.removeNotify();
            }
            Graphics gbuffer = image.getGraphics();
            RotateFilter rotfilter = new RotateFilter(this.angle);
            if (this.color.getRed() + this.color.getGreen() + this.color.getBlue() < 384) {
                gbuffer.setColor(Color.white);
            } else {
                gbuffer.setColor(Color.black);
                rotfilter.reverseMask();
            }
            gbuffer.fillRect(0, 0, width, height);
            gbuffer.setFont(this.font);
            gbuffer.setColor(this.color);
            for (int i = 0; i < str.length; ++i) {
                gbuffer.drawString(str[i], 0, fm.getMaxAscent() + (fm.getMaxAscent() + fm.getMaxDescent()) * i);
            }
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), rotfilter);
            if (this.rotImage != null) {
                this.rotImage.flush();
            }
            this.rotImage = this.component.createImage(prod);
            if (System.getProperty("java.vendor").indexOf("IBM") < 0 && System.getProperty("java.vendor.url").indexOf("ibm") < 0) {
                image.flush();
            }
            g.setFont(oldfont);
            gbuffer.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getCharsWidth(String[] list, FontMetrics fm) {
        int max = 0;
        for (String element : list) {
            int width = fm.charsWidth(element.toCharArray(), 0, element.length());
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private String[] tokenizer(String str) {
        String str2 = "";
        int len = str.length();
        boolean isSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && !isSlash) {
                isSlash = true;
                continue;
            }
            if ((c == 'n' || c == 'r') && isSlash) {
                c = '\n';
            } else if (c != '\\' && isSlash) {
                str2 = str2 + '\\';
            }
            isSlash = false;
            str2 = str2 + c;
        }
        StringTokenizer st = new StringTokenizer(str2, "\r\n");
        if (st.countTokens() <= 0) {
            return new String[]{str};
        }
        int i = 0;
        String[] list = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            list[i++] = st.nextToken();
        }
        return list;
    }

    public void draw(Graphics g) {
        if (IOUtil.isJava2D() && this.isJ2DRotate) {
            Font oldfont = g.getFont();
            g.setFont(this.font);
            FontMetrics fm = g.getFontMetrics();
            int degree = (int)(this.angle * 180.0 * 10.0 / Math.PI % 3600.0);
            int height = fm.getMaxAscent() + fm.getMaxDescent();
            int dx = 0;
            int dy = 0;
            String[] str = this.tokenizer(this.text);
            int width = 0;
            for (String element : str) {
                int wid = fm.charsWidth(element.toCharArray(), 0, element.length());
                if (wid <= width) continue;
                width = wid;
            }
            if (degree != 0 && degree > 500) {
                if (degree <= 950) {
                    dy = -(height / 2 * str.length);
                } else if (degree <= 1400) {
                    dy = height;
                    dx = -width;
                } else if (degree <= 1850) {
                    dx = width;
                    dy = height * str.length;
                } else if (degree <= 2300) {
                    dx = width;
                    dy = height / 2 * str.length;
                } else if (degree <= 2750) {
                    dy = -(height * str.length);
                } else if (degree <= 3200) {
                    dy = -(height / 2 * str.length);
                }
            }
            this.pos.x += dx;
            this.pos.y += dy;
            AffineTransformText.setRotateText(g, this.text, this.angle, this.pos, this.font, this.color);
            g.setFont(oldfont);
        } else {
            if (this.rotImage == null) {
                this.prepareImage(g);
            }
            if (this.rotImage != null) {
                try {
                    g.drawImage(this.rotImage, this.pos.x, this.pos.y, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

