/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.PopupMenuForColumnWindow;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SimpleDictionary;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.LoadQuery;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.querybuilder.query.TableInfo;

public class AdvanceDictionary
extends SimpleDictionary {
    private JTable originalTable = null;
    private String[][] originalJoinProperties = null;
    private ColumnFieldWindow[] originalWindows = null;
    private ColumnFieldWindow[] columnTableMap = null;
    private String whereClause = "";
    private DesignView designView;

    public AdvanceDictionary(LoadQuery lq, QueryMain qm) throws Exception {
        super("Dictionary");
        ColumnFieldWindow newCol_temp;
        ColumnFieldWindow newCol;
        int i;
        this.lineMonitor = qm.qbeWindow.designView;
        this.designView = qm.qbeWindow.designView;
        DatabaseInfo dbInfo = new DatabaseInfo(lq.getDriver(), lq.getURL(), lq.getUserName(), lq.getPassword());
        JTable table = new JTable(10, 20);
        table.setGridColor(Color.lightGray);
        this.originalTable = new JTable(10, 20);
        this.originalTable.setGridColor(Color.lightGray);
        DefaultTableModel model = (DefaultTableModel)this.originalTable.getModel();
        model.setDataVector(lq.getQBETable(), lq.getQBEHeader());
        model = (DefaultTableModel)table.getModel();
        model.setDataVector(lq.getQBETable(), lq.getQBEHeader());
        this.originalJoinProperties = lq.getJoinProperties();
        this.joinProperties = new String[this.originalJoinProperties.length][5];
        for (int i2 = 0; i2 < this.joinProperties.length; ++i2) {
            for (int j = 0; j < 5; ++j) {
                this.joinProperties[i2][j] = this.originalJoinProperties[i2][j];
            }
        }
        String[] tNames = lq.getSelectedTable();
        String[] tAlias = lq.getTableAlias();
        Rectangle[] tBounds = lq.getTableBounds();
        LoadQuery[] dictionaries = lq.getDictionaries();
        String[] dictionaryAlias = lq.getDictionaryAlias();
        Rectangle[] dictionaryBounds = lq.getDictionaryBounds();
        Hashtable<String, String> old_new_Alias = new Hashtable<String, String>();
        this.windows = new ColumnFieldWindow[tNames.length + dictionaries.length];
        this.originalWindows = new ColumnFieldWindow[tNames.length + dictionaries.length];
        for (i = 0; i < tNames.length; ++i) {
            newCol = new ColumnFieldWindow(this.designView, new TableInfo(dbInfo, tNames[i]));
            newCol.setDisplayName(tAlias[i] + "_" + this.alias);
            newCol.setPosition(tBounds[i]);
            old_new_Alias.put(tAlias[i], tAlias[i] + "_" + this.alias);
            this.windows[i] = newCol;
            newCol_temp = new ColumnFieldWindow(this.designView, new TableInfo(dbInfo, tNames[i]));
            this.originalWindows[i] = newCol_temp;
        }
        for (i = 0; i < dictionaries.length; ++i) {
            newCol = new AdvanceDictionary(dictionaries[i], qm);
            newCol.setDisplayName(dictionaryAlias[i] + "_" + this.alias);
            newCol.setPosition(dictionaryBounds[i]);
            old_new_Alias.put(dictionaryAlias[i], dictionaryAlias[i] + "_" + this.alias);
            this.windows[tNames.length + i] = newCol;
            newCol_temp = new AdvanceDictionary(dictionaries[i], qm);
            this.originalWindows[tNames.length + i] = newCol_temp;
        }
        Vector<Object[]> colwindowpairs = new Vector<Object[]>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (row == 0) {
                    String table_name = (String)model.getValueAt(row, col);
                    String col_name = (String)model.getValueAt(1, col);
                    if (table_name != null && col_name != null && !"Expression".equals(table_name)) {
                        if (!col_name.equals("*") && !col_name.equals("")) {
                            colwindowpairs.add(new Object[]{model.getColumnName(col), col_name, this.getWindow(table_name + "_" + this.alias)});
                        } else if (col_name.equals("*")) {
                            String[] cols;
                            ColumnFieldWindow cfw = this.getWindow(table_name + "_" + this.alias);
                            for (String col2 : cols = cfw.getColumns()) {
                                colwindowpairs.add(new Object[]{col2, col2, cfw});
                            }
                        }
                        model.setValueAt("$QB$" + (String)model.getValueAt(row, col) + "$/QB$", row, col);
                        continue;
                    }
                    colwindowpairs.add(new Object[]{model.getColumnName(col), Integer.toString(col), null});
                    continue;
                }
                if (!(model.getValueAt(row, col) instanceof String)) continue;
                String text = (String)model.getValueAt(row, col);
                text = this.tagTableNames(text);
                model.setValueAt(text, row, col);
            }
        }
        this.qbeTable = table;
        this.updateAlias(this.qbeTable, this.joinProperties, old_new_Alias);
        QueryBuilder builder = QueryBuilder.create(QueryBuilder.mapDatabaseType(dbInfo.getProductName()), this.removeTags(table), this.windows, this.joinProperties);
        this.query = builder.buildQuery();
        this.whereClause = builder.setWhereClause();
        if (this.whereClause.toUpperCase().startsWith("\nWHERE")) {
            this.whereClause = this.whereClause.substring(6).trim();
        }
        Object[][] colresult = qm.databaseInfo.getTableInfo(this.query, true);
        this.columnInfo = new String[colresult.length][4];
        this.columnTableMap = new ColumnFieldWindow[colresult.length];
        for (int i3 = 0; i3 < colresult.length; ++i3) {
            this.columnInfo[i3][0] = (String)colresult[i3][0];
            this.columnInfo[i3][1] = ((Integer)colresult[i3][1]).toString();
            this.columnInfo[i3][2] = (String)colresult[i3][2];
            for (int j = 0; j < colwindowpairs.size(); ++j) {
                if (!((String)((Object[])colwindowpairs.elementAt(j))[0]).equals(this.columnInfo[i3][0])) continue;
                this.columnTableMap[i3] = (ColumnFieldWindow)((Object[])colwindowpairs.elementAt(j))[2];
                this.columnInfo[i3][3] = (String)((Object[])colwindowpairs.elementAt(j))[1];
                colwindowpairs.remove(j);
                j = colwindowpairs.size();
            }
        }
        this.init();
        this.setPosition();
        this.colWinMenu = new PopupMenuForColumnWindow(this.designView, this);
    }

    @Override
    void init() throws Exception {
        Object[] colField = new Object[this.columnInfo.length + 1];
        String[] dataTypes = new String[this.columnInfo.length + 1];
        for (int i = 0; i < colField.length; ++i) {
            colField[i] = i == 0 ? "*" : this.columnInfo[i - 1][0];
            dataTypes[i] = i == 0 ? null : this.columnInfo[i - 1][2];
        }
        this.init_Helper(colField, dataTypes);
    }

    @Override
    public String getTableName() {
        return this.query;
    }

    @Override
    public String getDisplayName() {
        return this.alias;
    }

    @Override
    void setDisplayName(String old_str) {
        String str = old_str.replace(' ', '_');
        Hashtable<String, String> old_new_Alias = new Hashtable<String, String>();
        for (ColumnFieldWindow window : this.windows) {
            String oldname = window.getDisplayName();
            String newname = oldname.substring(0, oldname.indexOf("_" + this.alias));
            old_new_Alias.put(oldname, newname + "_" + str);
            window.setDisplayName(newname + "_" + str);
        }
        this.updateAlias(this.qbeTable, this.joinProperties, old_new_Alias);
        QueryBuilder builder = QueryBuilder.create(this.designView.queryMain.getDatabaseType(), this.removeTags(this.qbeTable), this.windows, this.joinProperties);
        this.query = builder.buildQuery();
        this.whereClause = builder.setWhereClause();
        if (this.whereClause.toUpperCase().startsWith("\nWHERE")) {
            this.whereClause = this.whereClause.substring(6).trim();
        }
        super.setDisplayName(str);
    }

    @Override
    public int getSQLType(int index) {
        if (index <= 0) {
            return -5;
        }
        return Integer.parseInt(this.columnInfo[index - 1][1]);
    }

    @Override
    public JTable getQBETable() {
        return this.originalTable;
    }

    @Override
    public ColumnFieldWindow[] getWindows() {
        return this.originalWindows;
    }

    @Override
    public String[][] getJoinProperties() {
        return this.originalJoinProperties;
    }

    private String tagTableNames(String exp) {
        if (exp == null) {
            return null;
        }
        String[][] prefix_a = new String[][]{{"\""}, {"["}, {" ", ">", "<", "=", ",", "(", ")", "\n", "+", "-", "/", "*", "&"}, {"["}};
        String[] subfix_a = new String[]{"\".", "].", ".", "]!"};
        String[] prefix = null;
        String subfix = "";
        String retstr = "";
        int startIndex = 0;
        while (startIndex < exp.length()) {
            int endIndex = -1;
            for (int i = 0; i < subfix_a.length; ++i) {
                int newindex = exp.indexOf(subfix_a[i], startIndex);
                if ((newindex >= endIndex || newindex < 0) && (newindex <= endIndex || endIndex >= 0)) continue;
                endIndex = newindex;
                prefix = prefix_a[i];
                subfix = subfix_a[i];
            }
            if (endIndex > 0) {
                int newStartIndex = -1;
                for (void var13_14 : prefix) {
                    int newindex = exp.lastIndexOf((String)var13_14, endIndex - 1);
                    if (newindex <= newStartIndex) continue;
                    newStartIndex = newindex;
                }
                retstr = newStartIndex > -1 || startIndex == 0 && subfix.equals(subfix_a[2]) ? retstr + exp.substring(startIndex, newStartIndex + 1) + "$QB$" + exp.substring(newStartIndex + 1, endIndex) + "$/QB$" + subfix : retstr + exp.substring(startIndex, endIndex) + subfix;
                startIndex = endIndex + subfix.length();
                continue;
            }
            retstr = retstr + exp.substring(startIndex);
            startIndex = exp.length();
        }
        return retstr;
    }

    private void updateAlias(JTable table, String[][] jp, Hashtable alias) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        for (int col = 0; col < model.getColumnCount(); ++col) {
            for (int row = 0; row < model.getRowCount(); ++row) {
                if (!(model.getValueAt(row, col) instanceof String)) continue;
                String text = (String)model.getValueAt(row, col);
                String newtext = "";
                int sIndex = 0;
                if (text == null || text.length() <= 0) continue;
                while (sIndex < text.length()) {
                    int startIndex = text.indexOf("$QB$", sIndex);
                    if (startIndex > -1 && startIndex + 4 < text.length()) {
                        int endIndex = text.indexOf("$/QB$", startIndex + 4);
                        if (endIndex > -1) {
                            String tablename = text.substring(startIndex + 4, endIndex);
                            String newAlias = (String)alias.get(tablename);
                            newtext = newAlias != null ? newtext + text.substring(sIndex, startIndex + 4) + newAlias + "$/QB$" : newtext + text.substring(sIndex, endIndex + 5);
                            sIndex = endIndex + 5;
                            continue;
                        }
                        newtext = newtext + text.substring(sIndex);
                        sIndex = text.length();
                        continue;
                    }
                    newtext = newtext + text.substring(sIndex);
                    sIndex = text.length();
                }
                model.setValueAt(newtext, row, col);
            }
        }
        for (String[] element : jp) {
            String[] join = element;
            String newAlias = (String)alias.get(join[0]);
            if (newAlias != null) {
                join[0] = newAlias;
            }
            if ((newAlias = (String)alias.get(join[2])) == null) continue;
            join[2] = newAlias;
        }
    }

    private JTable removeTags(JTable table) {
        String[] keyword_a = new String[]{"$QB$", "$/QB$"};
        String keyword = "";
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        Object[][] data = new Object[model.getRowCount()][model.getColumnCount()];
        Object[] columnNames = new String[model.getColumnCount()];
        for (int col = 0; col < model.getColumnCount(); ++col) {
            columnNames[col] = table.getColumnName(col);
            for (int row = 0; row < model.getRowCount(); ++row) {
                if (model.getValueAt(row, col) instanceof String) {
                    String text = model.getValueAt(row, col).toString();
                    String newtext = "";
                    int sIndex = 0;
                    if (text != null && text.length() > 0) {
                        while (sIndex < text.length()) {
                            int keyIndex = -1;
                            for (String element : keyword_a) {
                                int newindex = text.indexOf(element, sIndex);
                                if ((newindex >= keyIndex || newindex < 0) && (newindex <= keyIndex || keyIndex >= 0)) continue;
                                keyIndex = newindex;
                                keyword = element;
                            }
                            if (keyIndex < 0) {
                                newtext = newtext + text.substring(sIndex);
                                sIndex = text.length();
                                continue;
                            }
                            newtext = newtext + text.substring(sIndex, keyIndex);
                            sIndex = keyIndex + keyword.length();
                        }
                        data[row][col] = newtext;
                        continue;
                    }
                    data[row][col] = text;
                    continue;
                }
                data[row][col] = model.getValueAt(row, col);
            }
        }
        JTable newTable = new JTable(10, 20);
        newTable.setGridColor(Color.lightGray);
        model = (DefaultTableModel)newTable.getModel();
        model.setDataVector(data, columnNames);
        return newTable;
    }

    public Vector getTableAliasPairs() {
        Vector<Object> retvect = new Vector<Object>();
        for (ColumnFieldWindow window : this.windows) {
            if (window instanceof AdvanceDictionary) {
                Vector subalias = ((AdvanceDictionary)window).getTableAliasPairs();
                for (int j = 0; j < subalias.size(); ++j) {
                    retvect.add(subalias.elementAt(j));
                }
                continue;
            }
            retvect.add(new String[]{window.getTableName(), window.getDisplayName()});
        }
        return retvect;
    }

    private ColumnFieldWindow getWindow(String displayname) {
        for (ColumnFieldWindow window : this.windows) {
            if (!window.getDisplayName().equals(displayname)) continue;
            return window;
        }
        return null;
    }

    public String[] getActualTableColumn(String colname) {
        String[] ret = new String[]{null, ""};
        if (colname == null) {
            return ret;
        }
        boolean all = false;
        if (colname.equals("*")) {
            all = true;
        }
        for (int i = 0; i < this.columnInfo.length; ++i) {
            if (!all && !this.columnInfo[i][0].equals(colname)) continue;
            ColumnFieldWindow cfw = this.columnTableMap[i];
            String temp = "";
            if (cfw == null) {
                ret[0] = null;
                int col = Integer.parseInt(this.columnInfo[i][1]);
                JTable temptable = new JTable(10, 1);
                temptable.setGridColor(Color.lightGray);
                DefaultTableModel dtm = (DefaultTableModel)temptable.getModel();
                Object[][] columndata = new Object[this.qbeTable.getRowCount()][1];
                Object[] columnheader = new Object[]{"*"};
                for (int j = 0; j < columndata.length; ++j) {
                    columndata[j][0] = this.qbeTable.getValueAt(j, col);
                }
                dtm.setDataVector(columndata, columnheader);
                QueryBuilder builder = QueryBuilder.create(this.designView.queryMain.getDatabaseType(), this.removeTags(temptable), this.windows, this.joinProperties);
                temp = builder.getColumnNameList();
                if (all) {
                    ret[1] = ret[1] + ", " + temp;
                }
            } else if (cfw instanceof AdvanceDictionary) {
                String[] temp_a = ((AdvanceDictionary)cfw).getActualTableColumn(this.columnInfo[i][3]);
                ret[0] = temp_a[0];
                temp = temp_a[1];
                if (all) {
                    ret[1] = ret[0] == null ? ret[1] + ", " + temp : ret[1] + ", " + QueryBuilder.printExpression(this.designView.queryMain.getDatabaseType(), ret[0], temp);
                }
            } else {
                ret[0] = cfw.getDisplayName();
                temp = this.columnInfo[i][3];
                if (all) {
                    ret[1] = ret[1] + ", " + QueryBuilder.printExpression(this.designView.queryMain.getDatabaseType(), ret[0], temp);
                }
            }
            if (all) continue;
            ret[1] = temp;
            return ret;
        }
        ret[0] = null;
        if (ret[1].length() > 0) {
            ret[1] = ret[1].substring(1).trim();
        }
        return ret;
    }

    public String getExpressionForColumn(String colname) {
        String[] temp_a = this.getActualTableColumn(colname);
        if (temp_a[0] == null) {
            return temp_a[1];
        }
        return QueryBuilder.printExpression(this.designView.queryMain.getDatabaseType(), temp_a[0], temp_a[1]);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    @Override
    protected void finalize() throws Throwable {
        for (ColumnFieldWindow originalWindow : this.originalWindows) {
            try {
                originalWindow.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

