/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.LanguageEncoder;

public class ColumnDescriptionDialog
extends JDialog
implements ActionListener {
    private UndoTextArea textArea = null;
    private JButton okButton;
    private JButton cancelButton;
    private boolean modified = false;

    public ColumnDescriptionDialog(JDialog parent, String alias, String description, boolean edit) {
        super((Dialog)parent, true);
        this.setBackground(Color.lightGray);
        if (alias == null) {
            alias = "Column Description";
        }
        this.setTitle(alias);
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        if (description == null) {
            description = "";
        }
        this.textArea = new UndoTextArea(description);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        CompoundBorder border = new CompoundBorder(new TitledBorder(LanguageEncoder.getText("Description")), new BevelBorder(1));
        scrollPane.setBorder(border);
        bpanel.add((Component)scrollPane, "Center");
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        if (edit) {
            okpanel.add(this.cancelButton);
            this.textArea.setEditable(true);
        } else {
            this.textArea.setEditable(false);
        }
        bpanel.add((Component)okpanel, "South");
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        int x = (screenSize.width - dim.width) / 2;
        int y = (screenSize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.modified = false;
            this.setVisible(false);
        } else if (e.getSource() == this.okButton) {
            this.modified = true;
            this.setVisible(false);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getDescription() {
        return this.textArea.getText();
    }
}

