/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import quadbase.common.swing.DataTypeListCellRenderer;
import quadbase.common.swing.listeners.MousePopUpAdapter;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.IJoinLineMonitor;
import quadbase.querybuilder.designer.PopupMenuForColumnWindow;
import quadbase.querybuilder.query.TableInfo;

public class ColumnFieldWindow
extends JInternalFrame
implements ComponentListener,
AdjustmentListener {
    protected IJoinLineMonitor lineMonitor;
    protected JList mListBox;
    private TableInfo tableInfo = null;
    protected JScrollPane scrollPane;
    protected int selectedIndex = -1;
    protected PopupMenuForColumnWindow colWinMenu;
    private Object[] originalColumns = null;
    private Object[] alphabetizedColumns = null;
    private boolean alphabetized = false;
    private boolean forDataView = false;
    private static final int SORT_Y = 0;
    private static final int SORT_X = 1;
    private boolean autoPosition = true;

    public ColumnFieldWindow(IJoinLineMonitor lm, TableInfo tableInfo) throws Exception {
        super(tableInfo.getName(), true, false, false, false);
        this.tableInfo = tableInfo;
        this.lineMonitor = lm;
        this.init();
        this.setPosition();
        if (this.lineMonitor instanceof DesignView) {
            this.colWinMenu = new PopupMenuForColumnWindow((DesignView)this.lineMonitor, this);
        }
    }

    protected ColumnFieldWindow(String table_alias) {
        super(table_alias, true, false, false, false);
    }

    void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        int x = 5;
        int y = 5;
        if (this.lineMonitor != null) {
            int ct = this.lineMonitor.getColumnFieldWindowCount();
            for (int i = 0; i < ct; ++i) {
                if ((x += dim.width + 25) + dim.width < 1000) continue;
                x = 5;
                y = y + dim.height + 25;
            }
        }
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    void setPosition(Rectangle bounds) {
        if (bounds == null) {
            return;
        }
        this.autoPosition = false;
        this.setBounds(bounds);
        this.setSize((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    void setPosition(JInternalFrame[] frame, Dimension pane) {
        if (!this.autoPosition) {
            return;
        }
        if (frame == null || frame.length == 0) {
            return;
        }
        Vector<JInternalFrame[]> rows = ColumnFieldWindow.sortHorizontally(frame);
        Rectangle bounds = this.getBounds(null);
        double w = bounds.getWidth() + 25.0;
        Rectangle cur = null;
        Rectangle next = null;
        for (int i = 0; i < rows.size(); ++i) {
            JInternalFrame[] list = rows.elementAt(i);
            for (int j = 0; j < list.length; ++j) {
                double gap;
                cur = list[j].getBounds(cur);
                if (j == 0 && cur.getX() > w) {
                    bounds = new Rectangle((int)(cur.getX() - w), (int)cur.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
                    this.setPosition(bounds);
                    return;
                }
                if (j + 1 < list.length && (gap = (next = list[j + 1].getBounds(next)).getX() - (cur.getX() + cur.getWidth())) > w) {
                    bounds = new Rectangle((int)(cur.getX() + cur.getWidth() + 12.0), (int)cur.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
                    this.setPosition(bounds);
                    return;
                }
                if (j != list.length - 1 || !(cur.getX() + cur.getWidth() + w < pane.getWidth())) continue;
                bounds = new Rectangle((int)(cur.getX() + cur.getWidth() + 12.0), (int)cur.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
                this.setPosition(bounds);
                return;
            }
        }
        JInternalFrame[] list = rows.lastElement();
        list = ColumnFieldWindow.sortElement(list, 0, false);
        bounds = new Rectangle(5, list[0].getY() + list[0].getHeight() + 20, (int)bounds.getWidth(), (int)bounds.getHeight());
        this.setPosition(bounds);
    }

    void init() throws Exception {
        Object[] colField = new Object[this.tableInfo.getColumnCount() + 1];
        String[] dataTypes = new String[this.tableInfo.getColumnCount() + 1];
        for (int i = 0; i < colField.length; ++i) {
            colField[i] = i == 0 ? "*" : this.tableInfo.getColumn(i - 1).getColumnName();
            dataTypes[i] = i == 0 ? null : this.tableInfo.getColumn(i - 1).getTypeName();
        }
        this.init_Helper(colField, dataTypes);
    }

    public String addDataTypeToColumnName(String columnName, String typeName) {
        return columnName + " (" + typeName + ")";
    }

    void init_Helper(Object[] colField, String[] dataTypes) throws Exception {
        this.originalColumns = new Object[colField.length];
        this.alphabetizedColumns = new Object[colField.length];
        for (int i = 0; i < colField.length; ++i) {
            this.originalColumns[i] = colField[i];
            this.alphabetizedColumns[i] = colField[i];
        }
        Arrays.sort(this.alphabetizedColumns);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mListBox = new JList<Object>(colField);
        if (dataTypes != null) {
            DataTypeListCellRenderer dataTypeListCellRenderer = new DataTypeListCellRenderer(dataTypes);
            this.mListBox.setCellRenderer(dataTypeListCellRenderer);
        }
        this.mListBox.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                if (ColumnFieldWindow.this.colWinMenu == null) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                int viewPos = (int)ColumnFieldWindow.this.scrollPane.getViewport().getViewPosition().getY();
                ColumnFieldWindow.this.colWinMenu.show(ColumnFieldWindow.this, x, y - viewPos);
            }
        });
        this.mListBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ColumnFieldWindow.this.lineMonitor == null) {
                    return;
                }
                ColumnFieldWindow.this.lineMonitor.setParentCursor(Cursor.getPredefinedCursor(0));
                if (ColumnFieldWindow.this.selectedIndex > 0) {
                    int i;
                    int x = (int)((double)e.getX() + ColumnFieldWindow.this.getBounds().getX());
                    int viewPos = (int)ColumnFieldWindow.this.scrollPane.getViewport().getViewPosition().getY();
                    int y = (int)((double)e.getY() + ColumnFieldWindow.this.getBounds().getY() - (double)viewPos);
                    ColumnFieldWindow tmp = ColumnFieldWindow.this.lineMonitor.getSelectedColumnFieldWindow(x, y);
                    if (tmp != null && (i = tmp.locationToIndex(y)) > 0) {
                        ColumnFieldWindow.this.lineMonitor.setJoinProperty(ColumnFieldWindow.this, ColumnFieldWindow.this.selectedIndex, tmp, i, 0);
                        ColumnFieldWindow.this.lineMonitor.repaintDesktop();
                    }
                    ColumnFieldWindow.this.selectedIndex = -1;
                } else if (e.getClickCount() != 1) {
                    ColumnFieldWindow.this.addColumnField();
                }
            }
        });
        this.mListBox.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ColumnFieldWindow.this.lineMonitor == null) {
                    return;
                }
                if (ColumnFieldWindow.this.selectedIndex <= 0) {
                    ColumnFieldWindow.this.selectedIndex = ColumnFieldWindow.this.mListBox.getSelectedIndex();
                    ColumnFieldWindow.this.lineMonitor.setParentCursor(Cursor.getPredefinedCursor(1));
                } else if (ColumnFieldWindow.this.selectedIndex > 0) {
                    ColumnFieldWindow.this.mListBox.setSelectedIndex(ColumnFieldWindow.this.selectedIndex);
                }
            }
        });
        this.mListBox.setBackground(Color.white);
        this.scrollPane = new JScrollPane(this.mListBox);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        contentPane.add((Component)this.scrollPane, "Center");
        this.addComponentListener(this);
    }

    public String getDisplayName() {
        if (this.forDataView) {
            return this.getTitle();
        }
        return this.tableInfo.getName();
    }

    void setDisplayName(String str) {
        this.setTitle(str);
        this.tableInfo.setName(str);
    }

    public String getTableName() {
        return this.tableInfo.getTableName();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor == Cursor.getDefaultCursor()) {
            cursor = null;
            super.setCursor(cursor);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mListBox.validate();
    }

    public String[] getColumns() {
        ListModel list;
        int size;
        if (this.mListBox != null && (size = (list = this.mListBox.getModel()).getSize()) > 1) {
            String[] ret = new String[size - 1];
            for (int i = 1; i < size; ++i) {
                ret[i - 1] = list.getElementAt(i).toString();
            }
            return ret;
        }
        return new String[0];
    }

    String getColumn(int i) {
        return (String)this.mListBox.getModel().getElementAt(i);
    }

    int getSQLType(int index) {
        if (index <= 0) {
            return -5;
        }
        return this.tableInfo.getColumn(index - 1).getSQLType();
    }

    private int locationToIndex(int y) {
        int header = (int)(this.getBounds().getHeight() - this.scrollPane.getBounds().getHeight());
        header = 0;
        int viewPos = (int)this.scrollPane.getViewport().getViewPosition().getY();
        return this.mListBox.locationToIndex(new Point(0, y - this.getY() - header + viewPos));
    }

    Rectangle getCellBounds(int i) {
        Rectangle rec = this.mListBox.getCellBounds(i, i);
        int header = (int)(this.getBounds().getHeight() - this.scrollPane.getBounds().getHeight());
        int viewPos = (int)this.scrollPane.getViewport().getViewPosition().getY();
        int curY = (int)(rec.getY() + (double)this.getY() + (double)header - (double)viewPos);
        if ((double)curY < this.getBounds().getY()) {
            curY = (int)(this.getBounds().getY() + rec.getHeight() / 2.0);
        } else if ((double)curY > this.getBounds().getHeight() + this.getBounds().getY()) {
            curY = (int)(this.getBounds().getY() + this.getBounds().getHeight() - rec.getHeight() / 2.0);
        }
        rec.setLocation((int)(rec.getX() + (double)this.getX()), curY);
        rec.setSize((int)this.getBounds().getWidth(), (int)rec.getHeight());
        return rec;
    }

    public int getIndex(String str) {
        ListModel model = this.mListBox.getModel();
        for (int i = 1; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).toString().equals(str)) continue;
            return i;
        }
        return -1;
    }

    int getIndex(String str, int sqlType) {
        ListModel model = this.mListBox.getModel();
        for (int i = 1; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).toString().equals(str) || sqlType != this.getSQLType(i)) continue;
            return i;
        }
        return -1;
    }

    private void addColumnField() {
        Object[] selectedFields;
        if (this.lineMonitor == null) {
            return;
        }
        if (this.mListBox.isSelectionEmpty()) {
            return;
        }
        for (Object selectedField : selectedFields = this.mListBox.getSelectedValues()) {
            this.lineMonitor.setColumn(this.getDisplayName(), selectedField.toString());
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.lineMonitor == null) {
            return;
        }
        this.lineMonitor.repaintDesktop();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.lineMonitor == null) {
            return;
        }
        this.lineMonitor.repaintDesktop();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.lineMonitor == null) {
            return;
        }
        this.lineMonitor.repaintDesktop();
    }

    public void orderColumns(boolean alphabetize) {
        if (this.lineMonitor == null) {
            return;
        }
        if (alphabetize && !this.alphabetized || !alphabetize && this.alphabetized) {
            if (alphabetize) {
                this.mListBox.setListData(this.alphabetizedColumns);
            } else {
                this.mListBox.setListData(this.originalColumns);
            }
            this.mListBox.repaint();
            this.alphabetized = alphabetize;
            this.lineMonitor.updateJoinProperties(this);
        }
    }

    public boolean isAlphabetized() {
        return this.alphabetized;
    }

    public int findMapping(int oldIndex) {
        Object[] oldlist = this.alphabetizedColumns;
        Object[] currentlist = this.originalColumns;
        if (this.alphabetized) {
            oldlist = this.originalColumns;
            currentlist = this.alphabetizedColumns;
        }
        Object columnName = oldlist[oldIndex];
        for (int i = 0; i < currentlist.length; ++i) {
            if (!columnName.equals(currentlist[i])) continue;
            return i;
        }
        return 0;
    }

    void setLineMonitor(IJoinLineMonitor lm) {
        this.lineMonitor = lm;
    }

    void setForDataView(boolean state) {
        this.forDataView = state;
    }

    private static JInternalFrame[] sortElement(JInternalFrame[] acell, int order, boolean isAsc) {
        Rectangle rec = null;
        Rectangle recl = null;
        for (int k = 0; k < acell.length; ++k) {
            int j = k;
            rec = acell[k].getBounds(rec);
            double d1 = order == 0 ? rec.getY() : rec.getX();
            for (int l = k + 1; l < acell.length; ++l) {
                recl = acell[l].getBounds(recl);
                double d3 = order == 0 ? recl.getY() : recl.getX();
                if (isAsc ? !(d3 < d1) : !(d3 > d1)) continue;
                d1 = d3;
                j = l;
            }
            if (k == j) continue;
            JInternalFrame cell = acell[k];
            acell[k] = acell[j];
            acell[j] = cell;
        }
        return acell;
    }

    private static Vector<JInternalFrame[]> sortHorizontally(JInternalFrame[] acell) {
        Vector<JInternalFrame[]> vector = new Vector<JInternalFrame[]>();
        acell = ColumnFieldWindow.sortElement(acell, 0, true);
        int i = 0;
        double d = 0.0;
        Rectangle recq = null;
        Rectangle reck = null;
        int j = 0;
        while (j < acell.length) {
            double h = -1.0;
            for (int q = i; q < acell.length && h < 0.0; ++q) {
                recq = acell[q].getBounds(recq);
                d = recq.getHeight() + recq.getY();
                h = recq.getHeight();
            }
            for (int k = i; k < acell.length; ++k) {
                if ((reck = acell[k].getBounds(reck)).getY() >= d) {
                    if (h != 0.0) break;
                    ++j;
                    break;
                }
                ++j;
            }
            if (j > i) {
                JInternalFrame[] acell1 = new JInternalFrame[j - i];
                for (int l = 0; l < acell1.length; ++l) {
                    acell1[l] = acell[i + l];
                }
                vector.addElement(ColumnFieldWindow.sortElement(acell1, 1, true));
            }
            i = j;
        }
        return vector;
    }
}

