/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;

public class ColumnReplacementDialog
extends JDialog
implements ActionListener {
    String[] oldColNames;
    String[] newColNames;
    String[] oldViewNames;
    String[] newViewNames;
    JButton okButton;
    JButton cancelButton;
    JTextField tf1;
    JTextField tf2;
    JTextField tf3;
    JTextField tf4;

    ColumnReplacementDialog(JDialog parent) {
        super(parent, LanguageEncoder.getText("Replace field name"), true);
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2, 5, 5));
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("Replace Database Field Name")));
        JLabel label1 = new JLabel(LanguageEncoder.getText("Original database field"));
        this.tf1 = new JTextField(20);
        JLabel label2 = new JLabel(LanguageEncoder.getText("replace with"));
        this.tf2 = new JTextField(20);
        panel.add(label1);
        panel.add(this.tf1);
        panel.add(label2);
        panel.add(this.tf2);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(2, 2, 5, 5));
        panel2.setBorder(new TitledBorder(LanguageEncoder.getText("Replace Dataview Business Name")));
        JLabel label3 = new JLabel(LanguageEncoder.getText("Original dataview field"));
        this.tf3 = new JTextField(20);
        JLabel label4 = new JLabel(LanguageEncoder.getText("replace with"));
        this.tf4 = new JTextField(20);
        panel2.add(label3);
        panel2.add(this.tf3);
        panel2.add(label4);
        panel2.add(this.tf4);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)panel, "North");
        contentPane.add((Component)panel2, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.oldColNames = this.parseString(this.tf1.getText());
            this.newColNames = this.parseString(this.tf2.getText());
            this.oldViewNames = this.parseString(this.tf3.getText());
            this.newViewNames = this.parseString(this.tf4.getText());
            this.setVisible(false);
            this.dispose();
        }
        if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public String[] getOldColNames() {
        return this.oldColNames;
    }

    public String[] getNewColNames() {
        return this.newColNames;
    }

    public String[] getOldViewNames() {
        return this.oldViewNames;
    }

    public String[] getNewViewNames() {
        return this.newViewNames;
    }

    private String[] parseString(String str) {
        int startIndex = 0;
        int endIndex = str.indexOf(59);
        Vector<String> strVec = new Vector<String>();
        while (endIndex > 0) {
            strVec.addElement(str.substring(startIndex, endIndex).trim());
            startIndex = endIndex + 1;
            endIndex = str.indexOf(";", startIndex);
        }
        strVec.addElement(str.substring(startIndex).trim());
        String[] strArr = new String[strVec.size()];
        for (int i = 0; i < strVec.size(); ++i) {
            strArr[i] = (String)strVec.elementAt(i);
        }
        return strArr;
    }
}

