/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.query.QueryBuilder;

public class ColumnTreeNode
extends DefaultMutableTreeNode {
    private TableTreeNode[] tableNodes = null;
    private String columnName = "";
    private boolean is_expression = false;
    private boolean isDataViewExpression = false;
    private String description = null;

    public ColumnTreeNode(Object columnname, TableTreeNode[] tnode) {
        super(columnname, false);
        this.columnName = columnname.toString();
        this.tableNodes = tnode;
    }

    public TableTreeNode[] getTableTreeNodes() {
        return this.tableNodes;
    }

    protected void setTableTreeNodes(TableTreeNode[] tnode) {
        this.tableNodes = tnode;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String name) {
        this.columnName = name;
    }

    public String getAlias() {
        Object alias = this.getUserObject();
        if (alias != null) {
            return alias.toString();
        }
        return null;
    }

    public void setAlias(String alias) {
        this.setUserObject(alias);
    }

    void setExpression(String expression) {
        this.columnName = expression;
        this.is_expression = true;
    }

    void setDataViewExpression(String expression) {
        this.columnName = expression;
        this.is_expression = true;
        this.isDataViewExpression = true;
    }

    public boolean isExpression() {
        return this.is_expression;
    }

    public boolean isDataViewExpression() {
        return this.isDataViewExpression;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getDescription() {
        return this.description;
    }

    public void copy(ColumnTreeNode cNode) {
        this.setUserObject(cNode.getUserObject());
        this.tableNodes = cNode.tableNodes;
        this.columnName = cNode.columnName;
        this.is_expression = cNode.is_expression;
        this.isDataViewExpression = cNode.isDataViewExpression;
        this.description = cNode.description;
    }

    public String getColumnListSQL(String productName) {
        int productType = QueryBuilder.mapDatabaseType(productName);
        StringBuffer tableList = new StringBuffer(" from ");
        for (int i = 0; i < this.tableNodes.length; ++i) {
            if (i != 0) {
                tableList.append(", ").append(QueryBuilder.formatField(productType, this.tableNodes[i].getTableName()));
                continue;
            }
            tableList.append(QueryBuilder.formatField(productType, this.tableNodes[i].getTableName()));
        }
        if (!this.isExpression()) {
            return "select " + QueryBuilder.formatField(productType, this.columnName) + tableList.toString();
        }
        return "select " + this.columnName + tableList.toString();
    }
}

