/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ColumnDescriptionDialog;
import quadbase.querybuilder.designer.ColumnTreeNode;
import quadbase.querybuilder.designer.FormulaBuilderDialog;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.query.DatabaseInfo;

public class ConditionColumnSelectionDialog
extends JDialog
implements ActionListener,
MouseListener {
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton descripButton;
    private JButton buildButton;
    private JButton renameButton;
    private JTree tableTree;
    private JTree viewTree;
    private boolean modified = false;
    private DatabaseInfo databaseInfo;

    public ConditionColumnSelectionDialog(Dialog owner, JTree vtree, ColumnTreeNode[] columns, DatabaseInfo dbInfo) throws Exception {
        super(owner, true);
        this.tableTree = vtree;
        this.databaseInfo = dbInfo;
        this.init(columns);
        this.setPosition();
    }

    private void init(ColumnTreeNode[] selectedColumns) {
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionColumnSelectionDialog.this.closeDialog();
            }
        });
        this.setTitle(LanguageEncoder.getText("Choose Columns"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        JPanel buildpanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buildpanel.setLayout(gridbag);
        buildpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Column Selection")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 10;
        gbc.fill = 1;
        JLabel comp = new JLabel(LanguageEncoder.getText("Available Columns"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 2;
        gbc.gridy = 0;
        comp = new JLabel(LanguageEncoder.getText("Selected Columns"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        this.addButton.addActionListener(this);
        gridbag.setConstraints(this.addButton, gbc);
        buildpanel.add(this.addButton);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        this.removeButton.addActionListener(this);
        gridbag.setConstraints(this.removeButton, gbc);
        buildpanel.add(this.removeButton);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.descripButton = new JButton(LanguageEncoder.getText("Description"));
        this.descripButton.addActionListener(this);
        gridbag.setConstraints(this.descripButton, gbc);
        buildpanel.add(this.descripButton);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.buildButton = new JButton(LanguageEncoder.getText("Build Formula"));
        this.buildButton.addActionListener(this);
        gridbag.setConstraints(this.buildButton, gbc);
        buildpanel.add(this.buildButton);
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.renameButton = new JButton(LanguageEncoder.getText("Rename"));
        this.renameButton.addActionListener(this);
        gridbag.setConstraints(this.renameButton, gbc);
        buildpanel.add(this.renameButton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.tableTree.setRootVisible(false);
        this.tableTree.setShowsRootHandles(false);
        this.tableTree.setVisibleRowCount(14);
        this.tableTree.addMouseListener(this);
        FocusAdapter flistener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Component temptree = event.getComponent();
                if (temptree instanceof JTree) {
                    if (temptree == ConditionColumnSelectionDialog.this.tableTree) {
                        ConditionColumnSelectionDialog.this.viewTree.clearSelection();
                    } else if (temptree == ConditionColumnSelectionDialog.this.viewTree) {
                        ConditionColumnSelectionDialog.this.tableTree.clearSelection();
                    }
                    if (((JTree)temptree).getSelectionPath() != null) {
                        ConditionColumnSelectionDialog.this.setButtonState((DefaultMutableTreeNode)((JTree)temptree).getSelectionPath().getLastPathComponent());
                    }
                }
            }
        };
        TreeSelectionListener slistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                ConditionColumnSelectionDialog.this.setButtonState(tn);
            }
        };
        this.tableTree.addFocusListener(flistener);
        this.tableTree.addTreeSelectionListener(slistener);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.tableTree);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        gbc.gridx = 2;
        gbc.gridy = 1;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(LanguageEncoder.getText("Columns"));
        this.viewTree = new JTree(root, true);
        this.viewTree.setRootVisible(false);
        this.viewTree.setShowsRootHandles(false);
        this.viewTree.setVisibleRowCount(14);
        this.viewTree.addFocusListener(flistener);
        this.viewTree.addTreeSelectionListener(slistener);
        this.viewTree.addMouseListener(this);
        if (selectedColumns != null) {
            for (ColumnTreeNode selectedColumn : selectedColumns) {
                String heading = this.getHeadingName(selectedColumn);
                this.addColumnToViewTree(selectedColumn, heading);
            }
        }
        this.expandAll(this.viewTree);
        this.tableTree.setSelectionRow(0);
        this.viewTree.clearSelection();
        scroll = new JScrollPane();
        scroll.getViewport().add(this.viewTree);
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        bpanel.add("Center", buildpanel);
        bpanel.add("South", okpanel);
    }

    private void setPosition() {
        ((DefaultTreeModel)this.viewTree.getModel()).reload();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setButtonState(DefaultMutableTreeNode tn) {
        this.addButton.setEnabled(this.isAddEnabled(tn));
        this.removeButton.setEnabled(this.isRemoveEnabled(tn));
        this.descripButton.setEnabled(this.isDescriptionEnabled(tn));
        this.buildButton.setEnabled(this.isBuildEnabled(tn));
        this.renameButton.setEnabled(this.isRenameEnabled(tn));
    }

    public boolean isModified() {
        return this.modified;
    }

    private boolean isAddEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
        return node instanceof ColumnTreeNode || rootname.equals("View");
    }

    private boolean isRemoveEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        TreePath[] paths = this.viewTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path.getLastPathComponent() == this.viewTree.getModel().getRoot()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDescriptionEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        return node instanceof ColumnTreeNode && this.tableTree.getSelectionCount() == 1 || node.getUserObject() instanceof ColumnTreeNode && this.viewTree.getSelectionCount() == 1;
    }

    private boolean isBuildEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        return this.tableTree.getSelectionCount() == 1 || this.viewTree.getSelectionCount() == 1;
    }

    private boolean isRenameEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.getUserObject() instanceof ColumnTreeNode && ((ColumnTreeNode)node.getUserObject()).isDataViewExpression()) {
            return true;
        }
        return node instanceof ColumnTreeNode && ((ColumnTreeNode)node).isDataViewExpression();
    }

    private void doAdd() {
        try {
            TreePath[] selected = this.tableTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Vector<TreeNode> added = new Vector<TreeNode>();
            for (TreePath element : selected) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)element.getLastPathComponent();
                if (node instanceof ColumnTreeNode) {
                    if (added.contains(node)) continue;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    String parentString = null;
                    if (parent != null) {
                        parentString = (String)parent.getUserObject();
                    }
                    this.addColumnToViewTree(node, parentString);
                    added.addElement(node);
                    continue;
                }
                for (int j = 0; j < node.getChildCount(); ++j) {
                    if (added.contains(node.getChildAt(j))) continue;
                    this.addColumnToViewTree((DefaultMutableTreeNode)node.getChildAt(j), (String)node.getUserObject());
                    added.addElement(node.getChildAt(j));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doRemove() {
        try {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)this.viewTree.getModel();
            for (TreePath element : selected) {
                Object node = element.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) continue;
                DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)node;
                treeModel.removeNodeFromParent(dnode);
            }
            this.viewTree.clearSelection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doDescription(ColumnTreeNode cNode) {
        if (cNode == null) {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (!(selected != null && selected.length != 0 || (selected = this.tableTree.getSelectionPaths()) != null && selected.length != 0)) {
                return;
            }
            Object node = selected[selected.length - 1].getLastPathComponent();
            if (node instanceof ColumnTreeNode) {
                cNode = (ColumnTreeNode)node;
            } else if (node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof ColumnTreeNode) {
                cNode = (ColumnTreeNode)((DefaultMutableTreeNode)node).getUserObject();
            } else {
                return;
            }
        }
        ColumnDescriptionDialog dDialog = new ColumnDescriptionDialog(this, cNode.getAlias(), cNode.getDescription(), true);
        dDialog.setVisible(true);
        if (dDialog.isModified()) {
            cNode.setDescription(dDialog.getDescription());
        }
    }

    private void doRename() {
        try {
            boolean updateTree = false;
            TreePath[] selected = this.viewTree.getSelectionPaths();
            DefaultMutableTreeNode node = null;
            if (selected != null && selected.length != 0 && (node = (DefaultMutableTreeNode)selected[0].getLastPathComponent()).getUserObject() instanceof ColumnTreeNode && this.doRename((ColumnTreeNode)node.getUserObject())) {
                updateTree = true;
            }
            Object node1 = null;
            if (!updateTree && (selected = this.tableTree.getSelectionPaths()) != null && selected.length != 0 && (node1 = selected[0].getLastPathComponent()) instanceof ColumnTreeNode && this.doRename((ColumnTreeNode)node1)) {
                updateTree = true;
            }
            if (updateTree) {
                if (node != null) {
                    ((DefaultTreeModel)this.viewTree.getModel()).reload(node);
                }
                if (node1 != null) {
                    ((DefaultTreeModel)this.tableTree.getModel()).reload((ColumnTreeNode)node1);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean doRename(ColumnTreeNode node) {
        if (!node.isDataViewExpression()) {
            return false;
        }
        try {
            boolean OK = false;
            JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:") + " ", 3, 2);
            String tmp = node.getAlias();
            optionPane.setInitialSelectionValue(tmp);
            while (!OK) {
                optionPane.setWantsInput(true);
                JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("New Column Name"));
                dialog.setVisible(true);
                dialog.dispose();
                if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                    return false;
                }
                tmp = (String)optionPane.getInputValue();
                if (tmp != null && !tmp.trim().equals("")) {
                    boolean error = false;
                    if (ConditionColumnSelectionDialog.containsIllegalCharacters(tmp)) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Column name can only contain letters and numbers:") + " " + tmp);
                        error = true;
                    }
                    if (this.aliasExists(tmp = tmp.trim())) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Column name already exists:") + " " + tmp);
                        error = true;
                    }
                    if (error) continue;
                    node.setAlias(tmp);
                    OK = true;
                    continue;
                }
                OK = true;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void doBuild() {
        FormulaBuilderDialog builder = new FormulaBuilderDialog(this, this.databaseInfo, "", this.createCopy((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()), false);
        builder.setVisible(true);
        String formula = null;
        if (builder.isModified()) {
            formula = builder.getFormula();
        }
        if (formula == null || formula.trim().equals("")) {
            return;
        }
        Vector<TableTreeNode> selectedTablesVec = ConditionColumnSelectionDialog.getRequiredTableTreeNodes(formula, this.tableTree);
        TableTreeNode[] selectedTables = selectedTablesVec.toArray(new TableTreeNode[selectedTablesVec.size()]);
        String alias = "Expression";
        ColumnTreeNode columnNode = this.addColumnNode((Object)formula, selectedTables, this.tableTree);
        columnNode.setDataViewExpression(formula);
        int ct = 0;
        while (this.aliasExists(alias)) {
            alias = "Expression_" + ct++;
        }
        columnNode.setUserObject(alias);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)columnNode.getParent();
        String parentString = null;
        if (parent != null) {
            parentString = parent.getUserObject().toString();
        }
        this.addColumnToViewTree(columnNode, parentString);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tableTree.getModel();
        DefaultMutableTreeNode parentNode = parentString == null ? (DefaultMutableTreeNode)treeModel.getRoot() : this.getHeading(parentString, this.tableTree);
        columnNode.setParent(null);
        treeModel.insertNodeInto(columnNode, parentNode, parentNode.getChildCount());
    }

    private void doRebuild(ColumnTreeNode node) {
        FormulaBuilderDialog builder = new FormulaBuilderDialog((JDialog)this, this.databaseInfo, node.getColumnName(), this.createCopy((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()));
        builder.setVisible(true);
        String formula = null;
        if (builder.isModified()) {
            formula = builder.getFormula();
            node.setDataViewExpression(formula);
            Vector<TableTreeNode> selectedTablesVec = ConditionColumnSelectionDialog.getRequiredTableTreeNodes(formula, this.tableTree);
            TableTreeNode[] selectedTables = selectedTablesVec.toArray(new TableTreeNode[selectedTablesVec.size()]);
            node.setTableTreeNodes(selectedTables);
        }
    }

    public static Vector<TableTreeNode> getRequiredTableTreeNodes(String formula, JTree tableTree) {
        DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)tableTree.getModel().getRoot();
        Vector<TableTreeNode> nodeList = new Vector<TableTreeNode>();
        for (int i = 0; i < viewroot.getChildCount(); ++i) {
            DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)viewroot.getChildAt(i);
            for (int j = 0; j < tableNode.getChildCount(); ++j) {
                TableTreeNode[] tableNodes;
                DefaultMutableTreeNode tempnode = (DefaultMutableTreeNode)tableNode.getChildAt(j);
                if (!(tempnode instanceof ColumnTreeNode)) continue;
                ColumnTreeNode columnNode = (ColumnTreeNode)tempnode;
                String oldString = "{" + (String)tableNode.getUserObject() + "." + columnNode.getAlias() + "}";
                if (formula.indexOf(oldString) < 0 || (tableNodes = columnNode.getTableTreeNodes()) == null) continue;
                for (int k = 0; k < tableNodes.length; ++k) {
                    if (nodeList.contains(tableNodes[k])) continue;
                    nodeList.addElement(tableNodes[k]);
                }
            }
        }
        return nodeList;
    }

    private DefaultMutableTreeNode createCopy(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode cNode = null;
        if (node instanceof ColumnTreeNode) {
            cNode = new ColumnTreeNode((Object)"", null);
            ((ColumnTreeNode)cNode).copy((ColumnTreeNode)node);
        } else {
            cNode = new DefaultMutableTreeNode(node.getUserObject());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChildAt(i) instanceof ColumnTreeNode && ((ColumnTreeNode)node.getChildAt(i)).isDataViewExpression()) continue;
            cNode.add(this.createCopy((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return cNode;
    }

    private ColumnTreeNode getExpressionNode() {
        TreePath[] selected = this.viewTree.getSelectionPaths();
        if (selected != null && selected.length != 0) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)selected[0].getLastPathComponent();
            if (!(n.getUserObject() instanceof ColumnTreeNode)) {
                return null;
            }
            ColumnTreeNode node = (ColumnTreeNode)n.getUserObject();
            if (node.isDataViewExpression()) {
                return node;
            }
            return null;
        }
        selected = this.tableTree.getSelectionPaths();
        if (selected != null && selected.length != 0) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)selected[0].getLastPathComponent();
            if (!(n instanceof ColumnTreeNode)) {
                return null;
            }
            ColumnTreeNode node = (ColumnTreeNode)n;
            if (node.isDataViewExpression()) {
                return node;
            }
            return null;
        }
        return null;
    }

    private DefaultMutableTreeNode getSelectedFolder(JTree tree) {
        if (tree == null) {
            return null;
        }
        TreePath selected = tree.getSelectionPath();
        if (selected == null) {
            return null;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)selected.getLastPathComponent();
        if (!(n instanceof ColumnTreeNode) && !n.isLeaf()) {
            return n;
        }
        return (DefaultMutableTreeNode)n.getParent();
    }

    private boolean aliasExists(String alias) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            DefaultMutableTreeNode header = (DefaultMutableTreeNode)root.getChildAt(j);
            for (int i = 0; i < header.getChildCount(); ++i) {
                DefaultMutableTreeNode column = (DefaultMutableTreeNode)header.getChildAt(i);
                if (column.getUserObject() == null || !column.getUserObject().toString().equals(alias)) continue;
                return true;
            }
        }
        return false;
    }

    private ColumnTreeNode addColumnNode(Object name, TableTreeNode[] parentTable, JTree tree) {
        return this.addColumnNode(name, parentTable, this.getSelectedFolder(tree));
    }

    private ColumnTreeNode addColumnNode(Object name, TableTreeNode[] parentTable, DefaultMutableTreeNode viewroot) {
        ColumnTreeNode columnnode = new ColumnTreeNode(name, parentTable);
        String alias = (String)name;
        if (alias == null) {
            alias = "";
        }
        int ct = 0;
        while (this.aliasExists(alias)) {
            alias = name + "_" + ct++;
        }
        columnnode.setUserObject(alias);
        if (viewroot == null) {
            DefaultMutableTreeNode selectedNode = this.getSelectedFolder(this.viewTree);
            if (selectedNode != null) {
                viewroot = selectedNode;
            } else {
                DefaultTreeModel treeModel = (DefaultTreeModel)this.viewTree.getModel();
                viewroot = (DefaultMutableTreeNode)treeModel.getRoot();
            }
        }
        columnnode.setParent(viewroot);
        return columnnode;
    }

    public static boolean containsIllegalCharacters(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ' ' || c == '_') continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.addButton) {
            this.doAdd();
        } else if (e.getSource() == this.removeButton) {
            this.doRemove();
        } else if (e.getSource() == this.descripButton) {
            this.doDescription(null);
        } else if (e.getSource() == this.buildButton) {
            ColumnTreeNode expNode = this.getExpressionNode();
            if (expNode == null) {
                this.doBuild();
            } else {
                this.doRebuild(expNode);
            }
        } else if (e.getSource() == this.renameButton) {
            this.doRename();
        } else if (e.getSource() == this.okButton) {
            this.tableTree.removeMouseListener(this);
            DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
            if (viewroot.getChildCount() <= 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please add one or more columns to this result set."));
                return;
            }
            this.setVisible(false);
            this.dispose();
            this.modified = true;
        }
    }

    private void closeDialog() {
        this.tableTree.removeMouseListener(this);
        this.setVisible(false);
        this.dispose();
    }

    public ColumnTreeNode[] getSelectedColumns() {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        Vector<Object> selected = new Vector<Object>();
        for (int i = 0; i < tableroot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)tableroot.getChildAt(i);
            if (child.getAllowsChildren()) {
                for (int j = 0; j < child.getChildCount(); ++j) {
                    selected.add(((DefaultMutableTreeNode)child.getChildAt(j)).getUserObject());
                }
                continue;
            }
            selected.add(child.getUserObject());
        }
        ColumnTreeNode[] ret = new ColumnTreeNode[selected.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (ColumnTreeNode)selected.elementAt(i);
        }
        return ret;
    }

    private void addColumnToViewTree(DefaultMutableTreeNode tname, String heading) {
        ColumnTreeNode[] existing;
        if (!(tname instanceof ColumnTreeNode)) {
            return;
        }
        for (ColumnTreeNode element : existing = this.getSelectedColumns()) {
            if (!element.equals(tname)) continue;
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.viewTree.getModel();
        DefaultMutableTreeNode parentNode = heading == null ? (DefaultMutableTreeNode)treeModel.getRoot() : this.getHeading(heading, this.viewTree);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(tname, false);
        treeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
        this.viewTree.scrollPathToVisible(new TreePath(newNode.getPath()));
    }

    private DefaultMutableTreeNode getHeading(String name, JTree tree) {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)tree.getModel().getRoot();
        for (int i = 0; i < tableroot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)tableroot.getChildAt(i);
            if (!child.getAllowsChildren() || child.getUserObject() == null || !child.getUserObject().equals(name)) continue;
            return child;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode newHeading = new DefaultMutableTreeNode(name);
        treeModel.insertNodeInto(newHeading, tableroot, tableroot.getChildCount());
        return newHeading;
    }

    private String getHeadingName(ColumnTreeNode column) {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.tableTree.getModel().getRoot();
        for (int i = 0; i < tableroot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)tableroot.getChildAt(i);
            if (!child.getAllowsChildren()) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                if (!child.getChildAt(j).equals(column)) continue;
                return (String)child.getUserObject();
            }
        }
        return null;
    }

    private void expandAll(JTree tree) {
        int i;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        int rowCt = root.getChildCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = new TreePath(((DefaultMutableTreeNode)root.getChildAt(i)).getPath());
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath;
        if (e.getSource() == this.tableTree) {
            DefaultMutableTreeNode node;
            TreePath selPath2 = this.tableTree.getPathForLocation(e.getX(), e.getY());
            if (selPath2 != null && (node = (DefaultMutableTreeNode)selPath2.getLastPathComponent()) instanceof ColumnTreeNode && e.getClickCount() == 2) {
                this.doAdd();
            }
        } else if (e.getSource() == this.viewTree && (selPath = this.viewTree.getPathForLocation(e.getX(), e.getY())) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (e.getClickCount() == 2 && node.getUserObject() instanceof ColumnTreeNode) {
                this.doDescription((ColumnTreeNode)node.getUserObject());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    JTree getViewTree() {
        return this.viewTree;
    }

    JTree getTableTree() {
        return this.tableTree;
    }
}

