/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasourcemanager.manager.DataViewINParametersDialog;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.ColumnReplacementDialog;
import quadbase.querybuilder.designer.ColumnTreeNode;
import quadbase.querybuilder.designer.ConditionColumnSelectionDialog;
import quadbase.querybuilder.designer.ConditionOperatorDialog;
import quadbase.querybuilder.designer.ConditionPanel;
import quadbase.querybuilder.designer.DataViewDialog;
import quadbase.querybuilder.designer.FormulaBuilderDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.designer.ViewColumnDialog;
import quadbase.querybuilder.query.QueryBuilder;

public class ConditionDialog
extends JDialog
implements ActionListener,
MouseListener {
    private DataViewDialog dataView;
    private JButton cancelButton;
    private JButton okButton;
    private JButton chooseColumnsButton;
    private JButton toggleButton;
    private JButton saveQueryButton;
    private JTextField nameField = null;
    private JTable viewTable;
    private JTable viewTableVertical;
    private JScrollPane hScrollPane;
    private JScrollPane vScrollPane;
    private int[] columnSQLType = null;
    private ColumnFieldWindow[] windows;
    private ColumnFieldWindow[] requiredWindows;
    private String[][] joinProperties;
    private String[][] requiredJoinProperties;
    private JTable qbeTable;
    private boolean modified = false;
    private ColumnTreeNode[] selectedColumns;
    private boolean isVertical = false;
    private static final int VERSION = 1;
    private ConditionPanel conditionPanel;
    private JPopupMenu popupMenu = null;
    private Manager manager;
    private DataViewNode dataViewNode = null;
    private DataViewQueryNode dataViewQueryNode = null;
    private String formula = "";
    private QueryInParamSet paramSet = null;
    private boolean modifiedParameter = false;
    private boolean allowSaveQuery = true;
    private String[] defaultParamNames = null;
    private boolean defaultValueRequired = false;
    private boolean editing = false;
    private boolean silentMode = false;
    private boolean columnNotFound = false;
    private Exception error = null;
    private Vector<Vector<ColumnFieldWindow>> deadendPaths;
    private int[] fieldMap = new int[]{2, 3, 4, 5};

    public ConditionDialog(Manager owner, DataViewDialog dDialog, DataViewNode dnode) throws Exception {
        super((Dialog)owner, true);
        this.manager = owner;
        this.dataViewNode = dnode;
        this.dataView = dDialog;
        this.defaultParamNames = this.manager.getDefaultParamNames();
        this.defaultValueRequired = this.manager.isDefaultValueRequiredForParameters();
        this.windows = this.dataView.getColumnFieldWindows();
        this.joinProperties = this.dataView.getJoinProperties();
        this.qbeTable = this.dataView.getQBETable();
        this.formula = this.dataView.getFormula();
        ConditionColumnSelectionDialog columnDialog = new ConditionColumnSelectionDialog((Dialog)this, this.dataView.getViewTree(), null, this.dataView.getDatabaseInfo());
        columnDialog.setVisible(true);
        this.selectedColumns = columnDialog.getSelectedColumns();
        if (!columnDialog.isModified() || this.selectedColumns.length == 0) {
            throw new Exception("CANCELED");
        }
        this.updateTable();
        this.findRequiredWindows(this.selectedColumns);
        this.init();
        this.nameField.setEditable(true);
        this.setPosition();
        if (this.columnNotFound) {
            this.doColumnReplacement();
        }
    }

    public ConditionDialog(Manager owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable<String, String> env, String driver, String url, String username, String password, DataViewQueryNode dnode, boolean sMode) throws Exception {
        this(owner, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, dnode, sMode, null);
    }

    public ConditionDialog(Manager owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable<String, String> env, String driver, String url, String username, String password, DataViewQueryNode dnode, boolean sMode, Vector<String> additionalDb) throws Exception {
        super((Dialog)owner, true);
        this.editing = true;
        this.silentMode = sMode;
        this.dataViewQueryNode = dnode;
        this.manager = owner;
        this.dataViewNode = (DataViewNode)dnode.getParent();
        if (!this.silentMode) {
            this.defaultParamNames = this.manager.getDefaultParamNames();
        }
        if (!this.silentMode) {
            this.defaultValueRequired = this.manager.isDefaultValueRequiredForParameters();
        }
        this.dataView = new DataViewDialog(this.manager, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, this.dataViewNode.toString(), QueryMain.QUERYDIR + dnode.getDataViewFile() + ".dvw", true, additionalDb, sMode);
        this.windows = this.dataView.getColumnFieldWindows();
        this.joinProperties = this.dataView.getJoinProperties();
        this.qbeTable = this.dataView.getQBETable();
        this.formula = this.dataView.getFormula();
        this.selectedColumns = null;
        this.init();
        this.nameField.setText(this.dataViewQueryNode.getName());
        this.load(this.dataViewQueryNode.getQueryFile());
        this.setPosition();
        if (!this.silentMode && this.columnNotFound) {
            this.doColumnReplacement();
        }
    }

    public ConditionDialog(JFrame parent, boolean isUseJNDIDataSource, String JNDIName, Hashtable<String, String> env, String driver, String url, String username, String password, byte[][] fileBytes) throws Exception {
        super((Frame)parent, true);
        this.dataView = new DataViewDialog(parent, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, LanguageEncoder.getText("Data View"), fileBytes[0]);
        this.constructor_helper(fileBytes, false);
    }

    public ConditionDialog(JFrame parent, boolean isUseJNDIDataSource, String JNDIName, Hashtable<String, String> env, String driver, String url, String username, String password, Vector<String> additionalDb, byte[][] fileBytes) throws Exception {
        super((Frame)parent, true);
        this.dataView = new DataViewDialog(parent, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, LanguageEncoder.getText("Data View"), additionalDb, fileBytes[0]);
        this.constructor_helper(fileBytes, false);
    }

    public ConditionDialog(JDialog parent, boolean isUseJNDIDataSource, String JNDIName, Hashtable<String, String> env, String driver, String url, String username, String password, byte[][] fileBytes, boolean sMode) throws Exception {
        super((Dialog)parent, true);
        this.dataView = new DataViewDialog(parent, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, LanguageEncoder.getText("Data View"), fileBytes[0]);
        this.constructor_helper(fileBytes, sMode);
    }

    private void constructor_helper(byte[][] fileBytes, boolean sMode) throws Exception {
        this.editing = true;
        this.silentMode = sMode;
        this.allowSaveQuery = false;
        this.windows = this.dataView.getColumnFieldWindows();
        this.joinProperties = this.dataView.getJoinProperties();
        this.qbeTable = this.dataView.getQBETable();
        this.formula = this.dataView.getFormula();
        this.selectedColumns = null;
        this.init();
        this.load(new DataInputStream(new ByteArrayInputStream(fileBytes[1])));
        this.nameField.setText("Internal Dataview Query");
        this.setPosition();
        if (!this.silentMode && this.columnNotFound) {
            this.doColumnReplacement();
        }
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        this.setTitle(LanguageEncoder.getText("Data View -") + " " + this.dataView.getName());
        this.setJMenuBar(this.createMenuBar());
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.removeAll();
        bpanel.setLayout(new BorderLayout());
        JPanel buildpanel = new JPanel();
        buildpanel.setLayout(new BorderLayout());
        buildpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data View Properties")));
        int colcount = this.qbeTable.getColumnCount();
        this.viewTable = new JTable(5, colcount);
        this.viewTable.setGridColor(Color.lightGray);
        JTable rowHeader = new JTable(5, 1){

            @Override
            public boolean isCellSelected(int row, int col) {
                return row >= 4;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        rowHeader.setGridColor(Color.lightGray);
        rowHeader.setValueAt(LanguageEncoder.getText("Sort:"), 0, 0);
        rowHeader.setValueAt(LanguageEncoder.getText("Aggregation:"), 1, 0);
        rowHeader.setValueAt(LanguageEncoder.getText("Show:"), 2, 0);
        rowHeader.setValueAt(LanguageEncoder.getText("Condition:"), 3, 0);
        rowHeader.setValueAt("", 4, 0);
        rowHeader.setSelectionBackground(Color.lightGray);
        rowHeader.setGridColor(Color.lightGray);
        Object[][] data = new Object[5][colcount];
        Object[] header = new String[colcount];
        for (int i = 0; i < colcount; ++i) {
            header[i] = this.qbeTable.getModel().getColumnName(i);
            data[0][i] = null;
            data[1][i] = null;
            data[2][i] = Boolean.TRUE;
            data[3][i] = null;
            data[4][i] = null;
        }
        ((DefaultTableModel)this.viewTable.getModel()).setDataVector(data, header);
        if (this.selectedColumns != null) {
            TableColumnModel tcm = this.viewTable.getColumnModel();
            for (int i = 0; i < colcount; ++i) {
                int j = 0;
                for (j = 0; j < this.selectedColumns.length; ++j) {
                    if (!tcm.getColumn(i).getHeaderValue().equals(this.selectedColumns[j].getAlias())) continue;
                    tcm.getColumn(i).setPreferredWidth(110);
                    j = this.selectedColumns.length + 1;
                }
                if (j != this.selectedColumns.length) continue;
                tcm.getColumn(i).setMinWidth(0);
                tcm.getColumn(i).setMaxWidth(0);
            }
            this.syncColumnOrder(this.viewTable, this.selectedColumns);
        }
        this.viewTable.setDefaultEditor(new Object().getClass(), new InternalCellEditor());
        this.viewTable.setAutoResizeMode(0);
        this.viewTable.setCellSelectionEnabled(true);
        this.viewTable.setSelectionMode(0);
        this.viewTable.setDefaultRenderer(new Object().getClass(), new InternalCellRenderer(false));
        this.viewTable.addMouseListener(this);
        JScrollPane tablePanel = new JScrollPane();
        tablePanel.getViewport().add(this.viewTable);
        tablePanel.setRowHeaderView(rowHeader);
        Dimension d = tablePanel.getRowHeader().getPreferredSize();
        tablePanel.getRowHeader().setPreferredSize(new Dimension(80, (int)d.getHeight()));
        d = tablePanel.getPreferredSize();
        tablePanel.setPreferredSize(new Dimension(545, 300));
        this.hScrollPane = tablePanel;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(gridbag);
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new FlowLayout(0));
        this.chooseColumnsButton = new JButton(LanguageEncoder.getText("Choose Columns"));
        this.chooseColumnsButton.addActionListener(this);
        leftpanel.add(this.chooseColumnsButton);
        this.toggleButton = new JButton(LanguageEncoder.getText("Vertical View"));
        this.toggleButton.addActionListener(this);
        this.saveQueryButton = new JButton(LanguageEncoder.getText("Save Query"));
        this.saveQueryButton.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gridbag.setConstraints(leftpanel, gbc);
        bottomPanel.add(leftpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gridbag.setConstraints(okpanel, gbc);
        bottomPanel.add(okpanel);
        JPanel namePanel = new JPanel(new FlowLayout(1));
        namePanel.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        this.nameField = new JTextField("", 20);
        namePanel.add(this.nameField);
        this.nameField.setEditable(false);
        bpanel.add((Component)namePanel, "North");
        bpanel.add((Component)buildpanel, "Center");
        bpanel.add((Component)bottomPanel, "South");
        try {
            colcount = this.qbeTable.getColumnCount();
            Object[][] colInfo = this.dataView.getDatabaseInfo().getTableInfo(this.getQuery(true), true);
            this.columnSQLType = new int[colcount];
            for (int i = 0; i < colcount; ++i) {
                this.columnSQLType[i] = (Integer)colInfo[i][1];
            }
        }
        catch (Exception ex) {
            String excep = "";
            try {
                excep = QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n");
                excep = "\n" + excep;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.silentMode) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An error has occured while setting up the data view.") + excep);
            } else {
                this.error = ex;
            }
            this.columnSQLType = null;
            this.columnNotFound = true;
        }
        this.conditionPanel = new ConditionPanel(this, this.hScrollPane);
        buildpanel.add((Component)this.conditionPanel, "Center");
        this.popupMenu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Condition...");
        menuitem.addActionListener(this);
        this.popupMenu.add(menuitem);
        menuitem = new JMenuItem("Build...");
        menuitem.addActionListener(this);
        this.popupMenu.add(menuitem);
        this.popupMenu.addSeparator();
        menuitem = new JMenuItem("Delete");
        menuitem.addActionListener(this);
        this.popupMenu.add(menuitem);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu mFile = new JMenu("Option");
        JMenuItem menuitem = new JMenuItem("Horizontal/Vertical View");
        menuitem.setActionCommand("Toggle View");
        menuitem.addActionListener(this);
        mFile.add(menuitem);
        menuitem = new JMenuItem("Initialize Parameters...");
        menuitem.setActionCommand("Initialize Parameters...");
        menuitem.addActionListener(this);
        mFile.add(menuitem);
        if (this.manager != null && !this.manager.canModify()) {
            this.allowSaveQuery = false;
        }
        if (this.allowSaveQuery) {
            menuitem = new JMenuItem("Save Query");
            menuitem.setActionCommand("Save Query...");
            menuitem.addActionListener(this);
            mFile.add(menuitem);
        }
        menuBar.add(mFile);
        return menuBar;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getQuery() {
        return this.getQuery(false);
    }

    private String getQuery(boolean allVisible) {
        this.clearSelection();
        boolean includedFormula = false;
        TableColumnModel tcm = this.viewTable.getColumnModel();
        for (int i = 0; i < this.qbeTable.getColumnCount(); ++i) {
            Object condition = this.viewTable.getModel().getValueAt(3, i);
            this.qbeTable.getModel().setValueAt(this.viewTable.getModel().getValueAt(0, i), 2, i);
            this.qbeTable.getModel().setValueAt(condition, 5, i);
            Object aggr = this.qbeTable.getModel().getValueAt(3, i);
            if (aggr != null && aggr.toString().equals(QueryBuilder.AGGR[11]) || tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).getMaxWidth() == 0) {
                this.qbeTable.getModel().setValueAt(Boolean.FALSE, 4, i);
            } else {
                this.qbeTable.getModel().setValueAt(this.viewTable.getModel().getValueAt(2, i), 4, i);
            }
            this.qbeTable.getModel().setValueAt(condition, 5, i);
            if (!includedFormula && (condition == null || condition.toString().trim().equals(""))) {
                this.qbeTable.getModel().setValueAt(this.formula, 5, i);
                includedFormula = true;
            } else if (!includedFormula && i == this.qbeTable.getColumnCount() - 1) {
                this.qbeTable.getModel().setValueAt(condition.toString() + " AND (" + this.formula + ")", 5, i);
                includedFormula = true;
            }
            if (!allVisible) continue;
            this.qbeTable.getModel().setValueAt(Boolean.TRUE, 4, i);
        }
        ColumnFieldWindow[] temp_windows = this.windows;
        String[][] temp_joinProperties = this.joinProperties;
        if (this.selectedColumns != null) {
            ColumnTreeNode[] columnorder = new ColumnTreeNode[this.selectedColumns.length];
            int index = 0;
            for (int i = 0; i < this.viewTable.getColumnCount() && index < this.selectedColumns.length; ++i) {
                if (tcm.getColumn(i).getMaxWidth() == 0) continue;
                columnorder[index] = this.getColumnTreeNode(tcm.getColumn(i).getHeaderValue().toString());
                ++index;
            }
            if (!allVisible) {
                this.syncColumnOrder(this.qbeTable, columnorder);
                temp_windows = this.requiredWindows;
                temp_joinProperties = this.requiredJoinProperties;
            }
        }
        try {
            TableModel model = this.qbeTable.getModel();
            for (int i = 5; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    Object obj = model.getValueAt(i, this.qbeTable.convertColumnIndexToModel(j));
                    if (obj == null || obj.toString().trim().equals("")) continue;
                    String con = obj.toString().trim();
                    model.setValueAt(this.replaceDataViewFields(con), i, this.qbeTable.convertColumnIndexToModel(j));
                }
            }
            String query = QueryBuilder.create(QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName()), this.qbeTable, temp_windows, temp_joinProperties).buildQuery();
            return this.replaceDataViewFields(query);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public Vector<String> getColumnNames() {
        this.clearSelection();
        Vector<String> columnNames = new Vector<String>();
        TableColumnModel tcm = this.viewTable.getColumnModel();
        for (int i = 0; i < this.viewTable.getColumnCount(); ++i) {
            Object aggr = this.viewTable.getValueAt(1, i);
            if (aggr != null && aggr.toString().equals(QueryBuilder.AGGR[11]) || tcm.getColumn(i).getMaxWidth() <= 0 || !((Boolean)this.viewTable.getValueAt(2, i)).booleanValue()) continue;
            columnNames.add(this.addDataTypeToColumnName((String)tcm.getColumn(i).getHeaderValue(), this.viewTable.convertColumnIndexToModel(i)));
        }
        return columnNames;
    }

    public String addDataTypeToColumnName(String columnName, int columnIndex) {
        return "<html>" + columnName + "<br>(" + DataType.getTypeName(this.getSQLType(columnIndex)) + ")</html>";
    }

    private String getColumnQuery(int column) {
        Object aggr = this.qbeTable.getModel().getValueAt(3, column);
        if (column < 0 || column >= this.qbeTable.getColumnCount()) {
            return "";
        }
        JTable t = null;
        if (aggr == null || aggr.toString().trim().equals("") || aggr.toString().equals(QueryBuilder.AGGR[11])) {
            t = new JTable(10, 1);
            t.setGridColor(Color.lightGray);
            Object[][] data = new Object[10][1];
            Object[] header = new String[]{this.qbeTable.getModel().getColumnName(column)};
            data[1][0] = this.qbeTable.getModel().getValueAt(1, column);
            data[0][0] = this.qbeTable.getModel().getValueAt(0, column);
            data[4][0] = Boolean.TRUE;
            data[2][0] = QueryBuilder.SORT_ORDER[1];
            data[3][0] = null;
            data[5][0] = this.formula;
            data[6][0] = null;
            data[7][0] = null;
            data[8][0] = null;
            data[9][0] = null;
            ((DefaultTableModel)t.getModel()).setDataVector(data, header);
        } else {
            boolean includedFormula = false;
            for (int i = 0; i < this.qbeTable.getColumnCount(); ++i) {
                Object condition = this.viewTable.getModel().getValueAt(3, i);
                this.qbeTable.getModel().setValueAt(condition, 5, i);
                if (i != column) {
                    this.qbeTable.getModel().setValueAt(Boolean.FALSE, 4, i);
                    this.qbeTable.getModel().setValueAt(null, 2, i);
                } else {
                    this.qbeTable.getModel().setValueAt(Boolean.TRUE, 4, i);
                    this.qbeTable.getModel().setValueAt(QueryBuilder.SORT_ORDER[1], 2, i);
                }
                if (!includedFormula && (condition == null || condition.toString().trim().equals(""))) {
                    this.qbeTable.getModel().setValueAt(this.formula, 5, i);
                    includedFormula = true;
                    continue;
                }
                if (includedFormula || i != this.qbeTable.getColumnCount() - 1) continue;
                this.qbeTable.getModel().setValueAt(condition.toString() + " AND (" + this.formula + ")", 5, i);
                includedFormula = true;
            }
            t = this.qbeTable;
        }
        try {
            String query = "";
            if (!t.getModel().getValueAt(0, 0).toString().equalsIgnoreCase("Expression") && (aggr == null || aggr.toString().trim().equals("") || aggr.toString().equals(QueryBuilder.AGGR[11]))) {
                ColumnFieldWindow[] tempWindow = new ColumnFieldWindow[1];
                for (ColumnFieldWindow requiredWindow : this.requiredWindows) {
                    if (!requiredWindow.getTitle().equals(t.getModel().getValueAt(0, 0))) continue;
                    tempWindow[0] = requiredWindow;
                }
                query = QueryBuilder.create(QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName()), t, tempWindow, new String[0][0]).buildQuery();
            } else {
                query = QueryBuilder.create(QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName()), t, this.requiredWindows, this.requiredJoinProperties).buildQuery();
            }
            if (query.toUpperCase().trim().startsWith("SELECT")) {
                query = "SELECT DISTINCT " + query.trim().substring(6);
            }
            return this.replaceDataViewFields(query);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private int getSQLType(int column) {
        if (column < 0 || column >= this.columnSQLType.length) {
            return -2;
        }
        String aggr = (String)this.qbeTable.getModel().getValueAt(3, column);
        if (aggr != null && (aggr.equals(QueryBuilder.AGGR[2]) || aggr.equals(QueryBuilder.AGGR[3]) || aggr.equals(QueryBuilder.AGGR[6]) || aggr.equals(QueryBuilder.AGGR[7]) || aggr.equals(QueryBuilder.AGGR[8]))) {
            return 2;
        }
        return this.columnSQLType[column];
    }

    private void buildCondition(int column) {
        this.buildCondition(column, -1, false);
    }

    private void buildCondition(int column, int vRowIndex) {
        this.buildCondition(column, vRowIndex, false);
    }

    private void buildCondition(int column, int vRowIndex, boolean complex) {
        if (this.columnSQLType == null && !complex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build conditions for this data view because it contains errors.\nPlease try again using the formula builder."));
            return;
        }
        try {
            String cond = "";
            if (!complex) {
                ConditionOperatorDialog oDialog = new ConditionOperatorDialog(this, this.dataView.getDatabaseInfo(), ((DefaultTableModel)this.viewTable.getModel()).getColumnName(column), this.getSQLType(column), this.getColumnQuery(column));
                oDialog.setVisible(true);
                cond = oDialog.getCondition();
            } else {
                if (this.viewTable.getModel().getValueAt(3, column) != null) {
                    cond = this.viewTable.getModel().getValueAt(3, column).toString();
                }
                DefaultMutableTreeNode root = this.getViewTreeRoot();
                FormulaBuilderDialog fDialog = null;
                fDialog = root == null ? new FormulaBuilderDialog((JDialog)this, this.dataView.getDatabaseInfo(), cond, this.requiredWindows) : new FormulaBuilderDialog((JDialog)this, this.dataView.getDatabaseInfo(), cond, root);
                fDialog.setDefaultParamNames(this.defaultParamNames);
                fDialog.setVisible(true);
                if (!fDialog.isModified()) {
                    return;
                }
                cond = fDialog.getFormula();
            }
            if (cond != null) {
                if (vRowIndex >= 0) {
                    this.viewTableVertical.getModel().setValueAt(cond, vRowIndex, 3);
                }
                this.viewTable.getModel().setValueAt(cond, 3, column);
            }
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot build conditions for data in this column.\nPlease try again using the formula builder."));
            return;
        }
    }

    private void clearCondition(int column, int vRowIndex) {
        try {
            if (vRowIndex >= 0) {
                this.viewTableVertical.getModel().setValueAt("", vRowIndex, 3);
            }
            this.viewTable.getModel().setValueAt("", 3, column);
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot clear conditions for this column."));
            return;
        }
    }

    private void showColumn(int column) {
        try {
            ViewColumnDialog vcFrame = new ViewColumnDialog(this, this.dataView.getDatabaseInfo(), this.getColumnQuery(column), ((DefaultTableModel)this.viewTable.getModel()).getColumnName(column));
            vcFrame.setVisible(true);
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot retrieve column data."));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Cancel")) {
            this.setVisible(false);
            this.dispose();
        } else if (command.equals("Choose Columns")) {
            this.doChooseColumns();
        } else if (e.getSource() == this.toggleButton || command.equals("Toggle View")) {
            this.toggleView();
        } else if (e.getSource() == this.saveQueryButton || command.equals("Save Query...")) {
            this.doSaveQuery();
        } else if (command.equals("Initialize Parameters...")) {
            this.showParameters();
        } else if (command.equals("OK")) {
            this.clearSelection();
            if (!this.verifyParameters()) {
                return;
            }
            if (!this.editing) {
                if (this.isQueryModified()) {
                    boolean saved;
                    String dvqName = this.nameField.getText();
                    if (dvqName.length() > 50) {
                        dvqName = dvqName.substring(0, 50);
                    }
                    if (!(saved = this.doSaveQuery(dvqName, true))) {
                        return;
                    }
                }
                if (this.dataViewNode != null) {
                    this.dataViewNode.setBytes(this.getFileBytes());
                }
                this.modified = true;
            } else {
                boolean saved;
                String query = this.getQuery();
                try {
                    if (this.paramSet == null) {
                        this.dataView.getDatabaseInfo().getTableInfo(query, true);
                    }
                }
                catch (Exception dbe) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("This query contains errors and cannot be saved."));
                    return;
                }
                if (this.dataViewQueryNode != null && !(saved = this.doSaveQuery())) {
                    return;
                }
                this.modified = true;
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() instanceof JMenuItem) {
            String item = ((JMenuItem)e.getSource()).getText();
            if (item.equals("Condition...") || item.equals("Build...")) {
                int column = this.viewTable.convertColumnIndexToModel(this.viewTable.getSelectedColumn());
                int vRow = -1;
                if (this.isVertical) {
                    vRow = this.viewTableVertical.getSelectedRow();
                    column = this.viewTable.convertColumnIndexToModel(vRow);
                }
                this.buildCondition(column, vRow, item.equals("Build..."));
            } else if (item.equals("Delete")) {
                int column = this.viewTable.convertColumnIndexToModel(this.viewTable.getSelectedColumn());
                int vRow = -1;
                if (this.isVertical) {
                    vRow = this.viewTableVertical.getSelectedRow();
                    column = this.viewTable.convertColumnIndexToModel(vRow);
                }
                this.clearCondition(column, vRow);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean isPopupTrigger = e.isPopupTrigger();
        if (!isPopupTrigger) {
            int mouseMask = e.getModifiers() & 0xFFFFFFEF;
            boolean bl = isPopupTrigger = IOUtil.getRightMouseClickMask() == mouseMask;
        }
        if (isPopupTrigger) {
            int sColumn;
            int sRow;
            JTable table = this.viewTable;
            if (this.isVertical) {
                table = this.viewTableVertical;
            }
            try {
                Point p = new Point(e.getX(), e.getY());
                sRow = table.rowAtPoint(p);
                sColumn = table.columnAtPoint(p);
                sColumn = table.convertColumnIndexToModel(sColumn);
                if (sRow == -1 || sColumn == -1 || (sRow != 3 || this.isVertical) && (sColumn != 3 || !this.isVertical)) {
                    return;
                }
                Class<?> jtableClass = Class.forName("javax.swing.JTable");
                Method changeSelectionMethod = jtableClass.getMethod("changeSelection", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                changeSelectionMethod.invoke((Object)table, sRow, table.convertColumnIndexToView(sColumn), Boolean.FALSE, Boolean.FALSE);
            }
            catch (Exception p) {
                // empty catch block
            }
            sRow = table.getSelectedRow();
            sColumn = table.convertColumnIndexToModel(table.getSelectedColumn());
            if (sRow != 3 && !this.isVertical || sColumn != 3 && this.isVertical) {
                String message = LanguageEncoder.getText("Please left click to select a condition field first.");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
                return;
            }
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void doChooseColumns() {
        ConditionColumnSelectionDialog columnDialog = null;
        try {
            columnDialog = new ConditionColumnSelectionDialog((Dialog)this, this.dataView.getViewTree(), this.selectedColumns, this.dataView.getDatabaseInfo());
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open column selection dialog."));
            return;
        }
        columnDialog.setVisible(true);
        if (columnDialog.isModified() && columnDialog.getSelectedColumns().length > 0) {
            int i;
            this.clearSelection();
            this.selectedColumns = columnDialog.getSelectedColumns();
            this.updateTable();
            this.findRequiredWindows(this.selectedColumns);
            int ct = this.viewTable.getColumnCount();
            TableColumnModel tcm = this.viewTable.getColumnModel();
            boolean hasAggregation = false;
            for (i = 0; i < ct; ++i) {
                if (tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).getMaxWidth() <= 0) continue;
                Object value = this.viewTable.getModel().getValueAt(1, i);
                if (value != null && !value.equals("")) {
                    hasAggregation = true;
                }
                i = ct;
            }
            for (i = 0; i < ct; ++i) {
                int j = 0;
                for (j = 0; j < this.selectedColumns.length; ++j) {
                    if (!tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).getHeaderValue().equals(this.selectedColumns[j].getAlias())) continue;
                    tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).setMinWidth(15);
                    tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).setMaxWidth(Integer.MAX_VALUE);
                    tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).setPreferredWidth(110);
                    Object value = this.viewTable.getModel().getValueAt(1, i);
                    this.viewTable.getModel().setValueAt(Boolean.TRUE, 2, i);
                    if (hasAggregation && (value == null || value.equals(""))) {
                        this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[1], 1, i);
                        this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[1], 3, i);
                    } else if (!hasAggregation) {
                        this.viewTable.getModel().setValueAt(null, 1, i);
                        this.qbeTable.getModel().setValueAt(null, 3, i);
                    }
                    this.qbeTable.getModel().setValueAt(this.selectedColumns[j].getColumnName(), 1, i);
                    j = this.selectedColumns.length + 1;
                }
                if (j != this.selectedColumns.length) continue;
                tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).setMinWidth(0);
                tcm.getColumn(this.viewTable.convertColumnIndexToView(i)).setMaxWidth(0);
                this.viewTable.getModel().setValueAt(null, 0, i);
                this.viewTable.getModel().setValueAt(null, 1, i);
                this.viewTable.getModel().setValueAt(null, 2, i);
                this.qbeTable.getModel().setValueAt(null, 2, i);
                this.qbeTable.getModel().setValueAt(null, 3, i);
                this.qbeTable.getModel().setValueAt(null, 5, i);
            }
            this.syncColumnOrder(this.viewTable, this.selectedColumns);
            if (this.isVertical) {
                try {
                    this.buildVerticalTable();
                    this.conditionPanel.updateDesignPanel(this.vScrollPane);
                    this.setPosition();
                }
                catch (Exception ex) {
                    this.toggleView();
                }
            }
            this.conditionPanel.goToPanel(0);
        }
    }

    private void updateTable() {
        if (this.selectedColumns == null) {
            return;
        }
        TableColumnModel tcm = this.qbeTable.getColumnModel();
        int colcount = tcm.getColumnCount();
        for (ColumnTreeNode selectedColumn : this.selectedColumns) {
            boolean addColumn = true;
            int j = 0;
            for (j = 0; j < colcount; ++j) {
                if (!tcm.getColumn(j).getHeaderValue().equals(selectedColumn.getAlias())) continue;
                addColumn = false;
                j = colcount + 1;
            }
            if (!addColumn) continue;
            this.addColumn(selectedColumn);
        }
    }

    private void addColumn(ColumnTreeNode node) {
        Object[] data = new Object[10];
        data[1] = node.getColumnName();
        if (node.isExpression()) {
            data[0] = "Expression";
        } else {
            TableTreeNode[] parents = node.getTableTreeNodes();
            data[0] = parents[0].getAlias();
        }
        data[4] = Boolean.TRUE;
        data[2] = null;
        data[3] = null;
        data[5] = null;
        data[6] = null;
        data[7] = null;
        data[8] = null;
        data[9] = null;
        ((DefaultTableModel)this.qbeTable.getModel()).addColumn(node.getUserObject(), data);
        if (this.viewTable == null) {
            return;
        }
        Object[] vdata = new Object[]{null, null, Boolean.TRUE, null, null};
        ((DefaultTableModel)this.viewTable.getModel()).addColumn(node.getUserObject(), vdata);
    }

    private void toggleView() {
        if (!this.isVertical) {
            try {
                this.clearSelection();
                this.syncColumnOrder(this.viewTable, this.selectedColumns);
                this.buildVerticalTable();
                this.conditionPanel.updateDesignPanel(this.vScrollPane);
                this.toggleButton.setText(LanguageEncoder.getText("Horizontal View"));
                this.isVertical = true;
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to switch to vertical view."));
                return;
            }
        } else {
            this.clearSelection();
            this.conditionPanel.updateDesignPanel(this.hScrollPane);
            this.toggleButton.setText(LanguageEncoder.getText("Vertical View"));
            this.isVertical = false;
        }
    }

    public boolean doSaveQuery() {
        return this.doSaveQuery(null);
    }

    private boolean doSaveQuery(String initialname) {
        return this.doSaveQuery(initialname, false);
    }

    private boolean doSaveQuery(String initialname, boolean onOK) {
        boolean canSaveQuery = this.manager != null && this.manager.canModify();
        try {
            String query;
            DataViewQueryNode node;
            String queryFile;
            String dataViewFile;
            block28: {
                if (!this.verifyParameters()) {
                    return false;
                }
                dataViewFile = null;
                queryFile = null;
                node = null;
                if (this.dataViewQueryNode != null) {
                    node = this.dataViewQueryNode;
                    queryFile = node.getQueryFile();
                    dataViewFile = QueryMain.QUERYDIR + node.getDataViewFile();
                } else {
                    String nodeName = null;
                    if (canSaveQuery) {
                        boolean OK = false;
                        JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter Query Name:"), 3, 2);
                        boolean first = true;
                        if (initialname != null) {
                            optionPane.setInitialSelectionValue(initialname);
                        }
                        while (!OK) {
                            optionPane.setWantsInput(true);
                            if (first && initialname != null && !initialname.trim().equals("")) {
                                nodeName = initialname;
                            } else {
                                JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("New Query Name"));
                                dialog.setVisible(true);
                                if (!optionPane.getValue().equals(0)) {
                                    return false;
                                }
                                nodeName = (String)optionPane.getInputValue();
                            }
                            first = false;
                            if (nodeName == null || nodeName.equals("")) continue;
                            if (this.manager.managerPane.isChildNode(this.dataViewNode, nodeName)) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("A query named '") + nodeName + LanguageEncoder.getText("' already exists. Please choose another name."));
                                continue;
                            }
                            OK = true;
                        }
                    } else {
                        nodeName = "READ_MODE";
                    }
                    String fileprefix = this.manager.managerPane.dataSourceLoc;
                    fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
                    fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
                    fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
                    fileprefix = fileprefix + "_" + this.dataViewNode.getName() + "_";
                    String newFileName = fileprefix + nodeName;
                    if ((newFileName = QbUtil.getValidFilename(newFileName)).startsWith("_")) {
                        newFileName = "a" + newFileName;
                    }
                    String tmp = newFileName;
                    int ct = 0;
                    try {
                        while (new FileInfo(QueryMain.QUERYDIR + newFileName + ".dvw").exists()) {
                            newFileName = tmp + "_" + ct++;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    node = new DataViewQueryNode(nodeName);
                    dataViewFile = QueryMain.QUERYDIR + newFileName;
                    queryFile = QueryMain.QUERYDIR + newFileName + "_query";
                    node.setDataViewFile(newFileName);
                    node.setQueryFile(queryFile);
                    node.setID(this.manager.getNextID());
                }
                this.clearSelection();
                query = this.getQuery();
                try {
                    if (this.paramSet == null) {
                        this.dataView.getDatabaseInfo().getTableInfo(query, true);
                    }
                }
                catch (Exception dbe) {
                    String excep = "";
                    try {
                        excep = QbUtil.replace(dbe.toString(), "Exception: ", "Excepion:\n");
                        excep = "\n" + excep;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.silentMode) break block28;
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("This query contains errors and cannot be saved.") + excep);
                    return false;
                }
            }
            this.save(queryFile);
            this.dataView.save(dataViewFile);
            node.setSQL(query);
            if (this.paramSet != null) {
                node.setInSet((QueryInParamSet)this.paramSet.clone());
            } else {
                node.setInSet(null);
            }
            node.setBytes(this.getFileBytes());
            if (this.dataViewQueryNode == null) {
                this.dataViewNode.add(node);
                if (ServerMessage.useServer && !onOK) {
                    this.manager.managerPane.addNodeNoClose(node);
                }
                this.dataViewQueryNode = node;
            }
            if (canSaveQuery) {
                this.manager.managerPane.updateTree();
                if (!ServerMessage.useServer) {
                    this.manager.managerPane.saveDataSource();
                }
            }
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot save this data view because of an internal error.\n") + ex.toString());
            return false;
        }
        return true;
    }

    protected void save(String file) throws Exception {
        if (file == null || file.trim().equals("")) {
            throw new IOException(LanguageEncoder.getText("Please specific a file name."));
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        this.save(fstream);
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        wdfile.output(fstream.toByteArray(), file);
    }

    private void save(OutputStream stream) throws Exception {
        int i;
        DataOutputStream out = new DataOutputStream(stream);
        int colcount = this.viewTable.getColumnCount();
        int rowcount = this.viewTable.getRowCount();
        out.writeInt(1);
        if (this.paramSet == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(6612);
            this.paramSet.write(out);
        }
        out.writeInt(rowcount);
        out.writeInt(colcount);
        for (int i2 = 0; i2 < colcount; ++i2) {
            for (int j = 0; j < rowcount; ++j) {
                Object value = this.viewTable.getModel().getValueAt(j, i2);
                if (value == null) {
                    IOUtil.writeStr(out, null);
                    continue;
                }
                IOUtil.writeStr(out, value.toString());
            }
        }
        String[] columnorder = new String[this.selectedColumns.length];
        int index = 0;
        for (i = 0; i < this.viewTable.getColumnCount() && index < this.selectedColumns.length; ++i) {
            if (this.viewTable.getColumnModel().getColumn(i).getMaxWidth() == 0) continue;
            columnorder[index] = this.viewTable.getColumnModel().getColumn(i).getHeaderValue().toString();
            ++index;
        }
        out.writeInt(index);
        for (i = 0; i < index; ++i) {
            IOUtil.writeString(out, columnorder[i]);
        }
        out.flush();
    }

    boolean showParameters() {
        String query = this.getQuery();
        if (QueryParser.hasParameters(query)) {
            QueryInParamSet tempParamSet = QueryParser.filterParameters(query, this.paramSet);
            DBInfoBasic newDBInfo = null;
            newDBInfo = this.dataView.getDatabaseInfo().isUseJNDIDataSource() ? new DBInfoBasic(this.dataView.getDatabaseInfo().getJNDIName(), query, this.dataView.getDatabaseInfo().getEnvProperties()) : new DBInfoBasic(this.dataView.getDatabaseInfo().getURL(), this.dataView.getDatabaseInfo().getDriver(), this.dataView.getDatabaseInfo().getUserName(), this.dataView.getDatabaseInfo().getPassword(), query, this.dataView.getDatabaseInfo().getAdditionalDb());
            QueryFileInfo qfi = new QueryFileInfo("", 0, newDBInfo, tempParamSet);
            try {
                Object[][] matrix = this.createColumnInfoForParameterDialog();
                boolean showPromptSequence = true;
                if (this.manager != null && this.manager.interchange instanceof ChartWizard) {
                    showPromptSequence = false;
                }
                DataViewINParametersDialog pDialog = new DataViewINParametersDialog((JDialog)this, qfi, matrix, showPromptSequence);
                pDialog.setDefaultValueRequired(this.defaultValueRequired);
                pDialog.setVisible(true);
                if (pDialog.isModified()) {
                    tempParamSet = pDialog.getQueryInParamSet();
                    if (tempParamSet == null) {
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    this.paramSet = tempParamSet;
                    this.conditionPanel.setInSet(this.paramSet);
                    this.modifiedParameter = true;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query.") + "\n" + ex.toString());
                return false;
            }
        }
        new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("This query does not contain parameters."));
        return false;
    }

    private void syncColumnOrder(JTable table, ColumnTreeNode[] list) {
        try {
            TableColumnModel tcm = table.getColumnModel();
            for (int i = list.length - 1; i >= 0; --i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    if (!tcm.getColumn(j).getHeaderValue().equals(list[i].getAlias())) continue;
                    tcm.moveColumn(j, 0);
                    j = table.getColumnCount();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildVerticalTable() throws Exception {
        JTable rowHeader = new JTable(this.selectedColumns.length, 1){

            @Override
            public boolean isCellSelected(int row, int col) {
                return false;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        rowHeader.setGridColor(Color.lightGray);
        JTable verticalTable = new JTable(this.selectedColumns.length, 5);
        verticalTable.setGridColor(Color.lightGray);
        int rowIndex = 0;
        Object[][] data = new Object[this.selectedColumns.length][5];
        Object[] header = new String[]{LanguageEncoder.getText("Sort"), LanguageEncoder.getText("Aggregation"), LanguageEncoder.getText("Show"), LanguageEncoder.getText("Condition"), ""};
        TableColumnModel tcm = this.viewTable.getColumnModel();
        for (int i = 0; i < this.viewTable.getColumnCount() && rowIndex < this.selectedColumns.length; ++i) {
            if (tcm.getColumn(i).getMaxWidth() <= 0) continue;
            rowHeader.setValueAt(tcm.getColumn(i).getHeaderValue(), rowIndex, 0);
            data[rowIndex][0] = this.viewTable.getValueAt(0, i);
            data[rowIndex][1] = this.viewTable.getValueAt(1, i);
            data[rowIndex][2] = this.viewTable.getValueAt(2, i);
            data[rowIndex][3] = this.viewTable.getValueAt(3, i);
            data[rowIndex][4] = null;
            ++rowIndex;
        }
        ((DefaultTableModel)verticalTable.getModel()).setDataVector(data, header);
        verticalTable.getColumnModel().getColumn(0).setPreferredWidth(75);
        verticalTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        verticalTable.getColumnModel().getColumn(2).setPreferredWidth(45);
        verticalTable.getColumnModel().getColumn(3).setPreferredWidth(110);
        verticalTable.getColumnModel().getColumn(4).setPreferredWidth(110);
        verticalTable.setAutoResizeMode(0);
        verticalTable.setCellSelectionEnabled(true);
        verticalTable.setSelectionMode(0);
        verticalTable.setDefaultEditor(new Object().getClass(), new InternalCellEditorVertical());
        verticalTable.setDefaultRenderer(new Object().getClass(), new InternalCellRenderer(true));
        verticalTable.addMouseListener(this);
        JScrollPane tablePanel = new JScrollPane();
        tablePanel.getViewport().add(verticalTable);
        tablePanel.setRowHeaderView(rowHeader);
        Dimension d = tablePanel.getRowHeader().getPreferredSize();
        tablePanel.getRowHeader().setPreferredSize(new Dimension(110, (int)d.getHeight()));
        tablePanel.setPreferredSize(new Dimension(545, 300));
        this.viewTableVertical = verticalTable;
        this.vScrollPane = tablePanel;
    }

    DataViewDialog getDataViewDialog() {
        return this.dataView;
    }

    private void load(String file) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        this.load(readfile.getInputStream(file));
        readfile.close();
    }

    private void load(DataInputStream in) throws Exception {
        int i;
        boolean hasParam;
        int version = in.readInt();
        if (version >= 1 && (hasParam = in.readBoolean())) {
            int chartversion = in.readInt();
            this.paramSet = QueryInParamSet.read(in, chartversion);
            this.conditionPanel.setInSet(this.paramSet);
        }
        int rowcount = in.readInt();
        int colcount = in.readInt();
        for (i = 0; i < colcount; ++i) {
            for (int j = 0; j < rowcount; ++j) {
                String value = IOUtil.readStr(in);
                if (i >= this.viewTable.getColumnCount() || j >= this.viewTable.getRowCount()) continue;
                if (j < this.fieldMap.length) {
                    if (j == 2) {
                        this.viewTable.getModel().setValueAt(Boolean.valueOf(value), j, i);
                        continue;
                    }
                    this.viewTable.getModel().setValueAt(value, j, i);
                    this.qbeTable.getModel().setValueAt(value, this.fieldMap[j], i);
                    continue;
                }
                this.viewTable.getModel().setValueAt(value, j, i);
            }
        }
        this.selectedColumns = new ColumnTreeNode[in.readInt()];
        for (i = 0; i < this.selectedColumns.length; ++i) {
            this.selectedColumns[i] = this.getColumnTreeNode(IOUtil.readString(in, true));
        }
        this.findRequiredWindows(this.selectedColumns);
        TableColumnModel tcm = this.viewTable.getColumnModel();
        for (int i2 = 0; i2 < colcount; ++i2) {
            if (i2 >= this.viewTable.getColumnCount()) continue;
            int j = 0;
            for (j = 0; j < this.selectedColumns.length; ++j) {
                if (!tcm.getColumn(i2).getHeaderValue().equals(this.selectedColumns[j].getAlias())) continue;
                tcm.getColumn(i2).setPreferredWidth(110);
                j = this.selectedColumns.length + 1;
            }
            if (j != this.selectedColumns.length) continue;
            tcm.getColumn(i2).setMinWidth(0);
            tcm.getColumn(i2).setMaxWidth(0);
        }
        this.syncColumnOrder(this.viewTable, this.selectedColumns);
    }

    private void clearSelection() {
        try {
            if (this.isVertical) {
                this.viewTableVertical.editCellAt(-1, -1);
                this.viewTableVertical.clearSelection();
            } else {
                this.viewTable.editCellAt(-1, -1);
                this.viewTable.clearSelection();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ColumnTreeNode getColumnTreeNode(String alias) {
        TreeNode root = (TreeNode)this.dataView.getViewTree().getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode parent = root.getChildAt(i);
            for (int j = 0; j < parent.getChildCount(); ++j) {
                if (!(parent.getChildAt(j) instanceof ColumnTreeNode) || !((ColumnTreeNode)parent.getChildAt(j)).getAlias().equals(alias)) continue;
                return (ColumnTreeNode)parent.getChildAt(j);
            }
        }
        return null;
    }

    private void findRequiredWindows(ColumnTreeNode[] columnNodes) {
        if (columnNodes == null || columnNodes.length == 0) {
            this.requiredWindows = new ColumnFieldWindow[0];
            this.requiredJoinProperties = new String[0][];
            return;
        }
        Vector<ColumnFieldWindow> baseNodes = new Vector<ColumnFieldWindow>();
        for (ColumnTreeNode columnNode : columnNodes) {
            TableTreeNode[] tables = columnNode.getTableTreeNodes();
            if (tables == null || tables.length <= 0) continue;
            for (int j = 0; j < tables.length; ++j) {
                try {
                    if (baseNodes.contains(tables[j].getWindow())) continue;
                    baseNodes.add(tables[j].getWindow());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (baseNodes.size() == this.windows.length) {
            this.requiredWindows = this.windows;
            this.requiredJoinProperties = this.joinProperties;
            return;
        }
        Vector bestPath = new Vector();
        bestPath.add(baseNodes.elementAt(0));
        Vector<Vector> paths = new Vector<Vector>();
        paths.add(bestPath);
        Vector<Vector> childpaths = new Vector<Vector>();
        int bestPathScore = 1;
        this.deadendPaths = new Vector();
        while (paths.size() > 0 && bestPathScore != baseNodes.size()) {
            int i;
            for (i = 0; i < paths.size() && bestPathScore < baseNodes.size(); ++i) {
                Vector path = (Vector)paths.elementAt(i);
                int temp_score = 0;
                for (int j = 0; j < baseNodes.size(); ++j) {
                    if (!path.contains(baseNodes.elementAt(j))) continue;
                    ++temp_score;
                }
                if (temp_score > bestPathScore) {
                    bestPathScore = temp_score;
                    bestPath = path;
                }
                if (temp_score >= baseNodes.size()) continue;
                Vector<Vector<ColumnFieldWindow>> temp_children = this.searchHelper(path);
                for (int j = 0; j < temp_children.size(); ++j) {
                    childpaths.add(temp_children.elementAt(j));
                }
            }
            if (childpaths.size() == 0 && bestPathScore != baseNodes.size()) {
                for (i = 0; i < baseNodes.size(); ++i) {
                    if (bestPath.contains(baseNodes.elementAt(i))) continue;
                    boolean found = false;
                    for (int j = 0; j < this.deadendPaths.size(); ++j) {
                        Vector<ColumnFieldWindow> deadendPath = this.deadendPaths.get(j);
                        if (!deadendPath.contains(baseNodes.elementAt(i))) continue;
                        found = true;
                        for (int k = 0; k < deadendPath.size(); ++k) {
                            ColumnFieldWindow deadendPathNode = deadendPath.get(k);
                            if (!bestPath.contains(deadendPathNode)) {
                                bestPath.add(deadendPathNode);
                            }
                            if (deadendPathNode == baseNodes.elementAt(i)) break;
                        }
                        ++bestPathScore;
                        childpaths.add(bestPath);
                        i = baseNodes.size();
                        break;
                    }
                    if (found) continue;
                    bestPath.add(baseNodes.elementAt(i));
                    ++bestPathScore;
                    childpaths.add(bestPath);
                    i = baseNodes.size();
                }
            }
            paths = childpaths;
            childpaths = new Vector();
        }
        this.requiredWindows = new ColumnFieldWindow[bestPath.size()];
        for (int i = 0; i < this.requiredWindows.length; ++i) {
            this.requiredWindows[i] = (ColumnFieldWindow)bestPath.elementAt(i);
        }
        Vector<String[]> joins = new Vector<String[]>();
        for (String[] join : this.joinProperties) {
            int include = 0;
            for (int j = 0; j < this.requiredWindows.length && include != 5; ++j) {
                if (this.requiredWindows[j].getDisplayName().equals(join[0])) {
                    include += 3;
                }
                if (!this.requiredWindows[j].getDisplayName().equals(join[2])) continue;
                include += 2;
            }
            if (include != 5) continue;
            joins.add(join);
        }
        this.requiredJoinProperties = new String[joins.size()][];
        for (int i = 0; i < this.requiredJoinProperties.length; ++i) {
            this.requiredJoinProperties[i] = (String[])joins.elementAt(i);
        }
    }

    private Vector<Vector<ColumnFieldWindow>> searchHelper(Vector<ColumnFieldWindow> path) {
        Vector<ColumnFieldWindow> neighbors = this.getNeighbors(path.elementAt(path.size() - 1));
        for (int i = neighbors.size() - 1; i >= 0; --i) {
            if (!path.contains(neighbors.elementAt(i))) continue;
            neighbors.removeElementAt(i);
        }
        Vector<Vector<ColumnFieldWindow>> ret = new Vector<Vector<ColumnFieldWindow>>();
        for (int i = 0; i < neighbors.size(); ++i) {
            Vector<ColumnFieldWindow> childpath = new Vector<ColumnFieldWindow>();
            for (int j = 0; j < path.size(); ++j) {
                childpath.add(path.elementAt(j));
            }
            childpath.add(neighbors.elementAt(i));
            ret.add(childpath);
        }
        if (ret.size() == 0) {
            this.deadendPaths.add(path);
        }
        return ret;
    }

    private Vector<ColumnFieldWindow> getNeighbors(ColumnFieldWindow node) {
        Vector<ColumnFieldWindow> ret = new Vector<ColumnFieldWindow>();
        for (String[] join : this.joinProperties) {
            if (node.getDisplayName().equals(join[0])) {
                ret.add(this.getWindow(join[2]));
                continue;
            }
            if (!node.getDisplayName().equals(join[2])) continue;
            ret.add(this.getWindow(join[0]));
        }
        return ret;
    }

    private ColumnFieldWindow getWindow(String displayName) {
        for (ColumnFieldWindow window : this.windows) {
            if (!window.getDisplayName().equals(displayName)) continue;
            return window;
        }
        return null;
    }

    public QueryInParamSet getInSet() {
        return this.paramSet;
    }

    private boolean verifyParameters() {
        try {
            String[] paramNames = QueryParser.getAllParameters(this.getQuery());
            if (paramNames != null) {
                boolean initializationRequired;
                block10: {
                    initializationRequired = false;
                    if (this.paramSet != null) {
                        try {
                            QueryInParam[] params = new QueryInParam[paramNames.length];
                            for (int i = 0; i < paramNames.length; ++i) {
                                params[i] = this.paramSet.getParameter(paramNames[i]);
                                if (params[i] != null) continue;
                                initializationRequired = true;
                                i = paramNames.length;
                            }
                            if (!initializationRequired) {
                                this.paramSet = new QueryInParamSet(params, this.paramSet.getParameterInPromptSequence(), this.getQuery());
                                break block10;
                            }
                            this.paramSet = new QueryInParamSet(params, this.getQuery());
                        }
                        catch (Exception exception) {}
                    } else {
                        initializationRequired = true;
                    }
                }
                if (initializationRequired && !this.showParameters()) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An error has occured.\n") + ex.toString());
            return false;
        }
    }

    private DefaultMutableTreeNode getViewTreeRoot() {
        try {
            ConditionColumnSelectionDialog columnDialog = new ConditionColumnSelectionDialog((Dialog)this, this.dataView.getViewTree(), this.selectedColumns, this.dataView.getDatabaseInfo());
            JTree viewTree = columnDialog.getViewTree();
            return (DefaultMutableTreeNode)viewTree.getModel().getRoot();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private DefaultMutableTreeNode getTableTreeRoot() {
        try {
            ConditionColumnSelectionDialog columnDialog = new ConditionColumnSelectionDialog((Dialog)this, this.dataView.getViewTree(), this.selectedColumns, this.dataView.getDatabaseInfo());
            JTree tableTree = columnDialog.getTableTree();
            return (DefaultMutableTreeNode)tableTree.getModel().getRoot();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public byte[][] getFileBytes() {
        try {
            byte[][] fileBytes = new byte[2][];
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            this.dataView.save(bstream);
            bstream.close();
            fileBytes[0] = bstream.toByteArray();
            bstream = new ByteArrayOutputStream();
            this.save(bstream);
            bstream.close();
            fileBytes[1] = bstream.toByteArray();
            return fileBytes;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    public void setDefaultValueRequiredForParameters(boolean state) {
        this.defaultValueRequired = state;
    }

    private boolean isQueryModified() {
        String newQuery = this.getQuery();
        if (this.dataViewQueryNode != null) {
            if (!newQuery.equals(this.dataViewQueryNode.getSQL())) {
                return true;
            }
            return QueryParser.hasParameters(newQuery) && this.modifiedParameter;
        }
        return true;
    }

    private String replaceDataViewFields(String query) {
        DefaultMutableTreeNode viewroot = this.getTableTreeRoot();
        if (viewroot == null) {
            return query;
        }
        int databaseType = 0;
        try {
            databaseType = QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < viewroot.getChildCount(); ++i) {
            DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)viewroot.getChildAt(i);
            for (int j = 0; j < tableNode.getChildCount(); ++j) {
                DefaultMutableTreeNode tempnode = (DefaultMutableTreeNode)tableNode.getChildAt(j);
                if (!(tempnode instanceof ColumnTreeNode)) continue;
                ColumnTreeNode columnNode = (ColumnTreeNode)tempnode;
                String oldString = "{" + (String)tableNode.getUserObject() + "." + columnNode.getAlias() + "}";
                String newString = null;
                if (columnNode.isExpression()) {
                    newString = "(" + columnNode.getColumnName() + ")";
                } else {
                    String tableName = columnNode.getTableTreeNodes()[0].getAlias();
                    String columnName = columnNode.getColumnName();
                    if (tableName != null && columnName != null) {
                        newString = QueryBuilder.printExpression(databaseType, tableName, columnName);
                    }
                }
                if (newString == null) continue;
                query = QbUtil.replace(query, oldString, newString);
            }
        }
        return query;
    }

    private Object[][] createColumnInfoForParameterDialog() {
        if (this.selectedColumns == null) {
            return new Object[0][];
        }
        Object[][] matrix = new Object[this.selectedColumns.length][];
        TableColumnModel tcm = this.qbeTable.getColumnModel();
        for (int i = 0; i < this.qbeTable.getColumnCount(); ++i) {
            int j = 0;
            for (j = 0; j < this.selectedColumns.length; ++j) {
                ColumnTreeNode columnNode;
                if (!tcm.getColumn(i).getHeaderValue().equals(this.selectedColumns[j].getAlias())) continue;
                matrix[j] = new Object[4];
                matrix[j][0] = null;
                matrix[j][1] = null;
                if (this.selectedColumns[j] != null && !(columnNode = this.selectedColumns[j]).isExpression()) {
                    TableTreeNode[] tables = columnNode.getTableTreeNodes();
                    if (tables != null && tables.length >= 1 && tables[0] != null) {
                        try {
                            matrix[j][0] = QueryBuilder.print(QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName()), tables[0].getTableName());
                            matrix[j][1] = QueryBuilder.print(QueryBuilder.mapDatabaseType(this.dataView.getDatabaseInfo().getProductName()), columnNode.getColumnName());
                        }
                        catch (Exception ex) {
                            matrix[j][0] = tables[0].getTableName();
                            matrix[j][1] = columnNode.getColumnName();
                        }
                    }
                    matrix[j][2] = this.columnSQLType[this.qbeTable.convertColumnIndexToModel(i)];
                }
                j = this.selectedColumns.length + 1;
            }
        }
        DefaultMutableTreeNode viewroot = this.getViewTreeRoot();
        if (viewroot == null) {
            return new Object[0][];
        }
        for (int i = 0; i < viewroot.getChildCount(); ++i) {
            DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)viewroot.getChildAt(i);
            for (int j = 0; j < tableNode.getChildCount(); ++j) {
                DefaultMutableTreeNode tempnode = (DefaultMutableTreeNode)tableNode.getChildAt(j);
                if (!(tempnode.getUserObject() instanceof ColumnTreeNode)) continue;
                ColumnTreeNode columnNode = (ColumnTreeNode)tempnode.getUserObject();
                for (int k = 0; k < this.selectedColumns.length; ++k) {
                    if (!columnNode.getAlias().equals(this.selectedColumns[k].getAlias())) continue;
                    matrix[k][3] = tableNode.getUserObject() + "." + columnNode.getAlias();
                }
            }
        }
        return matrix;
    }

    private void doColumnReplacement() {
        ColumnReplacementDialog dialog = new ColumnReplacementDialog(this);
        dialog.setVisible(true);
        String[] oldColNames = dialog.getOldColNames();
        String[] newColNames = dialog.getNewColNames();
        if (oldColNames != null && newColNames != null && oldColNames.length == newColNames.length) {
            this.dataView.replaceColumnNames(oldColNames, newColNames);
        }
        String[] oldViewNames = dialog.getOldViewNames();
        String[] newViewNames = dialog.getNewViewNames();
        if (oldViewNames != null && newViewNames != null && oldViewNames.length == newViewNames.length) {
            this.dataView.replaceViewColumnNames(oldViewNames, newViewNames);
        }
        this.windows = this.dataView.getColumnFieldWindows();
        this.joinProperties = this.dataView.getJoinProperties();
        this.qbeTable = this.dataView.getQBETable();
        this.formula = this.dataView.getFormula();
        try {
            ConditionColumnSelectionDialog columnDialog = new ConditionColumnSelectionDialog((Dialog)this, this.dataView.getViewTree(), this.selectedColumns, this.dataView.getDatabaseInfo());
            this.selectedColumns = columnDialog.getSelectedColumns();
            this.updateTable();
            this.findRequiredWindows(this.selectedColumns);
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ColumnTreeNode[] getSelectedColumns() {
        return this.selectedColumns;
    }

    protected JTable getViewTable() {
        return this.viewTable;
    }

    protected void setViewTable(JTable vTable) {
        this.viewTable = vTable;
    }

    protected Exception getError() {
        return this.error;
    }

    protected void setDataViewDialog(DataViewDialog dDialog) {
        this.dataView = dDialog;
    }

    protected QueryInParamSet getParamSet() {
        if (this.paramSet != null) {
            return (QueryInParamSet)this.paramSet.clone();
        }
        return null;
    }

    public void setDataViewQueryNode(DataViewQueryNode node) {
        this.dataViewQueryNode = node;
    }

    public DataViewQueryNode getDataViewQueryNode() {
        return this.dataViewQueryNode;
    }

    private class InternalCellEditorVertical
    extends DefaultCellEditor {
        private JComponent comp;
        private int rowIndex;
        private int colIndex;
        int horizontalViewColIndex;

        public InternalCellEditorVertical() {
            super(new JTextField());
            this.rowIndex = 0;
            this.colIndex = 0;
            this.horizontalViewColIndex = 0;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comp = null;
            this.rowIndex = row;
            this.colIndex = table.convertColumnIndexToModel(column);
            this.horizontalViewColIndex = ConditionDialog.this.viewTable.convertColumnIndexToModel(this.rowIndex);
            if (this.colIndex == 0) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.SORT_ORDER);
                comboBox.setSelectedIndex(this.getIndex((String)value, QueryBuilder.SORT_ORDER));
                this.comp = comboBox;
            } else if (this.colIndex == 1) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.AGGR);
                comboBox.setSelectedIndex(this.getIndex((String)value, QueryBuilder.AGGR));
                this.comp = comboBox;
            } else if (this.colIndex == 2) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setHorizontalAlignment(0);
                checkBox.setSelected((Boolean)value);
                this.comp = checkBox;
            } else if (this.colIndex == 3) {
                ConditionDialog.this.buildCondition(this.horizontalViewColIndex, this.rowIndex);
                this.comp = null;
            } else if (this.colIndex == 4) {
                ConditionDialog.this.showColumn(this.horizontalViewColIndex);
                this.comp = null;
            }
            return this.comp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comp == null) {
                return null;
            }
            if (this.comp instanceof JComboBox) {
                String tmp = ((JComboBox)this.comp).getSelectedItem().toString();
                ConditionDialog.this.viewTable.getModel().setValueAt(tmp, this.colIndex, this.horizontalViewColIndex);
                if (this.colIndex == 1) {
                    int ct = ConditionDialog.this.viewTable.getColumnCount();
                    if (tmp.trim().equals("")) {
                        for (int i = 0; i < ct; ++i) {
                            if (i < ConditionDialog.this.viewTableVertical.getRowCount()) {
                                ConditionDialog.this.viewTableVertical.getModel().setValueAt(null, i, 1);
                            }
                            ConditionDialog.this.viewTable.getModel().setValueAt(null, 1, i);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(null, 3, i);
                        }
                    } else {
                        if (tmp.equals(QueryBuilder.AGGR[11])) {
                            ConditionDialog.this.viewTableVertical.getModel().setValueAt(Boolean.FALSE, this.rowIndex, 2);
                            ConditionDialog.this.viewTable.getModel().setValueAt(Boolean.FALSE, 2, this.horizontalViewColIndex);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(Boolean.FALSE, 4, this.horizontalViewColIndex);
                        }
                        TableColumnModel tcm = ConditionDialog.this.viewTable.getColumnModel();
                        for (int i = 0; i < ct; ++i) {
                            Object aggr = ConditionDialog.this.viewTable.getModel().getValueAt(1, i);
                            if (i == this.horizontalViewColIndex || aggr != null && !aggr.toString().trim().equals("") || tcm.getColumn(ConditionDialog.this.viewTable.convertColumnIndexToView(i)).getMaxWidth() <= 0) continue;
                            int vRowIndex = 0;
                            for (int j = 0; j < ConditionDialog.this.selectedColumns.length; ++j) {
                                if (!tcm.getColumn(ConditionDialog.this.viewTable.convertColumnIndexToView(i)).getHeaderValue().equals(ConditionDialog.this.selectedColumns[j].getAlias())) continue;
                                vRowIndex = j;
                                j = ConditionDialog.this.selectedColumns.length;
                            }
                            ConditionDialog.this.viewTableVertical.getModel().setValueAt(QueryBuilder.AGGR[1], vRowIndex, 1);
                            ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[1], 1, i);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[1], 3, i);
                        }
                    }
                    ConditionDialog.this.viewTable.getModel().setValueAt(tmp, 1, this.horizontalViewColIndex);
                    ConditionDialog.this.qbeTable.getModel().setValueAt(tmp, 3, this.horizontalViewColIndex);
                }
                return tmp;
            }
            if (this.comp instanceof JCheckBox) {
                boolean state = ((JCheckBox)this.comp).isSelected();
                Object aggr = ConditionDialog.this.viewTable.getModel().getValueAt(1, this.horizontalViewColIndex);
                if (aggr != null && !aggr.toString().trim().equals("")) {
                    if (!state) {
                        ConditionDialog.this.viewTableVertical.getModel().setValueAt(QueryBuilder.AGGR[11], this.rowIndex, 1);
                        ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[11], 1, this.horizontalViewColIndex);
                        ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[11], 3, this.horizontalViewColIndex);
                    } else if (state && (aggr.toString().trim().equals("") || aggr.equals(QueryBuilder.AGGR[11]))) {
                        ConditionDialog.this.viewTableVertical.getModel().setValueAt(QueryBuilder.AGGR[1], this.rowIndex, 1);
                        ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[1], 1, this.horizontalViewColIndex);
                        ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[1], 3, this.horizontalViewColIndex);
                    }
                }
                ConditionDialog.this.viewTable.getModel().setValueAt(state, this.colIndex, this.horizontalViewColIndex);
                return state;
            }
            return ((JTextField)this.comp).getText();
        }

        private int getIndex(String str, Object[] objs) {
            if (str == null) {
                return 0;
            }
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null || !str.equals(objs[i].toString())) continue;
                return i;
            }
            return 0;
        }
    }

    private class InternalCellRenderer
    extends DefaultTableCellRenderer {
        private boolean vertical = false;

        public InternalCellRenderer(boolean isV) {
            this.vertical = isV;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int index = row;
            if (this.vertical) {
                index = table.convertColumnIndexToModel(column);
            }
            if (index == 4) {
                return new JButton(LanguageEncoder.getText("View Column"));
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class InternalCellEditor
    extends DefaultCellEditor {
        private JComponent comp;
        private int rowIndex;
        private int colIndex;

        public InternalCellEditor() {
            super(new JTextField());
            this.rowIndex = 0;
            this.colIndex = 0;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comp = null;
            this.rowIndex = row;
            this.colIndex = table.convertColumnIndexToModel(column);
            if (row == 0) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.SORT_ORDER);
                comboBox.setSelectedIndex(this.getIndex((String)value, QueryBuilder.SORT_ORDER));
                this.comp = comboBox;
            } else if (row == 1) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.AGGR);
                comboBox.setSelectedIndex(this.getIndex((String)value, QueryBuilder.AGGR));
                this.comp = comboBox;
            } else if (row == 2) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setHorizontalAlignment(0);
                checkBox.setSelected((Boolean)value);
                this.comp = checkBox;
            } else if (row == 3) {
                ConditionDialog.this.buildCondition(this.colIndex);
                this.comp = null;
            } else if (row == 4) {
                ConditionDialog.this.showColumn(this.colIndex);
                this.comp = null;
            }
            return this.comp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comp == null) {
                return null;
            }
            if (this.comp instanceof JComboBox) {
                String tmp = ((JComboBox)this.comp).getSelectedItem().toString();
                if (this.rowIndex == 1) {
                    int ct = ConditionDialog.this.viewTable.getColumnCount();
                    if (tmp.trim().equals("")) {
                        for (int i = 0; i < ct; ++i) {
                            ConditionDialog.this.viewTable.getModel().setValueAt(null, 1, i);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(null, 3, i);
                        }
                    } else {
                        if (tmp.equals(QueryBuilder.AGGR[11])) {
                            ConditionDialog.this.viewTable.getModel().setValueAt(Boolean.FALSE, 2, this.colIndex);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(Boolean.FALSE, 4, this.colIndex);
                        }
                        TableColumnModel tcm = ConditionDialog.this.viewTable.getColumnModel();
                        for (int i = 0; i < ct; ++i) {
                            Object aggr = ConditionDialog.this.viewTable.getModel().getValueAt(1, i);
                            if (i == this.colIndex || aggr != null && !aggr.toString().trim().equals("") || tcm.getColumn(ConditionDialog.this.viewTable.convertColumnIndexToView(i)).getMaxWidth() <= 0) continue;
                            if (((Boolean)ConditionDialog.this.viewTable.getModel().getValueAt(2, i)).booleanValue()) {
                                ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[1], 1, i);
                                ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[1], 3, i);
                                continue;
                            }
                            ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[11], 1, i);
                            ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[11], 3, i);
                        }
                    }
                    ConditionDialog.this.qbeTable.getModel().setValueAt(tmp, 3, this.colIndex);
                }
                return tmp;
            }
            if (this.comp instanceof JCheckBox) {
                boolean state = ((JCheckBox)this.comp).isSelected();
                Object aggr = ConditionDialog.this.viewTable.getModel().getValueAt(1, this.colIndex);
                if (aggr != null && !aggr.toString().trim().equals("")) {
                    if (!state) {
                        ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[11], 1, this.colIndex);
                        ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[11], 3, this.colIndex);
                    } else if (state && (aggr.toString().trim().equals("") || aggr.equals(QueryBuilder.AGGR[11]))) {
                        ConditionDialog.this.viewTable.getModel().setValueAt(QueryBuilder.AGGR[1], 1, this.colIndex);
                        ConditionDialog.this.qbeTable.getModel().setValueAt(QueryBuilder.AGGR[1], 3, this.colIndex);
                    }
                }
                return state;
            }
            return ((JTextField)this.comp).getText();
        }

        private int getIndex(String str, Object[] objs) {
            if (str == null) {
                return 0;
            }
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null || !str.equals(objs[i].toString())) continue;
                return i;
            }
            return 0;
        }
    }
}

