/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ConditionValueDialog;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.QueryBuilder;

public class ConditionOperatorDialog
extends JDialog
implements ActionListener {
    private DatabaseInfo databaseInfo;
    private int SQLType;
    private JButton gtButton;
    private JButton ltButton;
    private JButton eqButton;
    private JButton neqButton;
    private JButton lButton;
    private JButton nlButton;
    private JButton bButton;
    private JButton nbButton;
    private ColumnThread columnThread;
    private String columnName;
    private String condition = null;
    private ConditionValueDialog cvDialog;

    public ConditionOperatorDialog(JDialog owner, DatabaseInfo dbInfo, String colname, int type, String query) throws Exception {
        super((Dialog)owner, true);
        this.databaseInfo = dbInfo;
        this.SQLType = type;
        this.columnName = colname;
        this.init();
        this.setPosition();
        this.cvDialog = new ConditionValueDialog(this);
        this.columnThread = new ColumnThread(query);
        this.columnThread.start();
    }

    private void init() throws Exception {
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        this.setTitle(LanguageEncoder.getText("Conditions"));
        JPanel bpanel = (JPanel)this.getContentPane();
        this.gtButton = new JButton(">");
        this.ltButton = new JButton("<");
        this.eqButton = new JButton("=");
        this.neqButton = new JButton("<>");
        this.lButton = new JButton("LIKE");
        this.nlButton = new JButton("NOT LIKE");
        this.bButton = new JButton("BETWEEN");
        this.nbButton = new JButton("NOT BETWEEN");
        this.gtButton.addActionListener(this);
        this.ltButton.addActionListener(this);
        this.eqButton.addActionListener(this);
        this.neqButton.addActionListener(this);
        this.lButton.addActionListener(this);
        this.nlButton.addActionListener(this);
        this.bButton.addActionListener(this);
        this.nbButton.addActionListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        bpanel.setLayout(gridbag);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 5, 5);
        gridbag.setConstraints(this.gtButton, gbc);
        bpanel.add(this.gtButton);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 5, 5, 10);
        gridbag.setConstraints(this.ltButton, gbc);
        bpanel.add(this.ltButton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 5, 5);
        gridbag.setConstraints(this.eqButton, gbc);
        bpanel.add(this.eqButton);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 10);
        gridbag.setConstraints(this.neqButton, gbc);
        bpanel.add(this.neqButton);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 5, 5);
        gridbag.setConstraints(this.lButton, gbc);
        bpanel.add(this.lButton);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 10);
        gridbag.setConstraints(this.nlButton, gbc);
        bpanel.add(this.nlButton);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 10, 5);
        gridbag.setConstraints(this.bButton, gbc);
        bpanel.add(this.bButton);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 10, 10);
        gridbag.setConstraints(this.nbButton, gbc);
        bpanel.add(this.nbButton);
        int internalType = DataType.mapType(this.SQLType);
        if (internalType == 0) {
            this.gtButton.setEnabled(false);
            this.ltButton.setEnabled(false);
            this.lButton.setEnabled(false);
            this.nlButton.setEnabled(false);
            this.bButton.setEnabled(false);
            this.nbButton.setEnabled(false);
        } else if (DataType.isNumeric(internalType) || DataType.isDateTime(internalType)) {
            this.lButton.setEnabled(false);
            this.nlButton.setEnabled(false);
        } else if (internalType != 7) {
            throw new Exception(LanguageEncoder.getText("Cannot build condition with data from this column."));
        }
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public String getCondition() {
        return this.condition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setTitle(LanguageEncoder.getText("Please wait..."));
        try {
            this.setVisible(false);
            String delimiter = "";
            int internalType = DataType.mapType(this.SQLType);
            if (QueryBuilder.mapDatabaseType(this.databaseInfo.getProductName()) == 1 && DataType.isDateTime(internalType)) {
                delimiter = "#";
            } else if (DataType.isDateTime(internalType) || internalType == 7) {
                delimiter = "'";
            }
            int specialData = -1;
            if (QueryBuilder.mapDatabaseType(this.databaseInfo.getProductName()) == 2 && DataType.isDateTime(internalType)) {
                specialData = 0;
            } else if (this.databaseInfo.getProductName().toLowerCase().startsWith("informix") && DataType.isDateTime(internalType)) {
                specialData = 1;
            }
            this.cvDialog.init(this.columnName, ((JButton)e.getSource()).getText(), delimiter, specialData, this.SQLType);
            this.cvDialog.setVisible(true);
            this.condition = this.cvDialog.getCondition();
            this.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ColumnThread
    extends Thread {
        private String query;

        public ColumnThread(String q) {
            this.query = q;
        }

        @Override
        public void run() {
            try {
                DatabaseInfo dbInfo = !ConditionOperatorDialog.this.databaseInfo.isUseJNDIDataSource() ? new DatabaseInfo(ConditionOperatorDialog.this.databaseInfo.getDriver(), ConditionOperatorDialog.this.databaseInfo.getURL(), ConditionOperatorDialog.this.databaseInfo.getUserName(), ConditionOperatorDialog.this.databaseInfo.getPassword(), ConditionOperatorDialog.this.databaseInfo.getAdditionalDb()) : new DatabaseInfo(ConditionOperatorDialog.this.databaseInfo.getJNDIName(), ConditionOperatorDialog.this.databaseInfo.getEnvProperties());
                Vector data = dbInfo.excuteQuery(this.query, 0, -1);
                Vector vTemp = new Vector();
                for (int i = 0; i < data.size(); ++i) {
                    vTemp.addElement(((Vector)data.elementAt(i)).elementAt(0));
                }
                ConditionOperatorDialog.this.cvDialog.setValues(vTemp, ConditionOperatorDialog.this.SQLType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

