/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.DataSheetView;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SQLView;

public class ConditionPanel
extends JPanel
implements ChangeListener {
    private JTabbedPane mainPanel;
    private ConditionDialog conditionDialog;
    private JScrollPane designPanel;
    private SQLView sqlView;
    private DataSheetView dataSheetView;
    private QueryInParamSet paramSet = null;
    private int lastTabIndex = 0;

    public ConditionPanel(ConditionDialog cDialog, JScrollPane dPanel) {
        this.conditionDialog = cDialog;
        this.designPanel = dPanel;
        this.init();
    }

    private void init() {
        this.mainPanel = new JTabbedPane();
        this.mainPanel.insertTab(LanguageEncoder.getText("Design View"), null, this.designPanel, null, 0);
        this.mainPanel.insertTab(LanguageEncoder.getText("SQL View"), null, this.getSQLPanel(), null, 1);
        this.mainPanel.insertTab(LanguageEncoder.getText("Datasheet View"), null, this.getDatasheetPanel(), null, 2);
        this.mainPanel.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
    }

    private JPanel getSQLPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.sqlView = new SQLView(this.buildQuery());
        panel.add((Component)this.sqlView, "Center");
        this.sqlView.setSQLEditable(false);
        return panel;
    }

    private JPanel getDatasheetPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.dataSheetView = new DataSheetView(this.conditionDialog, "*", new Vector<String>());
        panel.add((Component)this.dataSheetView, "Center");
        return panel;
    }

    public void goToPanel(int selectedIndex) {
        this.setPanel(selectedIndex);
        this.mainPanel.setSelectedIndex(selectedIndex);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPanel(this.mainPanel.getSelectedIndex());
        this.lastTabIndex = this.mainPanel.getSelectedIndex();
    }

    private void setPanel(int selectedIndex) {
        String oldtitle = this.conditionDialog.getTitle();
        this.conditionDialog.setTitle(QueryMain.WAIT_TITLE);
        this.conditionDialog.setCursor(Cursor.getPredefinedCursor(3));
        if (selectedIndex == 1) {
            if (!this.sqlView.isModified()) {
                this.sqlView.setQuery(this.buildQuery());
            }
        } else if (selectedIndex == 2) {
            if (!this.sqlView.isModified()) {
                this.updateDataSheet();
            } else {
                this.updateDataSheet(this.sqlView.getQuery());
            }
        } else if (selectedIndex == 0 && this.sqlView.isModified()) {
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this.conditionDialog, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You may lose the query that you modified, continue?"), 2);
            int response = msgDialog.getResponse();
            if (response == 4) {
                this.sqlView.resetQuery();
            } else {
                this.goToPanel(1);
            }
        }
        this.conditionDialog.setCursor(Cursor.getPredefinedCursor(0));
        this.conditionDialog.setTitle(oldtitle);
    }

    private String buildQuery() {
        return this.conditionDialog.getQuery();
    }

    private void updateDataSheet() {
        this.updateDataSheet(this.buildQuery());
    }

    private void updateDataSheet(String query) {
        try {
            this.updateDataSheet(query, this.conditionDialog.getColumnNames());
        }
        catch (Exception ex) {
            Vector<String> tmp = new Vector<String>();
            for (int i = 0; i < 5; ++i) {
                tmp.addElement("");
            }
            this.updateDataSheet(query, tmp);
        }
    }

    private void updateDataSheet(String query, Vector<String> columnNames) {
        QueryInParamSet pset = null;
        try {
            if (QueryParser.hasParameters(query)) {
                boolean initializationRequired = true;
                pset = QueryParser.filterParameters(query, this.paramSet);
                if (pset != null) {
                    QueryInParam[] params = pset.getParameter();
                    for (int i = 0; i < params.length; ++i) {
                        initializationRequired = false;
                        if (params[i] != null) continue;
                        initializationRequired = true;
                        i = params.length;
                    }
                }
                if (initializationRequired) {
                    this.paramSet = null;
                    this.conditionDialog.showParameters();
                    if (this.paramSet == null) {
                        this.goToPanel(this.lastTabIndex);
                        return;
                    }
                    pset = this.paramSet;
                }
                DBInfoBasic newDBInfo = this.conditionDialog.getDataViewDialog().getDatabaseInfo().isUseJNDIDataSource() ? new DBInfoBasic(this.conditionDialog.getDataViewDialog().getDatabaseInfo().getJNDIName(), query, this.conditionDialog.getDataViewDialog().getDatabaseInfo().getEnvProperties()) : new DBInfoBasic(this.conditionDialog.getDataViewDialog().getDatabaseInfo().getURL(), this.conditionDialog.getDataViewDialog().getDatabaseInfo().getDriver(), this.conditionDialog.getDataViewDialog().getDatabaseInfo().getUserName(), this.conditionDialog.getDataViewDialog().getDatabaseInfo().getPassword(), query, this.conditionDialog.getDataViewDialog().getDatabaseInfo().getAdditionalDb());
                QueryFileInfo qfi = new QueryFileInfo("", 0, newDBInfo, pset);
                EnterInParamDialog eDialog = new EnterInParamDialog(this.conditionDialog, qfi, true, 0, null, null);
                eDialog.setVisible(true);
                if (eDialog.isCancelled()) {
                    this.goToPanel(this.lastTabIndex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dataSheetView.setQuery(query, columnNames, pset);
    }

    void updateDesignPanel(JScrollPane scrollPane) {
        this.mainPanel.setComponentAt(0, scrollPane);
        if (this.mainPanel.getSelectedIndex() == 0) {
            this.mainPanel.repaint();
        }
    }

    void setInSet(QueryInParamSet inSet) {
        this.paramSet = inSet;
    }
}

