/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDateFormat;

public class ConditionValueDialog
extends JDialog
implements ActionListener {
    private boolean singleOperand = true;
    private JComboBox operand1;
    private JComboBox operand2;
    private JButton okButton;
    private JButton cancelButton;
    private String condition = null;
    private String operator;
    private String delimiter = "";
    public static final int ORACLE_DATE = 0;
    public static final int INFORMIX_DATE = 1;
    private int specialData = -1;
    private Vector values;
    private Vector dfValues;

    public ConditionValueDialog(JDialog parent) {
        super((Dialog)parent, true);
    }

    public void init(String colname, String op, String de, int sd, int sqlType) {
        this.specialData = sd;
        this.operator = op;
        if (de != null) {
            this.delimiter = de;
        }
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        this.setTitle(LanguageEncoder.getText("Conditions"));
        JPanel bpanel = (JPanel)this.getContentPane();
        BorderLayout bLayout = new BorderLayout();
        bLayout.setVgap(5);
        bpanel.setLayout(bLayout);
        if (this.operator == null) {
            this.operator = "";
        }
        if (colname == null) {
            colname = "";
        }
        this.operator = this.operator.trim();
        String exp = "";
        exp = this.operator.toUpperCase().endsWith("LIKE") || this.operator.toUpperCase().endsWith("BETWEEN") ? colname.trim() + " is " + this.operator : colname.trim() + " " + this.operator;
        if (!this.operator.toUpperCase().trim().endsWith("BETWEEN")) {
            JPanel buildpanel = new JPanel();
            buildpanel.setLayout(new FlowLayout());
            buildpanel.add(new JLabel(exp + " "));
            this.operand1 = new JComboBox();
            this.operand1.setEditable(true);
            buildpanel.add(this.operand1);
            bpanel.add((Component)buildpanel, "Center");
        } else {
            this.singleOperand = false;
            JPanel buildpanel1 = new JPanel();
            buildpanel1.setLayout(new FlowLayout());
            buildpanel1.add(new JLabel(exp));
            this.operand1 = new JComboBox();
            this.operand2 = new JComboBox();
            this.operand1.setEditable(true);
            this.operand2.setEditable(true);
            JPanel buildpanel2 = new JPanel();
            buildpanel2.setLayout(new FlowLayout());
            buildpanel2.add(this.operand1);
            buildpanel2.add(new JLabel(" AND "));
            buildpanel2.add(this.operand2);
            bpanel.add((Component)buildpanel1, "North");
            bpanel.add((Component)buildpanel2, "Center");
        }
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        bpanel.add((Component)okpanel, "South");
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension d = this.getPreferredSize();
        int x = (screenSize.width - ((int)d.getWidth() + 50)) / 2;
        int y = (screenSize.height - (int)d.getHeight()) / 2;
        this.setBounds(x, y, (int)d.getWidth() + 50, (int)d.getHeight());
        this.setSize(new Dimension((int)d.getWidth() + 50, (int)d.getHeight()));
        if (this.values != null) {
            this.dfValues = this.fixValues(this.values, sqlType);
        }
        this.fillOperands();
    }

    public String getCondition() {
        return this.condition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.okButton) {
            try {
                Object obj = null;
                obj = this.operand1.getSelectedIndex() == -1 || this.operand1.getSelectedIndex() == 0 ? this.operand1.getSelectedItem() : this.values.get(this.operand1.getSelectedIndex() - 1);
                if (obj == null || obj.toString().trim().equals("")) {
                    this.condition = "";
                } else {
                    String value = this.quoteValue(obj);
                    this.condition = this.operator + " " + value;
                    if (!this.singleOperand) {
                        if (this.operand2.getSelectedIndex() > 0) {
                            value = this.quoteValue(this.values.get(this.operand2.getSelectedIndex() - 1));
                        }
                        this.condition = this.condition + " AND " + value;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.condition = null;
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setValues(Vector values, int sqlType) {
        this.values = values;
        this.dfValues = this.fixValues(values, sqlType);
        this.fillOperands();
    }

    private void fillOperands() {
        if (this.operand1 == null || this.operand1.getModel().getSize() > 0 || this.dfValues == null) {
            return;
        }
        JTextComponent txtComp = (JTextComponent)this.operand1.getEditor().getEditorComponent();
        String txt = txtComp.getText();
        Vector v = (Vector)this.dfValues.clone();
        v.insertElementAt(txt, 0);
        DefaultComboBoxModel dcbm = new DefaultComboBoxModel(v);
        this.operand1.setModel(dcbm);
        txtComp.setCaretPosition(txt.length());
        if (this.operand2 != null) {
            txtComp = (JTextComponent)this.operand2.getEditor().getEditorComponent();
            txt = txtComp.getText();
            Vector v2 = (Vector)this.dfValues.clone();
            v2.insertElementAt(txt, 0);
            DefaultComboBoxModel dcbm2 = new DefaultComboBoxModel(v2);
            this.operand2.setModel(dcbm2);
            txtComp.setCaretPosition(txt.length());
        }
        this.pack();
    }

    private Vector fixValues(Vector values, int sqlType) {
        Vector<String> vect = new Vector<String>();
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.elementAt(i);
            if (obj != null && obj instanceof Date) {
                String dstring = obj.toString();
                if (sqlType == 91) {
                    dstring = QbDateFormat.getFormattedDateTime((Date)obj, QbDateFormat.getDefaultDateFormat());
                } else if (sqlType == 93) {
                    dstring = QbDateFormat.getFormattedDateTime((Date)obj, QbDateFormat.getDefaultTimestampFormat());
                } else if (sqlType == 92) {
                    dstring = QbDateFormat.getFormattedDateTime((Date)obj, QbDateFormat.getDefaultTimeFormat());
                }
                vect.addElement(dstring);
                continue;
            }
            vect.addElement((String)obj);
        }
        return vect;
    }

    private String quoteValue(Object value) {
        if (this.specialData == 0) {
            return "TO_TIMESTAMP(" + this.delimiter + value.toString() + this.delimiter + ", 'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        if (this.specialData == 1) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            return this.delimiter + format.format((Date)value) + this.delimiter;
        }
        return this.delimiter + value.toString() + this.delimiter;
    }
}

