/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import quadbase.common.util.internal.LanguageEncoder;

public class CustomParameterDialog
extends JDialog
implements ActionListener {
    private JComboBox comboBox = null;
    private JTextField textField = null;
    private boolean modified = false;

    public CustomParameterDialog(JDialog parent, String[] choices) {
        super(parent, LanguageEncoder.getText("Parameter"), true);
        this.init(choices);
    }

    private void init(String[] choices) {
        this.setBackground(Color.lightGray);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(2, 1, 0, 2));
        topPanel.add(new JLabel(LanguageEncoder.getText("Parameter Name:")));
        if (choices != null) {
            this.comboBox = new JComboBox<String>(choices);
            Dimension dim = this.comboBox.getPreferredSize();
            dim.width = 150;
            this.comboBox.setPreferredSize(dim);
            this.comboBox.setEditable(true);
            topPanel.add(this.comboBox);
        } else {
            this.textField = new JTextField(20);
            topPanel.add(this.textField);
        }
        topPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        JButton button = new JButton(LanguageEncoder.getText("OK"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton(LanguageEncoder.getText("Cancel"));
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        bottomPanel.add(button);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)topPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        int x = (screenSize.width - dim.width) / 2;
        int y = (screenSize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.modified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public String getText() {
        String item;
        if (this.comboBox != null) {
            Object item2 = this.comboBox.getSelectedItem();
            if (item2 != null) {
                return item2.toString();
            }
        } else if (this.textField != null && (item = this.textField.getText()) != null) {
            return item;
        }
        return "param";
    }
}

