/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.DataSheetView;
import quadbase.querybuilder.designer.NumericDialog;

public class DataSheetToolBar
extends JToolBar
implements ActionListener {
    private DataSheetView dataSheet;
    private JButton prevButton;
    private JButton nextButton;
    private JButton firstButton;
    private JButton lastButton;

    public DataSheetToolBar(DataSheetView dataSheet) {
        this.setFloatable(false);
        this.dataSheet = dataSheet;
        this.setBorder(new TitledBorder(""));
        this.firstButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("First Page"), LanguageEncoder.getText("FIRST"), "first.gif", this.firstButton);
        this.addSeparator();
        this.prevButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Previous Page"), LanguageEncoder.getText("PREVIOUS"), "rewind.gif", this.prevButton);
        this.addNewButton(LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("GOTO"), "goto.gif");
        this.nextButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Next Page"), LanguageEncoder.getText("NEXT"), "forward.gif", this.nextButton);
        this.addSeparator();
        this.lastButton = new JButton();
        this.addNewButton(LanguageEncoder.getText("Last Page"), LanguageEncoder.getText("LAST"), "last.gif", this.lastButton);
        this.addSeparator();
        this.addNewButton(LanguageEncoder.getText("Display Rows"), LanguageEncoder.getText("DISPLAYROWS"), "rownum.gif");
        this.setEnabled();
    }

    private void addNewButton(String tip, String command, String img) {
        this.addNewButton(tip, command, img, new JButton());
    }

    private void addNewButton(String tip, String command, String img, JButton newBtn) {
        img = ServerMessage.reportImagesPath + img;
        newBtn.setIcon(IOUtil.getImageIcon(img));
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    public void setEnabled() {
        this.setEnabled(this.dataSheet != null);
        if (this.dataSheet == null) {
            return;
        }
        this.firstButton.setEnabled(!this.dataSheet.isFirstPage());
        this.prevButton.setEnabled(!this.dataSheet.isFirstPage());
        this.nextButton.setEnabled(!this.dataSheet.isLastPage());
        this.lastButton.setEnabled(!this.dataSheet.isLastPage());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command.equals(LanguageEncoder.getText("FIRST"))) {
                this.dataSheet.goToFirstPage();
            } else if (command.equals(LanguageEncoder.getText("PREVIOUS"))) {
                this.dataSheet.goToPreviousPage();
            } else if (command.equals(LanguageEncoder.getText("NEXT"))) {
                this.dataSheet.goToNextPage();
            } else if (command.equals(LanguageEncoder.getText("LAST"))) {
                this.dataSheet.goToLastPage();
            } else if (command.equals(LanguageEncoder.getText("GOTO"))) {
                NumericDialog dialog = null;
                if (this.dataSheet.window instanceof JDialog) {
                    dialog = new NumericDialog((JDialog)this.dataSheet.window, this.dataSheet.getSelectedRow() + 1, LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("Row Index :"));
                } else if (this.dataSheet.window instanceof JFrame) {
                    dialog = new NumericDialog((JFrame)this.dataSheet.window, this.dataSheet.getSelectedRow() + 1, LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("Row Index :"));
                } else {
                    return;
                }
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.dataSheet.goTo(dialog.getValue());
                }
            } else if (command.equals(LanguageEncoder.getText("DISPLAYROWS"))) {
                NumericDialog dialog = null;
                if (this.dataSheet.window instanceof JDialog) {
                    dialog = new NumericDialog((JDialog)this.dataSheet.window, this.dataSheet.getDisplayRow(), LanguageEncoder.getText("Set Display Row ..."), LanguageEncoder.getText("Number Of Display Row :"));
                } else if (this.dataSheet.window instanceof JFrame) {
                    dialog = new NumericDialog((JFrame)this.dataSheet.window, this.dataSheet.getDisplayRow(), LanguageEncoder.getText("Set Display Row ..."), LanguageEncoder.getText("Number Of Display Row :"));
                } else {
                    return;
                }
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.dataSheet.setDisplayRow(dialog.getValue());
                }
            } else {
                System.out.println("PreviewToolBar command : " + command);
            }
        }
        catch (Exception ex) {
            new JMessageDialog((Frame)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)), LanguageEncoder.getText("Error"), ex.toString());
        }
    }
}

