/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.worker.SwingWorker;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.DataSheetToolBar;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;

public class DataSheetView
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(DataSheetView.class.getName());
    private String query = "";
    private JTable table;
    private Vector<String> columnNames;
    int startIndex = 0;
    int displayRow = 30;
    private JScrollPane scrollPane;
    private DataSheetToolBar toolBar;
    Window window;
    private DefaultCellEditor noEditor;
    private DatabaseInfo databaseInfo;
    private boolean isDataView = false;
    private QueryInParamSet inSet = null;
    private SwingWorker<Vector, Void> swingWorker;
    private final Object swingWorkerLock = new Object();
    private int selectRowIndex = -1;

    public DataSheetView(QueryMain queryMain, String query, Vector<String> columnNames) {
        this.window = queryMain;
        this.databaseInfo = queryMain.databaseInfo;
        this.init(query, columnNames);
    }

    public DataSheetView(ConditionDialog conditionDialog, String query, Vector<String> columnNames) {
        this.isDataView = true;
        this.databaseInfo = conditionDialog.getDataViewDialog().getDatabaseInfo();
        this.window = conditionDialog;
        this.init(query, columnNames);
    }

    public void updateDataSheet(String query, QueryInParamSet pset) {
        this.setQuery(query, null, pset);
    }

    public void cancelQuery() {
        if (this.swingWorker != null && this.swingWorker.getState() != SwingWorker.StateValue.DONE) {
            this.swingWorker.cancel(true);
        }
    }

    private void init(String query, Vector<String> columnNames) {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.displayRow, columnNames.size() <= 0 ? 5 : columnNames.size());
        this.table.setGridColor(Color.lightGray);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        this.noEditor = new DefaultCellEditor(notEditableField);
        this.table.setCellEditor(this.noEditor);
        this.table.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.toolBar = new DataSheetToolBar(this);
        this.setQuery(query, columnNames, this.inSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(final int startIndex, final int displayRow) throws Exception {
        this.startIndex = startIndex;
        final String newQuery = QueryMain.getReplaceColInfoList() != null ? this.getNewQuery() : this.query;
        Object object = this.swingWorkerLock;
        synchronized (object) {
            while (this.swingWorker != null) {
                this.swingWorkerLock.wait();
            }
            this.swingWorker = new SwingWorker<Vector, Void>(){
                private boolean cancel;
                private boolean canceled;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Vector doInBackground() throws Exception {
                    Object object = DataSheetView.this.swingWorkerLock;
                    synchronized (object) {
                        Vector vector;
                        try {
                            Future<Vector> future = DataSheetView.this.databaseInfo.executeQueryAsync(newQuery, DataSheetView.this.inSet, startIndex, displayRow, -1);
                            while (!future.isDone()) {
                                if (this.cancel && !this.canceled) {
                                    this.canceled = true;
                                    LOGGER.finest("Asking to cancel query");
                                    DataSheetView.this.databaseInfo.cancelRunningQuery();
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            vector = future.get();
                        }
                        catch (Throwable throwable) {
                            DataSheetView.this.swingWorker = null;
                            DataSheetView.this.swingWorkerLock.notify();
                            throw throwable;
                        }
                        DataSheetView.this.swingWorker = null;
                        DataSheetView.this.swingWorkerLock.notify();
                        return vector;
                    }
                }

                @Override
                protected void done() {
                    Vector vec;
                    if (this.isCancelled()) {
                        this.cancel = true;
                        return;
                    }
                    try {
                        vec = (Vector)this.get();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (ExecutionException e) {
                        LOGGER.log(Level.FINER, "Failed to set query", e);
                        DataSheetView.this.setErrorMessage(e);
                        return;
                    }
                    if (DataSheetView.this.startIndex < 0) {
                        int rowCT = DataSheetView.this.databaseInfo.getRowCount();
                        DataSheetView.this.startIndex = rowCT % displayRow == 0 ? rowCT - displayRow : (int)(Math.floor((double)rowCT / (double)displayRow) * (double)displayRow);
                    }
                    DataSheetView.this.toolBar.setEnabled();
                    DataSheetView.this.setupColumnNames(vec);
                    ((DefaultTableModel)DataSheetView.this.table.getModel()).setDataVector(vec, DataSheetView.this.columnNames);
                    for (int i = 0; i < DataSheetView.this.table.getColumnCount(); ++i) {
                        DataSheetView.this.table.getColumnModel().getColumn(i).setCellEditor(DataSheetView.this.noEditor);
                    }
                    if (DataSheetView.this.selectRowIndex != -1) {
                        try {
                            DataSheetView.this.table.setRowSelectionInterval(DataSheetView.this.selectRowIndex, DataSheetView.this.selectRowIndex);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Select row index failed", ex);
                        }
                        DataSheetView.this.selectRowIndex = -1;
                    }
                    DataSheetView.this.removeAll();
                    DataSheetView.this.add("Center", DataSheetView.this.scrollPane);
                    DataSheetView.this.add("South", DataSheetView.this.toolBar);
                    DataSheetView.this.revalidate();
                    DataSheetView.this.repaint();
                }
            };
            this.swingWorker.execute();
        }
    }

    private void setupColumnNames(Vector vec) {
        int i;
        Vector row = (Vector)vec.elementAt(0);
        int numOfRow = vec.size();
        if (this.columnNames == null) {
            this.columnNames = new Vector(row.size());
            for (i = 0; i < row.size(); ++i) {
                Object name = ((Vector)vec.elementAt(numOfRow - 3)).elementAt(i);
                Object dataType = ((Vector)vec.elementAt(numOfRow - 1)).elementAt(i);
                this.columnNames.addElement(DesignView.getColumnHeaderStringWithDataType(name != null ? name.toString() : "", dataType != null ? dataType.toString() : ""));
            }
        }
        if (row.size() != this.columnNames.size()) {
            for (i = 0; i < row.size(); ++i) {
                if (i >= row.size() || i < this.columnNames.size()) continue;
                this.columnNames.add(i + 1 + "");
            }
            while (i < this.columnNames.size()) {
                this.columnNames.removeElementAt(i);
            }
        }
        vec.remove(numOfRow - 1);
        vec.remove(numOfRow - 2);
        vec.remove(numOfRow - 3);
    }

    private void setErrorMessage(Exception exception) {
        String message = exception.getMessage() != null ? exception.getMessage() : exception.toString();
        message = message.replace("java.util.concurrent.ExecutionException: ", "");
        message = message.replace("java.io.IOException: ", "");
        JTextArea text = new JTextArea();
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setText(message);
        text.setEditable(false);
        this.removeAll();
        this.add("North", text);
        this.revalidate();
        this.repaint();
    }

    private void setRunningQueryMessage() {
        ImageIcon imageIcon = new ImageIcon(DataSheetView.class.getResource("/images/loader.gif"));
        JLabel label = new JLabel("Running query", imageIcon, 2);
        imageIcon.setImageObserver(label);
        this.removeAll();
        this.add("North", label);
        this.revalidate();
        this.repaint();
    }

    private String getNewQuery() {
        try {
            Object replaceColInfoList = QueryMain.getReplaceColInfoList();
            Class<?> c = Class.forName("quadbase.reportdesigner.util.ReplaceColumnInfoList");
            Class[] paramTypes = new Class[]{String.class, String.class, String.class};
            Method replaceColumnInfoForWhereClauseMethod = c.getMethod("replaceColumnInfoForWhereClause", paramTypes);
            Object[] arguments = new Object[]{this.query, this.databaseInfo.getDriver(), this.databaseInfo.getURL()};
            Object result = replaceColumnInfoForWhereClauseMethod.invoke(replaceColInfoList, arguments);
            return (String)result;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to get new query", e);
            return this.query;
        }
    }

    boolean isLastPage() {
        return this.databaseInfo.isLastPage(this.startIndex, this.displayRow);
    }

    boolean isFirstPage() {
        return this.startIndex < this.displayRow;
    }

    void goToFirstPage() throws Exception {
        if (this.isFirstPage()) {
            return;
        }
        this.setValue(0, this.displayRow);
    }

    void goToPreviousPage() throws Exception {
        if (this.isFirstPage()) {
            return;
        }
        this.setValue(this.startIndex - this.displayRow, this.displayRow);
    }

    void goToNextPage() throws Exception {
        if (this.isLastPage()) {
            return;
        }
        this.setValue(this.startIndex + this.displayRow, this.displayRow);
    }

    void goToLastPage() throws Exception {
        if (this.isLastPage()) {
            return;
        }
        this.setValue(-1, this.displayRow);
    }

    void goTo(int rowIndex) throws Exception {
        if (rowIndex < 0) {
            this.goToFirstPage();
        } else if (this.databaseInfo.isLastPage(rowIndex, this.displayRow)) {
            boolean wasLastPage = this.isLastPage();
            this.goToLastPage();
            int newRowIndex = rowIndex % this.displayRow - 1;
            if (wasLastPage) {
                try {
                    this.table.setRowSelectionInterval(newRowIndex, newRowIndex);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Select row index failed", ex);
                }
            } else {
                this.selectRowIndex = newRowIndex;
            }
        } else {
            int tmp = (int)(Math.floor(rowIndex / this.displayRow) * (double)this.displayRow);
            this.setValue(tmp, this.displayRow);
            this.selectRowIndex = rowIndex % this.displayRow - 1;
        }
    }

    void setDisplayRow(int rowCt) throws Exception {
        this.setValue(0, rowCt);
        this.displayRow = rowCt;
    }

    int getDisplayRow() {
        return this.displayRow;
    }

    int getSelectedRow() {
        int tmp = this.table.getSelectedRow();
        if (tmp < 0) {
            return -1;
        }
        return tmp + this.startIndex;
    }

    void setQuery(String query, Vector<String> columnNames, QueryInParamSet inSet) {
        this.setRunningQueryMessage();
        if (query.equals("SELECT")) {
            ((DefaultTableModel)this.table.getModel()).setDataVector(new Vector(), columnNames);
        }
        if ("*".equals(query)) {
            return;
        }
        try {
            if (!this.query.equals(query) || this.inSet == null && inSet != null || this.inSet != null && inSet == null || this.inSet != null && !this.inSet.equals(inSet)) {
                this.query = query;
                this.columnNames = columnNames;
                this.inSet = inSet != null ? (QueryInParamSet)inSet.clone() : null;
            }
            this.setValue(0, this.displayRow);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Failed to set query", ex);
            this.setErrorMessage(ex);
            return;
        }
    }

    public boolean isDataView() {
        return this.isDataView;
    }
}

