/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JScrollPane;
import quadbase.common.swing.listeners.MousePopUpAdapter;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.DataViewDialog;
import quadbase.querybuilder.designer.DataViewTableSelectionDialog;
import quadbase.querybuilder.designer.IJoinLineMonitor;
import quadbase.querybuilder.designer.JoinLine;
import quadbase.querybuilder.designer.JoinPropertyDialog;
import quadbase.querybuilder.designer.PopupMenuForJoinLine;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.ForeignKeyLocator;
import quadbase.querybuilder.query.QueryBuilder;

public class DataViewDiagram
extends JScrollPane
implements IJoinLineMonitor {
    private Vector lineList;
    private JoinLine selectedJoinLine = null;
    private PopupMenuForJoinLine joinLineMenu;
    private JDesktopPane diagramPane;
    private DataViewTableSelectionDialog tableDialog;

    public DataViewDiagram(DataViewTableSelectionDialog p) {
        this.tableDialog = p;
        this.lineList = p.getJoinsVector();
        this.init();
        this.joinLineMenu = new PopupMenuForJoinLine(this);
        this.setPreferredSize(new Dimension(400, 400));
    }

    private void init() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.diagramPane = new JDesktopPane(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                for (int i = 0; i < DataViewDiagram.this.lineList.size(); ++i) {
                    ((JoinLine)DataViewDiagram.this.lineList.elementAt(i)).draw(g);
                }
            }
        };
        this.diagramPane.setPreferredSize(new Dimension(1000, 8000));
        this.diagramPane.setBackground(Color.lightGray);
        this.diagramPane.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                for (int i = DataViewDiagram.this.lineList.size() - 1; i >= 0; --i) {
                    if (!((JoinLine)DataViewDiagram.this.lineList.elementAt(i)).contains(x, y)) continue;
                    DataViewDiagram.this.selectedJoinLine = (JoinLine)DataViewDiagram.this.lineList.elementAt(i);
                    DataViewDiagram.this.joinLineMenu.show(DataViewDiagram.this.diagramPane, x, y);
                }
            }
        });
        this.getViewport().add(this.diagramPane);
    }

    void addTable(ColumnFieldWindow window, boolean addJoins) {
        try {
            if (addJoins) {
                this.setJoinProperty(window);
            }
            window.setLineMonitor(this);
            window.setPosition();
            window.setPosition(this.diagramPane.getAllFrames(), new Dimension(1000, 1000));
            this.diagramPane.add(window);
            window.setVisible(true);
            window.toFront();
            window.setSelected(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this.tableDialog, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to display table in the window.\n") + ex.toString());
        }
    }

    void removeTable(ColumnFieldWindow col) {
        try {
            for (int i = this.lineList.size() - 1; i >= 0; --i) {
                JoinLine joinLine = (JoinLine)this.lineList.elementAt(i);
                if (!joinLine.isRelated(col)) continue;
                this.lineList.removeElementAt(i);
            }
            this.diagramPane.remove(col);
        }
        catch (Exception ex) {
            new JMessageDialog((Dialog)this.tableDialog, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to remove table from the window.\n") + ex.toString());
        }
    }

    @Override
    public void updateJoinProperty() {
        if (this.selectedJoinLine == null) {
            return;
        }
        JoinPropertyDialog joinDialog = new JoinPropertyDialog(this.tableDialog, this.selectedJoinLine);
        joinDialog.setVisible(true);
        if (!joinDialog.isModified()) {
            return;
        }
        this.selectedJoinLine.setJoinProperty(joinDialog.getJoinProperty());
        this.diagramPane.repaint();
    }

    @Override
    public void deleteJoinProperty() {
        if (this.selectedJoinLine != null) {
            this.lineList.removeElement(this.selectedJoinLine);
        }
        this.diagramPane.repaint();
    }

    @Override
    public int getColumnFieldWindowCount() {
        return this.diagramPane.getAllFrames().length;
    }

    @Override
    public void repaintDesktop() {
        this.diagramPane.repaint();
    }

    @Override
    public void setParentCursor(Cursor c) {
        this.tableDialog.setCursor(c);
    }

    @Override
    public ColumnFieldWindow getSelectedColumnFieldWindow(int x, int y) {
        int ct = this.getColumnFieldWindowCount();
        for (int i = 0; i < ct; ++i) {
            ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[i];
            if (!tmp.getBounds().contains(x, y)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void setJoinProperty(ColumnFieldWindow col1, int idx1, ColumnFieldWindow col2, int idx2, int joinProperty) {
        if (col1 == col2) {
            return;
        }
        DataViewDialog.addJoin(this.lineList, new JoinLine(col1, idx1, col2, idx2, joinProperty));
    }

    private void setJoinProperty(ColumnFieldWindow newCol) {
        DatabaseInfo databaseInfo = this.tableDialog.getDatabaseInfo();
        int ct = this.getColumnFieldWindowCount();
        if (ct > 0) {
            Vector joincols = null;
            try {
                joincols = new ForeignKeyLocator(QueryBuilder.mapDatabaseType(databaseInfo.getProductName()), databaseInfo).findForeignKeys(newCol, Arrays.asList(this.diagramPane.getAllFrames()).toArray(new ColumnFieldWindow[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (joincols != null) {
                for (int i = 0; i < joincols.size(); ++i) {
                    DataViewDialog.addJoin(this.lineList, new JoinLine((ColumnFieldWindow)((Vector)joincols.elementAt(i)).elementAt(0), (Integer)((Vector)joincols.elementAt(i)).elementAt(1), (ColumnFieldWindow)((Vector)joincols.elementAt(i)).elementAt(2), (Integer)((Vector)joincols.elementAt(i)).elementAt(3)));
                }
                return;
            }
            String[] columnNames = newCol.getColumns();
            for (int i = 0; i < columnNames.length; ++i) {
                for (int j = 0; j < ct; ++j) {
                    ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[j];
                    int index = tmp.getIndex(columnNames[i], newCol.getSQLType(i + 1));
                    if (tmp == newCol || index <= -1) continue;
                    DataViewDialog.addJoin(this.lineList, new JoinLine(newCol, i + 1, tmp, index));
                }
            }
        }
    }

    @Override
    public void setColumn(String s1, String s2) {
    }

    @Override
    public void updateJoinProperties(ColumnFieldWindow w) {
    }
}

