/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.querybuilder.designer.ColumnDescriptionDialog;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.ColumnTreeNode;
import quadbase.querybuilder.designer.DataViewTableSelectionDialog;
import quadbase.querybuilder.designer.FormulaBuilderDialog;
import quadbase.querybuilder.designer.JoinLine;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.QueryBuilder;

public class DataViewDialog
extends JDialog
implements ActionListener,
MouseListener {
    private JTextField nameField = null;
    private JButton addButton;
    private JButton removeButton;
    private JButton renameButton;
    private JButton buildButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton addHeadingButton;
    private JButton removeHeadingButton;
    private JButton groupButton;
    private JButton chooseTableButton;
    private JButton descripButton;
    private JButton upButton;
    private JButton downButton;
    private DatabaseInfo databaseInfo;
    private JTree tableTree;
    private JTree viewTree;
    private Vector joinProperties;
    private static final int VERSION = 10;
    private boolean modified = false;
    private DataViewTableSelectionDialog tableSelectionDialog = null;
    TableTreeNode[] allTables;
    private FormulaBuilderDialog formulaDialog;
    private int tableNameFormat = 0;
    private DataViewNode[] siblings = null;
    private boolean doAutoJoin = true;
    private boolean silentMode = false;

    public DataViewDialog(Dialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, boolean autoJoin, int tnFormat, DataViewNode[] s) throws Exception {
        this(owner, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, autoJoin, tnFormat, null, s);
    }

    public DataViewDialog(Dialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, boolean autoJoin, int tnFormat, Vector additionalDb, DataViewNode[] s) throws Exception {
        super(owner, true);
        this.databaseInfo = isUseJNDIDataSource ? new DatabaseInfo(JNDIName, env) : new DatabaseInfo(driver, url, username, password, additionalDb);
        this.siblings = s;
        if (tnFormat < 0) {
            tnFormat = 0;
        }
        if (tnFormat > 2) {
            tnFormat = 2;
        }
        this.tableNameFormat = tnFormat;
        this.doAutoJoin = autoJoin;
        this.joinProperties = new Vector();
        this.init();
        this.tableSelectionDialog = new DataViewTableSelectionDialog(this, autoJoin);
        this.tableSelectionDialog.setVisible(true);
        if (this.tableSelectionDialog.isModified()) {
            TableTreeNode[] selectedTables;
            for (TableTreeNode selectedTable : selectedTables = this.tableSelectionDialog.getTables()) {
                this.addTable(selectedTable);
            }
        } else {
            ((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()).removeAllChildren();
        }
        if (this.formulaDialog != null) {
            this.formulaDialog.updateTables(this.getColumnFieldWindows());
        }
        this.setPosition();
    }

    public DataViewDialog(Dialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin) throws Exception {
        this(owner, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, file, autoJoin, false);
    }

    public DataViewDialog(Dialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin, boolean sMode) throws Exception {
        this(owner, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, file, autoJoin, null, false);
    }

    public DataViewDialog(Dialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin, Vector additionalDb, boolean sMode) throws Exception {
        super(owner, true);
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, file, autoJoin, additionalDb, sMode);
    }

    public DataViewDialog(JDialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin, boolean sMode) throws Exception {
        super((Dialog)owner, true);
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, file, autoJoin, sMode);
    }

    private void constructor_helper(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin, boolean sMode) throws Exception {
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, file, autoJoin, null, sMode);
    }

    private void constructor_helper(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, String file, boolean autoJoin, Vector additionalDb, boolean sMode) throws Exception {
        this.silentMode = sMode;
        this.databaseInfo = isUseJNDIDataSource ? new DatabaseInfo(JNDIName, env) : new DatabaseInfo(driver, url, username, password, additionalDb);
        this.joinProperties = new Vector();
        this.doAutoJoin = autoJoin;
        this.load(file);
        if (this.formulaDialog != null) {
            this.formulaDialog.updateTables(this.getColumnFieldWindows());
        }
        this.nameField.setText(name);
        this.setPosition();
    }

    public DataViewDialog(Frame owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, byte[] fileBytes) throws Exception {
        super(owner, true);
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, fileBytes);
    }

    public DataViewDialog(Frame owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, Vector additionalDb, byte[] fileBytes) throws Exception {
        super(owner, true);
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, additionalDb, fileBytes);
    }

    public DataViewDialog(JDialog owner, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, byte[] fileBytes) throws Exception {
        super((Dialog)owner, true);
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, fileBytes);
    }

    private void constructor_helper(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, byte[] fileBytes) throws Exception {
        this.constructor_helper(isUseJNDIDataSource, JNDIName, env, driver, url, username, password, name, null, fileBytes);
    }

    private void constructor_helper(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String name, Vector additionalDb, byte[] fileBytes) throws Exception {
        this.databaseInfo = isUseJNDIDataSource ? new DatabaseInfo(JNDIName, env) : new DatabaseInfo(driver, url, username, password, additionalDb);
        this.joinProperties = new Vector();
        this.load(new DataInputStream(new ByteArrayInputStream(fileBytes)));
        if (this.formulaDialog != null) {
            this.formulaDialog.updateTables(this.getColumnFieldWindows());
        }
        this.nameField.setText(name);
        this.setPosition();
    }

    private void init() throws Exception {
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Create Data View"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("New Data View")));
        JPanel buildpanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buildpanel.setLayout(gridbag);
        JPanel namePanel = new JPanel(new FlowLayout());
        JLabel comp = new JLabel(LanguageEncoder.getText("Name :") + " ");
        this.nameField = new JTextField("", 15);
        Dimension d = this.nameField.getPreferredSize();
        namePanel.add(comp);
        namePanel.add(this.nameField);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 10;
        gbc.fill = 1;
        comp = new JLabel(LanguageEncoder.getText("Available Database Fields"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 2;
        gbc.gridy = 1;
        comp = new JLabel(LanguageEncoder.getText("View Fields"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        this.addButton.addActionListener(this);
        gridbag.setConstraints(this.addButton, gbc);
        buildpanel.add(this.addButton);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 10, 25, 10);
        this.removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        this.removeButton.addActionListener(this);
        gridbag.setConstraints(this.removeButton, gbc);
        buildpanel.add(this.removeButton);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.addHeadingButton = new JButton(LanguageEncoder.getText("Add Heading"));
        this.addHeadingButton.addActionListener(this);
        gridbag.setConstraints(this.addHeadingButton, gbc);
        buildpanel.add(this.addHeadingButton);
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.removeHeadingButton = new JButton(LanguageEncoder.getText("Remove Heading"));
        this.removeHeadingButton.addActionListener(this);
        this.removeHeadingButton.setEnabled(false);
        gridbag.setConstraints(this.removeHeadingButton, gbc);
        buildpanel.add(this.removeHeadingButton);
        gbc.gridx = 1;
        gbc.gridy = 6;
        this.groupButton = new JButton(LanguageEncoder.getText("Group Fields"));
        this.groupButton.addActionListener(this);
        gridbag.setConstraints(this.groupButton, gbc);
        buildpanel.add(this.groupButton);
        gbc.gridx = 1;
        gbc.gridy = 7;
        this.renameButton = new JButton(LanguageEncoder.getText("Rename"));
        this.renameButton.addActionListener(this);
        gridbag.setConstraints(this.renameButton, gbc);
        buildpanel.add(this.renameButton);
        gbc.gridx = 1;
        gbc.gridy = 8;
        this.buildButton = new JButton(LanguageEncoder.getText("Build Formula"));
        this.buildButton.addActionListener(this);
        gridbag.setConstraints(this.buildButton, gbc);
        buildpanel.add(this.buildButton);
        gbc.gridx = 1;
        gbc.gridy = 9;
        this.descripButton = new JButton(LanguageEncoder.getText("Description"));
        this.descripButton.addActionListener(this);
        gridbag.setConstraints(this.descripButton, gbc);
        buildpanel.add(this.descripButton);
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.upButton = new JButton(new ArrowIcon(true));
        Insets is = this.upButton.getMargin();
        is.left = 2;
        is.right = 2;
        this.upButton.setMargin(is);
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this);
        gridbag.setConstraints(this.upButton, gbc);
        buildpanel.add(this.upButton);
        gbc.gridx = 3;
        gbc.gridy = 6;
        this.downButton = new JButton(new ArrowIcon(false));
        is = this.downButton.getMargin();
        is.left = 2;
        is.right = 2;
        this.downButton.setMargin(is);
        this.downButton.addActionListener(this);
        gridbag.setConstraints(this.downButton, gbc);
        buildpanel.add(this.downButton);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 9;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        Vector tablelist = null;
        try {
            tablelist = this.databaseInfo.getTableList(new String[]{"TABLE", "VIEW", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, this.tableNameFormat);
            if (this.databaseInfo.getAdditionalDbSize() > 0) {
                tablelist.addAll(this.databaseInfo.getAdditionalTableList(new String[]{"TABLE", "VIEW", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, this.tableNameFormat));
            }
        }
        catch (Exception e) {
            if (!this.silentMode) {
                throw e;
            }
            tablelist = new Vector();
        }
        this.allTables = new TableTreeNode[tablelist.size()];
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tables");
        for (int i = 0; i < tablelist.size(); ++i) {
            TableTreeNode node = new TableTreeNode(this.databaseInfo, (String)tablelist.elementAt(i));
            node.setMaster(true);
            this.allTables[i] = node;
        }
        this.tableTree = new JTree(root, true);
        this.tableTree.setRootVisible(false);
        this.tableTree.setShowsRootHandles(false);
        this.tableTree.setVisibleRowCount(14);
        this.tableTree.addMouseListener(this);
        this.tableTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                Object tableNode;
                if (event.getSource() == DataViewDialog.this.tableTree && (tableNode = event.getPath().getLastPathComponent()) instanceof TableTreeNode) {
                    try {
                        ((TableTreeNode)tableNode).generateColumns();
                    }
                    catch (Exception ex) {
                        new JMessageDialog((Dialog)DataViewDialog.this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve columns for this table.\n") + ex.toString());
                    }
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        FocusAdapter flistener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Component temptree = event.getComponent();
                if (temptree instanceof JTree && ((JTree)temptree).getSelectionPath() != null) {
                    DataViewDialog.this.setButtonState((DefaultMutableTreeNode)((JTree)temptree).getSelectionPath().getLastPathComponent());
                }
            }
        };
        TreeSelectionListener slistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                DataViewDialog.this.setButtonState(tn);
            }
        };
        this.tableTree.addFocusListener(flistener);
        this.tableTree.addTreeSelectionListener(slistener);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.tableTree);
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        gbc.gridx = 2;
        gbc.gridy = 2;
        root = new DefaultMutableTreeNode("View");
        root.add(new DefaultMutableTreeNode("View"));
        this.viewTree = new JTree(root, true);
        this.viewTree.setCellRenderer(new InternalCellRenderer());
        this.viewTree.setRootVisible(false);
        this.viewTree.setShowsRootHandles(false);
        this.viewTree.setVisibleRowCount(14);
        this.viewTree.addFocusListener(flistener);
        this.viewTree.addTreeSelectionListener(slistener);
        this.viewTree.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.viewTree);
        this.viewTree.setSelectionRow(0);
        this.viewTree.clearSelection();
        scroll = new JScrollPane();
        scroll.getViewport().add(this.viewTree);
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        p1.add("North", namePanel);
        p1.add("Center", buildpanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 2));
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new FlowLayout(0));
        this.chooseTableButton = new JButton(LanguageEncoder.getText("Choose Tables"));
        this.chooseTableButton.addActionListener(this);
        leftpanel.add(this.chooseTableButton);
        bottomPanel.add(leftpanel);
        bottomPanel.add(okpanel);
        this.formulaDialog = new FormulaBuilderDialog((JDialog)this, this.databaseInfo, "", new ColumnFieldWindow[0]);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Columns", p1);
        tabbedPane.addTab("Conditions", this.formulaDialog.getMainPanel());
        bpanel.add("Center", tabbedPane);
        bpanel.add("South", bottomPanel);
    }

    private void setPosition() {
        ((DefaultTreeModel)this.tableTree.getModel()).reload();
        this.expandAll(this.viewTree);
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (IOUtil.isMac()) {
            if (dim.getWidth() > screenSize.getWidth() * 2.0 / 3.0) {
                dim = new Dimension((int)(screenSize.getWidth() * 2.0 / 3.0), (int)dim.getHeight());
            }
            if (dim.getHeight() > screenSize.getWidth() * 4.0 / 5.0) {
                dim = new Dimension((int)screenSize.getWidth(), (int)(dim.getHeight() * 4.0 / 5.0));
            }
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private void setButtonState(DefaultMutableTreeNode tn) {
        this.addButton.setEnabled(this.isAddEnabled(tn));
        this.removeButton.setEnabled(this.isRemoveEnabled(tn));
        this.groupButton.setEnabled(this.isRemoveEnabled(tn));
        this.renameButton.setEnabled(this.isRenameEnabled(tn));
        this.buildButton.setEnabled(this.isBuildEnabled(tn));
        this.removeHeadingButton.setEnabled(this.isRemoveHeadingEnabled());
        this.descripButton.setEnabled(this.isDescriptionEnabled(tn));
        this.upButton.setEnabled(this.isUpEnabled());
        this.downButton.setEnabled(this.isUpEnabled());
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public String getName() {
        if (this.nameField.getText() == null) {
            return "";
        }
        String str = this.nameField.getText().trim();
        if (str.length() > 50) {
            str = str.substring(0, 50);
        }
        return str;
    }

    DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public void save(String file) throws Exception {
        if (file == null || file.trim().equals("")) {
            throw new IOException(LanguageEncoder.getText("Please specific a file name."));
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        this.save(fstream);
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        wdfile.output(fstream.toByteArray(), file);
    }

    public void save(OutputStream stream) throws Exception {
        int i;
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(10);
        out.writeInt(this.tableNameFormat);
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.tableTree.getModel().getRoot();
        out.writeInt(tableroot.getChildCount());
        for (int i2 = 0; i2 < tableroot.getChildCount(); ++i2) {
            IOUtil.writeString(out, ((TableTreeNode)tableroot.getChildAt(i2)).getTableName());
            IOUtil.writeString(out, ((TableTreeNode)tableroot.getChildAt(i2)).getAlias());
        }
        DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        int count = 0;
        for (i = 0; i < viewroot.getChildCount(); ++i) {
            count = count + ((DefaultMutableTreeNode)viewroot.getChildAt(i)).getChildCount() + 1;
        }
        out.writeInt(count);
        for (int k = 0; k < viewroot.getChildCount(); ++k) {
            DefaultMutableTreeNode header = (DefaultMutableTreeNode)viewroot.getChildAt(k);
            out.writeInt(0);
            IOUtil.writeString(out, (String)header.getUserObject());
            for (int i3 = 0; i3 < header.getChildCount(); ++i3) {
                out.writeInt(1);
                ColumnTreeNode columnnode = (ColumnTreeNode)header.getChildAt(i3);
                IOUtil.writeString(out, columnnode.getAlias());
                IOUtil.writeString(out, columnnode.getDescription());
                IOUtil.writeString(out, columnnode.getColumnName());
                out.writeBoolean(columnnode.isExpression());
                out.writeBoolean(columnnode.isDataViewExpression());
                TableTreeNode[] tablenodes = columnnode.getTableTreeNodes();
                out.writeInt(tablenodes.length);
                for (TableTreeNode tablenode : tablenodes) {
                    IOUtil.writeString(out, tablenode.getAlias());
                }
            }
        }
        out.writeInt(this.joinProperties.size());
        for (i = 0; i < this.joinProperties.size(); ++i) {
            JoinLine join = (JoinLine)this.joinProperties.elementAt(i);
            IOUtil.writeString(out, join.list1.getDisplayName());
            try {
                IOUtil.writeString(out, join.list1.getColumn(join.index1));
            }
            catch (Exception ex) {
                IOUtil.writeString(out, "");
            }
            IOUtil.writeString(out, join.list2.getDisplayName());
            try {
                IOUtil.writeString(out, join.list2.getColumn(join.index2));
            }
            catch (Exception ex) {
                IOUtil.writeString(out, "");
            }
            out.writeInt(join.property);
        }
        IOUtil.writeString(out, (String)((DefaultMutableTreeNode)viewroot.getFirstChild()).getUserObject());
        IOUtil.writeString(out, this.getFormula());
        out.flush();
    }

    private void load(String file) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        this.load(readfile.getInputStream(file));
        readfile.close();
    }

    private void load(DataInputStream in) throws Exception {
        int i;
        int version = in.readInt();
        if (version <= 7) {
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
        }
        if (version >= 5) {
            this.tableNameFormat = in.readInt();
        }
        this.init();
        if (version >= 6) {
            int count = in.readInt();
            for (int i2 = 0; i2 < count; ++i2) {
                String t = IOUtil.readString(in, true);
                String alias = IOUtil.readString(in, true);
                this.addTable(t, alias);
            }
        } else {
            in = this.loadTables(in, version);
        }
        DefaultMutableTreeNode currentHeading = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.viewTree.getModel().getRoot()).getFirstChild();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            int type = 1;
            if (version >= 1) {
                type = in.readInt();
            }
            if (type == 0) {
                String headingTitle = IOUtil.readString(in, true);
                if (i <= 0) continue;
                currentHeading = new DefaultMutableTreeNode(headingTitle);
                ((DefaultMutableTreeNode)this.viewTree.getModel().getRoot()).add(currentHeading);
                continue;
            }
            if (type != 1) continue;
            String alias = IOUtil.readString(in, true);
            String description = null;
            if (version >= 7) {
                description = IOUtil.readString(in, true);
            }
            String colname = IOUtil.readString(in, true);
            boolean isExp = in.readBoolean();
            boolean isDVExp = false;
            if (version >= 9) {
                isDVExp = in.readBoolean();
            }
            int pcount = in.readInt();
            TableTreeNode[] parents = new TableTreeNode[pcount];
            for (int j = 0; j < pcount; ++j) {
                parents[j] = this.getTableTreeNode(IOUtil.readString(in, true));
            }
            ColumnTreeNode colNode = this.addColumnNode(colname, parents, currentHeading);
            if (isDVExp) {
                colNode.setDataViewExpression(colname);
            } else if (isExp) {
                colNode.setExpression(colname);
            }
            colNode.setAlias(alias);
            colNode.setDescription(description);
        }
        count = in.readInt();
        this.joinProperties = new Vector();
        for (i = 0; i < count; ++i) {
            String columnname2;
            String tablename23;
            String columnname1;
            String tablename1;
            ColumnFieldWindow w1 = null;
            int index1 = 0;
            ColumnFieldWindow w2 = null;
            int index2 = 0;
            int type = 0;
            if (version <= 3) {
                tablename1 = IOUtil.readString(in, true);
                columnname1 = IOUtil.readString(in, true);
                tablename23 = IOUtil.readString(in, true);
                columnname2 = IOUtil.readString(in, true);
                try {
                    w1 = this.getTableTreeNode(tablename1).getWindow();
                    index1 = w1.getIndex(columnname1);
                    w2 = this.getTableTreeNode(tablename23).getWindow();
                    index2 = w2.getIndex(columnname2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String t = IOUtil.readString(in, true);
                type = t.equals(QueryBuilder.JOINPROPERTY[1]) ? 1 : (t.equals(QueryBuilder.JOINPROPERTY[2]) ? 2 : 0);
            } else if (version <= 9) {
                tablename1 = IOUtil.readString(in, true);
                index1 = in.readInt();
                String tablename22 = IOUtil.readString(in, true);
                index2 = in.readInt();
                try {
                    w1 = this.getTableTreeNode(tablename1).getWindow();
                    w2 = this.getTableTreeNode(tablename22).getWindow();
                }
                catch (Exception tablename23) {
                    // empty catch block
                }
                type = in.readInt();
            } else {
                tablename1 = IOUtil.readString(in, true);
                columnname1 = IOUtil.readString(in, true);
                tablename23 = IOUtil.readString(in, true);
                columnname2 = IOUtil.readString(in, true);
                try {
                    w1 = this.getTableTreeNode(tablename1).getWindow();
                    index1 = w1.getIndex(columnname1);
                    w2 = this.getTableTreeNode(tablename23).getWindow();
                    index2 = w2.getIndex(columnname2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                type = in.readInt();
            }
            if (index1 < 0 || index2 < 0) continue;
            DataViewDialog.addJoin(this.joinProperties, new JoinLine(w1, index1, w2, index2, type));
        }
        if (version >= 3) {
            ((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.viewTree.getModel().getRoot()).getFirstChild()).setUserObject(IOUtil.readString(in, true));
        }
        if (version >= 4) {
            String formula = IOUtil.readString(in, true);
            if (this.formulaDialog != null) {
                this.formulaDialog.setFormula(formula);
            }
        }
        ((DefaultTreeModel)this.tableTree.getModel()).reload();
        ((DefaultTreeModel)this.viewTree.getModel()).reload();
        this.expandAll(this.viewTree);
    }

    Vector loadJoinProperties(String file, TableTreeNode[] tablelist) throws Exception {
        int i;
        int count;
        DataInputStream in;
        int version;
        Vector newJoins = new Vector();
        ReadDataFile readfile = new ReadDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        if ((version = (in = readfile.getInputStream(file)).readInt()) < 10) {
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
            IOUtil.readString(in, true);
        }
        Hashtable<String, TableTreeNode> props = new Hashtable<String, TableTreeNode>();
        int nameformat = 0;
        if (version >= 5) {
            nameformat = in.readInt();
        }
        if (version >= 6) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                String tname = IOUtil.readString(in, true);
                String alias = IOUtil.readString(in, true);
                props.put(alias, this.getTableTreeNode(tname, nameformat, tablelist));
            }
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            int type = 1;
            if (version >= 1) {
                type = in.readInt();
            }
            if (type == 0) {
                IOUtil.readString(in, true);
                continue;
            }
            if (type != 1) continue;
            IOUtil.readString(in, true);
            if (version >= 7) {
                IOUtil.readString(in, true);
            }
            IOUtil.readString(in, true);
            in.readBoolean();
            if (version >= 10) {
                in.readBoolean();
            }
            int pcount = in.readInt();
            for (int j = 0; j < pcount; ++j) {
                IOUtil.readString(in, true);
            }
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            TableTreeNode node1 = null;
            TableTreeNode node2 = null;
            int index1 = 0;
            int index2 = 0;
            int type = 0;
            if (version <= 3) {
                String t;
                node1 = (TableTreeNode)props.get(IOUtil.readString(in, true));
                if (node1 != null) {
                    ColumnFieldWindow w1 = node1.getWindow();
                    index1 = w1.getIndex(IOUtil.readString(in, true));
                }
                if ((node2 = (TableTreeNode)props.get(IOUtil.readString(in, true))) != null) {
                    ColumnFieldWindow w2 = node2.getWindow();
                    index2 = w2.getIndex(IOUtil.readString(in, true));
                }
                type = (t = IOUtil.readString(in, true)).equals(QueryBuilder.JOINPROPERTY[1]) ? 1 : (t.equals(QueryBuilder.JOINPROPERTY[2]) ? 2 : 0);
            } else {
                node1 = (TableTreeNode)props.get(IOUtil.readString(in, true));
                ColumnFieldWindow window1 = null;
                if (node1 != null) {
                    window1 = node1.getWindow();
                }
                if (version >= 10) {
                    String tmp = IOUtil.readString(in, true);
                    if (window1 != null) {
                        index1 = window1.getIndex(tmp);
                    }
                } else {
                    index1 = in.readInt();
                }
                node2 = (TableTreeNode)props.get(IOUtil.readString(in, true));
                ColumnFieldWindow window2 = null;
                if (node2 != null) {
                    window2 = node2.getWindow();
                }
                if (version >= 10) {
                    String tmp = IOUtil.readString(in, true);
                    if (window2 != null) {
                        index2 = window2.getIndex(tmp);
                    }
                } else {
                    index2 = in.readInt();
                }
                type = in.readInt();
            }
            if (node1 == null || node2 == null) continue;
            Vector<Serializable> v = new Vector<Serializable>();
            v.addElement(node1);
            v.addElement(Integer.valueOf(index1));
            v.addElement(node2);
            v.addElement(Integer.valueOf(index2));
            v.addElement(Integer.valueOf(type));
            newJoins.addElement(v);
        }
        readfile.close();
        return newJoins;
    }

    private DataInputStream loadTables(DataInputStream in, int version) throws Exception {
        int i;
        if (version >= 6) {
            return in;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bstream);
        int count = in.readInt();
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            int type = 1;
            if (version >= 1) {
                type = in.readInt();
                out.writeInt(type);
            }
            if (type == 0) {
                IOUtil.writeString(out, IOUtil.readString(in, true));
                continue;
            }
            if (type != 1) continue;
            IOUtil.writeString(out, IOUtil.readString(in, true));
            IOUtil.writeString(out, IOUtil.readString(in, true));
            out.writeBoolean(in.readBoolean());
            int pcount = in.readInt();
            out.writeInt(pcount);
            for (int j = 0; j < pcount; ++j) {
                IOUtil.writeString(out, IOUtil.readString(in, true));
            }
        }
        count = in.readInt();
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            if (version <= 3) {
                IOUtil.writeString(out, IOUtil.readString(in, true));
                IOUtil.writeString(out, IOUtil.readString(in, true));
                IOUtil.writeString(out, IOUtil.readString(in, true));
                IOUtil.writeString(out, IOUtil.readString(in, true));
                IOUtil.writeString(out, IOUtil.readString(in, true));
                continue;
            }
            IOUtil.writeString(out, IOUtil.readString(in, true));
            out.writeInt(in.readInt());
            IOUtil.writeString(out, IOUtil.readString(in, true));
            out.writeInt(in.readInt());
            out.writeInt(in.readInt());
        }
        if (version >= 2) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                String t = IOUtil.readString(in, true);
                this.addTable(t, t);
            }
        } else {
            for (TableTreeNode allTable : this.allTables) {
                ((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()).add(allTable);
            }
        }
        if (version >= 3) {
            IOUtil.writeString(out, IOUtil.readString(in, true));
        }
        if (version >= 4) {
            IOUtil.writeString(out, IOUtil.readString(in, true));
        }
        out.flush();
        out.close();
        return new DataInputStream(new ByteArrayInputStream(bstream.toByteArray()));
    }

    private TableTreeNode getTableTreeNode(String alias) {
        TableTreeNode[] tables;
        for (TableTreeNode table : tables = this.getTables()) {
            if (!table.getAlias().equals(alias)) continue;
            return table;
        }
        return null;
    }

    private TableTreeNode getTableTreeNode(String tableName, int newformat, TableTreeNode[] tables) {
        if (tableName == null) {
            return null;
        }
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            String parent = "";
            String child = "c";
            if (newformat > this.tableNameFormat) {
                parent = tableName;
                child = tables[i].getTableName();
            } else {
                parent = tables[i].getTableName();
                child = tableName;
            }
            if (!parent.endsWith(child)) continue;
            TableTreeNode node = tables[i];
            tables[i] = null;
            return node;
        }
        for (TableTreeNode allTable : this.allTables) {
            String parent = "";
            String child = "c";
            if (newformat > this.tableNameFormat) {
                parent = tableName;
                child = allTable.getTableName();
            } else {
                parent = allTable.getTableName();
                child = tableName;
            }
            if (!parent.endsWith(child)) continue;
            return new TableTreeNode(allTable);
        }
        return null;
    }

    private boolean isAddEnabled(DefaultMutableTreeNode node) {
        if (node != null) {
            String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
            if (node instanceof TableTreeNode || rootname.equals("Tables")) {
                return true;
            }
        }
        return this.tableTree.getSelectionPath() != null;
    }

    private boolean isRemoveEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        TreePath[] paths = this.viewTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof ColumnTreeNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRenameEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
        return (node instanceof ColumnTreeNode || rootname.equals("View")) && this.viewTree.getSelectionCount() == 1;
    }

    private boolean isBuildEnabled(DefaultMutableTreeNode node) {
        return true;
    }

    private boolean isRemoveHeadingEnabled() {
        DefaultMutableTreeNode node;
        return this.viewTree.getSelectionCount() == 1 && (node = (DefaultMutableTreeNode)this.viewTree.getSelectionPath().getLastPathComponent()).getLevel() == 1 && !(node instanceof ColumnTreeNode) && node.getPreviousSibling() != null;
    }

    private boolean isDescriptionEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
        return node instanceof ColumnTreeNode && rootname.equals("View") && this.viewTree.getSelectionCount() == 1;
    }

    private boolean isUpEnabled() {
        TreePath[] paths = this.viewTree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            TreeNode parent = null;
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                if (i == 0) {
                    parent = leaf.getParent();
                    continue;
                }
                if (leaf.getParent() == parent) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void doAdd() {
        try {
            DefaultTreeModel viewModel = (DefaultTreeModel)this.viewTree.getModel();
            TreePath[] selected = this.tableTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Vector<DefaultMutableTreeNode> added = new Vector<DefaultMutableTreeNode>();
            DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
            for (TreePath element : selected) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)element.getLastPathComponent();
                if (node instanceof TableTreeNode) {
                    String[] columns;
                    String headingName_base;
                    if (viewroot.getChildCount() == 1 && viewroot.getChildAt(0).getChildCount() == 0) {
                        viewModel.removeNodeFromParent((MutableTreeNode)viewroot.getChildAt(0));
                    }
                    String headingName = headingName_base = (String)((TableTreeNode)node).getUserObject();
                    int count = 0;
                    while (this.headingExists(headingName)) {
                        headingName = headingName_base + "_" + count++;
                    }
                    DefaultMutableTreeNode heading = new DefaultMutableTreeNode(headingName);
                    int index = viewroot.getChildCount();
                    viewModel.insertNodeInto(heading, viewroot, index);
                    ColumnFieldWindow table = ((TableTreeNode)node).getWindow();
                    for (String column : columns = table.getColumns()) {
                        this.addColumnNode(column, new TableTreeNode[]{(TableTreeNode)node}, heading);
                    }
                    TreePath groupPath = new TreePath(new Object[]{heading.getParent(), heading});
                    this.viewTree.expandPath(groupPath);
                    added.addElement(node);
                    continue;
                }
                if (!(node.getParent() instanceof TableTreeNode) || added.contains(node.getParent())) continue;
                TreePath[] viewTreePath = this.viewTree.getSelectionPaths();
                if (viewTreePath == null || viewTreePath.length != 1) {
                    this.addColumnNode(node.getUserObject(), new TableTreeNode[]{(TableTreeNode)node.getParent()});
                    continue;
                }
                DefaultMutableTreeNode viewTreeNode = (DefaultMutableTreeNode)viewTreePath[0].getLastPathComponent();
                if (viewTreeNode.getParent() == this.viewTree.getModel().getRoot()) {
                    this.addColumnNode(node.getUserObject(), new TableTreeNode[]{(TableTreeNode)node.getParent()}, viewTreeNode);
                    continue;
                }
                this.addColumnNode(node.getUserObject(), new TableTreeNode[]{(TableTreeNode)node.getParent()});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ColumnTreeNode addColumnNode(Object name, TableTreeNode[] parentTable) {
        DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.viewTree.getModel().getRoot()).getFirstChild();
        return this.addColumnNode(name, parentTable, viewroot);
    }

    private ColumnTreeNode addColumnNode(Object name, TableTreeNode[] parentTable, DefaultMutableTreeNode viewroot) {
        ColumnTreeNode columnnode = new ColumnTreeNode(name, parentTable);
        String alias = (String)name;
        if (alias == null) {
            alias = "";
        }
        int ct = 0;
        while (this.aliasExists(alias)) {
            alias = name + "_" + ct++;
        }
        columnnode.setUserObject(alias);
        int index = viewroot.getChildCount();
        ((DefaultTreeModel)this.viewTree.getModel()).insertNodeInto(columnnode, viewroot, index);
        return columnnode;
    }

    private void doRemove() {
        try {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            for (TreePath element : selected) {
                Object node = element.getLastPathComponent();
                if (!(node instanceof ColumnTreeNode)) continue;
                ((DefaultTreeModel)this.viewTree.getModel()).removeNodeFromParent((ColumnTreeNode)node);
            }
            this.viewTree.clearSelection();
            this.setButtonState(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doRename() {
        try {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Object node = selected[0].getLastPathComponent();
            String rootname = (String)((DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getRoot()).getUserObject();
            if (node instanceof ColumnTreeNode || rootname.equals("View")) {
                boolean OK = false;
                boolean column = node instanceof ColumnTreeNode;
                JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:") + " ", 3, 2);
                String tmp = (String)((DefaultMutableTreeNode)node).getUserObject();
                optionPane.setInitialSelectionValue(tmp);
                while (!OK) {
                    optionPane.setWantsInput(true);
                    JDialog dialog = optionPane.createDialog(this, column ? LanguageEncoder.getText("New Column Name") : LanguageEncoder.getText("New Heading Name"));
                    dialog.setVisible(true);
                    dialog.dispose();
                    if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                        return;
                    }
                    tmp = (String)optionPane.getInputValue();
                    if (tmp != null && !tmp.trim().equals("")) {
                        boolean error = false;
                        tmp = tmp.trim();
                        if (column) {
                            if (this.aliasExists(tmp)) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Column name already exists:") + " " + tmp);
                                error = true;
                            }
                        } else if (this.headingExists(tmp)) {
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Heading name already exists:") + " " + tmp);
                            error = true;
                        }
                        if (error) continue;
                        ((DefaultMutableTreeNode)node).setUserObject(tmp);
                        ((DefaultTreeModel)this.viewTree.getModel()).reload((TreeNode)node);
                        OK = true;
                        continue;
                    }
                    OK = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doBuild() {
        Object root = this.tableTree.getModel().getRoot();
        int cnt = this.tableTree.getModel().getChildCount(root);
        Object[] tp = new Object[cnt];
        for (int i = 0; i < cnt; ++i) {
            tp[i] = this.tableTree.getModel().getChild(root, i);
        }
        Vector<TreeNode> added = new Vector<TreeNode>();
        Vector<ColumnFieldWindow> added1 = new Vector<ColumnFieldWindow>();
        if (tp != null && tp.length != 0) {
            for (Object element : tp) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)element;
                try {
                    if (node instanceof TableTreeNode) {
                        added.addElement(node);
                        added1.addElement(((TableTreeNode)node).getWindow());
                        continue;
                    }
                    if (!(node.getParent() instanceof TableTreeNode) || added.contains(node.getParent())) continue;
                    added.addElement(node.getParent());
                    added1.addElement(((TableTreeNode)node.getParent()).getWindow());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        TableTreeNode[] selectedTables = added.toArray(new TableTreeNode[0]);
        ColumnFieldWindow[] selectedWindows = added1.toArray(new ColumnFieldWindow[0]);
        FormulaBuilderDialog builder = new FormulaBuilderDialog((JDialog)this, this.databaseInfo, "", selectedWindows);
        builder.setVisible(true);
        String formula = null;
        if (builder.isModified()) {
            formula = builder.getFormula();
        }
        if (formula != null && !formula.trim().equals("")) {
            String alias = "Expression";
            ColumnTreeNode columnNode = this.addColumnNode(formula, selectedTables);
            columnNode.setExpression(formula);
            int ct = 0;
            while (this.aliasExists(alias)) {
                alias = "Expression_" + ct++;
            }
            columnNode.setUserObject(alias);
        }
    }

    private void doRebuild() {
        TableTreeNode[] parents;
        TreePath[] selected = this.viewTree.getSelectionPaths();
        if (selected == null || selected.length == 0) {
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)selected[0].getLastPathComponent();
        ColumnTreeNode node = null;
        if (!(n instanceof ColumnTreeNode)) {
            return;
        }
        node = (ColumnTreeNode)n;
        Vector<ColumnFieldWindow> added1 = new Vector<ColumnFieldWindow>();
        for (TableTreeNode parent2 : parents = node.getTableTreeNodes()) {
            try {
                added1.addElement(parent2.getWindow());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ColumnFieldWindow[] selectedWindows = added1.toArray(new ColumnFieldWindow[0]);
        FormulaBuilderDialog builder = new FormulaBuilderDialog((JDialog)this, this.databaseInfo, node.getColumnName(), selectedWindows);
        builder.setVisible(true);
        String formula = null;
        if (builder.isModified()) {
            formula = builder.getFormula();
            node.setExpression(formula);
        }
    }

    private void doAddHeading() {
        try {
            String tmp;
            if (this.viewTree.getSelectionCount() <= 0) {
                this.viewTree.setSelectionRow(0);
            }
            if ((tmp = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Enter Group Name:"), LanguageEncoder.getText("New Group Name"), 3)) != null && !tmp.trim().equals("")) {
                DefaultMutableTreeNode[] headings;
                tmp = tmp.trim();
                for (DefaultMutableTreeNode heading : headings = this.getHeadings()) {
                    if (!tmp.equals(heading.getUserObject())) continue;
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Group name already exists:") + " " + tmp);
                    return;
                }
                DefaultMutableTreeNode heading = new DefaultMutableTreeNode(tmp);
                int parentIndex = this.getHeadings().length;
                if (this.viewTree.getSelectionCount() > 0) {
                    DefaultMutableTreeNode parent;
                    Object firstNode = this.viewTree.getSelectionPath().getLastPathComponent();
                    if (firstNode instanceof ColumnTreeNode) {
                        parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)firstNode).getParent();
                        parentIndex = ((DefaultMutableTreeNode)parent.getParent()).getIndex(parent) + 1;
                        int childIndex = parent.getIndex((ColumnTreeNode)firstNode);
                        for (int i = parent.getChildCount() - 1; i >= childIndex; --i) {
                            heading.insert((DefaultMutableTreeNode)parent.getChildAt(i), 0);
                        }
                    } else if (firstNode instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)firstNode).getLevel() != 0 && !firstNode.equals(((DefaultMutableTreeNode)this.viewTree.getModel().getRoot()).getFirstChild())) {
                        parent = (DefaultMutableTreeNode)firstNode;
                        parentIndex = ((DefaultMutableTreeNode)parent.getParent()).getIndex(parent);
                    }
                }
                DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
                ((DefaultTreeModel)this.viewTree.getModel()).insertNodeInto(heading, viewroot, parentIndex);
                TreePath groupPath = new TreePath(new Object[]{heading.getParent(), heading});
                this.viewTree.expandPath(groupPath);
                this.removeHeadingButton.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doGroupFields() {
        TreePath[] paths;
        Object[] headings = this.getHeadings();
        DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Group selected fields under:") + " ", LanguageEncoder.getText("Group Fields"), 3, null, headings, headings[0]);
        if (tmp != null && (paths = this.viewTree.getSelectionPaths()) != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(leaf instanceof ColumnTreeNode) || leaf.getParent() == tmp) continue;
                ((DefaultTreeModel)this.viewTree.getModel()).removeNodeFromParent(leaf);
                tmp.add(leaf);
            }
            TreePath groupPath = new TreePath(new Object[]{tmp.getParent(), tmp});
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)groupPath.getLastPathComponent();
            ((DefaultTreeModel)this.viewTree.getModel()).reload(node);
            this.viewTree.expandPath(groupPath);
        }
    }

    private void doRemoveHeading() {
        DefaultMutableTreeNode[] headings = this.getHeadings();
        if (headings.length < 2) {
            return;
        }
        if (this.viewTree.getSelectionCount() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.viewTree.getSelectionPath().getLastPathComponent();
            DefaultMutableTreeNode sibling = node.getPreviousSibling();
            if (node.getLevel() == 1 && !(node instanceof ColumnTreeNode) && sibling != null) {
                int viewSize = sibling.getChildCount();
                for (int i = node.getChildCount() - 1; i >= 0; --i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    if (!(child instanceof ColumnTreeNode)) continue;
                    child.removeFromParent();
                    sibling.insert(child, viewSize);
                }
                node.removeFromParent();
                ((DefaultTreeModel)this.viewTree.getModel()).reload();
                this.expandAll(this.viewTree);
                if (headings.length <= 2) {
                    this.removeHeadingButton.setEnabled(false);
                }
            }
        }
    }

    private void doMove(int moveWhere) {
        if (!this.isUpEnabled() || Math.abs(moveWhere) > 1) {
            return;
        }
        try {
            DefaultTreeModel viewModel = (DefaultTreeModel)this.viewTree.getModel();
            TreePath[] paths = this.viewTree.getSelectionPaths();
            if (paths.length == 0) {
                return;
            }
            Vector<DefaultMutableTreeNode> nodes = this.getSortedNodesFromPaths(paths);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nodes.get(0).getParent();
            int count = 0;
            if (moveWhere > 0) {
                for (int j = nodes.size() - 1; j >= 0; --j) {
                    DefaultMutableTreeNode movedNode = nodes.get(j);
                    int i = parent.getIndex(movedNode);
                    if (i == -1 || i >= parent.getChildCount() - 1 - count) {
                        ++count;
                        continue;
                    }
                    viewModel.removeNodeFromParent(movedNode);
                    viewModel.insertNodeInto(movedNode, parent, i + moveWhere);
                }
            } else {
                for (int j = 0; j < nodes.size(); ++j) {
                    DefaultMutableTreeNode movedNode = nodes.get(j);
                    int i = parent.getIndex(movedNode);
                    if (i == -1 || i <= count) {
                        ++count;
                        continue;
                    }
                    viewModel.removeNodeFromParent(movedNode);
                    viewModel.insertNodeInto(movedNode, parent, i + moveWhere);
                }
            }
            this.viewTree.setSelectionPaths(paths);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Vector<DefaultMutableTreeNode> getSortedNodesFromPaths(TreePath[] paths) {
        int[] indexes = new int[paths.length];
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)paths[0].getPathComponent(paths[0].getPathCount() - 2);
        for (int i = 0; i < paths.length; ++i) {
            indexes[i] = parent.getIndex((DefaultMutableTreeNode)paths[i].getLastPathComponent());
        }
        Arrays.sort(indexes);
        Vector<DefaultMutableTreeNode> tempNodes = new Vector<DefaultMutableTreeNode>();
        for (int i : indexes) {
            tempNodes.add((DefaultMutableTreeNode)parent.getChildAt(i));
        }
        return tempNodes;
    }

    private void doChooseTable() {
        try {
            int i;
            Vector old_joinProperties = new Vector();
            for (i = 0; i < this.joinProperties.size(); ++i) {
                old_joinProperties.addElement(this.joinProperties.elementAt(i));
            }
            if (this.tableSelectionDialog == null) {
                this.tableSelectionDialog = new DataViewTableSelectionDialog(this, this.doAutoJoin);
            }
            this.tableSelectionDialog.setModified(false);
            this.tableSelectionDialog.setVisible(true);
            if (this.tableSelectionDialog.isModified()) {
                ColumnTreeNode[] old_columns;
                TableTreeNode[] tables;
                Vector<TableTreeNode> windows = new Vector<TableTreeNode>();
                ((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()).removeAllChildren();
                for (TableTreeNode table : tables = this.tableSelectionDialog.getTables()) {
                    this.addTable(table);
                    windows.addElement(table);
                }
                ((DefaultTreeModel)this.tableTree.getModel()).reload();
                for (ColumnTreeNode old_column : old_columns = this.getColumnNodes()) {
                    TableTreeNode[] dependents = old_column.getTableTreeNodes();
                    for (int j = 0; j < dependents.length; ++j) {
                        if (!windows.contains(dependents[j])) {
                            old_column.removeFromParent();
                            j = dependents.length;
                            continue;
                        }
                        dependents[j] = (TableTreeNode)windows.elementAt(windows.indexOf(dependents[j]));
                    }
                }
                ((DefaultTreeModel)this.viewTree.getModel()).reload();
                if (this.formulaDialog != null) {
                    this.formulaDialog.updateTables(this.getColumnFieldWindows());
                }
            } else {
                this.tableSelectionDialog = null;
                this.joinProperties.removeAllElements();
                for (i = 0; i < old_joinProperties.size(); ++i) {
                    this.joinProperties.addElement(old_joinProperties.elementAt(i));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to open table selection window.\n") + ex.toString());
        }
    }

    private boolean aliasExists(String alias) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            DefaultMutableTreeNode header = (DefaultMutableTreeNode)root.getChildAt(j);
            for (int i = 0; i < header.getChildCount(); ++i) {
                DefaultMutableTreeNode column = (DefaultMutableTreeNode)header.getChildAt(i);
                if (column.getUserObject() == null || !column.getUserObject().toString().equals(alias)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean headingExists(String heading) {
        DefaultMutableTreeNode[] existing;
        for (DefaultMutableTreeNode element : existing = this.getHeadings()) {
            if (!element.getUserObject().equals(heading)) continue;
            return true;
        }
        return false;
    }

    private String[][] getColumns() {
        ColumnTreeNode[] nodes = this.getColumnNodes();
        String[][] columns = new String[nodes.length][3];
        for (int j = 0; j < nodes.length; ++j) {
            TableTreeNode[] parents;
            columns[j][0] = (String)nodes[j].getUserObject();
            columns[j][1] = nodes[j].getColumnName();
            columns[j][2] = nodes[j].isExpression() ? null : ((parents = nodes[j].getTableTreeNodes())[0] == null ? nodes[j].getParent().toString() : parents[0].getAlias());
        }
        return columns;
    }

    private ColumnTreeNode[] getColumnNodes() {
        int count = 0;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            count += ((DefaultMutableTreeNode)root.getChildAt(i)).getChildCount();
        }
        ColumnTreeNode[] columns = new ColumnTreeNode[count];
        count = 0;
        for (int j = 0; j < root.getChildCount(); ++j) {
            DefaultMutableTreeNode header = (DefaultMutableTreeNode)root.getChildAt(j);
            for (int i = 0; i < header.getChildCount(); ++i) {
                columns[count] = (ColumnTreeNode)header.getChildAt(i);
                ++count;
            }
        }
        return columns;
    }

    public ColumnFieldWindow[] getColumnFieldWindows() {
        TableTreeNode[] tables = this.getTables();
        Vector<ColumnFieldWindow> windows = new Vector<ColumnFieldWindow>();
        for (TableTreeNode table : tables) {
            try {
                ColumnFieldWindow w = table.getWindow();
                windows.addElement(w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return windows.toArray(new ColumnFieldWindow[0]);
    }

    public String[][] getJoinProperties() {
        String[][] jp = new String[this.joinProperties.size()][5];
        for (int i = 0; i < this.joinProperties.size(); ++i) {
            JoinLine join = (JoinLine)this.joinProperties.elementAt(i);
            jp[i] = join.getValues();
        }
        return jp;
    }

    public JTable getQBETable() {
        String[][] cols = this.getColumns();
        JTable t = new JTable(10, cols.length);
        Object[][] data = new Object[10][cols.length];
        Object[] header = new String[cols.length];
        for (int j = 0; j < cols.length; ++j) {
            header[j] = cols[j][0];
            data[1][j] = cols[j][1];
            data[0][j] = cols[j][2] != null ? cols[j][2] : "Expression";
            data[4][j] = Boolean.TRUE;
            data[2][j] = null;
            data[3][j] = null;
            data[5][j] = null;
            data[6][j] = null;
            data[7][j] = null;
            data[8][j] = null;
            data[9][j] = null;
        }
        ((DefaultTableModel)t.getModel()).setDataVector(data, header);
        return t;
    }

    private void doDescription(ColumnTreeNode cNode) {
        if (cNode == null) {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Object node = selected[selected.length - 1].getLastPathComponent();
            if (node instanceof ColumnTreeNode) {
                cNode = (ColumnTreeNode)node;
            } else {
                return;
            }
        }
        ColumnDescriptionDialog dDialog = new ColumnDescriptionDialog(this, cNode.getAlias(), cNode.getDescription(), true);
        dDialog.setVisible(true);
        if (dDialog.isModified()) {
            cNode.setDescription(dDialog.getDescription());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.tableSelectionDialog = null;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.addButton) {
            this.doAdd();
        } else if (e.getSource() == this.removeButton) {
            this.doRemove();
        } else if (e.getSource() == this.renameButton) {
            this.doRename();
        } else if (e.getSource() == this.chooseTableButton) {
            this.doChooseTable();
        } else if (e.getSource() == this.buildButton) {
            this.doBuild();
        } else if (e.getSource() == this.addHeadingButton) {
            this.doAddHeading();
        } else if (e.getSource() == this.removeHeadingButton) {
            this.doRemoveHeading();
        } else if (e.getSource() == this.groupButton) {
            this.doGroupFields();
        } else if (e.getSource() == this.descripButton) {
            this.doDescription(null);
        } else if (e.getSource() == this.upButton) {
            this.doMove(-1);
        } else if (e.getSource() == this.downButton) {
            this.doMove(1);
        } else if (e.getSource() == this.okButton) {
            this.nameField.setText(this.getName());
            String name = this.nameField.getText();
            if (name == null || name.trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please enter a name for this data view."));
                return;
            }
            if (this.siblings != null && this.siblings.length != 0) {
                for (DataViewNode sibling : this.siblings) {
                    if (!name.trim().equals(sibling.getUserObject().toString().trim())) continue;
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("A data view named '") + name.trim() + LanguageEncoder.getText("' already exists. Please choose another name."));
                    return;
                }
            }
            try {
                String[][] columns = this.getColumns();
                if (columns.length <= 0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please add one or more columns to this data view."));
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String excep = "";
                try {
                    excep = QbUtil.replace(ex.toString(), "Exception: ", "Excepion:\n");
                    excep = "\n" + excep;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An unexpected error has occured.\nThis data view cannot be saved, and it will be closed immediately.") + excep);
                this.setVisible(false);
                this.dispose();
                return;
            }
            this.setVisible(false);
            this.dispose();
            this.modified = true;
        }
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    private DefaultMutableTreeNode[] getHeadings() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        DefaultMutableTreeNode[] ret = new DefaultMutableTreeNode[root.getChildCount()];
        for (int i = 0; i < root.getChildCount(); ++i) {
            ret[i] = (DefaultMutableTreeNode)root.getChildAt(i);
        }
        return ret;
    }

    public TableTreeNode[] getTables() {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.tableTree.getModel().getRoot();
        TableTreeNode[] ret = new TableTreeNode[tableroot.getChildCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (TableTreeNode)tableroot.getChildAt(i);
        }
        return ret;
    }

    private void addTable(String tablename, String alias) {
        for (TableTreeNode allTable : this.allTables) {
            if (!allTable.getTableName().equalsIgnoreCase(tablename)) continue;
            try {
                allTable.generateColumns();
            }
            catch (Exception exception) {
                // empty catch block
            }
            TableTreeNode tnode = new TableTreeNode(allTable);
            tnode.setAlias(alias);
            ((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()).add(tnode);
        }
    }

    private void addTable(TableTreeNode node) {
        ((DefaultMutableTreeNode)this.tableTree.getModel().getRoot()).add(new TableTreeNode(node));
    }

    public JTree getViewTree() {
        return new JTree(this.viewTree.getModel());
    }

    TableTreeNode[] getAllTables() {
        return this.allTables;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        DefaultMutableTreeNode node;
        TreePath selPath;
        if (e.getSource() == this.tableTree) {
            TreePath selPath2 = this.tableTree.getPathForLocation(e.getX(), e.getY());
            if (selPath2 != null) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)selPath2.getLastPathComponent();
                String rootname = (String)((DefaultMutableTreeNode)node2.getRoot()).getUserObject();
                if (!(node2 instanceof TableTreeNode) && rootname.equals("Tables") && e.getClickCount() == 2) {
                    this.doAdd();
                }
            }
        } else if (e.getSource() == this.viewTree && (selPath = this.viewTree.getPathForLocation(e.getX(), e.getY())) != null && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()) instanceof ColumnTreeNode && e.getClickCount() == 2) {
            this.doDescription((ColumnTreeNode)node);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    Vector getJoinsVector() {
        return this.joinProperties;
    }

    String getFormula() {
        String formula = "";
        if (this.formulaDialog != null) {
            formula = this.formulaDialog.getUnformattedFormula();
        }
        return formula;
    }

    int getTableNameFormat() {
        return this.tableNameFormat;
    }

    void setTableNameFormat(int format) throws Exception {
        int newformat = 0;
        if (format == 1 || format == 2) {
            newformat = format;
        }
        if (newformat != this.tableNameFormat) {
            Vector tablelist = this.databaseInfo.getTableList(new String[]{"TABLE", "VIEW", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, newformat);
            if (this.allTables != null) {
                int i;
                Vector<TableTreeNode> existing = new Vector<TableTreeNode>();
                for (TableTreeNode allTable : this.allTables) {
                    existing.addElement(allTable);
                }
                Vector<TableTreeNode> newTables = new Vector<TableTreeNode>();
                for (i = 0; i < tablelist.size(); ++i) {
                    if (tablelist.elementAt(i) == null) continue;
                    int j = 0;
                    for (j = 0; j < existing.size(); ++j) {
                        TableTreeNode treenode = (TableTreeNode)existing.elementAt(j);
                        if (treenode == null || treenode.getTableName() == null) continue;
                        String parent = "";
                        String child = "c";
                        if (newformat > this.tableNameFormat) {
                            parent = tablelist.elementAt(i).toString();
                            child = treenode.getTableName();
                        } else {
                            parent = treenode.getTableName();
                            child = tablelist.elementAt(i).toString();
                        }
                        if (!parent.endsWith(child)) continue;
                        treenode.setTableName(tablelist.elementAt(i).toString());
                        treenode.setAlias(tablelist.elementAt(i).toString());
                        newTables.addElement(treenode);
                        existing.removeElementAt(j);
                        j = existing.size() + 1;
                    }
                    if (j != existing.size()) continue;
                    newTables.addElement(new TableTreeNode(this.databaseInfo, (String)tablelist.elementAt(i)));
                }
                if (newTables.size() != this.allTables.length) {
                    this.allTables = new TableTreeNode[newTables.size()];
                }
                for (i = 0; i < this.allTables.length; ++i) {
                    this.allTables[i] = (TableTreeNode)newTables.elementAt(i);
                }
                if (this.tableTree != null) {
                    ((DefaultTreeModel)this.tableTree.getModel()).reload();
                }
            } else {
                this.allTables = new TableTreeNode[tablelist.size()];
                for (int i = 0; i < tablelist.size(); ++i) {
                    TableTreeNode node;
                    this.allTables[i] = node = new TableTreeNode(this.databaseInfo, (String)tablelist.elementAt(i));
                }
            }
            this.tableNameFormat = newformat;
        }
    }

    public static void addJoin(Vector existing, JoinLine newJoin) {
        if (existing == null) {
            return;
        }
        if (newJoin.index1 < 1 || newJoin.index1 > newJoin.list1.getColumns().length) {
            return;
        }
        if (newJoin.index2 < 1 || newJoin.index2 > newJoin.list2.getColumns().length) {
            return;
        }
        for (int i = 0; i < existing.size(); ++i) {
            if (!(existing.elementAt(i) instanceof JoinLine)) continue;
            JoinLine old = (JoinLine)existing.elementAt(i);
            if ((old.list1 != newJoin.list1 || old.list2 != newJoin.list2 || old.index1 != newJoin.index1 || old.index2 != newJoin.index2) && (old.list1 != newJoin.list2 || old.list2 != newJoin.list1 || old.index1 != newJoin.index2 || old.index2 != newJoin.index1)) continue;
            old.list1 = newJoin.list1;
            old.list2 = newJoin.list2;
            old.index1 = newJoin.index1;
            old.index2 = newJoin.index2;
            old.property = newJoin.property;
            return;
        }
        existing.addElement(newJoin);
    }

    public void setSiblingNodes(DataViewNode[] s) {
        this.siblings = s;
    }

    public DataViewNode[] getSiblingNodes() {
        return this.siblings;
    }

    public void replaceColumnNames(String[] oldColNames, String[] newColNames) {
        try {
            DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
            for (int i = 0; i < viewroot.getChildCount(); ++i) {
                TreeNode tableTreeNode = viewroot.getChildAt(i);
                for (int j = 0; j < tableTreeNode.getChildCount(); ++j) {
                    ColumnTreeNode columnTreeNode = (ColumnTreeNode)tableTreeNode.getChildAt(j);
                    String columnName = columnTreeNode.getColumnName();
                    for (int k = 0; k < oldColNames.length; ++k) {
                        if (oldColNames[k].indexOf(46) < 0) {
                            if (columnName.equals(oldColNames[k])) {
                                columnTreeNode.setColumnName(newColNames[k]);
                                continue;
                            }
                            if (!columnTreeNode.isExpression() || columnName.indexOf(oldColNames[k]) < 0) continue;
                            columnTreeNode.setColumnName(QbUtil.replace(columnName, oldColNames[k], newColNames[k]));
                            continue;
                        }
                        if (oldColNames[k].equals(columnTreeNode.getTableTreeNodes()[0].getTableName() + "." + columnTreeNode.getColumnName())) {
                            columnTreeNode.setColumnName(newColNames[k].substring(newColNames[k].indexOf(46) + 1));
                            continue;
                        }
                        if (!columnTreeNode.isExpression() || columnName.indexOf(oldColNames[k]) < 0) continue;
                        columnTreeNode.setColumnName(QbUtil.replace(columnName, oldColNames[k], newColNames[k]));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void replaceViewColumnNames(String[] oldAlias, String[] newAlias) {
        try {
            DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
            for (int i = 0; i < viewroot.getChildCount(); ++i) {
                DefaultMutableTreeNode tableTreeNode = (DefaultMutableTreeNode)viewroot.getChildAt(i);
                for (int j = 0; j < tableTreeNode.getChildCount(); ++j) {
                    ColumnTreeNode columnTreeNode = (ColumnTreeNode)tableTreeNode.getChildAt(j);
                    String columnAlias = columnTreeNode.getAlias();
                    for (int k = 0; k < oldAlias.length; ++k) {
                        if (oldAlias[k].indexOf(46) < 0) {
                            if (!columnAlias.equals(oldAlias[k])) continue;
                            columnTreeNode.setAlias(newAlias[k]);
                            continue;
                        }
                        if (!oldAlias[k].equals(tableTreeNode.getUserObject() + "." + columnTreeNode.getAlias())) continue;
                        columnTreeNode.setAlias(newAlias[k].substring(newAlias[k].indexOf(46) + 1));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ArrowIcon
    implements Icon {
        private boolean up;

        public ArrowIcon(boolean s) {
            this.up = s;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            if (this.up) {
                g.fillPolygon(new int[]{x + 2, x + 14, x + 8}, new int[]{y + 14, y + 14, y + 2}, 3);
            } else {
                g.fillPolygon(new int[]{x + 2, x + 14, x + 8}, new int[]{y + 2, y + 2, y + 13}, 3);
            }
        }
    }

    private class InternalCellRenderer
    extends DefaultTreeCellRenderer {
        private InternalCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            block5: {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof ColumnTreeNode) {
                    try {
                        ColumnTreeNode columnNode = (ColumnTreeNode)value;
                        if (columnNode.isExpression()) {
                            this.setToolTipText(columnNode.getUserObject().toString());
                            break block5;
                        }
                        TableTreeNode[] tables = columnNode.getTableTreeNodes();
                        this.setToolTipText(tables[0].getAlias() + "." + columnNode.getColumnName());
                    }
                    catch (Exception exception) {}
                } else {
                    this.setToolTipText(null);
                }
            }
            return this;
        }
    }
}

