/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ColumnTreeNode;

public class DataViewMappingDialog
extends JDialog
implements ActionListener {
    private String[][] selectedColumns = null;
    private String[][] choiceColumns = null;
    private JComboBox[] choiceList = null;
    private boolean modified = false;
    private boolean cancelAll = false;

    public DataViewMappingDialog(JDialog owner, String queryName, JTree oldtree, ColumnTreeNode[] sColumn, JTree newtree) {
        super((Dialog)owner, true);
        Vector<String[]> sc = new Vector<String[]>();
        for (int i = 0; i < sColumn.length; ++i) {
            if (!sColumn[i].isDataViewExpression()) {
                String[] n = new String[]{(String)((DefaultMutableTreeNode)sColumn[i].getParent()).getUserObject(), sColumn[i].getAlias()};
                if (this.containsAlias(n, sc)) continue;
                sc.add(n);
                continue;
            }
            String formula = sColumn[i].getColumnName();
            String[][] referencedColumns = this.getColumns(formula, oldtree);
            if (referencedColumns == null) continue;
            for (int j = 0; j < referencedColumns.length; ++j) {
                if (this.containsAlias(referencedColumns[j], sc)) continue;
                sc.add(referencedColumns[j]);
            }
        }
        this.selectedColumns = (String[][])sc.toArray((T[])new String[0][]);
        this.init(queryName, newtree);
        this.setPosition();
    }

    private void init(String queryName, JTree newTree) {
        int j;
        int i;
        this.setTitle(LanguageEncoder.getText("Map to New Dataview Configuration..."));
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Field Mapping")));
        mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(1));
        topPanel.add(new JLabel(LanguageEncoder.getText("Dataview Query Name:")));
        JTextField textfield = new JTextField(queryName, 20);
        textfield.setEditable(false);
        topPanel.add(textfield);
        mainPanel.add((Component)topPanel, "North");
        JPanel mapPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mapPanel.setLayout(gbl);
        Vector<String> newChoices = new Vector<String>();
        newChoices.add("-- NONE --");
        Vector<String[]> sc = new Vector<String[]>();
        sc.add(new String[]{null, null});
        TreeNode newroot = (TreeNode)newTree.getModel().getRoot();
        for (i = 0; i < newroot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)newroot.getChildAt(i);
            for (j = 0; j < child.getChildCount(); ++j) {
                if (!(child.getChildAt(j) instanceof ColumnTreeNode)) continue;
                newChoices.add(((ColumnTreeNode)child.getChildAt(j)).getAlias());
                sc.add(new String[]{(String)child.getUserObject(), ((ColumnTreeNode)child.getChildAt(j)).getAlias()});
            }
        }
        this.choiceColumns = (String[][])sc.toArray((T[])new String[0][]);
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.choiceList = new JComboBox[this.selectedColumns.length];
        for (i = 0; i < this.selectedColumns.length; ++i) {
            gbc.gridx = 0;
            JLabel comp = new JLabel(this.selectedColumns[i][1]);
            gbl.setConstraints(comp, gbc);
            mapPanel.add(comp);
            gbc.gridx = 1;
            this.choiceList[i] = new JComboBox(newChoices);
            for (j = 0; j < newChoices.size(); ++j) {
                if (!newChoices.elementAt(j).equals(this.selectedColumns[i][1])) continue;
                this.choiceList[i].setSelectedIndex(j);
                j = newChoices.size();
            }
            gbl.setConstraints(this.choiceList[i], gbc);
            mapPanel.add(this.choiceList[i]);
        }
        mainPanel.add((Component)new JScrollPane(mapPanel), "Center");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        JButton but = new JButton(LanguageEncoder.getText("Apply"));
        but.setActionCommand("Apply");
        but.addActionListener(this);
        bottomPanel.add(but);
        but = new JButton(LanguageEncoder.getText("Skip"));
        but.setActionCommand("Skip");
        but.addActionListener(this);
        bottomPanel.add(but);
        but = new JButton(LanguageEncoder.getText("Cancel"));
        but.setActionCommand("Cancel");
        but.addActionListener(this);
        bottomPanel.add(but);
        contentPane.add((Component)bottomPanel, "South");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Apply".equals(command)) {
            Vector<Integer> indices = new Vector<Integer>();
            for (int i = 0; i < this.choiceList.length; ++i) {
                int selected = this.choiceList[i].getSelectedIndex();
                if (selected > 0 && indices.contains(selected)) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Each column must have a unique mapping.\n") + "'" + this.selectedColumns[indices.indexOf(selected)][1] + "' and '" + this.selectedColumns[i][1] + "' are mapped to the same column.");
                    return;
                }
                indices.add(selected);
            }
            this.modified = true;
        } else if ("Cancel".equals(command)) {
            this.cancelAll = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public String[][] getMapping() {
        String[][] mapping = new String[this.selectedColumns.length][4];
        for (int i = 0; i < this.selectedColumns.length; ++i) {
            mapping[i][0] = this.selectedColumns[i][0];
            mapping[i][1] = this.selectedColumns[i][1];
            mapping[i][2] = this.choiceColumns[this.choiceList[i].getSelectedIndex()][0];
            mapping[i][3] = this.choiceColumns[this.choiceList[i].getSelectedIndex()][1];
        }
        return mapping;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isCancelled() {
        return this.cancelAll;
    }

    private String[][] getColumns(String formula, JTree tree) {
        if (formula == null && tree == null) {
            return null;
        }
        Vector<String[]> ret = new Vector<String[]>();
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode header = (DefaultMutableTreeNode)root.getChildAt(i);
            for (int j = 0; j < header.getChildCount(); ++j) {
                TreeNode c = header.getChildAt(j);
                if (!(c instanceof ColumnTreeNode) || formula.indexOf("{" + (String)header.getUserObject() + "." + ((ColumnTreeNode)c).getAlias() + "}") < 0) continue;
                ret.addElement(new String[]{(String)header.getUserObject(), ((ColumnTreeNode)c).getAlias()});
            }
        }
        return (String[][])ret.toArray((T[])new String[0][]);
    }

    public boolean isMappingSufficient(String[][] mapping) {
        boolean ok = true;
        if (mapping != null) {
            for (int i = 0; i < this.selectedColumns.length; ++i) {
                int j = 0;
                for (j = 0; j < mapping.length; ++j) {
                    if (!mapping[j][1].equals(this.selectedColumns[i][1])) continue;
                    this.choiceList[i].setSelectedItem(mapping[j][3]);
                    j = mapping.length + 1;
                }
                if (j != mapping.length) continue;
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean containsAlias(String[] alias, Vector existing) {
        for (int i = 0; i < existing.size(); ++i) {
            String[] exist = (String[])existing.elementAt(i);
            if (!exist[1].equals(alias[1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.modified = false;
        }
        super.setVisible(state);
    }
}

