/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.ConditionColumnSelectionDialog;
import quadbase.querybuilder.designer.DataViewDiagram;
import quadbase.querybuilder.designer.DataViewDialog;
import quadbase.querybuilder.designer.JoinLine;
import quadbase.querybuilder.designer.QualifiedNameDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.query.DatabaseInfo;

public class DataViewTableSelectionDialog
extends JDialog
implements ActionListener,
MouseListener,
ItemListener {
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton nameFormatButton;
    private JCheckBox autoJoinBox;
    private boolean doAutoJoin = true;
    private JButton importButton;
    private JButton aliasButton;
    private JTree tableTree;
    private JTree viewTree;
    private DataViewDialog dataViewDialog;
    private boolean modified = false;
    private DataViewDiagram diagram;

    public DataViewTableSelectionDialog(DataViewDialog dialog, boolean autojoin) throws Exception {
        super((Dialog)dialog, true);
        this.doAutoJoin = autojoin;
        this.dataViewDialog = dialog;
        this.init();
        this.setPosition();
    }

    private void init() {
        TableTreeNode[] tables;
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Choose Tables"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel buildpanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buildpanel.setLayout(gridbag);
        buildpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Table Selection")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 10;
        gbc.fill = 1;
        JLabel comp = new JLabel(LanguageEncoder.getText("Available Tables and Views"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 2;
        gbc.gridy = 0;
        comp = new JLabel(LanguageEncoder.getText("Selected Tables"));
        gridbag.setConstraints(comp, gbc);
        buildpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        this.addButton.addActionListener(this);
        gridbag.setConstraints(this.addButton, gbc);
        buildpanel.add(this.addButton);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        this.removeButton.addActionListener(this);
        gridbag.setConstraints(this.removeButton, gbc);
        buildpanel.add(this.removeButton);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.nameFormatButton = new JButton(LanguageEncoder.getText("Table Name Format"));
        this.nameFormatButton.addActionListener(this);
        gridbag.setConstraints(this.nameFormatButton, gbc);
        buildpanel.add(this.nameFormatButton);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.importButton = new JButton(LanguageEncoder.getText("Import Joins..."));
        this.importButton.addActionListener(this);
        gridbag.setConstraints(this.importButton, gbc);
        buildpanel.add(this.importButton);
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.aliasButton = new JButton(LanguageEncoder.getText("Rename"));
        this.aliasButton.addActionListener(this);
        gridbag.setConstraints(this.aliasButton, gbc);
        buildpanel.add(this.aliasButton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        TableTreeNode[] tablelist = this.dataViewDialog.getAllTables();
        if (tablelist == null) {
            tablelist = new TableTreeNode[]{};
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tables");
        for (TableTreeNode element : tablelist) {
            root.add(element);
        }
        this.tableTree = new JTree(root, true);
        this.tableTree.setRootVisible(false);
        this.tableTree.setShowsRootHandles(false);
        this.tableTree.setVisibleRowCount(14);
        this.tableTree.addMouseListener(this);
        this.tableTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                Object tableNode;
                if (event.getSource() == DataViewTableSelectionDialog.this.tableTree && (tableNode = event.getPath().getLastPathComponent()) instanceof TableTreeNode) {
                    try {
                        ((TableTreeNode)tableNode).generateColumns();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        String excep = "";
                        try {
                            excep = QbUtil.replace(ex.toString(), "Exception: ", "Excepion:\n");
                            excep = "\n" + excep;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        new JMessageDialog((Dialog)DataViewTableSelectionDialog.this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve columns for this table.\n") + excep);
                    }
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        FocusAdapter flistener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Component temptree = event.getComponent();
                if (temptree instanceof JTree) {
                    if (temptree == DataViewTableSelectionDialog.this.tableTree) {
                        DataViewTableSelectionDialog.this.viewTree.clearSelection();
                    } else if (temptree == DataViewTableSelectionDialog.this.viewTree) {
                        DataViewTableSelectionDialog.this.tableTree.clearSelection();
                    }
                    if (((JTree)temptree).getSelectionPath() != null) {
                        DataViewTableSelectionDialog.this.setButtonState((DefaultMutableTreeNode)((JTree)temptree).getSelectionPath().getLastPathComponent());
                    }
                }
            }
        };
        TreeSelectionListener slistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DefaultMutableTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                DataViewTableSelectionDialog.this.setButtonState(tn);
            }
        };
        this.tableTree.addFocusListener(flistener);
        this.tableTree.addTreeSelectionListener(slistener);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.tableTree);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        this.diagram = new DataViewDiagram(this);
        gbc.gridx = 2;
        gbc.gridy = 1;
        root = new DefaultMutableTreeNode("Views");
        this.viewTree = new JTree(root, true);
        for (TableTreeNode table : tables = this.dataViewDialog.getTables()) {
            this.addTableToView(table, false);
        }
        this.viewTree.setCellRenderer(new InternalCellRenderer());
        this.viewTree.setRootVisible(false);
        this.viewTree.setShowsRootHandles(false);
        this.viewTree.setVisibleRowCount(14);
        this.viewTree.addFocusListener(flistener);
        this.viewTree.addTreeSelectionListener(slistener);
        ToolTipManager.sharedInstance().registerComponent(this.viewTree);
        this.viewTree.setSelectionRow(0);
        this.viewTree.clearSelection();
        scroll = new JScrollPane();
        scroll.getViewport().add(this.viewTree);
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        gridbag.setConstraints(scroll, gbc);
        buildpanel.add(scroll);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.autoJoinBox = new JCheckBox(LanguageEncoder.getText("Auto Join"), this.doAutoJoin);
        this.autoJoinBox.addItemListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        okpanel.add(this.autoJoinBox);
        okpanel.add(this.okButton);
        okpanel.add(this.cancelButton);
        tabbedPane.addTab("Tables", buildpanel);
        tabbedPane.addTab("Joins", this.diagram);
        bpanel.add("Center", tabbedPane);
        bpanel.add("South", okpanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataViewTableSelectionDialog.this.modified = false;
                DataViewTableSelectionDialog.this.setVisible(false);
                DataViewTableSelectionDialog.this.dispose();
            }
        });
        this.setButtonState(null);
    }

    private void setPosition() {
        ((DefaultTreeModel)this.viewTree.getModel()).reload();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setButtonState(DefaultMutableTreeNode tn) {
        this.addButton.setEnabled(this.isAddEnabled(tn));
        this.removeButton.setEnabled(this.isRemoveEnabled(tn));
        this.aliasButton.setEnabled(this.isAliasEnabled(tn));
    }

    public boolean isModified() {
        return this.modified;
    }

    private boolean isAddEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
        return rootname.equals("Tables");
    }

    private boolean isRemoveEnabled(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        TreePath[] paths = this.viewTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path.getLastPathComponent() == this.viewTree.getModel().getRoot() || path.getPathCount() != 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAliasEnabled(DefaultMutableTreeNode node) {
        TreePath[] paths = this.viewTree.getSelectionPaths();
        return this.isRemoveEnabled(node) && paths != null && paths.length == 1 && paths[0].getPathCount() == 2;
    }

    private void doAdd() {
        try {
            TreePath[] selected = this.tableTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Vector<TreeNode> added = new Vector<TreeNode>();
            for (TreePath element : selected) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)element.getLastPathComponent();
                if (node instanceof TableTreeNode) {
                    boolean contains = false;
                    for (int j = 0; j < added.size() && !contains; ++j) {
                        if (added.elementAt(j) != node) continue;
                        contains = true;
                    }
                    if (contains) continue;
                    try {
                        ((TableTreeNode)node).generateColumns();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        String excep = "";
                        try {
                            excep = QbUtil.replace(ex.toString(), "Exception: ", "Excepion:\n");
                            excep = "\n" + excep;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("This table cannot be added because you do not have permission to select from it.\n") + excep);
                        return;
                    }
                    this.addTableToView((TableTreeNode)node, this.doAutoJoin);
                    added.addElement(node);
                    continue;
                }
                if (!(node.getParent() instanceof TableTreeNode) || added.contains(node.getParent())) continue;
                this.addTableToView((TableTreeNode)node.getParent(), this.doAutoJoin);
                added.addElement(node.getParent());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doRemove() {
        try {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            for (TreePath element : selected) {
                Object node = element.getLastPathComponent();
                if (!(node instanceof TableTreeNode)) continue;
                TableTreeNode viewnode = (TableTreeNode)node;
                ((DefaultTreeModel)this.viewTree.getModel()).removeNodeFromParent(viewnode);
                if (this.diagram == null) continue;
                this.diagram.removeTable(viewnode.getWindow());
            }
            this.setButtonState(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doNameFormat() {
        QualifiedNameDialog qnDialog = new QualifiedNameDialog(this, this.dataViewDialog.getTableNameFormat());
        qnDialog.setVisible(true);
        if (qnDialog.isModified()) {
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You may lose the selected tables?"), 2);
            int response = msgDialog.getResponse();
            if (response == 5) {
                return;
            }
            try {
                this.setTableNameFormat(qnDialog.getSelectedFormat());
                if (this.tableTree != null) {
                    ((DefaultTreeModel)this.tableTree.getModel()).reload();
                }
                if (this.viewTree != null) {
                    ((DefaultTreeModel)this.viewTree.getModel()).reload();
                }
            }
            catch (Exception ex) {
                String excep = "";
                try {
                    excep = QbUtil.replace(ex.toString(), "Exception: ", "Excepion:\n");
                    excep = "\n" + excep;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to change the table name format.\n") + excep);
            }
        }
    }

    private void setTableNameFormat(int format) throws Exception {
        int newformat = 0;
        if (format == 1 || format == 2) {
            newformat = format;
        }
        if (newformat != this.dataViewDialog.getTableNameFormat()) {
            Vector tablelist = this.dataViewDialog.getDatabaseInfo().getTableList(new String[]{"TABLE", "VIEW", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, newformat);
            DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.tableTree.getModel().getRoot();
            this.dataViewDialog.allTables = new TableTreeNode[tablelist.size()];
            if (tableroot != null) {
                tableroot.removeAllChildren();
            }
            for (int i = 0; i < tablelist.size(); ++i) {
                TableTreeNode node;
                this.dataViewDialog.allTables[i] = node = new TableTreeNode(this.dataViewDialog.getDatabaseInfo(), (String)tablelist.elementAt(i));
                if (tableroot == null) continue;
                tableroot.add(this.dataViewDialog.allTables[i]);
            }
            if (this.viewTree != null) {
                DefaultMutableTreeNode viewroot2 = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
                viewroot2.removeAllChildren();
            }
            this.dataViewDialog.setTableNameFormat(newformat);
        }
    }

    private void doImport() {
        Object[] siblings = this.dataViewDialog.getSiblingNodes();
        if (siblings == null || siblings.length == 0) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to find compatible data views."));
            return;
        }
        DataViewNode dv = (DataViewNode)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please select a data view:"), LanguageEncoder.getText("Import Joins..."), 3, null, siblings, siblings[0]);
        if (dv != null) {
            try {
                Vector joins = this.dataViewDialog.loadJoinProperties(QueryMain.QUERYDIR + dv.getQueryFile() + ".dvw", this.getTables());
                for (int i = 0; i < joins.size(); ++i) {
                    Vector v = (Vector)joins.elementAt(i);
                    TableTreeNode treenode = (TableTreeNode)v.elementAt(0);
                    if (!this.isSelected(treenode)) {
                        this.addTableToView(treenode, false);
                    }
                    ColumnFieldWindow w1 = treenode.getWindow();
                    treenode = (TableTreeNode)v.elementAt(2);
                    if (!this.isSelected(treenode)) {
                        this.addTableToView(treenode, false);
                    }
                    ColumnFieldWindow w2 = treenode.getWindow();
                    DataViewDialog.addJoin(this.getJoinsVector(), new JoinLine(w1, (Integer)v.elementAt(1), w2, (Integer)v.elementAt(3), (Integer)v.elementAt(4)));
                }
                if (this.diagram != null) {
                    this.diagram.repaintDesktop();
                }
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
                return;
            }
        }
    }

    private boolean isSelected(TableTreeNode node) {
        TableTreeNode[] existing;
        for (TableTreeNode element : existing = this.getTables()) {
            if (!element.equals(node)) continue;
            return true;
        }
        return false;
    }

    private void doAlias() {
        try {
            TreePath[] selected = this.viewTree.getSelectionPaths();
            if (selected == null || selected.length == 0) {
                return;
            }
            Object node = selected[0].getLastPathComponent();
            if (node instanceof TableTreeNode) {
                boolean OK = false;
                JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Alias:"), 3, 2);
                String tmp = ((TableTreeNode)node).getAlias();
                optionPane.setInitialSelectionValue(tmp);
                while (!OK) {
                    optionPane.setWantsInput(true);
                    JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("New Table Alias"));
                    dialog.setVisible(true);
                    dialog.dispose();
                    if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                        return;
                    }
                    tmp = (String)optionPane.getInputValue();
                    if (tmp != null && !tmp.trim().equals("")) {
                        boolean error = false;
                        if (ConditionColumnSelectionDialog.containsIllegalCharacters(tmp)) {
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Table alias can only contain letters and numbers:") + " " + tmp);
                            error = true;
                        }
                        if (this.aliasExists(tmp = tmp.trim())) {
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Table alias already exists:") + " " + tmp);
                            error = true;
                        }
                        if (error) continue;
                        ((TableTreeNode)node).setAlias(tmp);
                        ((DefaultTreeModel)this.viewTree.getModel()).reload((TreeNode)node);
                        OK = true;
                        continue;
                    }
                    OK = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.doAutoJoin = this.autoJoinBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.modified = false;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.addButton) {
            this.doAdd();
        } else if (e.getSource() == this.removeButton) {
            this.doRemove();
        } else if (e.getSource() == this.nameFormatButton) {
            this.doNameFormat();
        } else if (e.getSource() == this.importButton) {
            this.doImport();
        } else if (e.getSource() == this.aliasButton) {
            this.doAlias();
        } else if (e.getSource() == this.okButton) {
            DefaultMutableTreeNode viewroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
            if (viewroot.getChildCount() <= 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please add one or more tables to this data view."));
                return;
            }
            this.setVisible(false);
            this.dispose();
            this.modified = true;
        }
    }

    public TableTreeNode[] getTables() {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        TableTreeNode[] ret = new TableTreeNode[tableroot.getChildCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (TableTreeNode)tableroot.getChildAt(i);
        }
        return ret;
    }

    private void addTableToView(TableTreeNode node, boolean addJoins) {
        String alias_base = node.getTableName();
        int count = 0;
        if (!node.getAlias().equals(node.getTableName())) {
            alias_base = node.getAlias();
        }
        if (alias_base != null) {
            alias_base = alias_base.replace('.', '_').replaceAll("`", "");
        }
        String alias = alias_base;
        int databaseType = QueryMain.getDatabaseType(this.dataViewDialog.getDatabaseInfo());
        if ((databaseType == 2 || databaseType == 7) && alias.length() > 30) {
            alias = alias_base.substring(0, 28) + "_0";
        }
        while (this.aliasExists(alias)) {
            alias = databaseType == 2 || databaseType == 7 ? (alias_base.length() > 28 && count < 10 ? alias_base.substring(0, 28) + "_" + count : (alias_base.length() > 27 && count < 100 ? alias_base.substring(0, 27) + "_" + count : alias_base + "_" + count)) : alias_base + "_" + count;
            ++count;
        }
        try {
            node.generateColumns();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableTreeNode nodewrapper = new TableTreeNode(node);
        nodewrapper.setAlias(alias);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        int index = root.getChildCount();
        ((DefaultTreeModel)this.viewTree.getModel()).insertNodeInto(nodewrapper, root, index);
        try {
            if (this.diagram != null) {
                this.diagram.addTable(nodewrapper.getWindow(), addJoins);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean aliasExists(String alias) {
        DefaultMutableTreeNode tableroot = (DefaultMutableTreeNode)this.viewTree.getModel().getRoot();
        for (int i = 0; i < tableroot.getChildCount(); ++i) {
            if (!((TableTreeNode)tableroot.getChildAt(i)).getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    void setModified(boolean state) {
        this.modified = state;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tableTree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            String rootname = (String)((DefaultMutableTreeNode)node.getRoot()).getUserObject();
            if (!(node instanceof TableTreeNode) && rootname.equals("Tables") && e.getClickCount() == 2) {
                this.doAdd();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    DatabaseInfo getDatabaseInfo() {
        return this.dataViewDialog.getDatabaseInfo();
    }

    Vector getJoinsVector() {
        return this.dataViewDialog.getJoinsVector();
    }

    private class InternalCellRenderer
    extends DefaultTreeCellRenderer {
        private InternalCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof TableTreeNode) {
                try {
                    this.setToolTipText(((TableTreeNode)value).getTableName());
                }
                catch (Exception exception) {}
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

