/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;

public class DatabaseInfoDialog
extends JDialog
implements ActionListener {
    JButton closeButton;
    DatabaseInfo info;

    public DatabaseInfoDialog(QueryMain queryMain) {
        super(queryMain, LanguageEncoder.getText("Database Information ..."), false);
        this.info = queryMain.databaseInfo;
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Database")));
        bpanel.setLayout(new BorderLayout());
        JPanel mainPanelWest = new JPanel(new GridLayout(0, 1, 5, 5));
        JPanel mainPanelCenter = new JPanel(new GridLayout(0, 1, 5, 5));
        try {
            String prodName = this.info.getProductName();
            mainPanelWest.add(new JLabel(LanguageEncoder.getText("Product Name :")));
            mainPanelCenter.add(new JLabel(prodName));
        }
        catch (Exception prodName) {
            // empty catch block
        }
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("URL :")));
        mainPanelCenter.add(new JLabel(this.info.getURL()));
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("Driver :")));
        mainPanelCenter.add(new JLabel(this.info.getDriver()));
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("User Name :")));
        mainPanelCenter.add(new JLabel(this.info.getUserName()));
        bpanel.add("West", mainPanelWest);
        bpanel.add("Center", mainPanelCenter);
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        this.closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add("Center", this.closeButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", bpanel);
        contentPane.add("South", this.closeButton);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

