/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import quadbase.common.swing.listeners.MousePopUpAdapter;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.AdvanceDictionary;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.IJoinLineMonitor;
import quadbase.querybuilder.designer.JoinLine;
import quadbase.querybuilder.designer.JoinPropertyDialog;
import quadbase.querybuilder.designer.PopupMenuForJoinLine;
import quadbase.querybuilder.designer.PopupMenuForQBETable;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SimpleDictionary;
import quadbase.querybuilder.query.ColumnInfo;
import quadbase.querybuilder.query.ForeignKeyLocator;
import quadbase.querybuilder.query.LoadQuery;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.querybuilder.query.TableInfo;

public class DesignView
extends JSplitPane
implements IJoinLineMonitor {
    QueryMain queryMain;
    private JDesktopPane diagramPane;
    private JTable table;
    int lastColIndex = 0;
    private Vector<JoinLine> lineList;
    private JoinLine selectedJoinLine = null;
    boolean isPopupTrigger = false;
    private PopupMenuForJoinLine joinLineMenu;
    private PopupMenuForQBETable tableMenu;
    private CellEditor cellEditor;
    private RowHeader rowHeader;
    private Vector<Object> headerList;
    private JScrollPane lowerPanel;
    private Hashtable<String, TableInfo> tableInfoTable = new Hashtable();
    private static final int NUMBER_OF_TABLE_ROWS = 10;
    private static final int NUMBER_OF_TABLE_COLUMNS = 15;
    private static final int TABLE_COLUMN_WIDTH = 120;
    private static final int TABLE_HEADER_HEIGHT = 35;

    public DesignView(QueryMain queryMain) {
        super(0, false);
        this.queryMain = queryMain;
        this.lineList = new Vector();
        this.headerList = new Vector();
        this.init();
        this.joinLineMenu = new PopupMenuForJoinLine(this);
        this.tableMenu = new PopupMenuForQBETable(this);
    }

    private void init() {
        this.diagramPane = new JDesktopPane(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                for (int i = 0; i < DesignView.this.lineList.size(); ++i) {
                    ((JoinLine)DesignView.this.lineList.elementAt(i)).draw(g);
                }
            }
        };
        this.diagramPane.setPreferredSize(new Dimension(1000, 8000));
        this.diagramPane.setBackground(Color.lightGray);
        this.diagramPane.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                for (int i = DesignView.this.lineList.size() - 1; i >= 0; --i) {
                    if (!((JoinLine)DesignView.this.lineList.elementAt(i)).contains(x, y)) continue;
                    DesignView.this.selectedJoinLine = (JoinLine)DesignView.this.lineList.elementAt(i);
                    DesignView.this.joinLineMenu.show(DesignView.this.diagramPane, x, y);
                }
            }
        });
        this.diagramPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (e.getClickCount() != 1 && mouseMask == 0) {
                    for (int i = DesignView.this.lineList.size() - 1; i >= 0; --i) {
                        if (!((JoinLine)DesignView.this.lineList.elementAt(i)).contains(e.getX(), e.getY())) continue;
                        return;
                    }
                }
            }
        });
        JScrollPane upperPanel = new JScrollPane();
        upperPanel.getViewport().add(this.diagramPane);
        upperPanel.getHorizontalScrollBar().setBackground(new Color(225, 225, 225));
        upperPanel.getVerticalScrollBar().setBackground(new Color(225, 225, 225));
        upperPanel.getHorizontalScrollBar().setForeground(Color.red);
        upperPanel.getVerticalScrollBar().setForeground(Color.red);
        this.table = new JTable(10, 15){

            @Override
            public void removeEditor() {
                try {
                    super.removeEditor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.table.setGridColor(Color.lightGray);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (mouseMask == IOUtil.getRightMouseClickMask()) {
                    try {
                        Point p = new Point(e.getX(), e.getY());
                        int sRow = DesignView.this.table.rowAtPoint(p);
                        int sColumn = DesignView.this.table.columnAtPoint(p);
                        if (sRow != -1 && sColumn != -1) {
                            Class<?> jtableClass = Class.forName("javax.swing.JTable");
                            Method changeSelectionMethod = jtableClass.getMethod("changeSelection", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            changeSelectionMethod.invoke((Object)DesignView.this.table, sRow, sColumn, Boolean.FALSE, Boolean.FALSE);
                        }
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                    int row = DesignView.this.table.getSelectedRow();
                    if (row == -1) {
                        String message = LanguageEncoder.getText("Please left click to select a column first!");
                        new JMessageDialog((Dialog)DesignView.this.queryMain, LanguageEncoder.getText("Error"), message);
                        return;
                    }
                    DesignView.this.tableMenu.setBuildEnabled(row == 1 || row == 5 || row >= 6);
                    DesignView.this.tableMenu.show(DesignView.this.table, e.getX(), e.getY());
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.cellEditor = new CellEditor();
        this.table.setCellEditor(this.cellEditor);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.headerList.addElement(" ");
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setHeaderValue(this.headerList.elementAt(i));
            tableColumn.setPreferredWidth(120);
            tableColumn.setCellEditor(this.cellEditor);
        }
        this.table.getTableHeader().setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), 35));
        this.lowerPanel = new JScrollPane();
        this.lowerPanel.getViewport().add(this.table);
        this.lowerPanel.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DesignView.this.table.getTableHeader().setPreferredSize(new Dimension(DesignView.this.table.getColumnModel().getTotalColumnWidth(), 35));
            }
        });
        this.rowHeader = new RowHeader(this.table);
        JViewport view = new JViewport();
        view.add(this.rowHeader);
        view.setPreferredSize(this.rowHeader.getPreferredSize());
        this.lowerPanel.setRowHeader(view);
        this.setTopComponent(upperPanel);
        this.setBottomComponent(this.lowerPanel);
    }

    @Override
    public ColumnFieldWindow getSelectedColumnFieldWindow(int x, int y) {
        int ct = this.getColumnFieldWindowCount();
        for (int i = 0; i < ct; ++i) {
            ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[i];
            if (!tmp.getBounds().contains(x, y)) continue;
            return tmp;
        }
        return null;
    }

    private ColumnFieldWindow getWindow(String aliasName) {
        int ct = this.getColumnFieldWindowCount();
        for (int i = 0; i < ct; ++i) {
            ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[i];
            if (!tmp.getDisplayName().equals(aliasName)) continue;
            return tmp;
        }
        return null;
    }

    ColumnFieldWindow[] getAllWindows() {
        int ct = this.getColumnFieldWindowCount();
        ColumnFieldWindow[] ret = new ColumnFieldWindow[ct];
        for (int i = 0; i < ct; ++i) {
            ret[i] = (ColumnFieldWindow)this.diagramPane.getAllFrames()[i];
        }
        return ret;
    }

    boolean isTableAliasExisted(String str) {
        int ct = this.getColumnFieldWindowCount();
        for (int i = 0; i < ct; ++i) {
            JInternalFrame tmp = this.diagramPane.getAllFrames()[i];
            if (!tmp.getTitle().equals(str)) continue;
            return true;
        }
        return false;
    }

    private String createColumnAlias(int colIndex, String agg, Object colField) {
        String tmp = "Expression";
        if (colField != null && agg != null && !this.table.getValueAt(0, colIndex).equals("Expression")) {
            tmp = agg + " Of " + colField.toString();
        }
        if (colField != null && agg != null && agg.equalsIgnoreCase("group by")) {
            tmp = colField.toString();
        }
        int i = 0;
        String tmp2 = tmp;
        while (this.isColumnAliasExisted(colIndex, tmp2)) {
            tmp2 = tmp + "_" + i++;
        }
        return tmp2;
    }

    boolean isColumnAliasExisted(int colIndex, String str) {
        for (int i = 0; i < this.headerList.size(); ++i) {
            if (colIndex == i || !((String)this.headerList.elementAt(i)).equals(str)) continue;
            return true;
        }
        return false;
    }

    ColumnFieldWindow showTable(String tableName) throws Exception {
        return this.showTable(tableName, this.queryMain.isAutoJoinEnabled());
    }

    private ColumnFieldWindow showTable(String tableName, boolean autoJoin) throws Exception {
        TableInfo tableInfo = new TableInfo(this.queryMain.databaseInfo, tableName);
        ColumnFieldWindow columnFieldWindow = this.showTable(new ColumnFieldWindow(this, tableInfo), autoJoin);
        this.tableInfoTable.put(tableInfo.getName(), tableInfo);
        return columnFieldWindow;
    }

    ColumnFieldWindow showDictionary(LoadQuery lq, String alias, boolean autoJoin) throws Exception {
        SimpleDictionary newCol = null;
        newCol = this.queryMain.getDatabaseType() == 0 || this.queryMain.getDatabaseType() == 1 ? new AdvanceDictionary(lq, this.queryMain) : new SimpleDictionary(lq, this.queryMain);
        ((ColumnFieldWindow)newCol).setDisplayName(alias);
        return this.showTable(newCol, autoJoin);
    }

    private ColumnFieldWindow showTable(ColumnFieldWindow newCol, boolean autoJoin) throws Exception {
        if (this.queryMain.getDatabaseType() != 9) {
            String displayName = newCol.getDisplayName();
            int ct = 1;
            if (displayName != null) {
                String displayName_org = displayName = displayName.replace('.', '_').replaceAll("[\\[\\]\"]", "").replaceAll("`", "");
                if ((this.queryMain.getDatabaseType() == 2 || this.queryMain.getDatabaseType() == 7) && displayName.length() > 30) {
                    displayName = displayName.substring(0, 28) + "_0";
                }
                while (this.isTableAliasExisted(displayName)) {
                    displayName = ct < 10 && displayName_org.length() > 28 ? displayName_org.substring(0, 28) + "_" + ct : (ct < 100 && displayName_org.length() > 27 ? displayName_org.substring(0, 27) + "_" + ct : displayName_org + "_" + ct);
                    ++ct;
                }
                newCol.setDisplayName(displayName);
            }
        }
        if (autoJoin) {
            this.setJoinProperty(newCol);
        }
        newCol.setPosition(this.diagramPane.getAllFrames(), this.diagramPane.getSize());
        this.diagramPane.add(newCol);
        newCol.setVisible(true);
        newCol.toFront();
        newCol.setSelected(true);
        return newCol;
    }

    void setColumnWindows(String[] tableName, String[] tableAlias, Rectangle[] bounds, LoadQuery[] dictionaries, String[] dictionaryAlias, Rectangle[] dictionaryBounds, String[][] joinProperties) throws Exception {
        ColumnFieldWindow col;
        int i;
        this.deleteAllColumnWindows();
        for (i = 0; i < tableName.length; ++i) {
            col = this.showTable(tableName[i], false);
            col.setPosition(bounds[i]);
            col.setDisplayName(tableAlias[i]);
        }
        if (dictionaries != null && dictionaryAlias != null) {
            for (i = 0; i < dictionaries.length; ++i) {
                col = this.showDictionary(dictionaries[i], "", false);
                col.setDisplayName(dictionaryAlias[i]);
                col.setPosition(dictionaryBounds[i]);
            }
        }
        this.setJoinProperties(joinProperties);
    }

    void setQBEWindow(Object[][] data, Object[] headerData) {
        this.getTableModel().setDataVector(data, headerData);
        this.headerList = new Vector();
        for (int i = 0; i < headerData.length; ++i) {
            this.headerList.addElement(headerData[i]);
            if (headerData[i] == null || headerData[i].toString().trim().equals("")) continue;
            this.lastColIndex = i + 1;
        }
        this.resetProperties();
    }

    private void deleteAllColumnWindows() {
        int ct = this.getColumnFieldWindowCount();
        for (int i = ct - 1; i >= 0; --i) {
            ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[i];
            this.deleteColumnWindow(tmp);
        }
    }

    void deleteColumnWindow(ColumnFieldWindow col) {
        for (int i = this.lineList.size() - 1; i >= 0; --i) {
            JoinLine joinLine = this.lineList.elementAt(i);
            if (!joinLine.isRelated(col)) continue;
            this.lineList.removeElementAt(i);
        }
        this.removeTableColumn(col.getDisplayName());
        this.diagramPane.remove(col);
    }

    private void setJoinProperties(String[][] join) {
        for (String[] element : join) {
            ColumnFieldWindow col1 = this.getWindow(element[0]);
            ColumnFieldWindow col2 = this.getWindow(element[2]);
            if (col1 == null || col2 == null) continue;
            int index1 = col1.getIndex(element[1]);
            int index2 = col2.getIndex(element[3]);
            if (index1 < 0 || index2 < 0) continue;
            this.setJoinProperty(col1, index1, col2, index2, QueryBuilder.mapJoinLineIndex(element[4]));
        }
    }

    private void setJoinProperty(ColumnFieldWindow newCol) {
        try {
            Vector joincols;
            if (this.getColumnFieldWindowCount() > 0 && (joincols = new ForeignKeyLocator(this.queryMain.getDatabaseType(), this.queryMain.databaseInfo).findForeignKeys(newCol, Arrays.asList(this.diagramPane.getAllFrames()).toArray(new ColumnFieldWindow[0]))) != null) {
                for (int i = 0; i < joincols.size(); ++i) {
                    this.lineList.addElement(new JoinLine((ColumnFieldWindow)((Vector)joincols.elementAt(i)).elementAt(0), (Integer)((Vector)joincols.elementAt(i)).elementAt(1), (ColumnFieldWindow)((Vector)joincols.elementAt(i)).elementAt(2), (Integer)((Vector)joincols.elementAt(i)).elementAt(3)));
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int ct = this.getColumnFieldWindowCount();
        if (ct < 1) {
            return;
        }
        String[] columnNames = newCol.getColumns();
        int index = -1;
        for (int i = 0; i < columnNames.length; ++i) {
            for (int j = 0; j < ct; ++j) {
                ColumnFieldWindow tmp = (ColumnFieldWindow)this.diagramPane.getAllFrames()[j];
                if (tmp == newCol || (index = tmp.getIndex(columnNames[i], newCol.getSQLType(i + 1))) <= -1) continue;
                this.lineList.addElement(new JoinLine(newCol, i + 1, tmp, index));
            }
        }
    }

    @Override
    public void setJoinProperty(ColumnFieldWindow col1, int idx1, ColumnFieldWindow col2, int idx2, int joinProperty) {
        if (col1 == col2) {
            return;
        }
        this.lineList.addElement(new JoinLine(col1, idx1, col2, idx2, joinProperty));
    }

    @Override
    public void updateJoinProperty() {
        if (this.selectedJoinLine == null) {
            return;
        }
        JoinPropertyDialog joinDialog = new JoinPropertyDialog(this.queryMain, this.selectedJoinLine);
        joinDialog.setVisible(true);
        if (!joinDialog.isModified()) {
            return;
        }
        this.selectedJoinLine.setJoinProperty(joinDialog.getJoinProperty());
        this.diagramPane.repaint();
    }

    @Override
    public void updateJoinProperties(ColumnFieldWindow table) {
        for (int i = 0; i < this.lineList.size(); ++i) {
            JoinLine join = this.lineList.elementAt(i);
            if (join.list1 == table) {
                join.index1 = table.findMapping(join.index1);
                continue;
            }
            if (join.list2 != table) continue;
            join.index2 = table.findMapping(join.index2);
        }
        this.diagramPane.repaint();
    }

    @Override
    public void deleteJoinProperty() {
        if (this.selectedJoinLine != null) {
            this.lineList.removeElement(this.selectedJoinLine);
        }
        if (this.queryMain != null) {
            this.queryMain.repaint();
        }
    }

    @Override
    public int getColumnFieldWindowCount() {
        JInternalFrame[] tmp = this.diagramPane.getAllFrames();
        return tmp.length;
    }

    private Vector getData() {
        if (this.table == null) {
            return null;
        }
        return this.getTableModel().getDataVector();
    }

    JTable getTable() {
        return this.table;
    }

    private DefaultTableModel getTableModel() {
        return (DefaultTableModel)this.table.getModel();
    }

    String[][] getJoinProperties() {
        String[][] tmp = new String[this.lineList.size()][5];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.lineList.elementAt(i).getValues();
        }
        return tmp;
    }

    void insertColumn() {
        this.insertColumn(this.table.getSelectedColumn());
    }

    void deleteColumn() {
        this.deleteColumn(this.table.getSelectedColumn());
    }

    void insertRow() {
        this.insertRow(this.table.getSelectedRow());
    }

    String getFormula() {
        int col = this.table.getSelectedColumn();
        int row = this.table.getSelectedRow();
        if (row == 5 || row >= 6) {
            return (String)this.table.getValueAt(row, col);
        }
        String tblName = (String)this.table.getValueAt(0, col);
        if (!"Expression".equals(tblName)) {
            return null;
        }
        return (String)this.table.getValueAt(row, col);
    }

    void setFormula(String formulaText) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        String tblName = (String)this.table.getValueAt(0, col);
        if (row == 1 && !"Expression".equals(tblName)) {
            this.table.setValueAt("Expression", 0, col);
            this.setHeaderName(col, this.createColumnAlias(col, null, null));
            if (this.table.getValueAt(4, col) == null) {
                this.table.setValueAt(Boolean.TRUE, 4, col);
            }
        }
        this.table.setValueAt(formulaText, row, col);
        if (this.lastColIndex == col) {
            ++this.lastColIndex;
        }
    }

    private void removeTableColumn(String tableName) {
        Vector data = this.getData();
        int colCount = ((Vector)data.elementAt(0)).size();
        boolean[] deleted = new boolean[colCount];
        Vector tableNameList = (Vector)data.elementAt(0);
        for (int i = colCount - 1; i >= 0; --i) {
            Object tmp = tableNameList.elementAt(i);
            if (tmp != null && tableName.equals(tmp.toString())) {
                for (int j = 0; j < data.size(); ++j) {
                    ((Vector)data.elementAt(j)).removeElementAt(i);
                }
                this.headerList.remove(i);
                this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(i)));
                --this.lastColIndex;
                --colCount;
                deleted[i] = true;
                continue;
            }
            deleted[i] = false;
        }
        int[] order = null;
        try {
            order = new int[colCount];
            int index = 0;
            for (int i = 0; i < deleted.length; ++i) {
                if (deleted[i]) continue;
                order[index] = this.table.convertColumnIndexToView(i);
                ++index;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getTableModel().setDataVector(data, this.headerList);
        this.resetProperties();
        if (order != null) {
            for (int i = 0; i < order.length && i < this.table.getColumnCount(); ++i) {
                try {
                    this.table.getColumnModel().getColumn(order[i]).setModelIndex(i);
                    this.table.getColumnModel().getColumn(order[i]).setHeaderValue(this.headerList.elementAt(i));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.addDataTypesToTableColumnHeaders();
    }

    void updateTableName(String oldStr, String newStr) {
        int ct = this.table.getColumnCount();
        for (int i = 0; i < ct; ++i) {
            String tblName = (String)this.table.getModel().getValueAt(0, i);
            if (tblName == null || !tblName.equals(oldStr)) continue;
            this.table.getModel().setValueAt(newStr, 0, i);
        }
    }

    private void insertColumn(int index) {
        int i;
        if (index < 0) {
            return;
        }
        Vector data = this.getData();
        int colCount = ((Vector)data.elementAt(0)).size() + 1;
        int[] order = null;
        try {
            order = new int[colCount];
            for (i = 0; i < order.length; ++i) {
                order[i] = i < index ? this.table.convertColumnIndexToModel(i) : (i == index ? colCount - 1 : this.table.convertColumnIndexToModel(i - 1));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.headerList.addElement(" ");
        for (i = 0; i < data.size(); ++i) {
            ((Vector)data.elementAt(i)).addElement(null);
        }
        this.getTableModel().setDataVector(data, this.headerList);
        if (index < this.lastColIndex) {
            ++this.lastColIndex;
        }
        this.resetProperties();
        if (order != null) {
            for (i = 0; i < order.length && i < this.table.getColumnCount(); ++i) {
                try {
                    this.table.getColumnModel().getColumn(i).setModelIndex(order[i]);
                    this.table.getColumnModel().getColumn(i).setHeaderValue(this.headerList.elementAt(order[i]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.addDataTypesToTableColumnHeaders();
    }

    void addDataTypesToTableColumnHeaders() {
        Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
        this.table.getTableHeader().setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), 35));
        block0: while (e.hasMoreElements()) {
            TableInfo tableInfo;
            TableColumn tc = e.nextElement();
            tc.setPreferredWidth(120);
            String key = (String)this.table.getModel().getValueAt(0, tc.getModelIndex());
            String columnName = (String)this.table.getModel().getValueAt(1, tc.getModelIndex());
            if (this.tableInfoTable == null || key == null || (tableInfo = this.tableInfoTable.get(key)) == null) continue;
            for (int i = 0; i < tableInfo.getColumnCount(); ++i) {
                ColumnInfo column2 = tableInfo.getColumn(i);
                if (column2.getColumnName().equals(columnName)) {
                    Object headerValue = tc.getHeaderValue();
                    String hValue = headerValue instanceof HeaderWithDataTypeObject ? ((HeaderWithDataTypeObject)headerValue).getValue() : (String)headerValue;
                    tc.setHeaderValue(new HeaderWithDataTypeObject(hValue, column2.getTypeName()));
                    continue block0;
                }
                if (!columnName.equals("*")) continue;
                tc.setHeaderValue(columnName);
                continue block0;
            }
        }
    }

    private void insertRow(int index) {
        if (index < 5) {
            index = 5;
        }
        this.getTableModel().insertRow(index, new Object[this.table.getColumnCount()]);
        this.rowHeader = new RowHeader(this.table);
        JViewport view = new JViewport();
        view.add(this.rowHeader);
        view.setPreferredSize(this.rowHeader.getPreferredSize());
        this.lowerPanel.setRowHeader(view);
        this.lowerPanel.validate();
        this.lowerPanel.repaint();
        this.validate();
        this.repaint();
    }

    private void deleteColumn(int index) {
        int i;
        if (index < 0) {
            return;
        }
        index = this.table.convertColumnIndexToModel(index);
        Vector data = this.getData();
        int colCount = ((Vector)data.elementAt(0)).size() - 1;
        this.headerList.remove(index);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(index)));
        for (int i2 = 0; i2 < data.size(); ++i2) {
            ((Vector)data.elementAt(i2)).remove(index);
        }
        int[] order = null;
        try {
            order = new int[colCount];
            for (i = 0; i < order.length; ++i) {
                if (i < index) {
                    order[i] = this.table.convertColumnIndexToView(i);
                }
                if (i < index) continue;
                order[i] = this.table.convertColumnIndexToView(i + 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getTableModel().setDataVector(data, this.headerList);
        if (index < this.lastColIndex) {
            --this.lastColIndex;
        }
        this.resetProperties();
        if (order != null) {
            for (i = 0; i < order.length && i < this.table.getColumnCount(); ++i) {
                try {
                    this.table.getColumnModel().getColumn(order[i]).setModelIndex(i);
                    this.table.getColumnModel().getColumn(order[i]).setHeaderValue(this.headerList.elementAt(i));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.addDataTypesToTableColumnHeaders();
    }

    void setHeaderName(String name) {
        this.setHeaderName(this.table.getSelectedColumn(), name);
    }

    private void setHeaderName(int idx, String name) {
        this.headerList.setElementAt(name, this.table.convertColumnIndexToModel(idx));
        String key = (String)this.table.getModel().getValueAt(0, this.table.convertColumnIndexToModel(idx));
        String oldColName = (String)this.table.getModel().getValueAt(1, this.table.convertColumnIndexToModel(idx));
        String string = oldColName = oldColName == null ? name : oldColName;
        if (this.tableInfoTable != null && key != null) {
            TableInfo tableInfo = this.tableInfoTable.get(key);
            if (tableInfo != null) {
                for (int i = 0; i < tableInfo.getColumnCount(); ++i) {
                    ColumnInfo column2 = tableInfo.getColumn(i);
                    if (!column2.getColumnName().equals(oldColName)) continue;
                    this.table.getColumnModel().getColumn(idx).setHeaderValue(new HeaderWithDataTypeObject(name, column2.getTypeName()));
                    break;
                }
            } else {
                this.table.getColumnModel().getColumn(idx).setHeaderValue(new HeaderWithDataTypeObject(name, null));
            }
        } else {
            this.table.getColumnModel().getColumn(idx).setHeaderValue(new HeaderWithDataTypeObject((String)this.headerList.elementAt(this.table.convertColumnIndexToModel(idx)), null));
        }
        this.table.getTableHeader().repaint();
    }

    String getHeaderName() {
        int idx = this.table.getSelectedColumn();
        Object header = this.table.getColumnModel().getColumn(idx).getHeaderValue();
        return header instanceof HeaderWithDataTypeObject ? ((HeaderWithDataTypeObject)header).getValue() : (String)header;
    }

    @Override
    public void setColumn(String tableName, String colName) {
        int viewIndex = this.findNextEmptyColumn();
        if (viewIndex < 0) {
            this.insertColumn(this.table.getColumnCount());
            viewIndex = this.table.getColumnCount() - 1;
            this.lastColIndex = this.table.getColumnCount() - 1;
        } else {
            this.lastColIndex = this.table.convertColumnIndexToModel(viewIndex);
        }
        this.table.getModel().setValueAt(tableName, 0, this.lastColIndex);
        this.table.getModel().setValueAt(colName, 1, this.lastColIndex);
        this.table.getModel().setValueAt(Boolean.TRUE, 4, this.lastColIndex);
        if (QueryBuilder.isAggregationEnabled(this.getTableModel())) {
            this.table.getModel().setValueAt(QueryBuilder.AGGR[1], 3, this.lastColIndex);
        }
        this.setHeaderName(viewIndex, colName);
        if (this.findNextEmptyColumn() < 0) {
            this.insertColumn(this.table.getColumnCount());
        }
        this.addDataTypesToTableColumnHeaders();
    }

    private int findNextEmptyColumn() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (!this.table.getColumnModel().getColumn(i).getHeaderValue().toString().trim().equals("")) continue;
            return i;
        }
        return -1;
    }

    private void resetProperties() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellEditor(this.cellEditor);
            this.table.getColumnModel().getColumn(i).setHeaderValue(this.headerList.elementAt(i));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DesignView.this.setDividerLocation(0.7);
            }
        });
    }

    private String[] getTableNames() {
        int ct = this.getColumnFieldWindowCount();
        String[] titleName = new String[ct];
        for (int i = 0; i < ct; ++i) {
            titleName[i] = this.diagramPane.getAllFrames()[i].getTitle();
        }
        return titleName;
    }

    private Vector<String> getColumnNames(String tableName) {
        Vector<String> vec = new Vector<String>();
        vec.addElement("");
        return this.getColumnNames(tableName, vec, false);
    }

    private Vector<String> getColumnNames(String tableName, Vector<String> vec, boolean attachTableName) {
        block5: {
            block4: {
                if (tableName != null && !tableName.equals("")) break block4;
                String[] titleNames = this.getTableNames();
                for (int i = 1; i < titleNames.length; ++i) {
                    this.getColumnNames(titleNames[i], vec, true);
                }
                break block5;
            }
            ColumnFieldWindow tmp = this.getWindow(tableName);
            if (tmp == null) break block5;
            String[] columnNames = tmp.getColumns();
            if (attachTableName) {
                vec.addElement(tableName + ".*");
            } else {
                vec.addElement("*");
            }
            for (String columnName : columnNames) {
                vec.addElement((attachTableName ? tableName + "." : "") + columnName);
            }
        }
        return vec;
    }

    private int getIndex(String str, Vector objs) {
        if (str == null) {
            return 0;
        }
        for (int i = 0; i < objs.size(); ++i) {
            if (!str.equals(objs.elementAt(i).toString())) continue;
            return i;
        }
        return 0;
    }

    private int getIndex(String str, Object[] objs) {
        if (str == null) {
            return 0;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!str.equals(objs[i].toString())) continue;
            return i;
        }
        return 0;
    }

    public static String getColumnHeaderStringWithDataType(String value, String dataType) {
        return "<html><table border=\"0\"><tr><td style=\"white-space: nowrap\">" + value + (dataType != null ? "<br>(" + dataType + ")" : "") + "</td></tr></html>";
    }

    @Override
    public void setParentCursor(Cursor cursor) {
        this.queryMain.setCursor(cursor);
    }

    @Override
    public void repaintDesktop() {
        this.diagramPane.repaint();
    }

    private class CellEditor
    extends DefaultCellEditor {
        private JTextField text;
        private JComponent comp;
        private int rowIndex;
        private int colIndex;

        public CellEditor() {
            super(new JTextField());
            this.text = new JTextField("TEMP");
            this.rowIndex = 0;
            this.colIndex = 0;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.rowIndex = row;
            this.colIndex = column;
            if (this.colIndex > DesignView.this.lastColIndex) {
                DesignView.this.lastColIndex = this.colIndex + 1;
            }
            if (row == 4) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setHorizontalAlignment(0);
                checkBox.setSelected(value == null ? false : (Boolean)value);
                this.comp = checkBox;
            } else if (row == 0) {
                JComboBox<String> comboBox = new JComboBox<String>(DesignView.this.getTableNames());
                Object str = table.getValueAt(0, this.colIndex);
                if (str != null && str.equals("Expression")) {
                    this.comp = new JLabel("Expression");
                    return this.comp;
                }
                comboBox.setSelectedIndex(DesignView.this.getIndex((String)value, DesignView.this.getTableNames()));
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CellEditor.this.selectFirstColumnInTheTable(((JComboBox)e.getSource()).getSelectedItem().toString(), CellEditor.this.colIndex);
                    }
                });
                this.comp = comboBox;
            } else if (row == 2) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.SORT_ORDER);
                comboBox.setSelectedIndex(DesignView.this.getIndex((String)value, QueryBuilder.SORT_ORDER));
                this.comp = comboBox;
            } else if (row == 3) {
                JComboBox<String> comboBox = new JComboBox<String>(QueryBuilder.AGGR);
                comboBox.setSelectedIndex(DesignView.this.getIndex((String)value, QueryBuilder.AGGR));
                this.comp = comboBox;
            } else if (row == 1) {
                String tableName = (String)table.getValueAt(0, column);
                if ("Expression".equals(tableName)) {
                    DesignView.this.queryMain.buildFormula();
                    return null;
                }
                JComboBox comboBox = new JComboBox(DesignView.this.getColumnNames(tableName));
                comboBox.setSelectedIndex(DesignView.this.getIndex((String)value, DesignView.this.getColumnNames(tableName)));
                this.comp = comboBox;
            } else {
                JTextField textField = new JTextField(value == null ? "" : value.toString());
                this.comp = textField;
            }
            return this.comp;
        }

        private void selectFirstColumnInTheTable(String tableName, int colIndex) {
            Vector columnNames;
            if (tableName != null && tableName.equals("")) {
                DesignView.this.table.setValueAt(null, 1, colIndex);
                DesignView.this.setHeaderName(colIndex, "");
                return;
            }
            DesignView.this.table.setValueAt(tableName, 0, colIndex);
            if ("Expression".equals(tableName)) {
                DesignView.this.queryMain.buildFormula();
            }
            if ((columnNames = DesignView.this.getColumnNames(tableName)).size() > 2) {
                DesignView.this.table.setValueAt(columnNames.get(2), 1, colIndex);
                DesignView.this.setHeaderName(colIndex, (String)columnNames.get(2));
            }
        }

        @Override
        public Object getCellEditorValue() {
            Object srcObj = this.changeEvent.getSource();
            if (srcObj == null) {
                return srcObj;
            }
            if (srcObj instanceof CellEditor) {
                srcObj = this.comp;
            }
            if (srcObj instanceof JCheckBox) {
                boolean state = ((JCheckBox)srcObj).isSelected();
                String aggr = QueryBuilder.getAggregation(DesignView.this.getTableModel(), this.colIndex);
                if (QueryBuilder.isAggregationEnabled(DesignView.this.getTableModel())) {
                    if (!state) {
                        DesignView.this.table.setValueAt(QueryBuilder.AGGR[11], 3, this.colIndex);
                    } else if (state && (aggr == null || aggr.equals(QueryBuilder.AGGR[11]))) {
                        DesignView.this.table.setValueAt(QueryBuilder.AGGR[1], 3, this.colIndex);
                    }
                }
                return state;
            }
            if (srcObj instanceof JComboBox) {
                String tmp = ((JComboBox)srcObj).getSelectedItem().toString();
                if (!(tmp != null && !tmp.equals("") || this.rowIndex != 1 && this.rowIndex != 0)) {
                    for (int i = 0; i < DesignView.this.table.getRowCount(); ++i) {
                        DesignView.this.table.setValueAt(null, i, this.colIndex);
                    }
                    DesignView.this.setHeaderName(this.colIndex, " ");
                }
                if (this.rowIndex == 3 && QueryBuilder.isValidColumn(DesignView.this.getTableModel(), DesignView.this.table.convertColumnIndexToModel(this.colIndex))) {
                    int ct = DesignView.this.table.getColumnCount();
                    if (tmp.trim().equals("")) {
                        for (int i = 0; i < ct; ++i) {
                            Object headerValueObj = DesignView.this.table.getColumnModel().getColumn(i).getHeaderValue();
                            String headerValue = (String)(headerValueObj instanceof HeaderWithDataTypeObject ? ((HeaderWithDataTypeObject)headerValueObj).getValue() : headerValueObj);
                            if (headerValue.indexOf(" Of ") > 0) {
                                DesignView.this.setHeaderName(i, (String)DesignView.this.table.getValueAt(1, i));
                            }
                            DesignView.this.table.setValueAt(null, 3, i);
                        }
                    } else {
                        Object headerValueObj = DesignView.this.table.getColumnModel().getColumn(this.colIndex).getHeaderValue();
                        String headerValue = (String)(headerValueObj instanceof HeaderWithDataTypeObject ? ((HeaderWithDataTypeObject)headerValueObj).getValue() : headerValueObj);
                        if (!tmp.equals(QueryBuilder.AGGR[1]) && !tmp.equals(QueryBuilder.AGGR[11])) {
                            DesignView.this.setHeaderName(this.colIndex, DesignView.this.createColumnAlias(this.colIndex, tmp, DesignView.this.table.getValueAt(1, this.colIndex)));
                        } else if (headerValue.indexOf(" Of ") > 0) {
                            DesignView.this.setHeaderName(this.colIndex, (String)DesignView.this.table.getValueAt(1, this.colIndex));
                        }
                        if (tmp.equals(QueryBuilder.AGGR[11])) {
                            DesignView.this.table.setValueAt(Boolean.FALSE, 4, this.colIndex);
                        }
                        for (int i = 0; i < ct; ++i) {
                            if (i == this.colIndex || !QueryBuilder.isValidColumn(DesignView.this.getTableModel(), DesignView.this.table.convertColumnIndexToModel(i)) || QueryBuilder.getAggregation(DesignView.this.getTableModel(), DesignView.this.table.convertColumnIndexToModel(i)) != null) continue;
                            if (((Boolean)DesignView.this.table.getValueAt(4, i)).booleanValue()) {
                                DesignView.this.table.setValueAt(QueryBuilder.AGGR[1], 3, i);
                                continue;
                            }
                            DesignView.this.table.setValueAt(QueryBuilder.AGGR[11], 3, i);
                        }
                    }
                }
                if (this.rowIndex == 1) {
                    int idx = tmp.lastIndexOf(46);
                    if (idx > 0) {
                        DesignView.this.table.setValueAt(tmp.substring(0, idx), 0, this.colIndex);
                        tmp = tmp.substring(idx + 1);
                    }
                    if (!tmp.trim().equals("")) {
                        if (DesignView.this.table.getValueAt(4, this.colIndex) == null) {
                            DesignView.this.table.setValueAt(Boolean.TRUE, 4, this.colIndex);
                        }
                        if (QueryBuilder.getAggregation(DesignView.this.getTableModel(), this.colIndex) == null && QueryBuilder.isAggregationEnabled(DesignView.this.getTableModel())) {
                            DesignView.this.table.setValueAt(QueryBuilder.AGGR[1], 3, this.colIndex);
                        }
                    }
                    DesignView.this.setHeaderName(this.colIndex, tmp);
                }
                return tmp;
            }
            if (srcObj instanceof JLabel) {
                return ((JLabel)srcObj).getText();
            }
            if (srcObj instanceof JTextField) {
                return QueryBuilder.formatCondition(DesignView.this.queryMain.getDatabaseType(), ((JTextField)srcObj).getText());
            }
            return super.getCellEditorValue();
        }
    }

    public static class HeaderWithDataTypeObject {
        private String value = null;
        private String dataType = null;

        public HeaderWithDataTypeObject(String value, String dataType) {
            this.value = value;
            this.dataType = dataType;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return DesignView.getColumnHeaderStringWithDataType(this.value, this.dataType);
        }
    }

    private class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        int align = 0;

        public LabelRenderer(int align) {
            this.align = align;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            }
            this.setHorizontalAlignment(this.align);
            this.setBackground(DesignView.this.queryMain.getBackground());
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        public RowHeader(JTable parentTable) {
            super(parentTable.getRowCount(), 1);
            this.setValueAt(LanguageEncoder.getText("Table :"), 0, 0);
            this.setValueAt(LanguageEncoder.getText("Field :"), 1, 0);
            this.setValueAt(LanguageEncoder.getText("Aggregation :"), 3, 0);
            this.setValueAt(LanguageEncoder.getText("Sort :"), 2, 0);
            this.setValueAt(LanguageEncoder.getText("Show :"), 4, 0);
            this.setValueAt(LanguageEncoder.getText("Condition :"), 5, 0);
            this.setValueAt(LanguageEncoder.getText("Or :"), 6, 0);
            int rowCt = this.getRowCount();
            for (int i = 7; i < rowCt; ++i) {
                this.setValueAt("", i, 0);
            }
            TableColumn col = this.getColumnModel().getColumn(0);
            col.setCellRenderer(new LabelRenderer(4));
            Dimension dim = this.getPreferredSize();
            dim.width = 100;
            this.setPreferredSize(dim);
        }

        @Override
        public boolean isCellSelected(int row, int col) {
            return false;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

