/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ReadDatabase;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.ColumnTreeNode;
import quadbase.querybuilder.designer.CustomParameterDialog;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.QueryBuilder;

public class FormulaBuilderDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    JButton insertButton;
    JButton browseDataButton;
    JCheckBox autoCorrect = null;
    UndoTextArea formulaText;
    String formula;
    boolean isModified = false;
    private DatabaseInfo databaseInfo = null;
    private Component parent = null;
    private JTree tree = null;
    private JPanel mainPanel;
    JList timeDateList;
    JList numericList;
    JList stringList;
    JSplitPane splitPane;
    private boolean fromDataViewCondition = false;
    private String[] defaultParamNames = null;

    public FormulaBuilderDialog(DesignView designView, String formula) {
        super(designView.queryMain, LanguageEncoder.getText("Formula Builder..."), true);
        this.databaseInfo = designView.queryMain.databaseInfo;
        this.parent = designView;
        this.formula = formula;
        this.buildTree(designView.getAllWindows());
        this.init(true);
        this.setPosition();
    }

    public FormulaBuilderDialog(JDialog dview, DatabaseInfo dbinfo, String formula, ColumnFieldWindow[] wins) {
        super(dview, LanguageEncoder.getText("Formula Builder..."), true);
        this.parent = dview;
        this.databaseInfo = dbinfo;
        this.formula = formula;
        this.buildTree(wins);
        this.init(false);
        this.setPosition();
    }

    public FormulaBuilderDialog(JDialog dview, DatabaseInfo dbinfo, String formula, DefaultMutableTreeNode root) {
        this(dview, dbinfo, formula, root, true);
    }

    public FormulaBuilderDialog(JDialog dview, DatabaseInfo dbinfo, String formula, DefaultMutableTreeNode root, boolean showParameterButton) {
        super(dview, LanguageEncoder.getText("Formula Builder..."), true);
        this.parent = dview;
        this.databaseInfo = dbinfo;
        this.formula = formula;
        this.buildTree(root);
        this.fromDataViewCondition = true;
        this.init(showParameterButton);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (dim.getWidth() > screensize.getWidth() * 7.0 / 8.0) {
            dim = new Dimension((int)(screensize.getWidth() * 7.0 / 8.0), (int)dim.getHeight());
        }
        if (dim.getHeight() > screensize.getHeight() * 2.0 / 3.0) {
            dim = new Dimension((int)dim.getWidth(), (int)(screensize.getHeight() * 2.0 / 3.0));
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    void init(boolean includeParameter) {
        this.setBackground(Color.lightGray);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.formulaText = new UndoTextArea();
        if (this.formula != null) {
            this.formulaText.setText(this.formula);
        }
        scrollPane.getViewport().add(this.formulaText);
        JScrollPane helper = null;
        try {
            helper = this.getHelperPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (helper == null) {
            p2.add((Component)scrollPane, "Center");
            p2.add((Component)this.getToolBar(includeParameter), "South");
        } else {
            this.splitPane = new JSplitPane(1, false);
            Dimension d = scrollPane.getPreferredSize();
            scrollPane.setPreferredSize(new Dimension(400, (int)d.getHeight()));
            this.splitPane.setLeftComponent(scrollPane);
            this.splitPane.setRightComponent(helper);
            p2.setBorder(new BevelBorder(1));
            p2.add((Component)this.splitPane, "Center");
            p2.add((Component)this.getToolBar(includeParameter), "South");
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(1));
        this.autoCorrect = new JCheckBox("Auto-Correct Formula");
        this.autoCorrect.setHorizontalTextPosition(2);
        pb.add(this.autoCorrect);
        pb.add(this.okButton);
        pb.add(this.cancelButton);
        this.mainPanel = p2;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p2);
        contentPane.add("South", pb);
        this.pack();
    }

    private JPanel getToolBar(boolean includeParameter) {
        JPanel panel = new JPanel();
        if (IOUtil.isMac()) {
            panel.setLayout(new GridLayout(4, 1));
        } else {
            panel.setLayout(new GridLayout(3, 1));
        }
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(1));
        panel1.add(this.newJButton(" + "));
        panel1.add(this.newJButton(" - "));
        panel1.add(this.newJButton(" / "));
        panel1.add(this.newJButton(" * "));
        panel1.add(this.newJButton(" & "));
        panel1.add(this.newJButton(" = "));
        panel1.add(this.newJButton(" <> "));
        JPanel panel1a = null;
        if (IOUtil.isMac()) {
            panel1a = new JPanel();
            panel1a.setLayout(new FlowLayout(1));
        } else {
            panel1a = panel1;
        }
        panel1a.add(this.newJButton(" > "));
        panel1a.add(this.newJButton(" < "));
        panel1a.add(this.newJButton(" <= "));
        panel1a.add(this.newJButton(" >= "));
        panel1a.add(this.newJButton(" ( "));
        panel1a.add(this.newJButton(" ) "));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(this.newJButton(" AND "));
        panel2.add(this.newJButton(" OR "));
        panel2.add(this.newJButton(" NOT "));
        panel2.add(this.newJButton(" LIKE "));
        panel2.add(this.newJButton(" BETWEEN "));
        panel2.add(this.newJButton(" IN "));
        panel2.add(this.newJButton(" IS NULL "));
        panel2.add(this.newJButton(" IS NOT NULL "));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(1));
        this.browseDataButton = this.newJButton("Browse Data Field");
        panel3.add(this.browseDataButton);
        if (includeParameter) {
            panel3.add(this.newJButton("PARAMETER"));
        }
        this.insertButton = this.newJButton(" INSERT ");
        panel3.add(this.insertButton);
        panel.add(panel1);
        if (IOUtil.isMac()) {
            panel.add(panel1a);
        }
        panel.add(panel2);
        panel.add(panel3);
        return panel;
    }

    private JButton newJButton(String str) {
        JButton tmp = new JButton(str);
        tmp.addActionListener(this);
        return tmp;
    }

    private void insertText(String newStr) {
        if (newStr == null) {
            return;
        }
        this.formulaText.replaceSelection(newStr);
    }

    private JScrollPane getHelperPanel() throws Exception {
        DefaultMutableTreeNode root = null;
        if (this.tree != null) {
            root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        } else {
            root = new DefaultMutableTreeNode("ROOT");
            this.tree = new JTree(root);
        }
        Vector functionFolders = this.databaseInfo.getFunctions();
        if (functionFolders != null) {
            for (int i = 0; i < functionFolders.size(); ++i) {
                Vector vec = (Vector)functionFolders.elementAt(i);
                if (vec.size() <= 1) continue;
                root.add(this.getFunctions(vec));
            }
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = FormulaBuilderDialog.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() >= 2) {
                    FormulaBuilderDialog.this.insertText(FormulaBuilderDialog.this.getSelectedText());
                }
            }
        });
        this.tree.setRootVisible(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        Dimension d = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        return scrollPane;
    }

    private void buildTree(ColumnFieldWindow[] windows) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        try {
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Tables");
            for (ColumnFieldWindow window : windows) {
                String[] colnames;
                MyMutableTreeNode node = new MyMutableTreeNode(window.getDisplayName());
                node.setTableName(window.getTableName());
                for (String colname : colnames = window.getColumns()) {
                    node.add(new DefaultMutableTreeNode(colname));
                }
                tableNode.add(node);
            }
            root.add(tableNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tree = new JTree(root);
    }

    private void buildTree(DefaultMutableTreeNode viewroot) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        try {
            int i;
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Fields");
            Vector<TreeNode> children = new Vector<TreeNode>();
            for (i = 0; i < viewroot.getChildCount(); ++i) {
                if (!viewroot.getChildAt(i).getAllowsChildren()) continue;
                children.add(viewroot.getChildAt(i));
            }
            for (i = 0; i < children.size(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.elementAt(i);
                child.removeFromParent();
                tableNode.add(child);
            }
            root.add(tableNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tree = new JTree(root);
    }

    private DefaultMutableTreeNode getFunctions(Vector vec) throws Exception {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(vec.elementAt(0));
        for (int i = 1; i < vec.size(); ++i) {
            node.add(new DefaultMutableTreeNode(vec.elementAt(i)));
        }
        return node;
    }

    boolean isModified() {
        return this.isModified;
    }

    String getFormula() {
        return this.formula;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.insertButton) {
            this.insertText(this.getSelectedText());
        } else if (e.getSource() == this.browseDataButton) {
            if (this.tree.isSelectionEmpty()) {
                new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("Select a leaf node from the Database Fields folder in the upper right panel"));
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (!node.isLeaf()) {
                new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("Select a leaf node from the Database Fields folder in the upper right panel"));
                return;
            }
            DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tableNode.getParent();
            if (parent != null && parent.getUserObject().toString().equals("Tables")) {
                String tableName = tableNode.getUserObject().toString();
                if (tableNode instanceof MyMutableTreeNode) {
                    tableName = ((MyMutableTreeNode)tableNode).getTableName();
                }
                String columnName = node.getUserObject().toString();
                try {
                    ReadDatabase readDB = new ReadDatabase(this.databaseInfo.getURL(), this.databaseInfo.getDriver(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword());
                    String query = QbUtil.buildSelectQuery(readDB, columnName, tableName);
                    Vector vec = readDB.excuteQuery(query, 0, 20);
                    String[] listData = new String[vec.size()];
                    for (int i = 0; i < vec.size(); ++i) {
                        if (((Vector)vec.elementAt(i)).elementAt(0) == null) continue;
                        listData[i] = ((Vector)vec.elementAt(i)).elementAt(0).toString();
                    }
                    JScrollPane list = new JScrollPane(new JList<String>(listData));
                    new JMessageDialog((Dialog)this, tableName + "." + columnName, (JComponent)list);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
                }
            } else if (parent != null && parent.getUserObject().toString().equals("Fields") && node instanceof ColumnTreeNode) {
                try {
                    ColumnTreeNode cnode = (ColumnTreeNode)node;
                    ReadDatabase readDB = new ReadDatabase(this.databaseInfo.getURL(), this.databaseInfo.getDriver(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword());
                    String query = cnode.getColumnListSQL(readDB.getProductName());
                    Vector vec = readDB.excuteQuery(query, 0, 20);
                    String[] listData = new String[vec.size()];
                    for (int i = 0; i < vec.size(); ++i) {
                        if (((Vector)vec.elementAt(i)).elementAt(0) == null) continue;
                        listData[i] = ((Vector)vec.elementAt(i)).elementAt(0).toString();
                    }
                    JScrollPane list = new JScrollPane(new JList<String>(listData));
                    new JMessageDialog((Dialog)this, cnode.getColumnName(), (JComponent)list);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
                }
            } else if (parent != null && parent.getUserObject().toString().equals("Fields") && node.getUserObject() instanceof ColumnTreeNode) {
                try {
                    ColumnTreeNode cnode = (ColumnTreeNode)node.getUserObject();
                    ReadDatabase readDB = new ReadDatabase(this.databaseInfo.getURL(), this.databaseInfo.getDriver(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword());
                    String query = cnode.getColumnListSQL(readDB.getProductName());
                    Vector vec = readDB.excuteQuery(query, 0, 20);
                    String[] listData = new String[vec.size()];
                    for (int i = 0; i < vec.size(); ++i) {
                        if (((Vector)vec.elementAt(i)).elementAt(0) == null) continue;
                        listData[i] = ((Vector)vec.elementAt(i)).elementAt(0).toString();
                    }
                    JScrollPane list = new JScrollPane(new JList<String>(listData));
                    new JMessageDialog((Dialog)this, cnode.getColumnName(), (JComponent)list);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
                }
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), "Highlighted item is not a database field, please select a database field");
            }
        } else if (e.getSource() == this.okButton) {
            String msg = null;
            try {
                this.formula = this.autoCorrect != null && this.autoCorrect.isSelected() ? QueryBuilder.formatCondition(QueryMain.getDatabaseType(this.databaseInfo), this.formulaText.getText()) : this.formulaText.getText();
            }
            catch (Exception ex) {
                msg = "There is an error in the formula. Please verify the syntax is correct";
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
            } else {
                this.isModified = true;
                this.setVisible(false);
                this.dispose();
                this.parent.repaint();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
            this.parent.repaint();
        } else if (e.getSource() instanceof JButton) {
            if (((JButton)e.getSource()).getText().equals("PARAMETER")) {
                if (this.defaultParamNames == null) {
                    String inputValue = JOptionPane.showInputDialog(this, (Object)LanguageEncoder.getText("Parameter Name:"));
                    if (inputValue != null && !inputValue.equals("")) {
                        this.insertText(" :" + this.replaceCharacters(inputValue) + " ");
                    }
                } else {
                    CustomParameterDialog cDialog = new CustomParameterDialog(this, this.defaultParamNames);
                    cDialog.setVisible(true);
                    if (cDialog.isModified()) {
                        this.insertText(" :" + cDialog.getText() + " ");
                    }
                }
            } else {
                this.insertText(((JButton)e.getSource()).getText());
            }
        }
    }

    private String getSelectedText() {
        try {
            if (this.tree.isSelectionEmpty()) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (!node.isLeaf()) {
                return null;
            }
            DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)node.getParent();
            if (((DefaultMutableTreeNode)tableNode.getParent()).isRoot()) {
                return (String)node.getUserObject();
            }
            Object tableName = null;
            Object columnName = null;
            if (!this.fromDataViewCondition) {
                tableName = tableNode.getUserObject();
                columnName = node.getUserObject();
            } else {
                if (node instanceof ColumnTreeNode) {
                    return "{" + tableNode.getUserObject() + "." + ((ColumnTreeNode)node).getAlias() + "}";
                }
                if (node.getUserObject() instanceof ColumnTreeNode) {
                    return "{" + tableNode.getUserObject() + "." + ((ColumnTreeNode)node.getUserObject()).getAlias() + "}";
                }
            }
            if (tableName != null && columnName != null) {
                int databaseType = 0;
                try {
                    databaseType = QueryBuilder.mapDatabaseType(this.databaseInfo.getProductName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return QueryBuilder.printExpression(databaseType, tableName, columnName);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String replaceCharacters(String text) {
        if (text == null) {
            return "PARAMETER";
        }
        String ret = "";
        for (int i = 0; i < text.length(); ++i) {
            ret = Character.isLetterOrDigit(text.charAt(i)) ? ret + text.charAt(i) : ret + "_";
        }
        return ret;
    }

    JPanel getMainPanel() {
        return this.mainPanel;
    }

    void updateTables(ColumnFieldWindow[] windows) {
        if (this.tree != null) {
            try {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)root.getFirstChild();
                tableNode.removeAllChildren();
                for (ColumnFieldWindow window : windows) {
                    String[] colnames;
                    MyMutableTreeNode node = new MyMutableTreeNode(window.getDisplayName());
                    node.setTableName(window.getTableName());
                    for (String colname : colnames = window.getColumns()) {
                        node.add(new DefaultMutableTreeNode(colname));
                    }
                    tableNode.add(node);
                }
                ((DefaultTreeModel)this.tree.getModel()).reload();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setFormula(String text) {
        if (text != null) {
            this.formulaText.setText(text);
        }
    }

    String getUnformattedFormula() {
        return this.formulaText.getText();
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    private class MyMutableTreeNode
    extends DefaultMutableTreeNode {
        String tableName;

        MyMutableTreeNode(Object userObject) {
            super(userObject);
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }
}

