/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import quadbase.common.util.internal.IOUtil;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.query.QueryBuilder;

public class JoinLine {
    ColumnFieldWindow list1;
    ColumnFieldWindow list2;
    int index1;
    int index2;
    final int offset = 10;
    final int arrowOffset = 5;
    int ptX1 = -1;
    int ptY1 = -1;
    int ptX2 = -1;
    int ptY2 = -1;
    int property = 0;

    public JoinLine(ColumnFieldWindow list1, int index1, ColumnFieldWindow list2, int index2) {
        this(list1, index1, list2, index2, 0);
    }

    public JoinLine(ColumnFieldWindow list1, int index1, ColumnFieldWindow list2, int index2, int property) {
        this.list1 = list1;
        this.list2 = list2;
        this.index1 = index1;
        this.index2 = index2;
        this.property = property;
    }

    String[] getValues() {
        String[] tmp = new String[]{this.list1.getDisplayName(), this.list1.getColumn(this.index1), this.list2.getDisplayName(), this.list2.getColumn(this.index2), QueryBuilder.JOINPROPERTY[this.property]};
        return tmp;
    }

    String getTableName1() {
        return this.list1.getDisplayName();
    }

    String getTableName2() {
        return this.list2.getDisplayName();
    }

    void setJoinProperty(int property) {
        this.property = property;
    }

    int getJoinProperty() {
        return this.property;
    }

    boolean contains(int x, int y) {
        if (this.ptX1 < 0) {
            return false;
        }
        return this.pickLine(this.ptX1, this.ptY1, this.ptX2, this.ptY2, x, y);
    }

    boolean isRelated(ColumnFieldWindow list) {
        return this.list1 == list || this.list2 == list;
    }

    private boolean pickLine(int x1, int y1, int x2, int y2, int x, int y) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int r = dx * dx + dy * dy;
        if (r == 0) {
            return (x - x1) * (x - x1) + (y - y1) * (y - y1) < 50;
        }
        double t = (double)(-((x2 - x) * dx + (y2 - y) * dy)) / (double)r;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double dx2 = (double)dx * t + (double)x2 - (double)x;
        double dy2 = (double)dy * t + (double)y2 - (double)y;
        return dx2 * dx2 + dy2 * dy2 < 50.0;
    }

    void draw(Graphics g) {
        int y2;
        int y1;
        int x2;
        int x1;
        Rectangle rec1 = this.list1.getCellBounds(this.index1);
        Rectangle rec2 = this.list2.getCellBounds(this.index2);
        if (IOUtil.isMac()) {
            rec1.setSize((int)rec1.getWidth(), 0);
            rec2.setSize((int)rec2.getWidth(), 0);
        }
        int[] xPts = null;
        int[] yPts = null;
        if (rec1.getX() + rec1.getWidth() < rec2.getX() + rec2.getWidth()) {
            x1 = (int)(rec1.getX() + rec1.getWidth());
            x2 = (int)rec2.getX();
            y1 = (int)(rec1.getY() + rec1.getHeight() / 2.0);
            y2 = (int)(rec2.getY() + rec2.getHeight() / 2.0);
            if (this.property == 1) {
                xPts = new int[]{x2, x2 - 5, x2 - 5};
                yPts = new int[]{y2, y2 - 5, y2 + 5};
            } else if (this.property == 2) {
                xPts = new int[]{x1, x1 + 5, x1 + 5};
                yPts = new int[]{y1, y1 - 5, y1 + 5};
            }
        } else {
            x1 = (int)(rec2.getX() + rec2.getWidth());
            x2 = (int)rec1.getX();
            y1 = (int)(rec2.getY() + rec2.getHeight() / 2.0);
            y2 = (int)(rec1.getY() + rec1.getHeight() / 2.0);
            if (this.property == 1) {
                xPts = new int[]{x1, x1 + 5, x1 + 5};
                yPts = new int[]{y1, y1 - 5, y1 + 5};
            } else if (this.property == 2) {
                xPts = new int[]{x2, x2 - 5, x2 - 5};
                yPts = new int[]{y2, y2 - 5, y2 + 5};
            }
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x1 + 10, y1);
        g.drawLine(x2, y2, x2 - 10, y2);
        this.ptX1 = x1 + 10;
        this.ptY1 = y1;
        this.ptX2 = x2 - 10;
        this.ptY2 = y2;
        g.drawLine(this.ptX1, this.ptY1, this.ptX2, this.ptY2);
        if (xPts != null) {
            g.fillPolygon(xPts, yPts, 3);
        }
    }
}

