/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.JoinLine;

public class JoinPropertyDialog
extends JDialog
implements ActionListener {
    boolean isModified = false;
    int property = 0;
    JRadioButton inner;
    JRadioButton left;
    JRadioButton right;
    String table1;
    String table2;
    JButton okButton;
    JButton cancelButton;

    public JoinPropertyDialog(JFrame frame, JoinLine selectedJoinLine) {
        super(frame, LanguageEncoder.getText("Join Properties..."), true);
        this.property = selectedJoinLine.getJoinProperty();
        this.table1 = selectedJoinLine.getTableName1();
        this.table2 = selectedJoinLine.getTableName2();
        this.init();
        this.setPosition();
    }

    public JoinPropertyDialog(JDialog dialog, JoinLine selectedJoinLine) {
        super(dialog, LanguageEncoder.getText("Join Properties..."), true);
        this.property = selectedJoinLine.getJoinProperty();
        this.table1 = selectedJoinLine.getTableName1();
        this.table2 = selectedJoinLine.getTableName2();
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(3, 1));
        this.inner = new JRadioButton(LanguageEncoder.getText("Only include rows where the joined fields from both tables are equal."), this.property == 0);
        p1.add(this.inner);
        this.left = new JRadioButton(LanguageEncoder.getText("Include ALL records from '") + this.table1 + LanguageEncoder.getText("' and only those records from '") + this.table2 + LanguageEncoder.getText("' where the joined fields are equal."), this.property == 1);
        p1.add(this.left);
        this.right = new JRadioButton(LanguageEncoder.getText("Include ALL records from '") + this.table2 + LanguageEncoder.getText("' and only those records from '") + this.table1 + LanguageEncoder.getText("' where the joined fields are equal."), this.property == 2);
        p1.add(this.right);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.inner);
        bg.add(this.left);
        bg.add(this.right);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(1));
        pb.add(this.okButton);
        pb.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", pb);
        this.pack();
    }

    boolean isModified() {
        return this.isModified;
    }

    private int getSelectedButton() {
        if (this.left.isSelected()) {
            return 1;
        }
        if (this.right.isSelected()) {
            return 2;
        }
        return 0;
    }

    int getJoinProperty() {
        return this.property;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.isModified = true;
            this.property = this.getSelectedButton();
        }
        this.setVisible(false);
        this.dispose();
    }
}

