/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.DesignView;

class PopupMenuForColumnWindow
extends JPopupMenu
implements ActionListener {
    private boolean isReady = false;
    private DesignView designView;
    private ColumnFieldWindow colWindow;
    private JCheckBoxMenuItem alpha = null;

    public PopupMenuForColumnWindow(DesignView designView, ColumnFieldWindow colWindow) {
        this.designView = designView;
        this.colWindow = colWindow;
        this.addMenu();
    }

    private void addMenu() {
        this.isReady = false;
        this.removeAll();
        this.add(this.newMenuItem(LanguageEncoder.getText("Alias")));
        this.add(this.newMenuItem(LanguageEncoder.getText("Delete")));
        this.addSeparator();
        this.alpha = new JCheckBoxMenuItem(LanguageEncoder.getText("Alphabetize"), this.colWindow.isAlphabetized());
        this.alpha.addActionListener(this);
        this.add(this.alpha);
        this.isReady = true;
    }

    private JMenuItem newMenuItem(String s) {
        JMenuItem m = new JMenuItem(s);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menuStr = ((JMenuItem)e.getSource()).getText();
        if (menuStr.equals(LanguageEncoder.getText("Delete"))) {
            this.designView.deleteColumnWindow(this.colWindow);
            this.designView.queryMain.repaint();
        } else if (menuStr.equals(LanguageEncoder.getText("Alias"))) {
            String tmp = JOptionPane.showInputDialog(this.designView.queryMain, LanguageEncoder.getText("Enter Alias :"), LanguageEncoder.getText("Table Alias"), 3);
            if (tmp != null && !tmp.equals("")) {
                if (this.containsIllegalCharacters(tmp)) {
                    new JMessageDialog((Dialog)this.designView.queryMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Table alias contains illegal characters.") + " " + LanguageEncoder.getText("Please use only letters or numbers."));
                } else if (!this.designView.isTableAliasExisted(tmp)) {
                    this.designView.updateTableName(this.colWindow.getDisplayName(), tmp);
                    this.colWindow.setDisplayName(tmp);
                } else {
                    new JMessageDialog((Dialog)this.designView.queryMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Can't repeat table name") + " " + tmp);
                }
            }
        } else if (menuStr.equals(LanguageEncoder.getText("Alphabetize"))) {
            this.colWindow.orderColumns(!this.colWindow.isAlphabetized());
            this.alpha.setState(this.colWindow.isAlphabetized());
        } else {
            System.out.println("ActionPerform : " + menuStr);
        }
    }

    private boolean containsIllegalCharacters(String alias) {
        for (int i = 0; i < alias.length(); ++i) {
            if (Character.isLetterOrDigit(alias.charAt(i)) || alias.charAt(i) == ' ' || alias.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }
}

