/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.DesignView;

class PopupMenuForQBETable
extends JPopupMenu
implements ActionListener {
    private boolean isReady = false;
    private DesignView designView;
    private JMenuItem buildItem;

    public PopupMenuForQBETable(DesignView designView) {
        this.designView = designView;
        this.addMenu();
    }

    private void addMenu() {
        this.isReady = false;
        this.removeAll();
        this.add(this.newMenuItem(LanguageEncoder.getText("Alias")));
        this.buildItem = this.newMenuItem(LanguageEncoder.getText("Build"));
        this.add(this.buildItem);
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Row")));
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Column")));
        this.add(this.newMenuItem(LanguageEncoder.getText("Delete Column")));
        this.addSeparator();
        this.isReady = true;
    }

    void setBuildEnabled(boolean b) {
        this.buildItem.setEnabled(b);
    }

    private JMenuItem newMenuItem(String s) {
        JMenuItem m = new JMenuItem(s);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menuStr = ((JMenuItem)e.getSource()).getText();
        if (menuStr.equals(LanguageEncoder.getText("Alias"))) {
            String tmp = (String)JOptionPane.showInputDialog(this.designView.queryMain, LanguageEncoder.getText("Enter Alias :"), LanguageEncoder.getText("Column Alias"), 3, null, null, this.designView.getHeaderName());
            if (tmp != null && !tmp.equals("")) {
                if (this.containsInvalidChar(tmp = this.formatAlias(tmp))) {
                    new JMessageDialog((Dialog)this.designView.queryMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("It contains invalid character!"));
                    return;
                }
                String subTmp = tmp;
                if (tmp.length() > 1 && tmp.indexOf(32) < 0) {
                    subTmp = tmp.substring(1, tmp.length() - 1);
                }
                if (!this.designView.isColumnAliasExisted(-1, tmp) && !this.designView.isColumnAliasExisted(-1, subTmp)) {
                    this.designView.setHeaderName(tmp);
                } else {
                    new JMessageDialog((Dialog)this.designView.queryMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Can't repeat table name"));
                }
            }
        } else if (menuStr.equals(LanguageEncoder.getText("Insert Row"))) {
            this.designView.insertRow();
        } else if (menuStr.equals(LanguageEncoder.getText("Insert Column"))) {
            this.designView.insertColumn();
        } else if (menuStr.equals(LanguageEncoder.getText("Delete Column"))) {
            this.designView.deleteColumn();
        } else if (menuStr.equals(LanguageEncoder.getText("Build"))) {
            this.designView.queryMain.buildFormula();
        } else {
            System.out.println("ActionPerform : " + menuStr);
        }
    }

    private String formatAlias(String alias) {
        if (alias.indexOf(32) >= 0) {
            return alias;
        }
        String ret = "";
        for (int i = 0; i < alias.length(); ++i) {
            ret = alias.charAt(i) == '\'' ? ret + "''" : ret + alias.charAt(i);
        }
        return ret;
    }

    private boolean containsInvalidChar(String alias) {
        for (int i = 0; i < alias.length(); ++i) {
            char c = alias.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '\"' || c == ' ' || c == '_') continue;
            return true;
        }
        return false;
    }
}

