/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.DataSheetView;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SQLView;
import quadbase.querybuilder.query.QueryBuilder;

public class QBEWindow
extends JPanel
implements ChangeListener {
    private QueryMain queryMain;
    private JTabbedPane mainPanel;
    DesignView designView;
    SQLView sqlView;
    DataSheetView dataSheetView;
    private QueryInParamSet paramSet = null;
    private int lastTabIndex = 0;

    public QBEWindow(QueryMain queryMain) {
        this.queryMain = queryMain;
        this.init();
    }

    private void init() {
        this.mainPanel = new JTabbedPane();
        this.mainPanel.insertTab(LanguageEncoder.getText("Design View"), null, this.getDesignPanel(), null, 0);
        this.mainPanel.insertTab(LanguageEncoder.getText("SQL View"), null, this.getSQLPanel(), null, 1);
        this.mainPanel.insertTab(LanguageEncoder.getText("Datasheet View"), null, this.getDatasheetPanel(), null, 2);
        this.mainPanel.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.queryMain.getQueryMenuBar().setDesignMenuEnabled();
    }

    private JPanel getDesignPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.designView = new DesignView(this.queryMain);
        panel.add((Component)this.designView, "Center");
        return panel;
    }

    private JPanel getSQLPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.sqlView = new SQLView(this.buildQuery());
        panel.add((Component)this.sqlView, "Center");
        return panel;
    }

    private JPanel getDatasheetPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.dataSheetView = new DataSheetView(this.queryMain, "*", new Vector<String>());
        panel.add((Component)this.dataSheetView, "Center");
        return panel;
    }

    void showTable(String tableName) throws Exception {
        this.designView.showTable(tableName);
    }

    public void goToPanel(int selectedIndex) {
        this.setPanel(selectedIndex);
        this.mainPanel.setSelectedIndex(selectedIndex);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPanel(this.mainPanel.getSelectedIndex());
        this.lastTabIndex = this.mainPanel.getSelectedIndex();
    }

    private void setPanel(int selectedIndex) {
        this.queryMain.resetSessionTimeoutInterval();
        if (selectedIndex == 1) {
            this.dataSheetView.cancelQuery();
            this.queryMain.getQueryMenuBar().setViewMenuEnabled();
            if (!this.sqlView.isModified()) {
                this.sqlView.setQuery(this.buildQuery());
            }
            this.sqlView.editor.requestFocus();
        } else if (selectedIndex == 2) {
            this.queryMain.getQueryMenuBar().setPreviewMenuEnabled();
            this.updateDataSheet();
        } else if (selectedIndex == 0) {
            this.dataSheetView.cancelQuery();
            this.queryMain.getQueryMenuBar().setDesignMenuEnabled();
            if (this.sqlView.isModified()) {
                JMessageDialog msgDialog = new JMessageDialog((Dialog)this.queryMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You may lose the query that you modified, continue?"), 2);
                int response = msgDialog.getResponse();
                if (response == 4) {
                    this.sqlView.resetQuery();
                } else {
                    this.goToPanel(1);
                }
            }
        }
        this.queryMain.setCursor(null);
        this.queryMain.setTitle(this.queryMain.getQueryTitle());
    }

    String buildQuery() {
        try {
            this.designView.getTable().editCellAt(-1, -1);
            this.designView.getTable().clearSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        QueryBuilder builder = QueryBuilder.create(this.queryMain.getDatabaseType(), this.designView.getTable(), this.designView.getAllWindows(), this.designView.getJoinProperties());
        builder.setSelectDistinct(this.queryMain.isSelectDistinct());
        String query = builder.buildQuery();
        if (this.queryMain.getBeforeSQL() != null && !this.queryMain.getBeforeSQL().trim().equals("")) {
            query = this.queryMain.getBeforeSQL().trim() + (this.queryMain.getBeforeSQL().trim().endsWith(";") ? "" : ";") + "\n\n" + query;
        }
        if (this.queryMain.getAfterSQL() != null && !this.queryMain.getAfterSQL().trim().equals("")) {
            query = query + (query.trim().endsWith(";") ? "" : ";") + "\n\n" + this.queryMain.getAfterSQL().trim() + (this.queryMain.getAfterSQL().trim().endsWith(";") ? "" : ";");
        }
        return query;
    }

    private void updateDataSheet() {
        String query;
        if (!this.sqlView.isModified()) {
            QueryBuilder qryBuilder = QueryBuilder.create(this.queryMain.getDatabaseType(), this.designView.getTable(), this.designView.getAllWindows(), this.designView.getJoinProperties());
            qryBuilder.buildQuery();
            query = this.buildQuery();
        } else {
            query = this.sqlView.getQuery();
        }
        try {
            this.designView.getTable().editCellAt(-1, -1);
            this.designView.getTable().clearSelection();
        }
        catch (Exception qryBuilder) {
            // empty catch block
        }
        Object pSet = this.getParamSet(QueryParser.removeComments(query));
        if (pSet != null && pSet instanceof String) {
            this.goToPanel(this.lastTabIndex);
            return;
        }
        this.dataSheetView.updateDataSheet(query, (QueryInParamSet)pSet);
    }

    Object getParamSet(String query) {
        return this.getParamSet(query, this.paramSet);
    }

    Object getParamSet(String query, QueryInParamSet paramSet) {
        QueryInParamSet pset = null;
        try {
            if (QueryParser.hasParameters(query)) {
                boolean initializationRequired = true;
                pset = QueryParser.filterParameters(query, paramSet);
                if (pset != null) {
                    QueryInParam[] params = pset.getParameter();
                    for (int i = 0; i < params.length; ++i) {
                        initializationRequired = false;
                        if (params[i] != null) continue;
                        initializationRequired = true;
                        i = params.length;
                    }
                }
                if (initializationRequired) {
                    paramSet = null;
                    this.queryMain.showParameters();
                    if (paramSet == null) {
                        return "CANCEL";
                    }
                    pset = paramSet;
                }
                DBInfoBasic newDBInfo = this.queryMain.databaseInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.queryMain.databaseInfo.getJNDIName(), query, this.queryMain.databaseInfo.getEnvProperties()) : new DBInfoBasic(this.queryMain.databaseInfo.getURL(), this.queryMain.databaseInfo.getDriver(), this.queryMain.databaseInfo.getUserName(), this.queryMain.databaseInfo.getPassword(), query, this.queryMain.databaseInfo.getAdditionalDb());
                QueryFileInfo qfi = new QueryFileInfo("", 0, newDBInfo, pset);
                EnterInParamDialog eDialog = new EnterInParamDialog((Frame)null, qfi, true);
                eDialog.setVisible(true);
                if (eDialog.isCancelled()) {
                    return "CANCEL";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pset;
    }

    public void setInSet(QueryInParamSet s) {
        this.paramSet = s;
    }
}

