/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Component;
import java.awt.Frame;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.IDBConnection;
import quadbase.common.util.internal.IInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.querybuilder.designer.QueryMain;

public class QbQueryBuilder {
    private QueryMain queryMain;

    public QbQueryBuilder(Object parent, IInterchange interchange) {
        QbUtil.setWindowsLAF();
        ServerMessage.useServer = true;
        ServerMessage.setParent(parent);
        this.startProgram(parent, interchange);
        if (this.queryMain == null) {
            return;
        }
    }

    private void startProgram(Object parent, IInterchange interchange) {
        try {
            this.queryMain = new QueryMain(interchange);
        }
        catch (Exception ex) {
            System.out.println("Cannot start program!");
            JFrame f = null;
            if (parent instanceof Component) {
                f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)parent);
            }
            new JMessageDialog((Frame)f, LanguageEncoder.getText("Error"), ex.toString());
        }
    }

    public boolean openQuery(String sqlName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password) {
        this.queryMain.setQueryFile(sqlName);
        boolean b = this.queryMain.openQuery(sqlName, useJNDIDataSource, JNDIName, env, driver, url, username, password);
        this.queryMain.qbeWindow.designView.setDividerLocation(0.7);
        return b;
    }

    public boolean openQuery(String sqlName, IDBConnection connection) {
        this.queryMain.setQueryFile(sqlName);
        boolean b = this.queryMain.openQuery(sqlName, false, null, null, null, null, null, null, null, null, connection);
        this.queryMain.qbeWindow.designView.setDividerLocation(0.7);
        return b;
    }

    public boolean newQuery(String sqlName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password) {
        this.queryMain.newQuery(sqlName, useJNDIDataSource, JNDIName, env, driver, url, username, password, null, null);
        this.queryMain.qbeWindow.designView.setDividerLocation(0.7);
        return true;
    }

    public boolean newQuery(String sqlName, IDBConnection connection) {
        this.queryMain.newQuery(sqlName, false, null, null, null, null, null, null, null, connection);
        this.queryMain.qbeWindow.designView.setDividerLocation(0.7);
        return true;
    }

    public JDialog getBuilder() {
        return this.queryMain;
    }

    public boolean isSaveOnExit() {
        return this.queryMain.isSaveOnExit();
    }

    public void setSaveOnExit(boolean b) {
        this.queryMain.setSaveOnExit(b);
    }

    public void save() {
        this.queryMain.save();
    }

    public void save(String sqlName) {
        this.queryMain.saveFile(sqlName);
    }

    public void showTablesWindow() throws Exception {
        this.queryMain.showTablesWindow();
    }

    public String getSQL() {
        return this.queryMain.getSQL();
    }

    public void setVisible(boolean b) {
        this.queryMain.setVisible(b);
    }

    public void dispose() {
        this.queryMain.dispose();
    }

    public QueryInParamSet getInSet() {
        return this.queryMain.getInSet();
    }
}

