/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;

public class QualifiedNameDialog
extends JDialog
implements ActionListener {
    public static final int UNQUALIFIED = 0;
    public static final int TWO_PART = 1;
    public static final int THREE_PART = 2;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton unqualified;
    private JRadioButton twoPart;
    private JRadioButton threePart;
    private int initialFormat;
    private boolean modified = false;

    public QualifiedNameDialog(JFrame parent, int it) {
        super(parent, "Table Name Format", true);
        this.initialFormat = it;
        this.init();
    }

    public QualifiedNameDialog(JDialog parent, int it) {
        super(parent, "Table Name Format", true);
        this.initialFormat = it;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        ButtonGroup bgroup = new ButtonGroup();
        this.unqualified = new JRadioButton(LanguageEncoder.getText("Unqualified Name"));
        this.twoPart = new JRadioButton(LanguageEncoder.getText("2-Part Qualified Name"));
        this.threePart = new JRadioButton(LanguageEncoder.getText("3-Part Qualified Name"));
        bgroup.add(this.unqualified);
        bgroup.add(this.twoPart);
        bgroup.add(this.threePart);
        if (this.initialFormat == 1) {
            this.twoPart.setSelected(true);
        } else if (this.initialFormat == 2) {
            this.threePart.setSelected(true);
        } else {
            this.unqualified.setSelected(true);
        }
        JPanel topPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        topPanel.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 2, 10);
        gridbag.setConstraints(this.unqualified, c);
        topPanel.add(this.unqualified);
        c.gridy = 1;
        c.insets = new Insets(2, 10, 2, 10);
        gridbag.setConstraints(this.twoPart, c);
        topPanel.add(this.twoPart);
        c.gridy = 2;
        c.insets = new Insets(2, 10, 10, 10);
        gridbag.setConstraints(this.threePart, c);
        topPanel.add(this.threePart);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", topPanel);
        contentPane.add("South", bottomPanel);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getSelectedFormat() {
        if (this.twoPart.isSelected()) {
            return 1;
        }
        if (this.threePart.isSelected()) {
            return 2;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.modified = e.getSource() == this.okButton;
        this.setVisible(false);
        this.dispose();
    }
}

