/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.IDBConnection;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.IDataInterchangePlus;
import quadbase.common.util.internal.IInterchange;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.QueryBuilderProcess;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.DatabaseInfoDialog;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.FormulaBuilderDialog;
import quadbase.querybuilder.designer.QBEWindow;
import quadbase.querybuilder.designer.QualifiedNameDialog;
import quadbase.querybuilder.designer.QueryMenuBar;
import quadbase.querybuilder.designer.SimpleQBEWindow;
import quadbase.querybuilder.designer.SupplementSQLDialog;
import quadbase.querybuilder.designer.TableWindow;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.LoadQuery;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.querybuilder.query.SaveQuery;
import quadbase.reportdesigner.report.Parameter;

public class QueryMain
extends JDialog
implements WindowListener,
KeyListener {
    private boolean isModified = false;
    private QueryMenuBar menuBar;
    private JPanel desktopPane;
    QBEWindow qbeWindow = null;
    private SimpleQBEWindow sqbeWindow = null;
    TableWindow tblWindow = null;
    DatabaseInfo databaseInfo;
    UIManager.LookAndFeelInfo[] lookAndFeel = null;
    boolean isUpdating = false;
    String title = "EspressQuery 1.0";
    static String WAIT_TITLE = LanguageEncoder.getText("Please wait...");
    private long lockTime = 0L;
    private String lockTable = "";
    public static String QUERYDIR = "queries/";
    public IInterchange interProcess;
    private String queryFile = "QUERYFILE";
    private Vector dictionaries = new Vector();
    private QueryInParamSet paramSet = null;
    private Vector reportParameters = null;
    private String[] parameterMap = null;
    boolean modifiedParameter = false;
    private boolean selectDistinct = false;
    private boolean saveOnExit = true;
    private boolean isAutoJoinEnabled = true;
    private int tableNameFormat = 0;
    private byte[] fileBytes = null;
    private Vector multipleDb = null;
    private String[] defaultParamNames = null;
    private boolean defaultValueRequired = false;
    private String beforeSQL = null;
    private String afterSQL = null;
    BrowseDirectories browseDir;
    private boolean isSaved = false;
    private static Object replaceColInfoList = null;

    public QueryMain(IInterchange interProcess) {
        this.interProcess = interProcess;
        this.initialize();
    }

    public QueryMain(JDialog parent, IInterchange interProcess) {
        this(parent, interProcess, true);
    }

    public QueryMain(JDialog parent, IInterchange interProcess, boolean autoJoin) {
        super((Dialog)parent, true);
        this.interProcess = interProcess;
        this.setAutoJoinEnabled(autoJoin);
        this.initialize();
    }

    private void initialize() {
        this.isUpdating = true;
        this.setTitle(this.title);
        this.lookAndFeel = UIManager.getInstalledLookAndFeels();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setJMenuBar(this.getQueryMenuBar());
        this.setContentPane(this.getJFrameContentPane());
        this.isModified = false;
        this.setPosition();
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.isUpdating = false;
        this.browseDir = new QbBrowseDirectories();
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.removeTablesWindow();
        } else if (this.tblWindow != null && this.tblWindow.isVisible()) {
            this.tblWindow.toFront();
        }
        super.setVisible(b);
    }

    private JPanel getJFrameContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setName("JFrameContentPane");
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.getQueryDesignerPane(), "Center");
        contentPane.add((Component)this.getStatusPane(), "South");
        return contentPane;
    }

    QueryMenuBar getQueryMenuBar() {
        if (this.menuBar != null) {
            return this.menuBar;
        }
        this.menuBar = new QueryMenuBar(this);
        return this.menuBar;
    }

    private JPanel getQueryDesignerPane() {
        if (this.desktopPane != null) {
            return this.desktopPane;
        }
        this.desktopPane = new JPanel();
        this.desktopPane.setLayout(new BorderLayout());
        return this.desktopPane;
    }

    private JDialog getTablesWindow() throws Exception {
        if (this.tblWindow != null) {
            return this.tblWindow;
        }
        this.tblWindow = new TableWindow(this);
        return this.tblWindow;
    }

    void showTablesWindow() throws Exception {
        this.getTablesWindow().setVisible(true);
        this.getTablesWindow().toFront();
    }

    private void removeTablesWindow() {
        if (this.tblWindow == null) {
            return;
        }
        this.tblWindow.setVisible(false);
        this.tblWindow = null;
    }

    private JPanel getQBEWindow() {
        if (this.qbeWindow != null) {
            return this.qbeWindow;
        }
        this.qbeWindow = new QBEWindow(this);
        return this.qbeWindow;
    }

    public JPanel getSQBEWindow() {
        return this.sqbeWindow;
    }

    public void setSQBEWindow(SimpleQBEWindow sqbeWindow) {
        this.sqbeWindow = sqbeWindow;
    }

    private void showQBEWindow() throws Exception {
        if (this.qbeWindow == null) {
            this.desktopPane.add((Component)this.getQBEWindow(), "Center");
        }
        this.validate();
        this.repaint();
    }

    private JPanel getStatusPane() {
        return new JPanel();
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.8);
        dim.width = (int)((double)screenSize.width * 0.74);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    String getQueryTitle() {
        return this.title;
    }

    public void setQueryFile(String qf) {
        if (qf != null && !qf.trim().equals("")) {
            this.queryFile = qf;
        }
    }

    public void setReportParameters(Vector parameters) {
        this.reportParameters = parameters;
    }

    public void setParameterMap(String[] map) {
        this.parameterMap = map;
    }

    public void setInSet(QueryInParamSet ps) {
        this.paramSet = ps;
    }

    public QueryInParamSet getInSet() {
        return this.paramSet;
    }

    void setModified() {
        this.setModified(true);
    }

    private void setModified(boolean mod) {
        this.isModified = mod;
        this.resetSessionTimeoutInterval();
    }

    public void resetSessionTimeoutInterval() {
        if (this.interProcess != null && this.interProcess instanceof QueryBuilderProcess) {
            ((QueryBuilderProcess)this.interProcess).managerPane.resetSessionTimeoutInterval();
        }
    }

    private boolean isModified() {
        return this.isModified;
    }

    public void setDatabaseInfo(DBInfoBasic dbInfo) {
        try {
            this.databaseInfo = dbInfo.isUseJNDIDataSource() ? new DatabaseInfo(dbInfo.getJNDIName(), dbInfo.getEnvProperties()) : new DatabaseInfo(dbInfo.getDriverName(), dbInfo.getURLString(), dbInfo.getUserID(), dbInfo.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean newQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, Vector multipleDb) {
        return this.newQuery(queryName, useJNDIDataSource, JNDIName, env, driver, url, username, password, multipleDb, null);
    }

    public boolean newQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, Vector multipleDb, IDBConnection conn) {
        this.title = queryName;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setTitle(WAIT_TITLE);
            this.databaseInfo = conn != null ? new DatabaseInfo(conn) : (useJNDIDataSource ? new DatabaseInfo(JNDIName, env) : new DatabaseInfo(driver, url, username, password, multipleDb));
            this.showQBEWindow();
            this.showTablesWindow();
            this.setModified(false);
            this.modifiedParameter = true;
            this.isModified = true;
        }
        catch (Exception ex) {
            this.errorMessage(ex);
            return false;
        }
        this.setCursor(null);
        this.setTitle(this.getQueryTitle());
        return true;
    }

    public boolean openQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password) {
        return this.openQuery(queryName, useJNDIDataSource, JNDIName, env, driver, url, username, password, null);
    }

    public boolean openQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String queryStat) {
        return this.openQuery(queryName, useJNDIDataSource, JNDIName, env, driver, url, username, password, queryStat, null);
    }

    public boolean openQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String queryStat, Vector additionalDb) {
        return this.openQuery(queryName, useJNDIDataSource, JNDIName, env, driver, url, username, password, queryStat, additionalDb, null);
    }

    public boolean openQuery(String queryName, boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, String queryStat, Vector additionalDb, IDBConnection conn) {
        try {
            String file = QUERYDIR + this.queryFile + ".qry";
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setTitle(WAIT_TITLE);
            LoadQuery query = new LoadQuery();
            if ((this.queryFile == null || this.queryFile.equals("QUERYFILE")) && this.fileBytes != null) {
                ByteArrayInputStream bstream = new ByteArrayInputStream(this.fileBytes);
                query.loadQuery(new DataInputStream(bstream));
            } else {
                this.fileBytes = query.loadQueryFromFile(file);
            }
            this.setSelectDistinct(query.isSelectDistinct());
            this.menuBar.distinct.setState(this.isSelectDistinct());
            if (conn != null) {
                this.setQuery(query, conn, queryStat);
            } else if (useJNDIDataSource) {
                this.setQuery(query, JNDIName, env, queryStat);
            } else {
                this.setQuery(query, driver, url, username, password, queryStat, additionalDb);
            }
            this.qbeWindow.setInSet(this.paramSet);
            this.setModified(false);
            this.title = queryName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMessage(LanguageEncoder.getText("The system cannot find the data source specified"));
            return false;
        }
        this.setCursor(null);
        this.setTitle(this.getQueryTitle());
        return true;
    }

    private void setQuery(LoadQuery query, IDBConnection conn, String querySQL) throws Exception {
        this.databaseInfo = new DatabaseInfo(conn);
        this.setQuery(query, querySQL);
    }

    private void setQuery(LoadQuery query, String JNDIName, Hashtable env, String querySQL) throws Exception {
        this.databaseInfo = new DatabaseInfo(JNDIName, env);
        this.setQuery(query, querySQL);
    }

    private void setQuery(LoadQuery query, String driver, String url, String username, String password, String querySQL, Vector additionalDb) throws Exception {
        this.databaseInfo = new DatabaseInfo(driver, url, username, password, additionalDb);
        this.setQuery(query, querySQL);
    }

    private void setQuery(LoadQuery query, String querySQL) throws Exception {
        this.removeTablesWindow();
        this.showQBEWindow();
        this.setTableNameFormat(query.getTableNameFormat());
        this.beforeSQL = query.getBeforeSQL();
        this.afterSQL = query.getAfterSQL();
        this.qbeWindow.designView.setColumnWindows(query.getSelectedTable(), query.getTableAlias(), query.getTableBounds(), query.getDictionaries(), query.getDictionaryAlias(), query.getDictionaryBounds(), query.getJoinProperties());
        this.qbeWindow.designView.setQBEWindow(query.getQBETable(), query.getQBEHeader());
        this.qbeWindow.designView.addDataTypesToTableColumnHeaders();
        String qbeSQL = "";
        if (querySQL != null && !querySQL.equals(qbeSQL = this.qbeWindow.buildQuery())) {
            this.qbeWindow.sqlView.setQuery(qbeSQL);
            this.qbeWindow.sqlView.setDefaultSQL(qbeSQL);
            this.qbeWindow.sqlView.editor.setText(querySQL);
            this.qbeWindow.goToPanel(1);
            return;
        }
        this.qbeWindow.sqlView.setDefaultSQL(this.qbeWindow.buildQuery());
        this.showTablesWindow();
    }

    public void setSaveOnExit(boolean b) {
        this.saveOnExit = b;
    }

    public boolean isSaveOnExit() {
        return this.saveOnExit;
    }

    public boolean save() {
        return this.saveFile(QUERYDIR + this.queryFile + ".qry");
    }

    public boolean saveFile(String fileName) {
        return this.saveFile(fileName, false);
    }

    public boolean saveFile(String fileName, boolean overwriteQuery) {
        boolean dictionaryOK = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setTitle(WAIT_TITLE);
            if (this.getDatabaseType() != 4 && this.getDatabaseType() != 2 && this.getDatabaseType() != 3) {
                String[][] jp;
                if (this.isSelectDistinct()) {
                    dictionaryOK = false;
                }
                JTable table = this.qbeWindow.designView.getTable();
                DefaultTableModel model = (DefaultTableModel)table.getModel();
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    String[][] aggr = (String[][])model.getValueAt(3, col);
                    if (aggr == null || aggr.equals("")) continue;
                    dictionaryOK = false;
                }
                for (String[] element : jp = this.qbeWindow.designView.getJoinProperties()) {
                    if (element[4].equals(QueryBuilder.JOINPROPERTY[0])) continue;
                    dictionaryOK = false;
                }
            }
            Object[][] colresult = null;
            try {
                String query = this.getSQL();
                if (QueryParser.hasParameters(query)) {
                    dictionaryOK = false;
                } else {
                    colresult = this.databaseInfo.getTableInfo(query, true);
                }
            }
            catch (Exception dbe) {
                dictionaryOK = false;
            }
            if (colresult != null) {
                Vector<Object> colnames = new Vector<Object>();
                for (int i = 0; i < colresult.length; ++i) {
                    if (colnames.contains(colresult[i][0])) {
                        dictionaryOK = false;
                        i = colresult.length;
                        continue;
                    }
                    colnames.add(colresult[i][0]);
                }
            }
            DesignView view = this.qbeWindow.designView;
            SaveQuery saveQuery = new SaveQuery(this.databaseInfo.isUseJNDIDataSource(), this.databaseInfo.getJNDIName(), this.databaseInfo.getEnvProperties(), this.databaseInfo.getDriver(), this.databaseInfo.getURL(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword(), view.getTable(), view.getAllWindows(), view.getJoinProperties(), this.isSelectDistinct(), this.getTableNameFormat(), this.paramSet, this.beforeSQL, this.afterSQL);
            if ((this.queryFile == null || this.queryFile.equals("QUERYFILE")) && this.fileBytes != null && !overwriteQuery) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bstream);
                saveQuery.saveData(dout);
                dout.close();
                bstream.close();
                this.fileBytes = bstream.toByteArray();
            } else {
                this.fileBytes = saveQuery.saveToFile(fileName);
            }
            this.setModified(false);
        }
        catch (Exception ex) {
            dictionaryOK = false;
            ex.printStackTrace();
            this.errorMessage(ex);
        }
        this.setCursor(null);
        this.setTitle(this.getQueryTitle());
        return dictionaryOK;
    }

    private boolean keyLock(String tableName) {
        long curTime = System.currentTimeMillis();
        if (curTime - this.lockTime < 5000L && tableName.equals(this.lockTable)) {
            return true;
        }
        this.lockTable = tableName;
        this.lockTime = curTime;
        return false;
    }

    public void setDictionaries(Vector d) {
        if (d != null) {
            this.dictionaries = d;
        }
    }

    public String[][] getDictionaries() {
        String[][] ret = new String[this.dictionaries.size()][2];
        for (int i = 0; i < this.dictionaries.size(); ++i) {
            String[] pair = (String[])this.dictionaries.elementAt(i);
            ret[i][0] = pair[0];
            ret[i][1] = pair[1];
        }
        return ret;
    }

    int getDatabaseType() {
        return QueryMain.getDatabaseType(this.databaseInfo);
    }

    static int getDatabaseType(DatabaseInfo databaseInfo) {
        try {
            return QueryBuilder.mapDatabaseType(databaseInfo.getProductName());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    void showTable(String tableName) {
        if (this.keyLock(tableName)) {
            return;
        }
        ColumnFieldWindow[] allWindows = this.qbeWindow.designView.getAllWindows();
        if (this.getDatabaseType() == 9 && allWindows != null && allWindows.length > 0) {
            this.errorMessage("Cassandra only supports single table in query.");
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setTitle(WAIT_TITLE);
            this.qbeWindow.showTable(tableName);
            this.setModified();
            this.showTablesWindow();
        }
        catch (Exception ex) {
            this.errorMessage(ex);
        }
        this.setCursor(null);
        this.setTitle(this.getQueryTitle());
    }

    void buildFormula() {
        FormulaBuilderDialog builder = new FormulaBuilderDialog(this.qbeWindow.designView, this.qbeWindow.designView.getFormula());
        builder.setDefaultParamNames(this.defaultParamNames);
        builder.setVisible(true);
        if (builder.isModified()) {
            String text = builder.getFormula();
            if (text.indexOf(58) >= 0) {
                this.modifiedParameter = true;
            }
            this.qbeWindow.designView.setFormula(text);
        }
    }

    void cancel() {
        if (this.isSaved) {
            this.interProcess.next();
        } else {
            this.interProcess.cancel();
        }
        this.exit();
    }

    public boolean parameterSharingOK(QueryInParamSet tempParamSet) {
        if (this.reportParameters == null) {
            return true;
        }
        for (int i = 0; i < this.reportParameters.size(); ++i) {
            Parameter parameter = (Parameter)this.reportParameters.elementAt(i);
            if (!parameter.isShared() && !parameter.isShareReferenced()) continue;
            if (tempParamSet == null) {
                return false;
            }
            QueryInParam inParam = tempParamSet.getParameter(parameter.getName());
            if (inParam == null) {
                return false;
            }
            if (inParam.getSqlType() == parameter.getSQLType()) continue;
            return false;
        }
        return true;
    }

    public boolean parameterMappingOK(QueryInParamSet tempParamSet) {
        if (this.reportParameters == null) {
            return true;
        }
        for (int i = 0; i < this.reportParameters.size(); ++i) {
            Parameter parameter = (Parameter)this.reportParameters.elementAt(i);
            if (this.parameterMap == null || this.parameterMap[i] == null) continue;
            if (tempParamSet == null) {
                return false;
            }
            QueryInParam inParam = tempParamSet.getParameter(parameter.getName());
            if (inParam == null) {
                return false;
            }
            if (inParam.getSqlType() == parameter.getSQLType()) continue;
            return false;
        }
        return true;
    }

    boolean fullySave() {
        QueryInParamSet tempParamSet;
        block12: {
            String query = this.getSQL();
            query = QueryParser.removeComments(query);
            tempParamSet = null;
            if (QueryParser.hasParameters(query)) {
                tempParamSet = QueryParser.filterParameters(query, this.paramSet);
                DBInfoBasic dbInfo = null;
                dbInfo = this.databaseInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.databaseInfo.getJNDIName(), query, this.databaseInfo.getEnvProperties()) : new DBInfoBasic(this.databaseInfo.getURL(), this.databaseInfo.getDriver(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword(), query, this.databaseInfo.getAdditionalDb());
                QueryFileInfo qfi = new QueryFileInfo("", 0, dbInfo, tempParamSet);
                boolean verified = false;
                try {
                    QueryFileInfo.verify(qfi);
                    verified = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.modifiedParameter || !verified) {
                    try {
                        boolean showPromptSequence = !this.forChart();
                        INParametersDialog pDialog = new INParametersDialog(this, qfi, showPromptSequence, this.getTableNameFormat());
                        pDialog.setVisible(true);
                        if (pDialog.isModified()) {
                            tempParamSet = pDialog.getQueryInParamSet();
                            if (tempParamSet == null) {
                                throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                            }
                            break block12;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                        return false;
                    }
                }
            }
        }
        if (!this.parameterSharingOK(tempParamSet) || !this.parameterMappingOK(tempParamSet)) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot save query, it violates parameter sharing conditions"));
            return false;
        }
        this.paramSet = tempParamSet;
        this.qbeWindow.setInSet(this.paramSet);
        this.modifiedParameter = false;
        if (this.saveOnExit) {
            boolean isDictionary = this.save();
            if (this.interProcess instanceof QueryBuilderProcess) {
                ((QueryBuilderProcess)this.interProcess).setDictionaryCompatible(isDictionary);
            }
        }
        if (this.interProcess instanceof IDataInterchangePlus) {
            ((IDataInterchangePlus)this.interProcess).save();
        }
        this.isSaved = true;
        return true;
    }

    boolean done() {
        if (!this.fullySave()) {
            return false;
        }
        this.interProcess.next();
        this.exit();
        return true;
    }

    private void exit() {
        if (this.tblWindow != null) {
            this.tblWindow.setVisible(false);
            this.tblWindow.dispose();
        }
        this.setVisible(false);
        this.dispose();
    }

    void showParameters() {
        String query = this.getSQL();
        if (QueryParser.hasParameters(query = QueryParser.removeComments(query))) {
            QueryInParamSet tempParamSet = QueryParser.filterParameters(query, this.paramSet);
            DBInfoBasic dbInfo = null;
            dbInfo = this.databaseInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.databaseInfo.getJNDIName(), query, this.databaseInfo.getEnvProperties()) : new DBInfoBasic(this.databaseInfo.getURL(), this.databaseInfo.getDriver(), this.databaseInfo.getUserName(), this.databaseInfo.getPassword(), query, this.databaseInfo.getAdditionalDb());
            QueryFileInfo qfi = new QueryFileInfo("", 0, dbInfo, tempParamSet);
            try {
                boolean showPromptSequence = !this.forChart();
                INParametersDialog pDialog = new INParametersDialog(this, qfi, false, showPromptSequence, this.getTableNameFormat());
                pDialog.setDefaultValueRequired(this.defaultValueRequired);
                pDialog.setVisible(true);
                if (pDialog.isModified()) {
                    tempParamSet = pDialog.getQueryInParamSet();
                    if (tempParamSet == null) {
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                } else {
                    return;
                }
                this.paramSet = tempParamSet;
                this.qbeWindow.setInSet(this.paramSet);
                this.modifiedParameter = false;
                this.setModified();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                return;
            }
        } else {
            new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("This query does not contain parameters."));
        }
    }

    void setLookAndFeel(String name) {
        if (this.lookAndFeel == null || this.lookAndFeel.length < 1) {
            return;
        }
        int i = 0;
        for (i = 0; i < this.lookAndFeel.length && !this.lookAndFeel[i].getName().equals(name); ++i) {
        }
        if (i >= this.lookAndFeel.length) {
            return;
        }
        try {
            this.isUpdating = true;
            UIManager.setLookAndFeel(this.lookAndFeel[i].getClassName());
            SwingUtilities.updateComponentTreeUI(this);
            if (this.tblWindow != null) {
                SwingUtilities.updateComponentTreeUI(this.tblWindow);
            }
            if (this.qbeWindow != null) {
                this.qbeWindow.designView.setDividerLocation(0.7);
            }
            this.isUpdating = false;
        }
        catch (Exception ex) {
            this.errorMessage(ex);
        }
    }

    void aboutDatabase() {
        DatabaseInfoDialog infoDialog = new DatabaseInfoDialog(this);
        infoDialog.setVisible(true);
    }

    private void errorMessage(Exception ex) {
        this.errorMessage(ex.toString());
    }

    private void errorMessage(String msg) {
        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
    }

    public void export(int exportType, String query) throws Exception {
        String[] ext = exportType == 1 ? new String[]{"CSV"} : new String[]{"SQL"};
        OpenFileDialog fDialog = new OpenFileDialog(this, LanguageEncoder.getText("Export..."), this.browseDir.getQueryExportDir(), ext, this.browseDir.getQueryExportDir(), true);
        fDialog.setVisible(true);
        String tmp = fDialog.getSelectedFile();
        if (tmp == null) {
            return;
        }
        this.browseDir.setQueryExportDir(fDialog.getCurrentDirectory());
        if (!OverWriteDialog.continueSave(this, tmp)) {
            return;
        }
        if (query == null) {
            query = this.getSQL();
        }
        Object pset = null;
        if (exportType == 1) {
            if (this.qbeWindow == null) {
                this.qbeWindow = new QBEWindow(this);
            }
            pset = this.sqbeWindow != null ? this.qbeWindow.getParamSet(query, this.sqbeWindow.getInSet()) : this.qbeWindow.getParamSet(query);
        }
        if (pset != null && pset instanceof String) {
            return;
        }
        this.databaseInfo.export(exportType, tmp, query, (QueryInParamSet)pset);
    }

    public boolean isAutoJoinEnabled() {
        return this.isAutoJoinEnabled;
    }

    public void setAutoJoinEnabled(boolean b) {
        this.isAutoJoinEnabled = b;
    }

    public String getSQL() {
        if (this.qbeWindow.sqlView != null && this.qbeWindow.sqlView.isModified()) {
            return this.qbeWindow.sqlView.getQuery();
        }
        return this.qbeWindow.buildQuery();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!(this.qbeWindow.sqlView == null || this.isSaved || !this.isModified() && this.getSQL().equals(this.qbeWindow.sqlView.getDefaultSQL()))) {
            JMessageDialog dialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Do you want to save?"), 2);
            int val = dialog.getResponse();
            if (val == 4) {
                if (!this.done()) {
                    return;
                }
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDictionary(String alias, String selectedFile) {
        try {
            this.setTitle(WAIT_TITLE);
            this.setCursor(Cursor.getPredefinedCursor(3));
            selectedFile = QUERYDIR + selectedFile + ".qry";
            LoadQuery query = new LoadQuery();
            query.loadQueryFromFile(selectedFile, "qry");
            if (this.databaseInfo.isUseJNDIDataSource() ? !query.getJNDIName().equals(this.databaseInfo.getJNDIName()) : !query.getDriver().equals(this.databaseInfo.getDriver()) || !query.getURL().equals(this.databaseInfo.getURL()) || !query.getUserName().equals(this.databaseInfo.getUserName()) || !query.getPassword().equals(this.databaseInfo.getPassword())) {
                throw new Exception(LanguageEncoder.getText("The Dictionary cannot be loaded.\nThe Dictionary must contain the same Data Source parameters as the query."));
            }
            try {
                this.qbeWindow.designView.showDictionary(query, alias, false);
            }
            catch (Exception dbe) {
                dbe.printStackTrace();
                throw new Exception(LanguageEncoder.getText("The Dictionary does not represent a valid query.\n\n") + dbe.getMessage());
            }
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            this.errorMessage(msg);
        }
        finally {
            this.setCursor(null);
            this.setTitle(this.getQueryTitle());
        }
    }

    void setSelectDistinct(boolean state) {
        this.selectDistinct = state;
    }

    boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public void setTableNameFormat(int format) {
        this.tableNameFormat = format == 1 || format == 2 ? format : 0;
        if (this.tblWindow != null) {
            this.tblWindow.setTableNameFormat(this.tableNameFormat);
        }
    }

    public int getTableNameFormat() {
        if (this.getDatabaseType() == 9 && this.tableNameFormat == 2) {
            return 1;
        }
        return this.tableNameFormat;
    }

    public void setAdditionalDb(Vector dbs) {
        this.multipleDb = dbs;
    }

    public Vector getAdditionalDb() {
        return this.multipleDb;
    }

    void selectTableNameFormat() {
        boolean isVisible = false;
        if (this.tblWindow != null) {
            isVisible = this.tblWindow.isVisible();
            this.tblWindow.setVisible(false);
        }
        QualifiedNameDialog qnDialog = new QualifiedNameDialog(this, this.getTableNameFormat());
        qnDialog.setVisible(true);
        if (qnDialog.isModified()) {
            this.setTableNameFormat(qnDialog.getSelectedFormat());
        }
        if (isVisible) {
            this.tblWindow.setVisible(true);
        }
    }

    public byte[] getQueryFileBytes() {
        return this.fileBytes;
    }

    public void setQueryFileBytes(byte[] bytes) {
        this.fileBytes = bytes;
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    public void setDefaultValueRequiredForParameters(boolean state) {
        this.defaultValueRequired = state;
    }

    public boolean isDefaultValueRequiredForParameters() {
        return this.defaultValueRequired;
    }

    void showSupplementSQL() {
        SupplementSQLDialog sDialog = new SupplementSQLDialog(this, this.beforeSQL, this.afterSQL);
        sDialog.setVisible(true);
        if (sDialog.isModified()) {
            this.beforeSQL = sDialog.getBeforeSQL();
            this.afterSQL = sDialog.getAfterSQL();
        }
    }

    public String getBeforeSQL() {
        return this.beforeSQL;
    }

    public String getAfterSQL() {
        return this.afterSQL;
    }

    public BrowseDirectories getBrowseDirectories() {
        return this.browseDir;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
    }

    public boolean forChart() {
        if (this.interProcess instanceof IDataInterchange) {
            return this.interProcess instanceof ChartWizard;
        }
        if (this.interProcess instanceof QueryBuilderProcess) {
            return ((QueryBuilderProcess)this.interProcess).managerPane.manager.interchange instanceof ChartWizard;
        }
        return false;
    }

    public static void setReplaceColInfoList(Object list) {
        replaceColInfoList = list;
    }

    public static Object getReplaceColInfoList() {
        return replaceColInfoList;
    }
}

