/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.NumericDialog;
import quadbase.querybuilder.designer.QueryMain;

public class QueryMenuBar
extends JMenuBar
implements ActionListener {
    private boolean isReady = false;
    private QueryMain queryMain;
    JMenu editMenu;
    JMenu viewMenu;
    JMenuItem extraSQL = null;
    JCheckBoxMenuItem distinct;
    JCheckBoxMenuItem autoJoin;

    public QueryMenuBar(QueryMain queryMain) {
        this.queryMain = queryMain;
        this.initMenu();
    }

    void setDesignMenuEnabled() {
        this.editMenu.setEnabled(true);
        this.viewMenu.setEnabled(false);
        this.extraSQL.setEnabled(true);
    }

    void setViewMenuEnabled() {
        this.editMenu.setEnabled(false);
        this.viewMenu.setEnabled(false);
        this.extraSQL.setEnabled(false);
    }

    void setPreviewMenuEnabled() {
        this.editMenu.setEnabled(false);
        this.viewMenu.setEnabled(true);
        this.extraSQL.setEnabled(false);
    }

    private void initMenu() {
        this.isReady = false;
        this.addFileMenu();
        this.addEditMenu();
        this.addViewMenu();
        this.addQueryMenu();
        this.isReady = true;
    }

    private void addFileMenu() {
        JMenu fileMenu = new JMenu(LanguageEncoder.getText("File"));
        fileMenu.add(this.addExportMenu());
        fileMenu.addSeparator();
        fileMenu.add(this.newMenuItem(LanguageEncoder.getText("Cancel")));
        fileMenu.add(this.newMenuItem(LanguageEncoder.getText("Save"), 83));
        fileMenu.add(this.newMenuItem(LanguageEncoder.getText("Done"), 68));
        this.add(fileMenu);
    }

    private JMenu addExportMenu() {
        JMenu exportMenu = new JMenu(LanguageEncoder.getText("Export"));
        exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate SQL")));
        exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate CSV")));
        return exportMenu;
    }

    private void addEditMenu() {
        this.editMenu = new JMenu(LanguageEncoder.getText("Edit"));
        this.editMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Column")));
        this.editMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Row")));
        this.editMenu.addSeparator();
        this.editMenu.add(this.newMenuItem(LanguageEncoder.getText("Delete Column")));
        this.add(this.editMenu);
    }

    private void addViewMenu() {
        this.viewMenu = new JMenu(LanguageEncoder.getText("View"));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("First Page")));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Previous Page")));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Next Page")));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Last Page")));
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Go To...")));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Display Rows")));
        this.add(this.viewMenu);
    }

    private void addQueryMenu() {
        JMenu queryMenu = new JMenu(LanguageEncoder.getText("Query"));
        queryMenu.add(this.newMenuItem(LanguageEncoder.getText("Database Information")));
        queryMenu.add(this.newMenuItem(LanguageEncoder.getText("Show Tables")));
        this.extraSQL = this.newMenuItem(LanguageEncoder.getText("Extra SQL..."));
        queryMenu.add(this.extraSQL);
        queryMenu.add(this.newMenuItem(LanguageEncoder.getText("Table Name Format...")));
        queryMenu.add(this.newMenuItem(LanguageEncoder.getText("Initialize Parameters...")));
        queryMenu.addSeparator();
        this.distinct = new JCheckBoxMenuItem(LanguageEncoder.getText("SELECT DISTINCT"), false);
        this.distinct.addActionListener(this);
        this.distinct.setActionCommand("SELECT DISTINCT");
        queryMenu.add(this.distinct);
        queryMenu.addSeparator();
        this.autoJoin = new JCheckBoxMenuItem(LanguageEncoder.getText("Auto Join"), this.queryMain.isAutoJoinEnabled());
        this.autoJoin.addActionListener(this);
        this.autoJoin.setActionCommand("Auto Join");
        queryMenu.add(this.autoJoin);
        queryMenu.addSeparator();
        queryMenu.add(this.newMenuItem(LanguageEncoder.getText("Refresh")));
        this.add(queryMenu);
    }

    private JMenuItem newMenuItem(String s, int i) {
        JMenuItem m = new JMenuItem(s);
        int modifier = 2;
        if (i == 127) {
            modifier = 0;
        }
        m.setAccelerator(KeyStroke.getKeyStroke(i, modifier));
        m.addActionListener(this);
        m.setActionCommand(s);
        return m;
    }

    private JMenuItem newMenuItem(String s) {
        JMenuItem m = new JMenuItem(s);
        m.addActionListener(this);
        m.setActionCommand(s);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menuStr = e.getActionCommand();
        try {
            if (menuStr.equals(LanguageEncoder.getText("Done"))) {
                this.queryMain.done();
            } else if (menuStr.equals(LanguageEncoder.getText("Save"))) {
                this.queryMain.fullySave();
            } else if (menuStr.equals(LanguageEncoder.getText("Cancel"))) {
                this.queryMain.cancel();
            } else if (menuStr.equals(LanguageEncoder.getText("Show Tables"))) {
                this.queryMain.showTablesWindow();
            } else if (menuStr.equals(LanguageEncoder.getText("Database Information"))) {
                this.queryMain.aboutDatabase();
            } else if (menuStr.equals(LanguageEncoder.getText("Insert Column"))) {
                this.queryMain.qbeWindow.designView.insertColumn();
            } else if (menuStr.equals(LanguageEncoder.getText("Insert Row"))) {
                this.queryMain.qbeWindow.designView.insertRow();
            } else if (menuStr.equals(LanguageEncoder.getText("Delete Column"))) {
                this.queryMain.qbeWindow.designView.deleteColumn();
            } else if (menuStr.equals(LanguageEncoder.getText("Design"))) {
                this.queryMain.qbeWindow.goToPanel(0);
            } else if (menuStr.equals(LanguageEncoder.getText("SQL"))) {
                this.queryMain.qbeWindow.goToPanel(1);
            } else if (menuStr.equals(LanguageEncoder.getText("Datasheet"))) {
                this.queryMain.qbeWindow.goToPanel(2);
            } else if (menuStr.equals(LanguageEncoder.getText("First Page"))) {
                this.queryMain.qbeWindow.dataSheetView.goToFirstPage();
            } else if (menuStr.equals(LanguageEncoder.getText("Previous Page"))) {
                this.queryMain.qbeWindow.dataSheetView.goToPreviousPage();
            } else if (menuStr.equals(LanguageEncoder.getText("Next Page"))) {
                this.queryMain.qbeWindow.dataSheetView.goToNextPage();
            } else if (menuStr.equals(LanguageEncoder.getText("Last Page"))) {
                this.queryMain.qbeWindow.dataSheetView.goToLastPage();
            } else if (menuStr.equals(LanguageEncoder.getText("Generate SQL"))) {
                this.queryMain.export(0, null);
            } else if (menuStr.equals(LanguageEncoder.getText("Generate CSV"))) {
                this.queryMain.export(1, null);
            } else if (menuStr.equals(LanguageEncoder.getText("Initialize Parameters..."))) {
                this.queryMain.showParameters();
            } else if (menuStr.equals(LanguageEncoder.getText("Table Name Format..."))) {
                this.queryMain.selectTableNameFormat();
            } else if (menuStr.equals(LanguageEncoder.getText("Extra SQL..."))) {
                this.queryMain.showSupplementSQL();
            } else if (menuStr.equals(LanguageEncoder.getText("SELECT DISTINCT"))) {
                this.queryMain.setSelectDistinct(this.distinct.isSelected());
            } else if (menuStr.equals(LanguageEncoder.getText("Auto Join"))) {
                this.queryMain.setAutoJoinEnabled(this.autoJoin.isSelected());
            } else if (menuStr.equals(LanguageEncoder.getText("Go To..."))) {
                NumericDialog dialog = new NumericDialog(this.queryMain, this.queryMain.qbeWindow.dataSheetView.getSelectedRow(), LanguageEncoder.getText("Go To ..."), LanguageEncoder.getText("Row Index :"));
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.queryMain.qbeWindow.dataSheetView.goTo(dialog.getValue());
                }
            } else if (menuStr.equals(LanguageEncoder.getText("Display Rows"))) {
                NumericDialog dialog = new NumericDialog(this.queryMain, this.queryMain.qbeWindow.dataSheetView.getDisplayRow(), LanguageEncoder.getText("Set Display Row ..."), LanguageEncoder.getText("Number Of Display Row :"));
                dialog.setVisible(true);
                if (dialog.isModified()) {
                    this.queryMain.qbeWindow.dataSheetView.setDisplayRow(dialog.getValue());
                }
            } else {
                this.queryMain.setLookAndFeel(menuStr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

