/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import jsyntaxpane.DefaultSyntaxKit;

public class SQLView
extends JScrollPane {
    JEditorPane editor;
    String query;
    String defaultQuery;

    public SQLView(String query) {
        this.query = query;
        this.defaultQuery = query;
        this.init();
    }

    private void init() {
        this.setBackground(Color.white);
        DefaultSyntaxKit.initKit();
        this.editor = new JEditorPane();
        this.getViewport().add(this.editor);
        this.editor.setContentType("text/plain");
        Font f = this.editor.getFont();
        this.editor.setContentType("text/sql");
        this.editor.setFont(f);
        this.editor.setText(this.query);
    }

    void setQuery(String qry) {
        this.query = qry;
        this.editor.setText(this.query);
    }

    String getQuery() {
        String text = this.editor.getText();
        int fromIndex = 0;
        int rindex = text.indexOf("\r", fromIndex);
        int nindex = text.indexOf("\n", fromIndex);
        while (rindex > -1) {
            if (rindex + 1 < nindex) {
                text = text.substring(0, rindex) + text.substring(rindex + 1, nindex) + "\r" + text.substring(nindex);
            }
            fromIndex = nindex + 1;
            rindex = text.indexOf("\r", fromIndex);
            nindex = text.indexOf("\n", fromIndex);
        }
        return text;
    }

    boolean isModified() {
        return !this.query.equals(this.getQuery());
    }

    void resetQuery() {
        this.editor.setText(this.query);
    }

    public void setSQLEditable(boolean state) {
        this.editor.setEditable(state);
        if (!state) {
            this.editor.setComponentPopupMenu(null);
        }
    }

    String getDefaultSQL() {
        return this.defaultQuery;
    }

    void setDefaultSQL(String sql) {
        this.defaultQuery = sql;
    }
}

