/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;

public class SaveBackToRegistryDialog
extends JDialog
implements ActionListener {
    private JRadioButton overwriteBtn;
    private JRadioButton saveAsNewBtn;
    private JRadioButton noBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private boolean overwrite;
    private boolean saveAsNew;
    private boolean isCancelled = false;

    public SaveBackToRegistryDialog(JDialog parent) {
        super(parent, "Save Query", true);
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        topPanel.add(new Label(LanguageEncoder.getText("Do you want to save the query back to the data source registry?")));
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new GridLayout(3, 1, 5, 5));
        this.saveAsNewBtn = new JRadioButton(LanguageEncoder.getText("Yes, Save As a new Query"), false);
        midPanel.add(this.saveAsNewBtn);
        this.overwriteBtn = new JRadioButton(LanguageEncoder.getText("Yes, Overwrite the existing query"), false);
        midPanel.add(this.overwriteBtn);
        this.noBtn = new JRadioButton(LanguageEncoder.getText("No, only save the modified query in this template"), true);
        midPanel.add(this.noBtn);
        ButtonGroup group = new ButtonGroup();
        group.add(this.overwriteBtn);
        group.add(this.saveAsNewBtn);
        group.add(this.noBtn);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1));
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(this.okBtn);
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(this.cancelBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add("North", topPanel);
        panel.add("Center", midPanel);
        panel.add("South", bottomPanel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.okBtn) {
            this.overwrite = this.overwriteBtn.isSelected();
            this.saveAsNew = this.saveAsNewBtn.isSelected();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancelBtn) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isSaveAsNew() {
        return this.saveAsNew;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

