/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.PopupMenuForColumnWindow;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.LoadQuery;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.querybuilder.query.TableInfo;

public class SimpleDictionary
extends ColumnFieldWindow {
    String query = "";
    String alias = "Dictionary";
    String[][] columnInfo = null;
    JTable qbeTable = null;
    ColumnFieldWindow[] windows = null;
    String[][] joinProperties = null;

    protected SimpleDictionary(String title) {
        super(title);
    }

    public SimpleDictionary(LoadQuery lq, QueryMain qm) throws Exception {
        super("Dictionary");
        ColumnFieldWindow newCol;
        int i;
        this.lineMonitor = qm.qbeWindow.designView;
        DatabaseInfo dbInfo = new DatabaseInfo(lq.getDriver(), lq.getURL(), lq.getUserName(), lq.getPassword());
        JTable table = new JTable(10, 20);
        table.setGridColor(Color.lightGray);
        ((DefaultTableModel)table.getModel()).setDataVector(lq.getQBETable(), lq.getQBEHeader());
        this.qbeTable = table;
        this.joinProperties = lq.getJoinProperties();
        String[] tNames = lq.getSelectedTable();
        String[] tAlias = lq.getTableAlias();
        Rectangle[] tableBounds = lq.getTableBounds();
        LoadQuery[] dictionaries = lq.getDictionaries();
        String[] dictionaryAlias = lq.getDictionaryAlias();
        Rectangle[] dictionaryBounds = lq.getDictionaryBounds();
        this.windows = new ColumnFieldWindow[tNames.length + dictionaries.length];
        for (i = 0; i < tNames.length; ++i) {
            newCol = new ColumnFieldWindow(this.lineMonitor, new TableInfo(dbInfo, tNames[i]));
            newCol.setDisplayName(tAlias[i]);
            newCol.setPosition(tableBounds[i]);
            this.windows[i] = newCol;
        }
        for (i = 0; i < dictionaries.length; ++i) {
            newCol = new SimpleDictionary(dictionaries[i], qm);
            newCol.setDisplayName(dictionaryAlias[i]);
            newCol.setPosition(dictionaryBounds[i]);
            this.windows[tNames.length + i] = newCol;
        }
        this.query = QueryBuilder.create(QueryBuilder.mapDatabaseType(dbInfo.getProductName()), table, this.windows, this.joinProperties).buildQuery();
        Object[][] colresult = qm.databaseInfo.getTableInfo(this.query, true);
        this.columnInfo = new String[colresult.length][3];
        for (int i2 = 0; i2 < colresult.length; ++i2) {
            this.columnInfo[i2][0] = (String)colresult[i2][0];
            this.columnInfo[i2][1] = ((Integer)colresult[i2][1]).toString();
            this.columnInfo[i2][2] = (String)colresult[i2][2];
        }
        this.init();
        this.setPosition();
        this.colWinMenu = new PopupMenuForColumnWindow(qm.qbeWindow.designView, this);
    }

    @Override
    void init() throws Exception {
        Object[] colField = new Object[this.columnInfo.length + 1];
        String[] dataTypes = new String[this.columnInfo.length + 1];
        for (int i = 0; i < colField.length; ++i) {
            colField[i] = i == 0 ? "*" : this.columnInfo[i - 1][0];
            dataTypes[i] = i == 0 ? null : this.columnInfo[i - 1][2];
        }
        this.init_Helper(colField, dataTypes);
    }

    @Override
    public String getTableName() {
        return this.query;
    }

    @Override
    public void setTitle(String title) {
        this.setDisplayName(title);
    }

    @Override
    public String getDisplayName() {
        return this.alias;
    }

    @Override
    void setDisplayName(String str) {
        super.setTitle(str);
        this.alias = str;
    }

    @Override
    public int getSQLType(int index) {
        if (index <= 0) {
            return -5;
        }
        return Integer.parseInt(this.columnInfo[index - 1][1]);
    }

    public JTable getQBETable() {
        return this.qbeTable;
    }

    public ColumnFieldWindow[] getWindows() {
        return this.windows;
    }

    public String[][] getJoinProperties() {
        return this.joinProperties;
    }

    protected void finalize() throws Throwable {
        for (ColumnFieldWindow window : this.windows) {
            try {
                window.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

