/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.SwingUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.querybuilder.designer.DataSheetView;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SQLView;
import quadbase.querybuilder.query.DatabaseInfo;

public class SimpleQBEWindow
extends JPanel
implements ChangeListener {
    private QueryMain queryMain;
    private JTabbedPane mainPanel;
    private SQLView sqlView;
    private DataSheetView dataSheetView;
    private String query = null;
    private QueryInParamSet paramSet = null;
    private int lastTabIndex = 0;

    public SimpleQBEWindow(QueryMain queryMain, String query) {
        this.queryMain = queryMain;
        this.queryMain.setSQBEWindow(this);
        this.query = query;
        this.init();
    }

    private void init() {
        this.mainPanel = new JTabbedPane();
        this.mainPanel.insertTab(LanguageEncoder.getText("SQL View"), null, this.getSQLPanel(), null, 0);
        this.mainPanel.insertTab(LanguageEncoder.getText("Datasheet View"), null, this.getDatasheetPanel(), null, 1);
        this.mainPanel.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((SimpleQBEWindow)SimpleQBEWindow.this).sqlView.editor.requestFocus();
            }
        });
    }

    private JPanel getSQLPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.sqlView = new SQLView(this.query == null ? "" : this.query);
        panel.add((Component)this.sqlView, "Center");
        return panel;
    }

    private JPanel getDatasheetPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        try {
            this.dataSheetView = new DataSheetView(this.queryMain, "*", new Vector<String>());
            panel.add((Component)this.dataSheetView, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return panel;
    }

    private void goToPanel(int selectedIndex) {
        this.setPanel(selectedIndex);
        this.mainPanel.setSelectedIndex(selectedIndex);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPanel(this.mainPanel.getSelectedIndex());
        this.lastTabIndex = this.mainPanel.getSelectedIndex();
    }

    private void setPanel(int selectedIndex) {
        this.queryMain.setTitle("Please Wait ...");
        this.queryMain.setCursor(Cursor.getPredefinedCursor(3));
        if (selectedIndex == 0) {
            if (!this.sqlView.isModified()) {
                this.sqlView.setQuery(this.sqlView.getQuery());
            }
            this.sqlView.editor.requestFocus();
        } else if (selectedIndex == 1) {
            this.queryMain.getQueryMenuBar().setPreviewMenuEnabled();
            if (this.sqlView.getQuery().trim().length() == 0) {
                this.dataSheetView.setQuery("SELECT", new Vector<String>(), null);
            } else {
                this.updateDataSheet();
            }
        }
        this.queryMain.setCursor(null);
        this.queryMain.setTitle(this.queryMain.getQueryTitle());
    }

    private void updateDataSheet() {
        String query = this.sqlView.getQuery();
        QueryInParamSet pSet = null;
        try {
            if (QueryParser.hasParameters(query)) {
                DatabaseInfo temp;
                boolean initializationRequired = true;
                pSet = QueryParser.filterParameters(query, this.paramSet);
                if (pSet != null) {
                    QueryInParam[] params = pSet.getParameter();
                    for (int i = 0; i < params.length; ++i) {
                        initializationRequired = false;
                        if (params[i] != null) continue;
                        initializationRequired = true;
                        i = params.length;
                    }
                }
                if (initializationRequired) {
                    this.paramSet = null;
                    this.showParameters(query);
                    if (this.paramSet == null) {
                        this.goToPanel(this.lastTabIndex);
                        return;
                    }
                    pSet = this.paramSet;
                }
                DBInfoBasic dbInfo = (temp = this.queryMain.databaseInfo).isUseJNDIDataSource() ? new DBInfoBasic(temp.getJNDIName(), query, temp.getEnvProperties()) : new DBInfoBasic(temp.getURL(), temp.getDriver(), temp.getUserName(), temp.getPassword(), query, temp.getAdditionalDb());
                QueryFileInfo qfi = new QueryFileInfo("", 0, dbInfo, pSet);
                EnterInParamDialog eDialog = new EnterInParamDialog((Dialog)SwingUtil.findJDialogParent(this), qfi, true);
                eDialog.setVisible(true);
                if (eDialog.isCancelled()) {
                    this.goToPanel(this.lastTabIndex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dataSheetView.updateDataSheet(query, pSet);
    }

    private void showParameters(String query) {
        if (QueryParser.hasParameters(query)) {
            QueryInParamSet tempParamSet = QueryParser.filterParameters(query, this.paramSet);
            DBInfoBasic newDBInfo = this.queryMain.databaseInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.queryMain.databaseInfo.getJNDIName(), query, this.queryMain.databaseInfo.getEnvProperties()) : new DBInfoBasic(this.queryMain.databaseInfo.getURL(), this.queryMain.databaseInfo.getDriver(), this.queryMain.databaseInfo.getUserName(), this.queryMain.databaseInfo.getPassword(), query, this.queryMain.databaseInfo.getAdditionalDb());
            QueryFileInfo qfi = new QueryFileInfo("", 0, newDBInfo, tempParamSet);
            try {
                boolean showPromptSequence = !this.queryMain.forChart();
                INParametersDialog pDialog = new INParametersDialog(this.queryMain, qfi, showPromptSequence, this.queryMain.getTableNameFormat());
                pDialog.setDefaultValueRequired(this.queryMain.isDefaultValueRequiredForParameters());
                pDialog.setVisible(true);
                if (pDialog.isModified()) {
                    tempParamSet = pDialog.getQueryInParamSet();
                    if (tempParamSet == null) {
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    this.paramSet = tempParamSet;
                    this.setInSet(this.paramSet);
                    this.queryMain.setModified();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new JMessageDialog((Dialog)this.queryMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
            }
        } else {
            new JMessageDialog((Dialog)this.queryMain, "Information", LanguageEncoder.getText("This query does not contain parameters."));
        }
    }

    public void setQuery(String query) {
        this.sqlView.setQuery(query);
    }

    public String getQuery() {
        return this.sqlView.getQuery();
    }

    public void setInSet(QueryInParamSet s) {
        this.paramSet = s;
    }

    public QueryInParamSet getInSet() {
        return this.paramSet;
    }
}

