/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.LanguageEncoder;

public class SupplementSQLDialog
extends JDialog
implements ActionListener {
    private UndoTextArea beforeArea = null;
    private UndoTextArea afterArea = null;
    private boolean modified = false;

    public SupplementSQLDialog(JDialog owner, String beforeSQL, String afterSQL) {
        super((Dialog)owner, true);
        this.init(beforeSQL, afterSQL);
        this.setPosition();
    }

    private void init(String beforeSQL, String afterSQL) {
        this.setTitle(LanguageEncoder.getText("Extra SQL..."));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(2, 1, 10, 10));
        this.beforeArea = new UndoTextArea(5, 50);
        this.afterArea = new UndoTextArea(5, 50);
        if (beforeSQL != null) {
            this.beforeArea.setText(beforeSQL);
        }
        if (afterSQL != null) {
            this.afterArea.setText(afterSQL);
        }
        JScrollPane scroll = new JScrollPane(this.beforeArea);
        scroll.setBorder(new TitledBorder(LanguageEncoder.getText("Before Query")));
        mainPanel.add(scroll);
        scroll = new JScrollPane(this.afterArea);
        scroll.setBorder(new TitledBorder(LanguageEncoder.getText("After Query")));
        mainPanel.add(scroll);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        JButton button = new JButton(LanguageEncoder.getText("OK"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton(LanguageEncoder.getText("Cancel"));
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        buttonPanel.add(button);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("OK".equals(command)) {
            this.modified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getBeforeSQL() {
        return this.beforeArea.getText();
    }

    public String getAfterSQL() {
        return this.afterArea.getText();
    }
}

