/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.TableInfo;

public class TableTreeNode
extends DefaultMutableTreeNode {
    private String tableName = null;
    private TableInfo tableInfo = null;
    private ColumnFieldWindow window = null;
    private DatabaseInfo databaseInfo;
    private boolean master = false;

    public TableTreeNode(DatabaseInfo dbInfo, String tablename) {
        super(tablename);
        this.tableName = tablename;
        this.databaseInfo = dbInfo;
    }

    public TableTreeNode(TableTreeNode _node) {
        super(_node.getUserObject());
        this.tableName = _node.tableName;
        this.tableInfo = _node.tableInfo;
        this.window = _node.window;
        this.databaseInfo = _node.databaseInfo;
        for (int i = 0; i < _node.getChildCount(); ++i) {
            this.add(new DefaultMutableTreeNode(((DefaultMutableTreeNode)_node.getChildAt(i)).getUserObject(), false));
        }
    }

    public void setMaster(boolean state) {
        this.master = state;
    }

    public void generateColumns() throws Exception {
        if (this.tableInfo == null) {
            this.tableInfo = new TableInfo(this.databaseInfo, this.tableName);
            for (int i = 0; i < this.tableInfo.getColumnCount(); ++i) {
                if (!this.getAllowsChildren()) continue;
                this.add(new DefaultMutableTreeNode(this.tableInfo.getColumn(i).getColumnName(), false));
            }
        }
    }

    public ColumnFieldWindow getWindow() throws Exception {
        if (this.master) {
            throw new Exception("This object is used as a master by 'DataViewDialog'. Therefore, this method is not allowed.");
        }
        if (this.window == null) {
            this.window = new ColumnFieldWindow(null, this.getTableInfo());
            this.window.setDisplayName(this.getAlias());
            this.window.setForDataView(true);
        }
        return this.window;
    }

    public TableInfo getTableInfo() throws Exception {
        this.generateColumns();
        return this.tableInfo;
    }

    @Override
    public void setUserObject(Object alias) {
        if (alias != null) {
            this.setAlias(alias.toString());
        }
    }

    public void setAlias(String alias) {
        super.setUserObject(alias);
        if (this.window != null) {
            this.window.setDisplayName(alias);
        }
    }

    public void setTableName(String tablename) {
        this.tableName = tablename;
        if (this.tableInfo != null && tablename != null) {
            this.tableInfo.setTableName(tablename);
        }
    }

    public String getAlias() {
        if (this.getUserObject() != null) {
            return this.getUserObject().toString();
        }
        return null;
    }

    public String getTableName() {
        if (this.tableInfo != null) {
            return this.tableInfo.getTableName();
        }
        return this.tableName;
    }

    public boolean equals(Object node) {
        if (node instanceof TableTreeNode) {
            return ((TableTreeNode)node).window == this.window;
        }
        return false;
    }
}

