/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import quadbase.common.client.ReadDatabase;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;

public class TableWindow
extends JDialog
implements ActionListener {
    QueryMain queryMain;
    private JTabbedPane tabbedPane;
    private JList mTableBox;
    private JList mViewBox;
    private JList mBothBox;
    private JButton add;
    private JButton close;
    private static final String TITLE = LanguageEncoder.getText("Database Tables");
    private String[][] dictionaries;
    private int listcount = 0;
    private int tableNameFormat = 0;
    private ListDriver listDriver;

    public TableWindow(QueryMain queryMain) throws Exception {
        super((Dialog)queryMain, TITLE);
        this.queryMain = queryMain;
        this.tableNameFormat = queryMain.getTableNameFormat();
        if (this.tableNameFormat != 1 && this.tableNameFormat != 2) {
            this.tableNameFormat = 0;
        }
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.setTitle(LanguageEncoder.getText("Retrieving tables..."));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.add = new JButton(LanguageEncoder.getText("Add"));
        this.close = new JButton(LanguageEncoder.getText("Close"));
        buttonPanel.add(this.add);
        buttonPanel.add(this.close);
        this.add.addActionListener(this);
        this.close.addActionListener(this);
        DefaultListModel tmodel = new DefaultListModel();
        DefaultListModel vmodel = new DefaultListModel();
        this.mTableBox = new JList(tmodel);
        this.mViewBox = new JList(vmodel);
        this.listDriver = new ListDriver(this.mTableBox, this.mViewBox, this.queryMain.databaseInfo, this.tableNameFormat);
        this.listDriver.start();
        this.setupList(true);
        this.setupList(false);
        this.dictionaries = this.queryMain.getDictionaries();
        String[] dList = new String[this.dictionaries.length];
        for (int i = 0; i < dList.length; ++i) {
            dList[i] = this.dictionaries[i][0];
        }
        this.mBothBox = new JList<String>(dList);
        this.mBothBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1) {
                    TableWindow.this.showBoth();
                }
            }
        });
        this.mBothBox.setBackground(Color.white);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.insertTab(LanguageEncoder.getText("Tables"), null, new JScrollPane(this.mTableBox), null, 0);
        this.tabbedPane.insertTab(LanguageEncoder.getText("Views"), null, new JScrollPane(this.mViewBox), null, 1);
        this.tabbedPane.insertTab(LanguageEncoder.getText("Queries"), null, new JScrollPane(this.mBothBox), null, 2);
        contentPane.add(this.tabbedPane);
        contentPane.add(buttonPanel);
        this.pack();
        while (this.tabbedPane.getTabRunCount() > 1) {
            Dimension d = this.tabbedPane.getPreferredSize();
            Dimension newD = new Dimension((int)d.getWidth() + 50, (int)d.getHeight());
            this.tabbedPane.setPreferredSize(new Dimension((int)d.getWidth() + 50, (int)d.getHeight()));
            this.tabbedPane.setSize(newD);
            this.pack();
        }
        this.listDriver.join();
        if (this.listDriver.getException() != null) {
            throw this.listDriver.getException();
        }
    }

    private void repaintLists() {
        this.mTableBox = new JList(this.mTableBox.getModel());
        this.setupList(true);
        if (this.tabbedPane != null) {
            this.tabbedPane.setComponentAt(0, new JScrollPane(this.mTableBox));
            this.tabbedPane.repaint();
        }
    }

    private void setupList(boolean state) {
        if (state) {
            this.mTableBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 1) {
                        TableWindow.this.showTable();
                    }
                }
            });
            this.mTableBox.setBackground(Color.white);
        } else {
            this.mViewBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 1) {
                        TableWindow.this.showView();
                    }
                }
            });
            this.mViewBox.setBackground(Color.white);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mTableBox.validate();
        this.mViewBox.validate();
        this.mBothBox.validate();
    }

    public void showTable() {
        Object[] selectedTables;
        if (this.mTableBox.isSelectionEmpty()) {
            return;
        }
        for (Object selectedTable : selectedTables = this.mTableBox.getSelectedValues()) {
            this.queryMain.showTable(selectedTable.toString());
        }
    }

    public void showView() {
        Object[] selectedTables;
        if (this.mViewBox.isSelectionEmpty()) {
            return;
        }
        for (Object selectedTable : selectedTables = this.mViewBox.getSelectedValues()) {
            this.queryMain.showTable(selectedTable.toString());
        }
    }

    public void showBoth() {
        int[] selectedTables;
        if (this.mBothBox.isSelectionEmpty()) {
            return;
        }
        for (int selectedTable : selectedTables = this.mBothBox.getSelectedIndices()) {
            this.queryMain.showDictionary(this.dictionaries[selectedTable][0], this.dictionaries[selectedTable][1]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.add) {
            this.queryMain.setTitle(QueryMain.WAIT_TITLE);
            this.queryMain.setCursor(Cursor.getPredefinedCursor(3));
            this.setTitle(QueryMain.WAIT_TITLE);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.showTable();
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.showView();
            } else if (this.tabbedPane.getSelectedIndex() == 2) {
                this.showBoth();
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setTitle(TITLE);
            this.queryMain.setCursor(Cursor.getPredefinedCursor(0));
            this.queryMain.setTitle(this.queryMain.getQueryTitle());
        } else if (target == this.close) {
            try {
                this.setVisible(false);
            }
            catch (Exception ex) {
                System.out.println("CANNOT CLOSE TABLEWINDOW!");
                this.setVisible(false);
                this.queryMain.tblWindow = null;
                this.queryMain = null;
                this.dispose();
            }
        }
    }

    public void setTableNameFormat(int format) {
        try {
            int newformat = 0;
            if (format == 1 || format == 2) {
                newformat = format;
            }
            if (newformat == 2 && this.queryMain.getDatabaseType() == 9) {
                newformat = 1;
            }
            if (this.tableNameFormat != newformat) {
                this.listDriver.kill();
                DefaultListModel model = (DefaultListModel)this.mTableBox.getModel();
                model.clear();
                model = (DefaultListModel)this.mViewBox.getModel();
                model.clear();
                this.listcount = 0;
                this.listDriver = new ListDriver(this.mTableBox, this.mViewBox, this.queryMain.databaseInfo, newformat);
                this.listDriver.start();
                this.tableNameFormat = newformat;
                this.setTitle(LanguageEncoder.getText("Retrieving tables..."));
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ void access$200(TableWindow x0) {
        x0.repaintLists();
    }

    private class PopulateList
    extends Thread {
        private DefaultListModel listModel;
        private DataInputStream instream;
        private boolean stop = false;

        public PopulateList(JList l, DataInputStream v) {
            this.listModel = (DefaultListModel)l.getModel();
            this.instream = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.listModel == null) return;
            if (this.instream == null) {
                return;
            }
            results = new Vector();
            try {
                first = true;
lbl7:
                // 3 sources

                while (true) {
                    if (!this.stop) ** GOTO lbl-1000
                    ** GOTO lbl47
                    break;
                }
            }
            catch (EOFException first) {
                results = ReadDatabase.sortStr(results);
                for (i = 0; i < results.size(); ++i) {
                    this.listModel.addElement(results.get(i));
                }
                TableWindow.access$008(TableWindow.this);
                if (TableWindow.access$000(TableWindow.this) >= 2) {
                    TableWindow.this.setTitle(TableWindow.access$100());
                    TableWindow.access$200(TableWindow.this);
                }
                TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    this.instream.close();
                    return;
                }
                catch (Exception i) {
                    return;
                }
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable var4_12) {
                    results = ReadDatabase.sortStr(results);
                    for (i = 0; i < results.size(); ++i) {
                        this.listModel.addElement(results.get(i));
                    }
                    TableWindow.access$008(TableWindow.this);
                    if (TableWindow.access$000(TableWindow.this) >= 2) {
                        TableWindow.this.setTitle(TableWindow.access$100());
                        TableWindow.access$200(TableWindow.this);
                    }
                    TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        this.instream.close();
                        throw var4_12;
                    }
                    catch (Exception var5_14) {
                        // empty catch block
                    }
                    throw var4_12;
                }
lbl47:
                // 1 sources

                results = ReadDatabase.sortStr(results);
                for (i = 0; i < results.size(); ++i) {
                    this.listModel.addElement(results.get(i));
                }
                TableWindow.access$008(TableWindow.this);
                if (TableWindow.access$000(TableWindow.this) >= 2) {
                    TableWindow.this.setTitle(TableWindow.access$100());
                    TableWindow.access$200(TableWindow.this);
                }
                TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    this.instream.close();
                    return;
                }
                catch (Exception i) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    tablename = IOUtil.readString(this.instream, true);
                    results.add(tablename);
                    if (!first) ** GOTO lbl7
                    TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
                    first = false;
                    ** continue;
                }
                results = ReadDatabase.sortStr(results);
                for (i = 0; i < results.size(); ++i) {
                    this.listModel.addElement(results.get(i));
                }
                TableWindow.access$008(TableWindow.this);
                if (TableWindow.access$000(TableWindow.this) >= 2) {
                    TableWindow.this.setTitle(TableWindow.access$100());
                    TableWindow.access$200(TableWindow.this);
                }
                TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    this.instream.close();
                    return;
                }
                catch (Exception var2_8) {
                    return;
                }
            }
        }

        public void kill() {
            this.stop = true;
        }
    }

    private class ListDriver
    extends Thread {
        private JList table;
        private JList view;
        private DatabaseInfo dbInfo;
        private int format;
        private PopulateList tThread;
        private PopulateList vThread;
        private boolean stop = false;
        private Exception error = null;

        public ListDriver(JList tl, JList vl, DatabaseInfo d, int f) {
            this.table = tl;
            this.view = vl;
            this.dbInfo = d;
            this.format = f;
        }

        @Override
        public void run() {
            int i;
            PopulateList[] popList;
            DataInputStream[] dis;
            DataInputStream instream;
            try {
                if (!this.stop) {
                    instream = this.dbInfo.getTableListStream(new String[]{"TABLE", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, this.format);
                    this.tThread = new PopulateList(this.table, instream);
                    this.tThread.start();
                    if (this.dbInfo.getAdditionalDbSize() > 0) {
                        this.tThread.join();
                        dis = this.dbInfo.getAdditionalTableListStream(new String[]{"TABLE", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, this.format);
                        popList = new PopulateList[dis.length];
                        for (i = 0; i < dis.length; ++i) {
                            if (dis[i] == null) continue;
                            popList[i] = new PopulateList(this.table, dis[i]);
                            popList[i].start();
                            popList[i].join();
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.error = ex;
                TableWindow.this.listcount++;
            }
            try {
                if (!this.stop) {
                    instream = this.dbInfo.getTableListStream(new String[]{"VIEW"}, this.format);
                    this.vThread = new PopulateList(this.view, instream);
                    this.vThread.start();
                    if (this.dbInfo.getAdditionalDbSize() > 0) {
                        this.vThread.join();
                        dis = this.dbInfo.getAdditionalTableListStream(new String[]{"VIEW"}, this.format);
                        popList = new PopulateList[dis.length];
                        for (i = 0; i < dis.length; ++i) {
                            if (dis[i] == null) continue;
                            popList[i] = new PopulateList(this.view, dis[i]);
                            popList[i].start();
                            popList[i].join();
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (this.error == null) {
                    this.error = ex;
                }
                TableWindow.this.listcount++;
                if (TableWindow.this.listcount >= 2) {
                    TableWindow.this.setTitle(TITLE);
                }
                TableWindow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public Exception getException() {
            return this.error;
        }

        public void kill() {
            this.stop = true;
            if (this.tThread != null) {
                this.tThread.kill();
                try {
                    this.tThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.vThread != null) {
                this.vThread.kill();
                try {
                    this.vThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

