/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.datareg.DataRegClient;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.querybuilder.designer.ColumnTreeNode;
import quadbase.querybuilder.designer.ConditionColumnSelectionDialog;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.DataViewDialog;
import quadbase.querybuilder.designer.DataViewMappingDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.TableTreeNode;

public class UpdateDataView
extends JDialog
implements Runnable {
    private String[][] mapping = null;
    private Dialog owner = null;
    private JLabel progressString = null;
    private JProgressBar progressBar = null;
    private boolean isUseJNDIDataSource;
    private String JNDIName;
    private Hashtable env;
    private String driver = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private DataViewNode dataviewNode = null;
    private DataViewQueryNode dataviewQueryNode = null;

    public UpdateDataView(Dialog owner) {
        super(owner, true);
        this.init();
        this.owner = owner;
    }

    private void init() {
        this.setTitle(LanguageEncoder.getText("Update Dataview Queries..."));
        JPanel mainPanel = (JPanel)this.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mainPanel.setLayout(gbl);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 10);
        this.progressString = new JLabel("Preparing to update...");
        gbl.setConstraints(this.progressString, gbc);
        mainPanel.add(this.progressString);
        gbc.insets = new Insets(0, 10, 10, 10);
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setStringPainted(true);
        gbl.setConstraints(this.progressBar, gbc);
        mainPanel.add(this.progressBar);
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.width = screenSize.width / 3;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    public void update(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, DataViewNode node) {
        this.isUseJNDIDataSource = isUseJNDIDataSource;
        this.JNDIName = JNDIName;
        this.env = env;
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.dataviewNode = node;
        this.dataviewQueryNode = null;
    }

    public void update(boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, DataViewQueryNode node) {
        this.isUseJNDIDataSource = isUseJNDIDataSource;
        this.JNDIName = JNDIName;
        this.env = env;
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.dataviewQueryNode = node;
        this.dataviewNode = null;
    }

    @Override
    public void run() {
        if (this.dataviewNode == null && this.dataviewQueryNode == null) {
            return;
        }
        if (this.dataviewNode != null && this.dataviewNode.getChildCount() == 0) {
            return;
        }
        String errorQueries = "";
        this.setPosition();
        new SimpleThread(this).start();
        if (this.dataviewNode != null) {
            this.progressBar.setMaximum(this.dataviewNode.getChildCount() * 5);
            for (int i = 0; i < this.dataviewNode.getChildCount(); ++i) {
                block12: {
                    this.mapping = null;
                    if (!(this.dataviewNode.getChildAt(i) instanceof DataViewQueryNode)) continue;
                    this.progressString.setText("Updating '" + ((DataViewQueryNode)this.dataviewNode.getChildAt(i)).getName() + "'...");
                    boolean cont = true;
                    try {
                        cont = this.updateDataViewQuery(this.dataviewNode, (DataViewQueryNode)this.dataviewNode.getChildAt(i), this.isUseJNDIDataSource, this.JNDIName, this.env, this.driver, this.url, this.username, this.password, i * 5);
                        if (cont) break block12;
                        break;
                    }
                    catch (Exception ex) {
                        errorQueries = errorQueries + "- " + ((DataViewQueryNode)this.dataviewNode.getChildAt(i)).getName() + "\n";
                    }
                }
                this.progressBar.setValue((i + 1) * 5);
            }
        } else {
            this.progressBar.setMaximum(5);
            try {
                this.updateDataViewQuery((DataViewNode)this.dataviewQueryNode.getParent(), this.dataviewQueryNode, this.isUseJNDIDataSource, this.JNDIName, this.env, this.driver, this.url, this.username, this.password, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String excep = "";
                try {
                    excep = QbUtil.replace(ex.toString(), "Exception: ", "Excepion:\n");
                    excep = "\n" + excep;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to update query.") + excep);
            }
            this.progressBar.setValue(5);
        }
        if (this.dataviewNode != null && !errorQueries.equals("")) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to update the following queries:\n") + errorQueries + "\nPlease try updating each query individually for more details.");
        }
        this.setVisible(false);
        this.closeEditNode();
    }

    /*
     * Could not resolve type clashes
     */
    private boolean updateDataViewQuery(DataViewNode dnode, DataViewQueryNode qnode, boolean isUseJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String username, String password, int startProgressValue) throws Exception {
        boolean redoMap = false;
        do {
            int i;
            DataViewDialog dDialog = new DataViewDialog(this, isUseJNDIDataSource, JNDIName, env, driver, url, username, password, null, QueryMain.QUERYDIR + dnode.getQueryFile() + ".dvw", false, true);
            ConditionDialog qDialog = new ConditionDialog(null, isUseJNDIDataSource, JNDIName, (Hashtable<String, String>)env, driver, url, username, password, qnode, true);
            ColumnTreeNode[] old_selectedColumns = qDialog.getSelectedColumns();
            DataViewMappingDialog mapDialog = new DataViewMappingDialog(this, qnode.getName(), qDialog.getDataViewDialog().getViewTree(), qDialog.getSelectedColumns(), dDialog.getViewTree());
            this.progressBar.setValue(startProgressValue + 1);
            if (!mapDialog.isMappingSufficient(this.mapping) || redoMap) {
                mapDialog.setVisible(true);
                if (mapDialog.isCancelled()) {
                    return false;
                }
                if (mapDialog.isModified()) {
                    if (this.mapping == null) {
                        this.mapping = mapDialog.getMapping();
                    } else {
                        String[][] temp_mapping = mapDialog.getMapping();
                        for (int i2 = 0; i2 < temp_mapping.length; ++i2) {
                            int j;
                            boolean updated = false;
                            for (j = 0; j < this.mapping.length; ++j) {
                                if (this.mapping[j][3] != this.mapping[i2][3] && (this.mapping[j][3] == null || !this.mapping[j][3].equals(temp_mapping[i2][3]))) continue;
                                this.mapping[j][0] = temp_mapping[i2][0];
                                this.mapping[j][1] = temp_mapping[i2][1];
                                this.mapping[j][2] = temp_mapping[i2][2];
                                updated = true;
                            }
                            if (!updated) {
                                for (j = 0; j < this.mapping.length; ++j) {
                                    if (!this.mapping[j][1].equals(temp_mapping[i2][1])) continue;
                                    this.mapping[j][0] = temp_mapping[i2][0];
                                    this.mapping[j][2] = temp_mapping[i2][2];
                                    this.mapping[j][3] = temp_mapping[i2][3];
                                    updated = true;
                                }
                            }
                            if (updated) continue;
                            String[][] new_mapping = new String[this.mapping.length + 1][4];
                            int j2 = 0;
                            for (j2 = 0; j2 < this.mapping.length; ++j2) {
                                new_mapping[j2][0] = this.mapping[j2][0];
                                new_mapping[j2][1] = this.mapping[j2][1];
                                new_mapping[j2][2] = this.mapping[j2][2];
                                new_mapping[j2][3] = this.mapping[j2][3];
                            }
                            new_mapping[j2][0] = temp_mapping[i2][0];
                            new_mapping[j2][1] = temp_mapping[i2][1];
                            new_mapping[j2][2] = temp_mapping[i2][2];
                            new_mapping[j2][3] = temp_mapping[i2][3];
                            this.mapping = new_mapping;
                        }
                    }
                } else {
                    return true;
                }
            }
            JTree newTree = dDialog.getViewTree();
            Vector<String[]> map = new Vector<String[]>();
            for (ColumnTreeNode old_selectedColumn : old_selectedColumns) {
                if (!old_selectedColumn.isDataViewExpression()) continue;
                String oldAlias = old_selectedColumn.getAlias();
                String formula = old_selectedColumn.getColumnName();
                formula = this.replace(formula, this.mapping);
                Vector<TableTreeNode> selectedTablesVec = ConditionColumnSelectionDialog.getRequiredTableTreeNodes(formula, newTree);
                DefaultMutableTreeNode[] selectedTables = selectedTablesVec.toArray(new TableTreeNode[selectedTablesVec.size()]);
                ColumnTreeNode columnnode = new ColumnTreeNode((Object)formula, (TableTreeNode[])selectedTables);
                columnnode.setDataViewExpression(formula);
                String alias = oldAlias;
                if (alias == null || alias.equals("")) {
                    alias = "Expression";
                }
                int ct = 0;
                while (this.aliasExists(alias, newTree)) {
                    alias = "Expression_" + ct++;
                }
                columnnode.setAlias(alias);
                TreeNode newroot = (TreeNode)newTree.getModel().getRoot();
                ((DefaultMutableTreeNode)newroot.getChildAt(0)).add(columnnode);
                String[] m = new String[]{(String)((DefaultMutableTreeNode)old_selectedColumn.getParent()).getUserObject(), old_selectedColumn.getAlias(), (String)((DefaultMutableTreeNode)newroot.getChildAt(0)).getUserObject(), alias};
                map.add(m);
            }
            String[][] dataViewExpressionNameMap = (String[][])map.toArray((T[])new String[0][]);
            this.progressBar.setValue(startProgressValue + 2);
            JTable qbeTable = dDialog.getQBETable();
            int colcount = qbeTable.getColumnCount();
            JTable viewTable = new JTable(5, colcount);
            viewTable.setGridColor(Color.lightGray);
            Object[][] data = new Object[5][colcount];
            Object[] header = new String[colcount];
            for (i = 0; i < colcount; ++i) {
                header[i] = qbeTable.getModel().getColumnName(i);
                data[0][i] = null;
                data[1][i] = null;
                data[2][i] = Boolean.TRUE;
                data[3][i] = null;
                data[4][i] = null;
            }
            ((DefaultTableModel)viewTable.getModel()).setDataVector(data, header);
            for (i = 0; i < viewTable.getColumnCount(); ++i) {
                viewTable.getColumnModel().getColumn(i).setMinWidth(0);
                viewTable.getColumnModel().getColumn(i).setMaxWidth(0);
            }
            JTable old_viewTable = qDialog.getViewTable();
            this.progressBar.setValue(startProgressValue + 3);
            for (DefaultMutableTreeNode old_selectedColumn : old_selectedColumns) {
                int j;
                int old_columnIndex = -1;
                for (int j3 = 0; j3 < old_viewTable.getColumnCount() && old_columnIndex < 0; ++j3) {
                    if (!old_viewTable.getColumnModel().getColumn(j3).getHeaderValue().equals(((ColumnTreeNode)old_selectedColumn).getAlias())) continue;
                    old_columnIndex = old_viewTable.convertColumnIndexToModel(j3);
                }
                String newAlias = null;
                for (j = 0; j < dataViewExpressionNameMap.length && newAlias == null; ++j) {
                    if (!dataViewExpressionNameMap[j][1].equals(((ColumnTreeNode)old_selectedColumn).getAlias())) continue;
                    newAlias = dataViewExpressionNameMap[j][3];
                }
                if (newAlias == null) {
                    for (j = 0; j < this.mapping.length && newAlias == null; ++j) {
                        if (!this.mapping[j][1].equals(((ColumnTreeNode)old_selectedColumn).getAlias())) continue;
                        newAlias = this.mapping[j][3];
                    }
                }
                boolean success = false;
                if (old_columnIndex >= 0 && newAlias != null) {
                    for (int j4 = 0; j4 < viewTable.getColumnCount(); ++j4) {
                        if (!viewTable.getColumnModel().getColumn(j4).getHeaderValue().equals(newAlias)) continue;
                        int new_columnIndex = viewTable.convertColumnIndexToModel(j4);
                        viewTable.getColumnModel().getColumn(j4).setMinWidth(15);
                        viewTable.getColumnModel().getColumn(j4).setMaxWidth(Integer.MAX_VALUE);
                        Object oldcond = old_viewTable.getModel().getValueAt(3, old_columnIndex);
                        if (oldcond != null) {
                            String cond = this.replace(oldcond.toString(), dataViewExpressionNameMap);
                            cond = this.replace(cond, this.mapping);
                            viewTable.getModel().setValueAt(cond, 3, new_columnIndex);
                        }
                        success = true;
                    }
                } else if (newAlias == null) {
                    success = true;
                }
                if (success) continue;
                return true;
            }
            qDialog.setDataViewDialog(dDialog);
            qDialog.setViewTable(viewTable);
            byte[][] filebytes = qDialog.getFileBytes();
            this.progressBar.setValue(startProgressValue + 4);
            ConditionDialog new_qDialog = new ConditionDialog(this, isUseJNDIDataSource, JNDIName, (Hashtable<String, String>)env, driver, url, username, password, filebytes, true);
            this.progressBar.setValue(startProgressValue + 5);
            redoMap = false;
            Exception excep = new_qDialog.getError();
            if (excep != null) {
                String estring = "";
                try {
                    String estring = QbUtil.replace(excep.toString(), "Exception: ", "Excepion:\n");
                    estring = "\n" + estring;
                }
                catch (Exception old_columnIndex) {
                    // empty catch block
                }
                int option = JOptionPane.showOptionDialog(this, "Failed to update dataview query '" + qnode.getName() + "'.\n" + estring + "\nDo you want to redo column mapping for this query?", LanguageEncoder.getText("Error"), 0, 0, null, new String[]{"Redo Mapping", "Skip Query"}, "Redo Mapping");
                if (option == 0) {
                    redoMap = true;
                    continue;
                }
                return true;
            }
            qnode.setSQL(new_qDialog.getQuery());
            qnode.setInSet(new_qDialog.getParamSet());
            qnode.setBytes(filebytes);
            qDialog.save(qnode.getQueryFile());
            dDialog.save(QueryMain.QUERYDIR + qnode.getDataViewFile());
        } while (redoMap);
        return true;
    }

    private String replace(String str, String[][] map) {
        for (String[] element : map) {
            String oldString = "{" + element[0] + "." + element[1] + "}";
            String newString = "{" + element[2] + "." + element[3] + "}";
            int beginIndex = 0;
            while (str.indexOf(oldString, beginIndex) >= 0) {
                int old_begin = str.indexOf(oldString, beginIndex);
                int old_end = old_begin + oldString.length();
                str = str.substring(0, old_begin) + newString + str.substring(old_end);
                beginIndex = old_end;
            }
        }
        return str;
    }

    private boolean aliasExists(String alias, JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            TreeNode header = root.getChildAt(j);
            for (int i = 0; i < header.getChildCount(); ++i) {
                ColumnTreeNode column = (ColumnTreeNode)header.getChildAt(i);
                if (!column.getAlias().equals(alias)) continue;
                return true;
            }
        }
        return false;
    }

    private void closeEditNode() {
        if (!ServerMessage.useServer) {
            return;
        }
        try {
            if (this.owner.isVisible()) {
                DataRegClient.closeEditNode();
            }
        }
        catch (Exception e) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), e.getMessage());
        }
    }

    private class SimpleThread
    extends Thread {
        private JDialog dialog = null;

        public SimpleThread(JDialog d) {
            this.dialog = d;
        }

        @Override
        public void run() {
            this.dialog.setVisible(true);
        }
    }
}

