/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.Future;
import quadbase.common.client.ReadDatabase;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.IDBConnection;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.querybuilder.query.ExportQuery;
import quadbase.querybuilder.query.XMLDatabaseFunctions;

public class DatabaseInfo {
    private boolean useJNDIDataSource = false;
    private String JNDIName;
    private Hashtable env;
    private String url;
    private String driver;
    private String userName;
    private String password;
    private String XMLFUNCTIONLIST = "userdb/DatabaseFunctions.xml";
    private ReadDatabase connection;
    private Vector additionalDb = null;

    public DatabaseInfo(String driver, String url, String userName, String password) throws Exception {
        this(driver, url, userName, password, null);
    }

    public DatabaseInfo(String driver, String url, String userName, String password, Vector additionalDb) throws Exception {
        this.driver = driver;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.connection = new ReadDatabase(url, driver, userName, password);
        this.additionalDb = additionalDb;
    }

    public DatabaseInfo(String JNDIName, Hashtable env) throws Exception {
        this.useJNDIDataSource = true;
        this.JNDIName = JNDIName;
        this.env = env;
        this.connection = new ReadDatabase(JNDIName, env);
    }

    public DatabaseInfo(IDBConnection conn) {
        this.connection = new ReadDatabase(conn);
    }

    public String getURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public Hashtable getEnvProperties() {
        return this.env;
    }

    public boolean isUseJNDIDataSource() {
        return this.useJNDIDataSource;
    }

    public Vector getTableList(String[] type, int format) throws Exception {
        return this.connection.getTableList(type, format);
    }

    public Vector getAdditionalTableList(String[] type, int format) throws Exception {
        if (this.additionalDb == null) {
            return null;
        }
        Vector result = new Vector();
        for (int i = 0; i < this.additionalDb.size(); ++i) {
            try {
                ReadDatabase tmpCon = new ReadDatabase((String)this.additionalDb.get(i), this.driver, this.userName, this.password);
                result.addAll(tmpCon.getTableList(type, format));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public DataInputStream getTableListStream(String[] type, int nameFormat) throws Exception {
        return this.connection.getTableListStream(type, nameFormat);
    }

    public DataInputStream[] getAdditionalTableListStream(String[] type, int nameFormat) throws Exception {
        if (this.additionalDb == null) {
            return null;
        }
        DataInputStream[] dis = new DataInputStream[this.additionalDb.size()];
        for (int i = 0; i < this.additionalDb.size(); ++i) {
            try {
                ReadDatabase tmpCon = new ReadDatabase((String)this.additionalDb.get(i), this.driver, this.userName, this.password);
                dis[i] = tmpCon.getTableListStream(type, nameFormat);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return dis;
    }

    public String getProductName() throws Exception {
        return this.connection.getProductName();
    }

    public Vector getFunctions() throws Exception {
        try {
            Vector vec = XMLDatabaseFunctions.getDatabaseFunctionList(this.XMLFUNCTIONLIST, this.getProductName());
            if (vec != null) {
                return vec;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error error) {
            // empty catch block
        }
        return this.connection.getDefaultFunctions();
    }

    public Vector excuteQuery(String query, int startIndex, int displayRow) throws Exception {
        return this.connection.excuteQuery(query, startIndex, displayRow);
    }

    public Vector executeQuery(String query, int startIndex, int displayRow, int timeout) throws Exception {
        return this.connection.executeQuery(query, startIndex, displayRow, timeout);
    }

    public Vector executeQuery(String query, QueryInParamSet inSet, int startIndex, int displayRow, int timeout) throws Exception {
        return this.connection.executeQuery(query, inSet, startIndex, displayRow, timeout);
    }

    public Future<Vector> executeQueryAsync(String query, QueryInParamSet inSet, int startIndex, int displayRow, int timeout) {
        return this.connection.executeQueryAsync(query, inSet, startIndex, displayRow, timeout);
    }

    public void export(int format, String fileName, String query, QueryInParamSet pset) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(1024);
        try {
            this.export(format, fstream, query, pset);
            new WriteDataFile().output(fstream.toByteArray(), ExportQuery.getFullName(fileName, format));
        }
        catch (Exception ex) {
            fstream.close();
            throw ex;
        }
        fstream.close();
    }

    public void export(int format, OutputStream out, String query, QueryInParamSet pset) throws Exception {
        switch (format) {
            case 0: {
                new ExportQuery(this).exportSQL(out, query);
                break;
            }
            case 1: {
                new ExportQuery(this).exportCSV(out, query, pset);
            }
        }
    }

    public Object[][] getTableInfo(String tableName) throws Exception {
        return this.connection.getTableInfo(tableName);
    }

    public Object[][] getTableInfo(String tableName, boolean isQuery) throws Exception {
        return this.connection.getTableInfo(tableName, isQuery);
    }

    public Vector getForeignKeys(int tableFormat, String tableName) throws Exception {
        return this.connection.getKeyConstraints(tableFormat, tableName);
    }

    public boolean isLastPage(int startIndex, int displayRow) {
        return this.connection.isLastPage(startIndex, displayRow);
    }

    public int getRowCount() {
        return this.connection.getRowCount();
    }

    public Vector getAdditionalDb() {
        return this.additionalDb;
    }

    public int getAdditionalDbSize() {
        if (this.additionalDb == null) {
            return 0;
        }
        return this.additionalDb.size();
    }

    public ReadDatabase getConnection() {
        return this.connection;
    }

    public void setConnection(ReadDatabase connection) {
        this.connection = connection;
    }

    public boolean checkDB2Views() {
        return this.connection.checkDB2Views();
    }

    public void cancelRunningQuery() {
        if (this.connection != null) {
            this.connection.cancelRunningQuery();
        }
    }
}

