/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.querybuilder.query.DatabaseInfo;

public class ExportQuery {
    DatabaseInfo databaseInfo;
    public static final int SQL = 0;
    public static final int CSV = 1;

    public ExportQuery(DatabaseInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

    void exportCSV(OutputStream out, String query, QueryInParamSet pset) throws Exception {
        this.exportCSV(new PrintWriter(out, true), query, pset);
    }

    private void exportCSV(PrintWriter out, String query, QueryInParamSet pset) throws Exception {
        this.printColNameAndDataType(out, query);
        Vector vec = this.databaseInfo.executeQuery(query, pset, 0, -1, 10);
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < vec.size(); ++i) {
            Vector vec1 = (Vector)vec.elementAt(i);
            int len = vec1.size();
            for (int j = 0; j < len; ++j) {
                String tmp = vec1.elementAt(j) == null ? "" : vec1.elementAt(j).toString();
                str = str.append(tmp + this.getSeparator(j, len));
            }
        }
        out.println(str.toString());
    }

    private void printColNameAndDataType(PrintWriter out, String query) throws Exception {
        int i;
        Object[][] tmp;
        try {
            tmp = this.databaseInfo.getTableInfo(query, true);
        }
        catch (Exception ex) {
            out.println("failed to get Table Info... no Colume name and Data Type printed.");
            return;
        }
        int n = tmp.length;
        for (i = 0; i < n - 1; ++i) {
            out.print(tmp[i][2] + ",");
        }
        out.print(tmp[n - 1][2] + "\n");
        for (i = 0; i < n - 1; ++i) {
            out.print(tmp[i][0] + ",");
        }
        out.print(tmp[n - 1][0] + "\n");
    }

    private String getSeparator(int index, int totalItem) {
        if (index == totalItem - 1) {
            return "\n";
        }
        return ",";
    }

    void exportSQL(OutputStream out, String query) throws Exception {
        this.exportSQL(new PrintWriter(out, true), query);
    }

    void exportSQL(PrintWriter out, String query) throws Exception {
        out.println(query);
    }

    private static String[] getExtension(int type) {
        switch (type) {
            case 0: {
                return new String[]{"SQL"};
            }
            case 1: {
                return new String[]{"CSV"};
            }
        }
        return new String[]{"*"};
    }

    public static String getFullName(String fileName, int type) {
        String[] ext = ExportQuery.getExtension(type);
        if (type < 0 || ext[0].equals("*")) {
            return fileName;
        }
        for (String element : ext) {
            if (!fileName.toUpperCase().endsWith(element)) continue;
            return fileName;
        }
        return fileName + "." + ext[0].toLowerCase();
    }
}

