/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.query.DatabaseInfo;

public class ForeignKeyLocator {
    private static final Logger LOGGER = Logger.getLogger(ForeignKeyLocator.class.getName());
    private int databaseType = 0;
    private DatabaseInfo databaseInfo = null;
    private static Vector standardDatabases = null;
    public static boolean debug = true;

    public ForeignKeyLocator(int dbtype, DatabaseInfo dbInfo) {
        this.databaseType = dbtype;
        this.databaseInfo = dbInfo;
    }

    public Vector findForeignKeys(ColumnFieldWindow table, ColumnFieldWindow[] existingtables) {
        Vector keysVect;
        block22: {
            String tablename = table.getTableName();
            String query = "";
            keysVect = new Vector();
            if (this.databaseType == 3) {
                query = "SELECT SO_R.name, SC_R.name, SO_P.name, SC_P.name FROM sysobjects SO_R, sysobjects SO_P, sysforeignkeys SF, syscolumns SC_R, syscolumns SC_P WHERE SF.fkeyid=SO_R.id AND SF.rkeyid=SO_P.id AND SC_R.id=SO_R.id AND SC_P.id=SO_P.id       AND SC_R.colid=SF.fkey AND SC_P.colid=SF.rkey       AND (SO_R.name='" + tablename + "' OR SO_P.name='" + tablename + "')";
            } else if (this.databaseType == 1) {
                query = "SELECT szObject, szColumn, szReferencedObject, szReferencedColumn FROM MSysRelationships WHERE szObject='" + tablename + "' OR szReferencedObject='" + tablename + "'";
            } else if (this.databaseType == 2) {
                if (tablename.lastIndexOf(46) > -1) {
                    tablename = tablename.substring(tablename.lastIndexOf(46) + 1);
                    query = "SELECT concat(concat(UCC_R.OWNER, '.'), UCC_R.Table_Name), UCC_R.Column_Name, concat(concat(UCC_P.OWNER, '.'), UCC_P.Table_Name), UCC_P.Column_Name FROM USER_CONSTRAINTS UC, USER_CONS_COLUMNS UCC_R, USER_CONS_COLUMNS UCC_P WHERE UC.Constraint_Name=UCC_R.Constraint_Name AND UC.R_Constraint_Name=UCC_P.Constraint_Name       AND UC.Constraint_Type='R' AND UCC_R.Position=UCC_P.Position AND       (UCC_R.Table_Name='" + tablename + "' OR UCC_P.Table_Name='" + tablename + "')";
                } else {
                    query = "SELECT UCC_R.Table_Name, UCC_R.Column_Name, UCC_P.Table_Name, UCC_P.Column_Name FROM USER_CONSTRAINTS UC, USER_CONS_COLUMNS UCC_R, USER_CONS_COLUMNS UCC_P WHERE UC.Constraint_Name=UCC_R.Constraint_Name AND UC.R_Constraint_Name=UCC_P.Constraint_Name       AND UC.Constraint_Type='R' AND UCC_R.Position=UCC_P.Position AND       (UCC_R.Table_Name='" + tablename + "' OR UCC_P.Table_Name='" + tablename + "')";
                }
            } else if (this.databaseType == 4) {
                query = "SELECT CONCAT(CONCAT(KCU_R.TABSCHEMA, '.'), KCU_R.TABNAME), KCU_R.COLNAME,       CONCAT(CONCAT(KCU_P.TABSCHEMA, '.'), KCU_P.TABNAME), KCU_P.COLNAME FROM SYSCAT.KEYCOLUSE KCU_R, SYSCAT.KEYCOLUSE KCU_P, SYSCAT.REFERENCES R WHERE KCU_R.CONSTNAME=R.CONSTNAME AND KCU_P.CONSTNAME=R.REFKEYNAME AND       KCU_R.COLSEQ=KCU_P.COLSEQ AND       (CONCAT(CONCAT(KCU_R.TABSCHEMA, '.'), KCU_R.TABNAME)='" + tablename + "'       OR CONCAT(CONCAT(KCU_P.TABSCHEMA, '.'), KCU_P.TABNAME)='" + tablename + "')";
            }
            if (!query.equals("") && !this.isStandardDBInfo(this.databaseInfo) && this.databaseType != 1) {
                try {
                    if (this.databaseType != 4 || this.databaseInfo.checkDB2Views()) {
                        keysVect = this.getForeignKeyConstraints(query);
                        break block22;
                    }
                    if (standardDatabases == null) {
                        standardDatabases = new Vector();
                    }
                    standardDatabases.add(this.databaseInfo);
                    keysVect = this.useStandardForeignKeyConstraints(tablename);
                }
                catch (Exception e) {
                    if (debug) {
                        System.out.println("Exception during getForeignKeyConstraints(query)");
                        e.printStackTrace();
                    }
                    if (standardDatabases == null) {
                        standardDatabases = new Vector();
                    }
                    standardDatabases.add(this.databaseInfo);
                    keysVect = this.useStandardForeignKeyConstraints(tablename);
                }
            } else if (this.databaseType == 1 && !query.equals("")) {
                try {
                    keysVect = this.getForeignKeyConstraints(query);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to get foreign key constraints.", e);
                }
            } else {
                keysVect = this.useStandardForeignKeyConstraints(tablename);
            }
        }
        if (keysVect == null || keysVect.size() == 0) {
            return null;
        }
        return this.processForeignKeyLink(table, existingtables, keysVect);
    }

    private Vector useStandardForeignKeyConstraints(String tablename) {
        int loc2;
        int tableFormat = 0;
        int loc = tablename.indexOf(46);
        tableFormat = loc < 0 ? 0 : ((loc2 = tablename.indexOf(".", loc + 1)) < 0 ? 1 : 2);
        return this.getStandardKeyConstraints(tableFormat, tablename);
    }

    private boolean isStandardDBInfo(DatabaseInfo dbInfo) {
        if (standardDatabases == null) {
            return false;
        }
        for (int i = 0; i < standardDatabases.size(); ++i) {
            DatabaseInfo standardDbInfo = (DatabaseInfo)standardDatabases.get(i);
            if (standardDbInfo == null || !standardDbInfo.getURL().equals(dbInfo.getURL())) continue;
            return true;
        }
        return false;
    }

    private Vector getForeignKeyConstraints(String query) throws Exception {
        Vector dbresult = this.databaseInfo.executeQuery(query, 0, -1, 5);
        return dbresult;
    }

    private Vector getStandardKeyConstraints(int tableFormat, String tableName) {
        Vector results = new Vector();
        try {
            results = this.databaseInfo.getForeignKeys(tableFormat, tableName);
        }
        catch (Exception e) {
            return null;
        }
        return results;
    }

    private ColumnFieldWindow[] findColumnFieldWindow(String tablename, ColumnFieldWindow[] tablelist) {
        Vector<ColumnFieldWindow> cfwvect = new Vector<ColumnFieldWindow>();
        for (ColumnFieldWindow element : tablelist) {
            if (!tablename.equals(element.getTableName())) continue;
            cfwvect.add(element);
        }
        if (cfwvect.size() > 0) {
            return cfwvect.toArray(new ColumnFieldWindow[0]);
        }
        return new ColumnFieldWindow[0];
    }

    private Vector processForeignKeyLink(ColumnFieldWindow table, ColumnFieldWindow[] existingtables, Vector dbresult) {
        try {
            String tablename = table.getTableName();
            Vector ret = new Vector();
            for (int i = 0; i < dbresult.size(); ++i) {
                try {
                    ColumnFieldWindow[] cfw_array;
                    ColumnFieldWindow cfw = null;
                    int primaryindex = 1;
                    int secondaryindex = 3;
                    int index1 = -1;
                    int index2 = -1;
                    Vector foreignkeyVect = (Vector)dbresult.elementAt(i);
                    String tablename_1 = (String)foreignkeyVect.elementAt(0);
                    String tablename_3 = (String)foreignkeyVect.elementAt(2);
                    if (tablename_1.equals(tablename)) {
                        cfw_array = this.findColumnFieldWindow(tablename_3, existingtables);
                    } else if (tablename_3.equals(tablename)) {
                        cfw_array = this.findColumnFieldWindow(tablename_1, existingtables);
                        primaryindex = 3;
                        secondaryindex = 1;
                    } else {
                        cfw_array = new ColumnFieldWindow[]{};
                    }
                    for (ColumnFieldWindow element : cfw_array) {
                        cfw = element;
                        if (cfw == null) continue;
                        index1 = table.getIndex((String)((Vector)dbresult.elementAt(i)).elementAt(primaryindex));
                        index2 = cfw.getIndex((String)((Vector)dbresult.elementAt(i)).elementAt(secondaryindex));
                        if (index1 <= -1 || index2 <= -1) continue;
                        Vector<Serializable> rowvect = new Vector<Serializable>();
                        rowvect.add(table);
                        rowvect.add(Integer.valueOf(index1));
                        rowvect.add(cfw);
                        rowvect.add(Integer.valueOf(index2));
                        ret.add(rowvect);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }
}

