/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.Hashtable;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;

public class LoadQuery {
    Object[][] tbl;
    Object[] header;
    String[] visibleTable;
    String[] tableAlias;
    Rectangle[] bounds;
    String[][] joinProperties;
    private String driver;
    private String url;
    private String userName;
    private String password;
    private String JNDIName;
    private boolean useJNDIDataSource;
    private Hashtable env = new Hashtable();
    LoadQuery[] dictionaries = null;
    String[] dictionaryAlias = null;
    Rectangle[] dictionaryBounds = null;
    private boolean selectDistinct = false;
    private int tableNameFormat = 0;
    private QueryInParamSet paramSet = null;
    private String beforeSQL = null;
    private String afterSQL = null;

    public byte[] loadQueryFromFile(String urlname) throws Exception {
        return this.loadQueryFromFile(urlname, "QRY");
    }

    public byte[] loadQueryFromFile(String urlname, String ext) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        if (!urlname.toUpperCase().endsWith(("." + ext).toUpperCase())) {
            urlname = urlname + "." + ext;
        }
        DataInputStream din = readfile.getInputStream(urlname);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            while (true) {
                bout.write(din.readByte());
            }
        }
        catch (EOFException eOFException) {
            readfile.close();
            this.loadQuery(new DataInputStream(new ByteArrayInputStream(bout.toByteArray())));
            return bout.toByteArray();
        }
    }

    public Object[][] getQBETable() {
        return this.tbl;
    }

    public Object[] getQBEHeader() {
        return this.header;
    }

    public String[] getSelectedTable() {
        return this.visibleTable;
    }

    public String[] getTableAlias() {
        return this.tableAlias;
    }

    public Rectangle[] getTableBounds() {
        return this.bounds;
    }

    public String[][] getJoinProperties() {
        return this.joinProperties;
    }

    public LoadQuery[] getDictionaries() {
        return this.dictionaries;
    }

    public String[] getDictionaryAlias() {
        return this.dictionaryAlias;
    }

    public Rectangle[] getDictionaryBounds() {
        return this.dictionaryBounds;
    }

    public String getURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public Hashtable getEnvProperties() {
        return this.env;
    }

    public boolean isUseJNDIDataSource() {
        return this.useJNDIDataSource;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public void loadQuery(DataInputStream in) throws Exception {
        int i;
        int i2;
        boolean hasParam;
        int version = in.readInt();
        if (version >= 9) {
            this.useJNDIDataSource = in.readBoolean();
        }
        if (this.useJNDIDataSource) {
            this.JNDIName = Coder.decode(IOUtil.readString(in, true));
            String ctxFactory = Coder.decode(IOUtil.readString(in, true));
            String url = Coder.decode(IOUtil.readString(in, true));
            if (ctxFactory != null && !ctxFactory.equals("")) {
                this.env.put("java.naming.factory.initial", ctxFactory);
            }
            if (url != null && !url.equals("")) {
                this.env.put("java.naming.provider.url", url);
            }
        } else {
            this.driver = Coder.decode(IOUtil.readString(in, true));
            this.url = Coder.decode(IOUtil.readString(in, true));
            this.userName = Coder.decode(IOUtil.readString(in, true));
            this.password = Coder.decode(IOUtil.readString(in, true));
        }
        if (version >= 6 && (hasParam = in.readBoolean())) {
            int chartversion = in.readInt();
            this.paramSet = QueryInParamSet.read(in, chartversion);
        }
        int ct = in.readInt();
        this.visibleTable = new String[ct];
        this.tableAlias = new String[ct];
        this.bounds = new Rectangle[ct];
        for (i2 = ct - 1; i2 >= 0; --i2) {
            this.visibleTable[i2] = IOUtil.readString(in, true);
            this.tableAlias[i2] = IOUtil.readString(in, true);
            if (version < 8) continue;
            this.bounds[i2] = new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }
        ct = in.readInt();
        this.joinProperties = new String[ct][5];
        for (i2 = 0; i2 < ct; ++i2) {
            for (int j = 0; j < 4; ++j) {
                this.joinProperties[i2][j] = IOUtil.readString(in, true);
            }
            this.joinProperties[i2][4] = version >= 2 ? IOUtil.readString(in, true) : "INNER";
        }
        int nRow = in.readInt();
        int nCol = in.readInt();
        this.header = new Object[nCol];
        for (i = 0; i < nCol; ++i) {
            this.header[i] = IOUtil.readStr(in);
        }
        this.tbl = new Object[nRow][nCol];
        for (i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                if (i == 4) {
                    String isShowing = IOUtil.readStr(in);
                    if (isShowing == null) {
                        this.tbl[i][j] = null;
                        continue;
                    }
                    this.tbl[i][j] = Boolean.valueOf(isShowing);
                    continue;
                }
                this.tbl[i][j] = IOUtil.readStr(in);
            }
        }
        if (version >= 3) {
            ct = in.readInt();
            this.dictionaries = new LoadQuery[ct];
            this.dictionaryAlias = new String[ct];
            this.dictionaryBounds = new Rectangle[ct];
            for (i = 0; i < ct; ++i) {
                this.dictionaryAlias[i] = IOUtil.readString(in, true);
                if (version >= 8) {
                    this.dictionaryBounds[i] = new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
                }
                LoadQuery lq = new LoadQuery();
                lq.loadQuery(in);
                this.dictionaries[i] = lq;
            }
        }
        if (version >= 4) {
            this.selectDistinct = in.readBoolean();
        }
        if (version >= 5) {
            this.tableNameFormat = in.readInt();
        }
        if (version >= 7) {
            this.beforeSQL = IOUtil.readStr(in);
            this.afterSQL = IOUtil.readStr(in);
        }
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public String getBeforeSQL() {
        return this.beforeSQL;
    }

    public String getAfterSQL() {
        return this.afterSQL;
    }

    public QueryInParamSet getParamSet() {
        return this.paramSet;
    }
}

