/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import quadbase.common.util.internal.QbUtil;
import quadbase.querybuilder.designer.AdvanceDictionary;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.DesignView;
import quadbase.querybuilder.designer.SimpleDictionary;
import quadbase.querybuilder.query.AccessQueryBuilder;
import quadbase.querybuilder.query.CassandraQueryBuilder;
import quadbase.querybuilder.query.HiveQueryBuilder;
import quadbase.querybuilder.query.MicrosoftQueryBuilder;
import quadbase.querybuilder.query.MongoDBQueryBuilder;
import quadbase.querybuilder.query.MySQLQueryBuilder;
import quadbase.querybuilder.query.OracleQueryBuilder;
import quadbase.querybuilder.query.PostgreSQLQueryBuilder;
import quadbase.querybuilder.query.StandardQueryBuilder;

public abstract class QueryBuilder {
    public static final int TABLE_FLD = 0;
    public static final int COLUMN_FLD = 1;
    public static final int SORT_FLD = 2;
    public static final int AGGR_FLD = 3;
    public static final int SHOW_FLD = 4;
    public static final int CRITERIA_FLD = 5;
    public static final int OR_FLD = 6;
    public static final int STANDARD = 0;
    public static final int ACCESS = 1;
    public static final int ORACLE = 2;
    public static final int MICROSOFT = 3;
    public static final int DB2 = 4;
    public static final int MYSQL = 5;
    public static final int POSTGRESQL = 6;
    public static final int OPENEDGE = 7;
    public static final int MONGODB = 8;
    public static final int CASSANDRA = 9;
    public static final int HIVE = 10;
    public static final String[] DATABASETYPES = new String[]{"STANDARD", "ACCESS", "ORACLE", "MICROSOFT SQL SERVER", "DB2", "MYSQL", "POSTGRESQL", "OPENEDGE", "MONGODB", "CASSANDRA", "HIVE"};
    public static final String[] SORT_ORDER = new String[]{"", "Ascending", "Descending", "[not sorted]"};
    public static final int ASC = 1;
    public static final int DESC = 2;
    public static final int GROUPBY = 1;
    public static final int NONE = 0;
    public static final int WHERE_AGGR = 11;
    public static final String EXPRESSION = "Expression";
    public static final String[] AGGR = new String[]{"", "Group By", "Sum", "Avg", "Min", "Max", "Count", "stDev", "Var", "First", "Last", "Where"};
    public static final String[] OPERATOR = new String[]{"<>", "<=", ">=", "<", ">", "=", " IS NOT NULL", " IS NULL", " NOT ", " LIKE ", " BETWEEN ", " IN "};
    private static String[] FUNCSIGN = new String[]{"+", "-", "*", "/"};
    public static final int INNERJOIN = 0;
    public static final int LEFTOUTERJOIN = 1;
    public static final int RIGHTOUTERJOIN = 2;
    public static final String[] JOINPROPERTY = new String[]{"INNER", "LEFT OUTER", "RIGHT OUTER"};
    int databaseType = 0;
    JTable table;
    DefaultTableModel model;
    String[][] joinProperties;
    ColumnFieldWindow[] windows;
    Vector columnNames = new Vector();
    Vector groupByFields = null;
    private int HAVING = 1;
    private int WHERE = 2;
    private static boolean debug = false;
    protected boolean selectDistinct = false;

    public static int mapJoinLineIndex(String tmp) {
        for (int i = 0; i < JOINPROPERTY.length; ++i) {
            if (!tmp.equals(JOINPROPERTY[i])) continue;
            return i;
        }
        return 0;
    }

    public static int mapDatabaseType(String databaseName) {
        for (int i = 0; i < DATABASETYPES.length; ++i) {
            if (databaseName.toUpperCase().indexOf(DATABASETYPES[i]) <= -1) continue;
            return i;
        }
        return 0;
    }

    public static QueryBuilder create(int databaseType, JTable table, ColumnFieldWindow[] windows, String[][] joinProperties) {
        QueryBuilder qb = databaseType == 2 ? new OracleQueryBuilder(table, windows, joinProperties) : (databaseType == 3 ? new MicrosoftQueryBuilder(table, windows, joinProperties) : (databaseType == 1 ? new AccessQueryBuilder(table, windows, joinProperties) : (databaseType == 5 ? new MySQLQueryBuilder(table, windows, joinProperties) : (databaseType == 6 ? new PostgreSQLQueryBuilder(table, windows, joinProperties) : (databaseType == 8 ? new MongoDBQueryBuilder(table, windows, joinProperties) : (databaseType == 9 ? new CassandraQueryBuilder(table, windows, joinProperties) : (databaseType == 10 ? new HiveQueryBuilder(table, windows, joinProperties) : new StandardQueryBuilder(table, windows, joinProperties))))))));
        return qb;
    }

    public QueryBuilder(int databaseType, JTable table, ColumnFieldWindow[] windows, String[][] joinProperties) {
        this.databaseType = databaseType;
        this.table = table;
        this.model = (DefaultTableModel)table.getModel();
        this.windows = windows;
        this.joinProperties = joinProperties;
        if (this.hasAdvanceDictionary()) {
            this.table = this.createNewTable(table);
            this.model = (DefaultTableModel)this.table.getModel();
            this.joinProperties = new String[joinProperties.length][5];
            for (int i = 0; i < this.joinProperties.length; ++i) {
                for (int j = 0; j <= 2; j += 2) {
                    ColumnFieldWindow cfw = this.getWindow(joinProperties[i][j]);
                    if (cfw != null && cfw instanceof AdvanceDictionary) {
                        String[] table_column = ((AdvanceDictionary)cfw).getActualTableColumn(joinProperties[i][j + 1]);
                        this.joinProperties[i][j] = table_column[0];
                        this.joinProperties[i][j + 1] = table_column[1];
                        continue;
                    }
                    this.joinProperties[i][j] = joinProperties[i][j];
                    this.joinProperties[i][j + 1] = joinProperties[i][j + 1];
                }
                this.joinProperties[i][4] = joinProperties[i][4];
            }
        }
    }

    public String buildQuery() {
        StringBuffer sql = new StringBuffer(this.getColumnNameList());
        if (sql.length() == 0) {
            return "SELECT";
        }
        if (this.selectDistinct) {
            sql.insert(0, "SELECT DISTINCT ");
        } else {
            sql.insert(0, "SELECT ");
        }
        this.setGroupByFields();
        sql.append(this.addGroupByToSelect(sql));
        if (this.outerJoinEnabled() && !this.hasAdvanceDictionary()) {
            sql.append("\nFROM ").append(this.setOuterJoinProperties());
            String whereclause = this.setConditions(this.WHERE).trim();
            if (!whereclause.equals("")) {
                sql.append("\nWHERE ").append(whereclause);
            }
        } else {
            sql.append("\nFROM ").append(this.getTableNameList());
            sql.append(this.setWhereClause());
        }
        sql.append(this.setGroupByClause());
        sql.append(this.setHavingClause());
        sql.append(this.setOrderProperties());
        return sql.toString();
    }

    protected String addGroupByToSelect(StringBuffer sql) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.groupByFields.size(); ++i) {
            if (sql.indexOf((String)this.groupByFields.get(i)) != -1) continue;
            str.append(", ").append(this.groupByFields.get(i));
        }
        return str.toString();
    }

    protected ColumnFieldWindow getWindow(String alias) {
        if (this.windows == null) {
            return null;
        }
        for (ColumnFieldWindow window : this.windows) {
            if (!window.getDisplayName().equals(alias)) continue;
            return window;
        }
        return null;
    }

    protected boolean isTableUsed(ColumnFieldWindow win, Vector usedTable) {
        for (int i = 0; i < usedTable.size(); ++i) {
            if (!win.getDisplayName().equals(usedTable.elementAt(i).toString())) continue;
            return true;
        }
        return false;
    }

    protected String printNameAliasPair(ColumnFieldWindow table) {
        if (table == null) {
            return "";
        }
        if (table instanceof SimpleDictionary) {
            return "(" + table.getTableName() + ") " + this.print(table.getDisplayName());
        }
        if (table.getTableName().equals(table.getDisplayName())) {
            return this.print(table.getTableName());
        }
        return this.print(table.getTableName()) + " " + this.print(table.getDisplayName());
    }

    private boolean outerJoinEnabled() {
        for (int i = 0; i < this.joinProperties.length; ++i) {
            if (this.joinProperties[i][4].equals(JOINPROPERTY[0])) continue;
            return true;
        }
        return false;
    }

    private String setOuterJoinProperties() {
        String tmp = "";
        Vector joinSets = this.reorderJoinProperties(this.joinProperties);
        Vector<String> usedTableList = new Vector<String>();
        for (int k = 0; k < joinSets.size(); ++k) {
            Vector joins = (Vector)joinSets.elementAt(k);
            if (k > 0) {
                tmp = this.printNameAliasPair(this.getWindow(((String[])joins.elementAt(0))[2])) + " CROSS JOIN (" + tmp + ")";
            }
            for (int i = 0; i < joins.size(); ++i) {
                String[] current = (String[])joins.elementAt(i);
                usedTableList.add(current[0]);
                usedTableList.add(current[2]);
                tmp = tmp.equals("") ? this.printNameAliasPair(this.getWindow(current[2])) : "(" + tmp + ")";
                tmp = this.printNameAliasPair(this.getWindow(current[0])) + " " + current[4] + " JOIN " + tmp + " ON " + this.printExpression(current[0], this.print(current[1])) + " = " + this.printExpression(current[2], this.print(current[3]));
                while (i < joins.size() - 1 && current[0].equals(((String[])joins.elementAt(i + 1))[0])) {
                    current = (String[])joins.elementAt(++i);
                    tmp = tmp + " AND " + this.printExpression(current[0], this.print(current[1])) + " = " + this.printExpression(current[2], this.print(current[3]));
                }
            }
        }
        String unUsedTbl = this.getTableNameList(usedTableList);
        if (unUsedTbl.trim().equals("")) {
            return tmp;
        }
        return unUsedTbl + ", " + tmp;
    }

    String setJoinProperties() {
        String tmp = "";
        for (String[] joinPropertie : this.joinProperties) {
            tmp = tmp.equals("") ? tmp : tmp + "\nAND ";
            String first = "";
            String second = "";
            first = joinPropertie[0] == null ? "(" + joinPropertie[1] + ")" : this.printExpression(joinPropertie[0], joinPropertie[1]);
            second = joinPropertie[2] == null ? "(" + joinPropertie[3] + ")" : this.printExpression(joinPropertie[2], joinPropertie[3]);
            tmp = tmp + "(" + first + " = " + second + ")";
        }
        return tmp;
    }

    String setGroupByClause() {
        int[] viewColIndexes;
        String tmp = "";
        for (int i : viewColIndexes = this.getViewColIndexes()) {
            String agg;
            if (!this.isValidColumn(i) || (agg = this.getAggregation(i)) == null || !agg.equals(AGGR[1])) continue;
            tmp = (tmp.equals("") ? "\nGROUP BY " : tmp + ", ") + this.printName(i);
        }
        return tmp;
    }

    void setGroupByFields() {
        int[] viewColIndexes;
        this.groupByFields = new Vector();
        for (int i : viewColIndexes = this.getViewColIndexes()) {
            String agg;
            if (!this.isValidColumn(i) || (agg = this.getAggregation(i)) == null || !agg.equals(AGGR[1])) continue;
            this.groupByFields.addElement(this.printName(i));
        }
    }

    private int[] getViewColIndexes() {
        int[] viewColIndexes = new int[this.model.getColumnCount()];
        for (int i = 0; i < viewColIndexes.length; ++i) {
            viewColIndexes[this.table.convertColumnIndexToView((int)i)] = i;
        }
        return viewColIndexes;
    }

    public String setWhereClause() {
        String join = this.setJoinProperties();
        return this.setConditionClause(join, this.WHERE);
    }

    private String setConditionClause(String join, int state) {
        String condition = this.setConditions(state);
        String tmp = "";
        String WHERE = "\nWHERE ";
        tmp = !join.equals("") && !condition.equals("") ? "(" + join + ") \nAND (" + condition + ")" : join + condition;
        if (this.hasAdvanceDictionary()) {
            for (ColumnFieldWindow window : this.windows) {
                if (!(window instanceof AdvanceDictionary)) continue;
                String subwc = ((AdvanceDictionary)window).getWhereClause();
                if (tmp.length() > 0 && subwc.length() > 0) {
                    tmp = "(" + tmp + ") \nAND (" + subwc + ")";
                    continue;
                }
                if (subwc.length() <= 0) continue;
                tmp = subwc;
            }
        }
        if (tmp.length() <= 0) {
            return tmp;
        }
        return WHERE + tmp;
    }

    String setHavingClause() {
        if (!QueryBuilder.isAggregationEnabled(this.model)) {
            return "";
        }
        String condition = this.setConditions(this.HAVING);
        if (condition.equals("")) {
            return "";
        }
        return "\nHAVING " + condition;
    }

    private String setConditions(int state) {
        String tmp = "";
        for (int i = 5; i < this.model.getRowCount(); ++i) {
            String str = this.getRowCondition(i, state);
            if (str == null) continue;
            tmp = (tmp.equals("") ? "" : tmp + "\nOR ") + str;
        }
        return tmp;
    }

    private String getRowCondition(int rowIndex, int state) {
        String tmp = "";
        for (int j = 0; j < this.model.getColumnCount(); ++j) {
            String str = this.getCondition(rowIndex, this.table.convertColumnIndexToModel(j), state);
            if (str == null) continue;
            tmp = (tmp.equals("") ? "" : tmp + " AND ") + str;
        }
        if (tmp.equals("")) {
            return null;
        }
        if (tmp.indexOf(" AND ") >= 0) {
            return "(" + tmp + ")";
        }
        return tmp;
    }

    String setOrderProperties() {
        int i;
        String tmp = "";
        String[] nameList = new String[this.model.getColumnCount()];
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            int t = this.table.convertColumnIndexToView(i);
            Boolean isAsc = this.isAscending(i);
            if (isAsc == null) continue;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
            Object header = colModel.getColumn(t).getHeaderValue();
            String displayField = header instanceof DesignView.HeaderWithDataTypeObject ? ((DesignView.HeaderWithDataTypeObject)header).getValue() : (String)header;
            String colField = this.model.getValueAt(1, i).toString();
            nameList[t] = this.getAggregation(i) == null && displayField.equals(colField) || displayField.equals("*") ? this.printName(i) + (isAsc != false ? "" : " DESC") : this.print(displayField) + (isAsc != false ? "" : " DESC");
        }
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            if (nameList[i] == null) continue;
            tmp = (tmp.equals("") ? "\nORDER BY " : tmp + ", ") + nameList[i];
        }
        return tmp;
    }

    public String getColumnNameList() {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
        String tmp = "";
        Vector<String> tablecolumns = null;
        Vector[] allTablecolumns = new Vector[this.model.getColumnCount()];
        Object[] temporary_headers = new Object[this.model.getColumnCount()];
        String[] nameList = new String[this.model.getColumnCount()];
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            if (!this.isColumnVisible(i)) continue;
            int t = this.table.convertColumnIndexToView(i);
            Object header = colModel.getColumn(t).getHeaderValue();
            String displayField = header instanceof DesignView.HeaderWithDataTypeObject ? ((DesignView.HeaderWithDataTypeObject)header).getValue() : (String)header;
            String colField = this.model.getValueAt(1, i).toString();
            String tableField = this.model.getValueAt(0, i).toString();
            nameList[t] = this.getAggregation(i) == null && displayField.equals(colField) || displayField.equals("*") ? ", " + this.printName(i) : ", " + this.printName(i) + " AS " + this.print(displayField);
            if (colField.equals("*")) {
                ColumnFieldWindow cfw = this.getWindow(tableField);
                tablecolumns = new Vector<String>();
                if (cfw != null) {
                    String[] cols;
                    for (String col : cols = cfw.getColumns()) {
                        tablecolumns.addElement(col);
                    }
                }
                temporary_headers[t] = tablecolumns;
            } else if (displayField.equals("*")) {
                int sep;
                String name;
                tablecolumns = new Vector();
                int start = 0;
                int end = colField.indexOf(44);
                while (end > -1) {
                    name = colField.substring(start, end);
                    sep = name.indexOf(46);
                    if (sep > -1) {
                        name = name.substring(sep + 1);
                    }
                    tablecolumns.add(name);
                    start = end + 1;
                    end = colField.indexOf(",", start);
                }
                name = colField.substring(start);
                sep = name.indexOf(46);
                if (sep > -1) {
                    name = name.substring(sep + 1);
                }
                tablecolumns.add(name);
                temporary_headers[t] = tablecolumns;
            } else {
                temporary_headers[t] = displayField;
            }
            allTablecolumns[i] = tablecolumns;
        }
        int inx = 0;
        for (String element : nameList) {
            if (element == null) continue;
            if (element.contains(".*") && this.databaseType == 8) {
                String tableName = element.substring(0, element.length() - 2);
                element = "";
                for (int j = 0; j < allTablecolumns[inx].size(); ++j) {
                    element = element + tableName + "." + (String)allTablecolumns[inx].get(j);
                }
                ++inx;
            }
            tmp = tmp + element;
        }
        if (tmp.length() > 0) {
            tmp = tmp.substring(1).trim();
        }
        for (Object temporary_header : temporary_headers) {
            if (temporary_header instanceof String) {
                this.columnNames.addElement(temporary_header);
                continue;
            }
            if (!(temporary_header instanceof Vector)) continue;
            tablecolumns = (Vector<String>)temporary_header;
            for (int i = 0; i < tablecolumns.size(); ++i) {
                this.columnNames.addElement(tablecolumns.elementAt(i));
            }
        }
        return tmp;
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    String getTableNameList() {
        return this.getTableNameList(new Vector());
    }

    private String getTableNameList(Vector usedTable) {
        String tmp = "";
        for (ColumnFieldWindow window : this.windows) {
            if (this.isTableUsed(window, usedTable)) continue;
            String tablestr = "";
            if (window instanceof AdvanceDictionary) {
                Vector tablelist = ((AdvanceDictionary)window).getTableAliasPairs();
                for (int j = 0; j < tablelist.size(); ++j) {
                    tablestr = tablestr + ", " + this.print(((String[])tablelist.elementAt(j))[0]) + " " + this.print(((String[])tablelist.elementAt(j))[1]);
                }
                if (tablestr.length() > 0) {
                    tablestr = tablestr.substring(1).trim();
                }
            } else {
                tablestr = window instanceof SimpleDictionary ? "(" + window.getTableName() + ") " + this.print(window.getDisplayName()) : (window.getTableName().equals(window.getDisplayName()) ? this.print(window.getTableName()) : this.print(window.getTableName()) + " " + this.print(window.getDisplayName()));
            }
            tmp = tmp.equals("") ? tablestr : tmp + ", " + tablestr;
        }
        return tmp;
    }

    public static boolean isValidColumn(DefaultTableModel model, int colIndex) {
        Object table = model.getValueAt(0, colIndex);
        if (table == null || table.toString().trim().equals("")) {
            return false;
        }
        Object column = model.getValueAt(1, colIndex);
        return column != null && !column.toString().trim().equals("");
    }

    private boolean isValidColumn(int colIndex) {
        return QueryBuilder.isValidColumn(this.model, colIndex);
    }

    private boolean isColumnVisible(int colIndex) {
        if (!this.isValidColumn(colIndex)) {
            return false;
        }
        Object showCol = this.model.getValueAt(4, colIndex);
        return showCol == null || !showCol.toString().trim().equals("false");
    }

    public static boolean isAggregationEnabled(DefaultTableModel model) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            if (QueryBuilder.getAggregation(model, i) == null) continue;
            return true;
        }
        return false;
    }

    private String getAggregation(int colIndex) {
        return QueryBuilder.getAggregation(this.model, colIndex);
    }

    public static String getAggregation(DefaultTableModel model, int colIndex) {
        Object col = model.getValueAt(3, colIndex);
        if (col == null || col.toString().trim().equals("")) {
            return null;
        }
        return col.toString();
    }

    private Boolean isAscending(int colIndex) {
        if (!this.isValidColumn(colIndex)) {
            return null;
        }
        Object col = this.model.getValueAt(2, colIndex);
        if (col == null) {
            return null;
        }
        if (col.toString().trim().equals(SORT_ORDER[1])) {
            return Boolean.TRUE;
        }
        if (col.toString().trim().equals(SORT_ORDER[2])) {
            return Boolean.FALSE;
        }
        return null;
    }

    private String getCondition(int row, int col, int state) {
        String cond;
        int i;
        if (!this.isValidColumn(col)) {
            return null;
        }
        Object obj = this.model.getValueAt(row, col);
        if (obj == null || obj.toString().trim().equals("")) {
            return null;
        }
        String con = obj.toString().trim();
        Vector strKeys = QueryBuilder.getStringTokenizer(con);
        for (int i2 = 0; i2 < strKeys.size(); ++i2) {
            String[] key = (String[])strKeys.elementAt(i2);
            con = QbUtil.replace(con, key[1], key[0]);
        }
        if (debug) {
            System.out.println("Sub COND : " + con);
        }
        Vector condVec = new Vector();
        QueryBuilder.andOrTokenizer(con, condVec);
        String str = "";
        String res = "";
        boolean isBetweenOp = false;
        boolean add = true;
        for (i = 0; i < condVec.size(); ++i) {
            String tmp = (String)condVec.elementAt(i);
            if ((" " + tmp).toUpperCase().indexOf(" BETWEEN ") >= 0) {
                str = str + tmp;
                isBetweenOp = true;
                continue;
            }
            if (isBetweenOp && tmp.toUpperCase().indexOf(" AND ") >= 0) {
                str = str + tmp;
                isBetweenOp = false;
                continue;
            }
            if (!isBetweenOp && this.checkAndOr(tmp)) {
                String cond2;
                if (debug) {
                    System.out.println("GET CONDITION = " + str);
                }
                if ((cond2 = this.getCondition(col, state, str.trim())) != null && !cond2.equals("")) {
                    res = res + cond2 + tmp;
                }
                str = "";
                add = true;
                continue;
            }
            if (add && this.isTableIncluded(tmp)) {
                str = str + tmp;
                continue;
            }
            add = false;
            str = "";
        }
        if (!str.equals("") && (cond = this.getCondition(col, state, str)) != null) {
            res = res + cond;
        }
        if (res.trim().toUpperCase().startsWith("AND")) {
            res = res.trim().substring(3);
        }
        if (res.trim().toUpperCase().endsWith("AND")) {
            res = res.trim().substring(0, res.trim().length() - 3);
        }
        if (res.trim().toUpperCase().startsWith("OR")) {
            res = res.trim().substring(2);
        }
        if (res.trim().toUpperCase().endsWith("OR")) {
            res = res.trim().substring(0, res.trim().length() - 2);
        }
        if (!(res = this.balanceParentheses(res)).trim().equals("")) {
            res = "(" + res + ")";
        }
        for (i = 0; i < strKeys.size(); ++i) {
            String[] key = (String[])strKeys.elementAt(i);
            res = QbUtil.replace(res, key[0], key[1]);
        }
        if (res == null || res.trim().equalsIgnoreCase("null") || res.trim().equals("")) {
            return null;
        }
        return res;
    }

    private String balanceParentheses(String str) {
        int i;
        StringBuffer sb = new StringBuffer();
        int parCt = 0;
        Vector<Integer> openPar = new Vector<Integer>();
        for (i = 0; i < str.length(); ++i) {
            boolean append = true;
            if (str.charAt(i) == '(') {
                ++parCt;
                openPar.add(i);
            } else if (str.charAt(i) == ')') {
                if (parCt == 0) {
                    append = false;
                } else {
                    --parCt;
                    openPar.remove(openPar.size() - 1);
                }
            }
            if (!append) continue;
            sb.append(str.charAt(i));
        }
        for (i = openPar.size() - 1; i >= 0; --i) {
            sb.deleteCharAt((Integer)openPar.get(i));
        }
        return sb.toString();
    }

    private boolean checkAndOr(String token) {
        return token.toUpperCase().matches("\\sAND\\s") || token.toUpperCase().matches("\\sOR\\s");
    }

    private boolean isTableIncluded(String token) {
        String tables = " " + this.getTableNameList() + " ";
        int dot = token.indexOf(46);
        if (dot == -1) {
            return true;
        }
        String table = token.substring(0, dot);
        Pattern pattern = Pattern.compile("[a-zA-Z0-9]+$");
        Matcher matcher = pattern.matcher(table);
        boolean matchFound = matcher.find();
        if (matchFound) {
            table = matcher.group();
        }
        if (tables.toUpperCase().indexOf(table.toUpperCase()) > -1) {
            return true;
        }
        pattern = Pattern.compile("^[+-]?[0-9]+$");
        matcher = pattern.matcher(table);
        matchFound = matcher.find();
        return matchFound;
    }

    private String getCondition(int col, int state, String str) {
        if (str.equals("")) {
            return null;
        }
        int index = QueryBuilder.indexOfOperator(str.trim());
        if (index < 0) {
            return this.filterCondition("(" + this.printName(col) + " = " + str + ")", state);
        }
        if (index == 0) {
            return this.filterCondition("(" + this.printName(col) + " " + str + ")", state);
        }
        return this.filterCondition("(" + str + ")", state);
    }

    private String filterCondition(String str, int state) {
        int i;
        if (this.groupByFields == null || this.groupByFields.size() == 0) {
            if (state == this.WHERE) {
                return str;
            }
            return null;
        }
        for (i = 0; i < this.groupByFields.size(); ++i) {
            if (!this.containsWord(str.toUpperCase(), this.groupByFields.elementAt(i).toString().toUpperCase())) continue;
            if (state == this.HAVING) {
                return null;
            }
            if (state != this.WHERE) continue;
            return str;
        }
        for (i = 2; i < AGGR.length - 1; ++i) {
            if (!this.containsWord(str.toUpperCase(), AGGR[i].toUpperCase())) continue;
            if (state == this.HAVING) {
                return str;
            }
            if (state != this.WHERE) continue;
            return null;
        }
        if (state == this.WHERE) {
            return str;
        }
        return null;
    }

    private boolean containsWord(String str, String word) {
        Pattern pattern = Pattern.compile("\\b" + word + "\\b");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private static int indexOfOperator(String orgStr) {
        String str = " " + orgStr;
        int tmp = -1;
        for (String element : OPERATOR) {
            tmp = str.toUpperCase().indexOf(element);
            if (tmp >= 1) {
                return tmp - 1;
            }
            if (tmp < 0) continue;
            return tmp;
        }
        tmp = str.toUpperCase().indexOf(" IN ");
        if (tmp >= 0) {
            return tmp;
        }
        tmp = str.toUpperCase().indexOf(" IN(");
        if (tmp >= 0) {
            return tmp;
        }
        tmp = str.toUpperCase().indexOf(")IN");
        if (tmp >= 0) {
            return tmp + 1;
        }
        tmp = str.toUpperCase().indexOf("IN ");
        if (tmp == 0) {
            return tmp;
        }
        tmp = str.toUpperCase().indexOf("IN(");
        if (tmp == 0) {
            return tmp;
        }
        tmp = str.toUpperCase().indexOf(" EXISTS ");
        if (tmp >= 0) {
            return 1;
        }
        tmp = str.toUpperCase().indexOf("EXISTS ");
        if (tmp == 0) {
            return 1;
        }
        return -1;
    }

    private static int indexOfFunctionSign(String orgStr) {
        String str = " " + orgStr;
        int tmp = -1;
        for (String element : FUNCSIGN) {
            tmp = str.toUpperCase().indexOf(element);
            if (tmp >= 1) {
                return tmp - 1;
            }
            if (tmp < 0) continue;
            return tmp;
        }
        return -1;
    }

    public static Vector getStringTokenizer(String con) {
        Vector<String[]> vec = new Vector<String[]>();
        boolean withinString = false;
        boolean withinPrompt = false;
        String str = "";
        for (int i = 0; i < con.length(); ++i) {
            String[] key;
            char val = con.charAt(i);
            if (val == '\'' && !withinPrompt) {
                if (i + 1 < con.length() && con.charAt(i + 1) == '\'') {
                    if (withinString) {
                        str = str + val;
                    }
                    ++i;
                    continue;
                }
                if (withinString) {
                    str = str + val;
                    key = new String[]{"QBD_I_KEY" + vec.size(), str};
                    vec.addElement(key);
                    withinString = false;
                    continue;
                }
                withinString = true;
                str = "'";
                continue;
            }
            if (val == '#' && !withinString) {
                if (withinPrompt) {
                    str = str + val;
                    key = new String[]{"QBD_I_KEY" + vec.size(), str};
                    vec.addElement(key);
                    withinPrompt = false;
                    continue;
                }
                withinPrompt = true;
                str = "#";
                continue;
            }
            if (!withinString && !withinPrompt) continue;
            str = str + val;
        }
        return vec;
    }

    public static String formatCondition(int databaseType, String con) {
        int i;
        if (!con.startsWith(" ")) {
            con = " " + con;
        }
        if (debug) {
            System.out.println("Original Statement : " + con);
        }
        Vector strKeys = QueryBuilder.getStringTokenizer(con);
        for (int i2 = 0; i2 < strKeys.size(); ++i2) {
            String[] key = (String[])strKeys.elementAt(i2);
            con = QbUtil.replace(con, key[1], key[0]);
        }
        if (debug) {
            System.out.println("Sub Statement : " + con);
        }
        Vector condVec = new Vector();
        QueryBuilder.conditionTokenizer(con, condVec);
        String str = "";
        String res = "";
        for (i = 0; i < condVec.size(); ++i) {
            String tmp = (String)condVec.elementAt(i);
            if (QueryBuilder.indexOfOperator(tmp) >= 0 || tmp.toUpperCase().indexOf(" AND ") >= 0 || tmp.toUpperCase().indexOf(" OR ") >= 0 || tmp.toUpperCase().startsWith("AND ") || tmp.toUpperCase().startsWith("OR ") || tmp.toUpperCase().endsWith(" AND") || tmp.toUpperCase().endsWith(" OR") || tmp.equalsIgnoreCase("AND") || tmp.equalsIgnoreCase("OR")) {
                res = res + QueryBuilder.formulaTokenizer(databaseType, str) + tmp;
                str = "";
                continue;
            }
            str = str + tmp;
        }
        if (!str.equals("")) {
            res = res + QueryBuilder.formulaTokenizer(databaseType, str);
        }
        for (i = 0; i < strKeys.size(); ++i) {
            String[] key = (String[])strKeys.elementAt(i);
            res = QbUtil.replace(res, key[0], key[1]);
        }
        res = QueryBuilder.autoCorrectInClause(res);
        if (debug) {
            System.out.println("Final Statement : " + res);
        }
        return res;
    }

    private static void conditionTokenizer(String con, Vector vec) {
        int tmp3;
        if (debug) {
            System.out.println("CONDITION TOKENIZER : " + con);
        }
        int tmp = -1;
        int operatorLen = 0;
        int i = 0;
        int tmp2 = con.toUpperCase().indexOf(" AND ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf(" OR ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf(" AND\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf("\nAND ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf("\nAND\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf(" OR\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf("\nOR\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf("\nOR ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        if ((tmp < 0 || con.toUpperCase().startsWith("AND ")) && con.toUpperCase().startsWith("AND ")) {
            operatorLen = 4;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().startsWith("OR ")) && con.toUpperCase().startsWith("OR ")) {
            operatorLen = 3;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().endsWith(" AND")) && con.toUpperCase().endsWith(" AND")) {
            operatorLen = 4;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().endsWith(" OR")) && con.toUpperCase().endsWith(" OR")) {
            operatorLen = 3;
            tmp = 0;
        }
        if ((tmp < 0 || con.equalsIgnoreCase("AND")) && con.equalsIgnoreCase("AND")) {
            operatorLen = 3;
            tmp = 0;
        }
        if (tmp < 0 && con.equalsIgnoreCase("OR")) {
            operatorLen = 2;
            tmp = 0;
        }
        if (tmp < 0) {
            for (i = 0; i < OPERATOR.length; ++i) {
                tmp = con.toUpperCase().indexOf(OPERATOR[i]);
                if (tmp < 0) continue;
                operatorLen = OPERATOR[i].length();
                break;
            }
        }
        if (tmp >= 0 && OPERATOR[i].equals("=")) {
            tmp3 = con.toUpperCase().indexOf("=NULL");
            if (tmp3 >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(0, tmp3), vec);
                vec.addElement(" IS NULL");
                QueryBuilder.conditionTokenizer(con.substring(tmp + 5), vec);
                return;
            }
            tmp3 = con.toUpperCase().indexOf("= NULL");
            if (tmp3 >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(0, tmp3), vec);
                vec.addElement(" IS NULL");
                QueryBuilder.conditionTokenizer(con.substring(tmp + 6), vec);
                return;
            }
        }
        if (tmp >= 0 && OPERATOR[i].equals("<>")) {
            tmp3 = con.toUpperCase().indexOf("<>NULL");
            if (tmp3 >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(0, tmp3), vec);
                vec.addElement(" IS NOT NULL");
                QueryBuilder.conditionTokenizer(con.substring(tmp + 6), vec);
                return;
            }
            tmp3 = con.toUpperCase().indexOf("<> NULL");
            if (tmp3 >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(0, tmp3), vec);
                vec.addElement(" IS NOT NULL");
                QueryBuilder.conditionTokenizer(con.substring(tmp + 7), vec);
                return;
            }
        }
        if (tmp >= 0 && OPERATOR[i].equals(" NOT ") && (tmp3 = con.toUpperCase().indexOf(" NOT NULL")) >= 0) {
            QueryBuilder.conditionTokenizer(con.substring(0, tmp3), vec);
            vec.addElement(" IS NOT NULL");
            QueryBuilder.conditionTokenizer(con.substring(tmp + 9), vec);
            return;
        }
        if (tmp < 0 && (tmp = con.toUpperCase().indexOf(" NULL")) >= 0) {
            QueryBuilder.conditionTokenizer(con.substring(0, tmp), vec);
            vec.addElement(" IS NULL");
            QueryBuilder.conditionTokenizer(con.substring(tmp + 5), vec);
            return;
        }
        if (tmp < 0) {
            vec.addElement(con);
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con);
            }
            return;
        }
        if (tmp > 0) {
            QueryBuilder.conditionTokenizer(con.substring(0, tmp), vec);
        }
        if (operatorLen > 0) {
            vec.addElement(con.substring(tmp, tmp + operatorLen));
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con.substring(tmp, tmp + operatorLen));
            }
            if (tmp >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(tmp + operatorLen), vec);
            }
        }
    }

    private static void functionSignTokenizer(String con, Vector vec) {
        int tmp = -1;
        int operatorLen = 0;
        for (String element : FUNCSIGN) {
            tmp = con.toUpperCase().indexOf(element);
            if (tmp < 0) continue;
            operatorLen = element.length();
            break;
        }
        if (tmp < 0) {
            vec.addElement(con);
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con);
            }
            return;
        }
        if (tmp > 0) {
            QueryBuilder.functionSignTokenizer(con.substring(0, tmp), vec);
        }
        if (operatorLen > 0) {
            vec.addElement(con.substring(tmp, tmp + operatorLen));
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con.substring(tmp, tmp + operatorLen));
            }
            if (tmp >= 0) {
                QueryBuilder.functionSignTokenizer(con.substring(tmp + operatorLen), vec);
            }
        }
    }

    public static void andOrTokenizer(String con, Vector vec) {
        if (debug) {
            System.out.println("AND OR TOKENIZER : " + con);
        }
        int tmp = -1;
        int operatorLen = 0;
        if (tmp < 0) {
            tmp = con.toUpperCase().indexOf(" AND ");
            operatorLen = 5;
        }
        int tmp2 = con.toUpperCase().indexOf(" AND\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf("\nAND ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = con.toUpperCase().indexOf("\nAND ");
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf("\nAND\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 5;
        }
        tmp2 = con.toUpperCase().indexOf(" OR ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf(" OR\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf("\nOR\n");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        tmp2 = con.toUpperCase().indexOf("\nOR ");
        if (tmp < 0 || tmp2 > -1 && tmp2 < tmp) {
            tmp = tmp2;
            operatorLen = 4;
        }
        if ((tmp < 0 || con.toUpperCase().startsWith("AND ")) && con.toUpperCase().startsWith("AND ")) {
            operatorLen = 4;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().startsWith("OR ")) && con.toUpperCase().startsWith("OR ")) {
            operatorLen = 3;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().endsWith(" AND")) && con.toUpperCase().endsWith(" AND")) {
            operatorLen = 4;
            tmp = 0;
        }
        if ((tmp < 0 || con.toUpperCase().endsWith(" OR")) && con.toUpperCase().endsWith(" OR")) {
            operatorLen = 3;
            tmp = 0;
        }
        if (tmp < 0 && con.equalsIgnoreCase("AND")) {
            operatorLen = 3;
            tmp = 0;
        }
        if (tmp < 0 && con.equalsIgnoreCase("OR")) {
            operatorLen = 2;
            tmp = 0;
        }
        if (tmp < 0) {
            vec.addElement(con);
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con);
            }
            return;
        }
        if (tmp > 0) {
            QueryBuilder.conditionTokenizer(con.substring(0, tmp), vec);
        }
        if (operatorLen > 0) {
            vec.addElement(con.substring(tmp, tmp + operatorLen));
            if (debug) {
                System.out.println("COND ADD ELEMENT : " + con.substring(tmp, tmp + operatorLen));
            }
            if (tmp >= 0) {
                QueryBuilder.conditionTokenizer(con.substring(tmp + operatorLen), vec);
            }
        }
    }

    private static String functionTokenizer(int databaseType, String func) {
        int opB = func.indexOf(40);
        int endB = func.lastIndexOf(41);
        if (opB >= 0 && endB > opB) {
            return func.substring(0, opB + 1) + QueryBuilder.functionTokenizer(databaseType, func.substring(opB + 1, endB)) + func.substring(endB);
        }
        if (func.indexOf(44) > 0 && endB >= 0) {
            String res = null;
            StringTokenizer strTk = new StringTokenizer(func, ",");
            while (strTk.hasMoreTokens()) {
                String token = strTk.nextToken();
                if (res == null) {
                    res = QueryBuilder.functionTokenizer(databaseType, token);
                    continue;
                }
                res = res + ", " + QueryBuilder.functionTokenizer(databaseType, token);
            }
            return res + func.substring(endB);
        }
        return QueryBuilder.formatExpression(databaseType, func);
    }

    static String getFunctionName(String tmp) {
        int opB = tmp.indexOf(40);
        if (opB > 0) {
            return tmp.substring(0, opB + 1);
        }
        return tmp + "(";
    }

    private static String formulaTokenizer(int databaseType, String func) {
        Vector condVec = new Vector();
        QueryBuilder.functionSignTokenizer(func, condVec);
        String str = "";
        String res = "";
        for (int i = 0; i < condVec.size(); ++i) {
            String tmp = (String)condVec.elementAt(i);
            if (debug) {
                System.out.println("FORM " + i + " = " + tmp);
            }
            if (QueryBuilder.indexOfFunctionSign(tmp) >= 0) {
                String orgStr = QueryBuilder.functionTokenizer(databaseType, str);
                String newStr = QueryBuilder.isString(orgStr);
                if (newStr == null) {
                    res = res + orgStr + tmp;
                    str = "";
                    continue;
                }
                str = str + tmp;
                continue;
            }
            str = str + tmp;
        }
        if (!str.equals("")) {
            res = res + QueryBuilder.functionTokenizer(databaseType, str);
        }
        res = QueryBuilder.autoCorrectInClause(res);
        if (debug) {
            System.out.println("Final Statement : " + res);
        }
        return res;
    }

    private static String autoCorrectInClause(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str);
        String val = "";
        while (tokenizer.hasMoreTokens()) {
            String tk = tokenizer.nextToken();
            if (tk.equalsIgnoreCase("IN")) {
                val = (val.equals("") ? "" : val + " ") + tk;
                if (!tokenizer.hasMoreTokens()) continue;
                String param = tokenizer.nextToken();
                if (param.startsWith(":")) {
                    val = val + " (" + param + ")";
                    continue;
                }
                val = (val.equals("") ? "" : val + " ") + param;
                continue;
            }
            val = (val.equals("") ? "" : val + " ") + tk;
        }
        return val;
    }

    private static String formatExpression(int databaseType, String func) {
        String prefix = "";
        String suffix = "";
        int prefixIdx = func.lastIndexOf(40);
        int suffixIdx = func.indexOf(41);
        String mstr = func;
        if (prefixIdx >= 0 && suffixIdx >= 0 && suffixIdx > prefixIdx) {
            mstr = func.substring(prefixIdx + 1, suffixIdx);
            prefix = func.substring(0, prefixIdx + 1);
            suffix = func.substring(suffixIdx);
        } else if (prefixIdx >= 0 && prefixIdx + 1 < func.length()) {
            mstr = func.substring(prefixIdx + 1);
            prefix = func.substring(0, prefixIdx + 1);
        } else if (suffixIdx >= 0) {
            mstr = func.substring(0, suffixIdx);
            suffix = func.substring(suffixIdx);
        }
        String trimStr = mstr.trim();
        if (trimStr.startsWith("{") && trimStr.endsWith("}")) {
            return func;
        }
        int doc = mstr.indexOf(46);
        if (doc > 0) {
            String str = QueryBuilder.formatField(databaseType, mstr.substring(0, doc));
            str = str + "." + QueryBuilder.formatField(databaseType, mstr.substring(doc + 1));
            return prefix + str + suffix;
        }
        if (trimStr.equals("")) {
            return func;
        }
        try {
            Double.parseDouble(trimStr);
        }
        catch (Exception ex) {
            if (trimStr.startsWith("QBD_I_KEY")) {
                return prefix + trimStr + suffix;
            }
            if (trimStr.startsWith(":")) {
                return prefix + trimStr + suffix;
            }
            return prefix + QueryBuilder.printString(databaseType, trimStr) + suffix;
        }
        return func;
    }

    public static String formatField(int databaseType, String tmp) {
        if (databaseType == 3) {
            return MicrosoftQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 2) {
            return OracleQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 1) {
            return AccessQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 5) {
            return MySQLQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 6) {
            return PostgreSQLQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 9) {
            return CassandraQueryBuilder.formatFieldName(tmp);
        }
        if (databaseType == 10) {
            return HiveQueryBuilder.formatFieldName(tmp);
        }
        return StandardQueryBuilder.formatFieldName(tmp);
    }

    static Object[][] getSortTable(JTable table) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        int nRow = model.getRowCount();
        int nCol = model.getColumnCount();
        Object[][] tbl = new Object[nRow + 1][nCol];
        for (int i = 0; i < nCol; ++i) {
            int colIdx = table.convertColumnIndexToView(i);
            Object headerValue = colModel.getColumn(colIdx).getHeaderValue();
            tbl[0][colIdx] = headerValue instanceof DesignView.HeaderWithDataTypeObject ? ((DesignView.HeaderWithDataTypeObject)headerValue).getValue() : headerValue;
            for (int j = 0; j < nRow; ++j) {
                tbl[j + 1][colIdx] = model.getValueAt(j, i);
            }
        }
        return tbl;
    }

    private String printName(int i) {
        String agg = this.getAggregation(i);
        String name = (String)this.model.getValueAt(1, i);
        if (!EXPRESSION.equals(this.model.getValueAt(0, i))) {
            name = this.printExpression(this.model.getValueAt(0, i), name);
        }
        if (agg == null || agg.equals(AGGR[1])) {
            return name;
        }
        if (agg.equals(AGGR[11])) {
            return name;
        }
        return agg + "(" + name + ")";
    }

    String print(Object tmp) {
        return QueryBuilder.print(this.databaseType, tmp);
    }

    private String printExpression(Object tbl, Object col) {
        return QueryBuilder.printExpression(this.databaseType, tbl, col);
    }

    public static String print(int databaseType, Object tmp) {
        if (databaseType == 2) {
            return OracleQueryBuilder.printObj(tmp);
        }
        if (databaseType == 3) {
            return MicrosoftQueryBuilder.printObj(tmp);
        }
        if (databaseType == 1) {
            return AccessQueryBuilder.printObj(tmp);
        }
        if (databaseType == 5) {
            return MySQLQueryBuilder.printObj(tmp);
        }
        if (databaseType == 6) {
            return PostgreSQLQueryBuilder.printObj(tmp);
        }
        if (databaseType == 9) {
            return CassandraQueryBuilder.printObj(tmp);
        }
        if (databaseType == 10) {
            return HiveQueryBuilder.printObj(tmp);
        }
        return StandardQueryBuilder.printObj(tmp);
    }

    public static String printExpression(int databaseType, Object tbl, Object col) {
        if (databaseType == 2) {
            return OracleQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 3) {
            return MicrosoftQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 1) {
            return AccessQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 5) {
            return MySQLQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 6) {
            return PostgreSQLQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 9) {
            return CassandraQueryBuilder.printExp(tbl, col);
        }
        if (databaseType == 10) {
            return HiveQueryBuilder.printExp(tbl, col);
        }
        return StandardQueryBuilder.printExp(tbl, col);
    }

    private static String printString(int databaseType, String str) {
        if (databaseType == 2) {
            return OracleQueryBuilder.printString(str);
        }
        return StandardQueryBuilder.printString(str);
    }

    private static String isString(String str) {
        String trimStr = str.trim();
        if (trimStr.startsWith("'") && trimStr.endsWith("'")) {
            return trimStr.substring(1, trimStr.length() - 1);
        }
        return null;
    }

    protected Vector reorderJoinProperties(String[][] jp) {
        int i;
        Vector rootVect = new Vector();
        Vector<String[]> joinset = new Vector<String[]>();
        Vector<String> existing = new Vector<String>();
        Vector<String[]> pending = new Vector<String[]>();
        if (jp == null) {
            return rootVect;
        }
        for (i = 0; i < jp.length; ++i) {
            if (i == 0) {
                existing.add(jp[0][0]);
                existing.add(jp[0][2]);
                joinset.add(jp[0]);
                continue;
            }
            pending.add(jp[i]);
        }
        while (!pending.isEmpty()) {
            i = 0;
            int originalsize = pending.size();
            while (i < pending.size()) {
                String[] currentJoin = (String[])pending.elementAt(i);
                if (existing.contains(currentJoin[0]) && existing.contains(currentJoin[2])) {
                    this.insertJoin(joinset, currentJoin);
                    pending.removeElementAt(i);
                    continue;
                }
                if (existing.contains(currentJoin[0])) {
                    String joinType = JOINPROPERTY[0];
                    if (currentJoin[4].equals(JOINPROPERTY[1])) {
                        joinType = JOINPROPERTY[2];
                    } else if (currentJoin[4].equals(JOINPROPERTY[2])) {
                        joinType = JOINPROPERTY[1];
                    }
                    joinset.add(new String[]{currentJoin[2], currentJoin[3], currentJoin[0], currentJoin[1], joinType});
                    existing.add(currentJoin[2]);
                    pending.removeElementAt(i);
                    continue;
                }
                if (existing.contains(currentJoin[2])) {
                    joinset.add(currentJoin);
                    existing.add(currentJoin[0]);
                    pending.removeElementAt(i);
                    continue;
                }
                ++i;
            }
            if (originalsize != pending.size()) continue;
            rootVect.add(joinset);
            joinset = new Vector();
            String[] temp = (String[])pending.elementAt(0);
            joinset.add(temp);
            existing.removeAllElements();
            existing.add(temp[0]);
            existing.add(temp[2]);
            pending.removeElementAt(0);
        }
        rootVect.add(joinset);
        return rootVect;
    }

    private void insertJoin(Vector joins, String[] newJoin) {
        if (joins.size() < 1 || newJoin == null) {
            return;
        }
        int pos = 0;
        for (int i = 1; i < joins.size(); ++i) {
            if (!((String[])joins.elementAt(i))[0].equals(newJoin[0]) && !((String[])joins.elementAt(i))[0].equals(newJoin[2])) continue;
            pos = i;
        }
        if (newJoin[0].equals(((String[])joins.elementAt(pos))[2])) {
            String joinType = JOINPROPERTY[0];
            if (newJoin[4].equals(JOINPROPERTY[1])) {
                joinType = JOINPROPERTY[2];
            } else if (newJoin[4].equals(JOINPROPERTY[2])) {
                joinType = JOINPROPERTY[1];
            }
            joins.insertElementAt(new String[]{newJoin[2], newJoin[3], newJoin[0], newJoin[1], joinType}, pos + 1);
        } else {
            joins.insertElementAt(newJoin, pos + 1);
        }
    }

    private boolean hasAdvanceDictionary() {
        if (this.windows == null) {
            return false;
        }
        for (ColumnFieldWindow window : this.windows) {
            if (!(window instanceof AdvanceDictionary)) continue;
            return true;
        }
        return false;
    }

    private JTable createNewTable(JTable old_table) {
        DefaultTableModel old_model = (DefaultTableModel)old_table.getModel();
        Object[][] data = new Object[old_model.getRowCount()][old_model.getColumnCount()];
        Object[] columnNames = new String[old_model.getColumnCount()];
        for (int col = 0; col < old_model.getColumnCount(); ++col) {
            Object obj = old_table.getColumnModel().getColumn(col).getHeaderValue();
            columnNames[col] = obj instanceof DesignView.HeaderWithDataTypeObject ? ((DesignView.HeaderWithDataTypeObject)obj).getValue() : (String)obj;
            for (int row = 0; row < old_model.getRowCount(); ++row) {
                if (data[row][col] != null) continue;
                boolean failed = true;
                if (row == 0) {
                    ColumnFieldWindow cfw;
                    String table_name = (String)old_model.getValueAt(row, col);
                    String col_name = (String)old_model.getValueAt(1, col);
                    if (table_name != null && col_name != null && !EXPRESSION.equals(table_name) && (cfw = this.getWindow(table_name)) != null && cfw instanceof AdvanceDictionary) {
                        data[row][col] = EXPRESSION;
                        data[1][col] = ((AdvanceDictionary)cfw).getExpressionForColumn(col_name);
                        failed = false;
                    }
                } else if (old_model.getValueAt(row, col) instanceof String) {
                    String text = (String)old_model.getValueAt(row, col);
                    text = this.modifyExpression(text);
                    data[row][col] = text;
                    failed = false;
                }
                if (!failed) continue;
                data[row][col] = old_model.getValueAt(row, col);
            }
        }
        JTable newTable = new JTable(10, 20);
        DefaultTableModel new_model = (DefaultTableModel)newTable.getModel();
        new_model.setDataVector(data, columnNames);
        return newTable;
    }

    /*
     * WARNING - void declaration
     */
    private String modifyExpression(String exp) {
        if (exp == null) {
            return null;
        }
        String[][] prefix_a = new String[][]{{"\""}, {"["}, {" ", ">", "<", "=", ",", "(", ")", "\n", "+", "-", "/", "*", "&"}, {"["}};
        String[] subfix_a = new String[]{"\".", "].", ".", "]!"};
        String[] prefix = null;
        String subfix = "";
        String retstr = "";
        int startIndex = 0;
        while (startIndex < exp.length()) {
            int endIndex = -1;
            for (int i = 0; i < subfix_a.length; ++i) {
                int newindex = exp.indexOf(subfix_a[i], startIndex);
                if ((newindex >= endIndex || newindex < 0) && (newindex <= endIndex || endIndex >= 0)) continue;
                endIndex = newindex;
                prefix = prefix_a[i];
                subfix = subfix_a[i];
            }
            if (endIndex > 0) {
                int newStartIndex = -1;
                for (void var13_16 : prefix) {
                    int newindex = exp.lastIndexOf((String)var13_16, endIndex - 1);
                    if (newindex <= newStartIndex) continue;
                    newStartIndex = newindex;
                }
                boolean failed = true;
                if (newStartIndex > -1 || startIndex == 0 && subfix.equals(subfix_a[2])) {
                    int n;
                    String alias = exp.substring(newStartIndex + 1, endIndex);
                    ColumnFieldWindow cfw = this.getWindow(alias);
                    if (!subfix.equals(subfix_a[2])) {
                        --newStartIndex;
                    }
                    if (cfw != null && cfw instanceof AdvanceDictionary && (n = endIndex + subfix.length()) < exp.length()) {
                        void var13_18;
                        String p = exp.substring(n, n + 1);
                        if (p.equals("\"") || p.equals("[")) {
                            prefix = prefix_a[0];
                            if (p.equals("[")) {
                                prefix = new String[]{"]"};
                            }
                            ++var13_18;
                        } else {
                            prefix = prefix_a[2];
                        }
                        if (var13_18 < exp.length()) {
                            int colEndIndex = -1;
                            for (String element : prefix) {
                                int temp = exp.indexOf(element, (int)var13_18);
                                if ((temp <= colEndIndex || colEndIndex >= 0) && (temp >= colEndIndex || temp < 0)) continue;
                                colEndIndex = temp;
                            }
                            if (colEndIndex < 0 && prefix == prefix_a[2]) {
                                colEndIndex = exp.length();
                            }
                            if (colEndIndex > -1) {
                                String column_name = exp.substring((int)var13_18, colEndIndex);
                                String newexpression = ((AdvanceDictionary)cfw).getExpressionForColumn(column_name);
                                if (!column_name.equals("*") && newexpression.length() > 0) {
                                    retstr = retstr + exp.substring(startIndex, newStartIndex + 1) + newexpression;
                                    if (colEndIndex < exp.length() && prefix == prefix_a[2]) {
                                        retstr = retstr + exp.charAt(colEndIndex);
                                    }
                                    endIndex = colEndIndex + 1;
                                    subfix = "";
                                    failed = false;
                                }
                            }
                        }
                    }
                }
                if (endIndex > exp.length()) {
                    endIndex = exp.length();
                }
                if (failed) {
                    retstr = retstr + exp.substring(startIndex, endIndex) + subfix;
                }
                startIndex = endIndex + subfix.length();
                continue;
            }
            retstr = retstr + exp.substring(startIndex);
            startIndex = exp.length();
        }
        return retstr;
    }

    public void setSelectDistinct(boolean state) {
        this.selectDistinct = state;
    }
}

