/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.querybuilder.designer.ColumnFieldWindow;
import quadbase.querybuilder.designer.SimpleDictionary;
import quadbase.querybuilder.query.QueryBuilder;

public class SaveQuery {
    public static final int VERSION = 9;
    public static final String VERSIONNAME = "EspressQuery 1.0";
    private JTable table;
    private DefaultTableModel model;
    private ColumnFieldWindow[] tableWindows;
    private String[][] joinProperties;
    private String driver = "";
    private String url = "";
    private String userName = "";
    private String password = "";
    private boolean useJNDIDataSource = false;
    private String JNDIName = "";
    private Hashtable env;
    private boolean selectDistinct = false;
    private int tableNameFormat = 0;
    private QueryInParamSet paramSet = null;
    private String beforeSQL = null;
    private String afterSQL = null;

    public SaveQuery(boolean useJNDIDataSource, String JNDIName, Hashtable env, String driver, String url, String userName, String password, JTable table, ColumnFieldWindow[] windows, String[][] joinProperties, boolean sDistinct, int nameformat, QueryInParamSet pSet, String bsql, String asql) {
        this.useJNDIDataSource = useJNDIDataSource;
        if (useJNDIDataSource && JNDIName != null) {
            this.JNDIName = JNDIName;
        }
        if (useJNDIDataSource && env != null) {
            this.env = env;
        }
        if (driver != null) {
            this.driver = driver;
        }
        if (url != null) {
            this.url = url;
        }
        if (userName != null) {
            this.userName = userName;
        }
        if (password != null) {
            this.password = password;
        }
        this.table = table;
        this.model = (DefaultTableModel)table.getModel();
        this.tableWindows = windows;
        this.joinProperties = joinProperties;
        this.selectDistinct = sDistinct;
        this.tableNameFormat = nameformat;
        this.paramSet = pSet;
        this.beforeSQL = bsql;
        this.afterSQL = asql;
    }

    public byte[] saveToFile(String cname) throws Exception {
        return this.saveToFile(cname, "qry");
    }

    public byte[] saveToFile(String cname, String ext) throws Exception {
        if (cname == null || cname.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        this.saveData(out);
        out.close();
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        if (!cname.toUpperCase().endsWith(("." + ext).toUpperCase())) {
            cname = cname + "." + ext;
        }
        wdfile.output(fstream.toByteArray(), cname);
        return fstream.toByteArray();
    }

    public void saveData(DataOutput out) throws Exception {
        Object[][] tbl;
        out.writeInt(9);
        out.writeBoolean(this.useJNDIDataSource);
        if (this.useJNDIDataSource) {
            IOUtil.writeString(out, Coder.encode(this.JNDIName));
            String ctxFactory = (String)this.env.get("java.naming.factory.initial");
            String url = (String)this.env.get("java.naming.provider.url");
            if (ctxFactory == null) {
                ctxFactory = "";
            }
            if (url == null) {
                url = "";
            }
            IOUtil.writeString(out, Coder.encode(ctxFactory));
            IOUtil.writeString(out, Coder.encode(url));
        } else {
            IOUtil.writeString(out, Coder.encode(this.driver));
            IOUtil.writeString(out, Coder.encode(this.url));
            IOUtil.writeString(out, Coder.encode(this.userName));
            IOUtil.writeString(out, Coder.encode(this.password));
        }
        if (this.paramSet == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(6612);
            this.paramSet.write(out);
        }
        int dictionarycount = 0;
        int tablecount = 0;
        ByteArrayOutputStream tbytes = new ByteArrayOutputStream();
        ByteArrayOutputStream dbytes = new ByteArrayOutputStream();
        DataOutputStream tout = new DataOutputStream(tbytes);
        DataOutputStream dout = new DataOutputStream(dbytes);
        Rectangle bounds = null;
        for (ColumnFieldWindow tableWindow : this.tableWindows) {
            if (tableWindow instanceof SimpleDictionary) {
                ++dictionarycount;
                SimpleDictionary simpled = (SimpleDictionary)tableWindow;
                IOUtil.writeString(dout, tableWindow.getDisplayName());
                bounds = tableWindow.getBounds();
                dout.writeInt((int)bounds.getX());
                dout.writeInt((int)bounds.getY());
                dout.writeInt((int)bounds.getWidth());
                dout.writeInt((int)bounds.getHeight());
                SaveQuery sq = new SaveQuery(this.useJNDIDataSource, this.JNDIName, this.env, this.driver, this.url, this.userName, this.password, simpled.getQBETable(), simpled.getWindows(), simpled.getJoinProperties(), false, 0, null, null, null);
                sq.saveData(dout);
                continue;
            }
            ++tablecount;
            IOUtil.writeString(tout, tableWindow.getTableName());
            IOUtil.writeString(tout, tableWindow.getDisplayName());
            bounds = tableWindow.getBounds();
            tout.writeInt((int)bounds.getX());
            tout.writeInt((int)bounds.getY());
            tout.writeInt((int)bounds.getWidth());
            tout.writeInt((int)bounds.getHeight());
        }
        out.writeInt(tablecount);
        tout.flush();
        byte[] barray = tbytes.toByteArray();
        out.write(barray, 0, barray.length);
        tout.close();
        tbytes.close();
        out.writeInt(this.joinProperties.length);
        for (String[] joinPropertie : this.joinProperties) {
            for (int j = 0; j < 5; ++j) {
                IOUtil.writeString(out, joinPropertie[j]);
            }
        }
        int nCol = this.model.getColumnCount();
        int nRow = this.model.getRowCount();
        out.writeInt(nRow);
        out.writeInt(nCol);
        for (Object[] element : tbl = QueryBuilder.getSortTable(this.table)) {
            for (int j = 0; j < nCol; ++j) {
                IOUtil.writeStr(out, element[j] == null ? null : element[j].toString());
            }
        }
        out.writeInt(dictionarycount);
        dout.flush();
        barray = dbytes.toByteArray();
        out.write(barray, 0, barray.length);
        dout.close();
        dbytes.close();
        out.writeBoolean(this.selectDistinct);
        out.writeInt(this.tableNameFormat);
        IOUtil.writeStr(out, this.beforeSQL);
        IOUtil.writeStr(out, this.afterSQL);
    }
}

