/*
 * Decompiled with CFR 0.152.
 */
package quadbase.querybuilder.query;

import java.applet.Applet;
import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;

public class XMLDatabaseFunctions {
    static final int ELEMENT_TYPE = 1;
    static final int ATTR_TYPE = 2;
    static final int TEXT_TYPE = 3;
    static final int CDATA_TYPE = 4;
    static final int ENTITYREF_TYPE = 5;
    static final int ENTITY_TYPE = 6;
    static final int PROCINSTR_TYPE = 7;
    static final int COMMENT_TYPE = 8;
    static final int DOCUMENT_TYPE = 9;
    static final int DOCTYPE_TYPE = 10;
    static final int DOCFRAG_TYPE = 11;
    static final int NOTATION_TYPE = 12;
    Document document;

    public XMLDatabaseFunctions(String uri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(uri);
    }

    public XMLDatabaseFunctions(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(file);
    }

    public XMLDatabaseFunctions(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(xmlStream);
    }

    public static Vector getDatabaseFunctionList(String filename, String productName) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String urlfile = filename;
        if ((filename = filename.replace('\\', '/')).startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
            return new XMLDatabaseFunctions(urlfile).readFunctions(productName);
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return new XMLDatabaseFunctions(IOUtil.getCodeBase(applet) + filename).readFunctions(productName);
                }
                return new XMLDatabaseFunctions(IOUtil.createFile(filename)).readFunctions(productName);
            }
            return new XMLDatabaseFunctions(new File(filename)).readFunctions(productName);
        }
        return new XMLDatabaseFunctions(new ReadDataFile().getInputStream(filename, false, true)).readFunctions(productName);
    }

    private Vector readFunctions(String productName) throws Exception {
        return this.readFunctions(this.document, productName);
    }

    private Vector readFunctions(Node domNode, String productName) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase("DatabaseFunctions")) {
                return this.parseFunctions(node, productName);
            }
            Vector vec = this.readFunctions(node, productName);
            if (vec == null) continue;
            return vec;
        }
        return null;
    }

    private Node getDatabase(Node domNode, String productName) throws Exception {
        String baseName;
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("Database");
        if (node == null) {
            return null;
        }
        String firstSet = baseName = this.getAttribute(node, "ProductName");
        do {
            if (productName.toUpperCase().indexOf(baseName) <= -1) continue;
            return node;
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement("Database"), "ProductName")).equals(firstSet));
        return null;
    }

    private Vector<Vector<String>> getFunctionSet(Node domNode) throws Exception {
        String baseName;
        Vector<Vector<String>> functionSet = new Vector<Vector<String>>();
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("FunctionSet");
        if (node == null) {
            return functionSet;
        }
        String firstSet = baseName = this.getAttribute(node, "Name");
        do {
            functionSet.addElement(this.getFunctions(node, baseName));
        } while (!(baseName = this.getAttribute(node = xmlNode.getNextElement("FunctionSet"), "Name")).equals(firstSet));
        return functionSet;
    }

    private Vector<String> getFunctions(Node domNode, String folderName) throws Exception {
        String baseName;
        Vector<String> functions = new Vector<String>();
        functions.addElement(folderName);
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("Function");
        if (node == null) {
            return functions;
        }
        String firstSet = baseName = this.getData(node);
        do {
            functions.addElement(baseName);
        } while (!(baseName = this.getData(node = xmlNode.getNextElement("Function"))).equals(firstSet));
        return functions;
    }

    private Vector parseFunctions(Node domNode, String productName) throws Exception {
        Node node = this.getDatabase(domNode, productName);
        if (node == null) {
            return null;
        }
        return this.getFunctionSet(node);
    }

    private String getAttribute(Node domNode, String attr) {
        NamedNodeMap nodeMap = domNode.getAttributes();
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        String s = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                s = s + this.getData(node);
                continue;
            }
            if (type == 3) {
                s = s + node.getNodeValue();
                continue;
            }
            if (type == 5) {
                s = s + this.getData(node);
                continue;
            }
            if (type != 4) continue;
            s = s + node.getNodeValue();
        }
        return s;
    }

    class XMLNode {
        Node domNode;
        int idx = 0;

        XMLNode(Node domNode) {
            this.domNode = domNode;
        }

        Node getNextElement(String element) throws Exception {
            if (this.domNode == null) {
                return null;
            }
            NodeList nodeList = this.domNode.getChildNodes();
            for (int j = 0; j < 2; ++j) {
                while (this.idx < nodeList.getLength()) {
                    Node node = nodeList.item(this.idx);
                    short type = node.getNodeType();
                    if (type == 1 && node.getNodeName().equalsIgnoreCase(element)) {
                        ++this.idx;
                        return node;
                    }
                    ++this.idx;
                }
                this.idx = 0;
            }
            return null;
        }
    }
}

