/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Date;
import java.util.Vector;
import quadbase.queryproc.Aggregator;

public class AggrStdDev
extends Aggregator {
    Vector doubleVal = new Vector();

    public AggrStdDev(int sqlType) {
        super(sqlType);
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        double d = 0.0;
        if (p instanceof Number) {
            d = ((Number)p).doubleValue();
        } else if (p instanceof Date) {
            d = ((Date)p).getTime();
        } else {
            throw new IllegalArgumentException("Attempt to perform average on non-numeric object: " + p);
        }
        this.doubleVal.add(d);
    }

    @Override
    public Object getResult() {
        if (this.doubleVal.size() == 0) {
            return 0.0;
        }
        return Math.sqrt(this.variance(this.doubleVal));
    }

    Double variance(Vector doubleVal) {
        double mean = AggrStdDev.average(doubleVal);
        double v = 0.0;
        for (int r = 0; r < doubleVal.size(); ++r) {
            v = Math.pow((Double)doubleVal.elementAt(r) - mean, 2.0) + v;
        }
        if (doubleVal.size() <= 1) {
            return 0.0;
        }
        return v / (double)(doubleVal.size() - 1);
    }

    static Double average(Vector element) {
        if (element == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (int r = 0; r < element.size(); ++r) {
            sum += ((Double)element.elementAt(r)).doubleValue();
        }
        return sum / (double)element.size();
    }
}

