/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Date;
import quadbase.common.util.internal.DataType;
import quadbase.queryproc.Aggregator;

public class AggrSumSquare
extends Aggregator {
    double d;
    boolean isInt = false;

    public AggrSumSquare(int sqlType) {
        super(sqlType);
        int datatype = DataType.mapType(sqlType);
        this.isInt = datatype == 0 || datatype == 2 || datatype == 11 || datatype == 12;
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        double v = 0.0;
        if (p instanceof Number) {
            v = ((Number)p).doubleValue();
        } else if (p instanceof Date) {
            v = ((Date)p).getTime();
        } else {
            throw new IllegalArgumentException("Attempt to perform average on non-numeric object: " + p);
        }
        this.d += Math.pow(v, 2.0);
    }

    @Override
    public Object getResult() {
        if (this.isInt) {
            return (int)Math.rint(this.d);
        }
        return this.d;
    }
}

